/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import java.util.List;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;

public enum BasetypeBuilderGroup {
    H2COH("H2COH", "H2-C-OH [tail group]", true, 'h', StereoConfiguration.Nonchiral.getStereosymbol(), (CoreModificationTemplate)null),
    HCOH_D("HCOH_D", "H-C-OH [dexter pos.]", false, '2', StereoConfiguration.Dexter.getStereosymbol(), (CoreModificationTemplate)null),
    HCOH_L("HCOH_L", "HO-C-H [laevus pos.]", false, '1', StereoConfiguration.Laevus.getStereosymbol(), (CoreModificationTemplate)null),
    HCH("HCH", "H-C-H [deoxy position]", false, 'd', StereoConfiguration.Nonchiral.getStereosymbol(), CoreModificationTemplate.DEOXY),
    COOH("COOH", "COOH [carboxyl group]", true, 'a', StereoConfiguration.Nonchiral.getStereosymbol(), CoreModificationTemplate.ACID),
    CHO("CHO", "H-C=O [carbonyl group]", true, 'o', StereoConfiguration.Nonchiral.getStereosymbol(), CoreModificationTemplate.KETO),
    KETO("CO", "C=O [keto group]", false, 'k', StereoConfiguration.Nonchiral.getStereosymbol(), CoreModificationTemplate.KETO),
    HCH_EN_DEOXY("HCH_EN_DEOXY", "[en + deoxy]", false, 'e', StereoConfiguration.Nonchiral.getStereosymbol(), new CoreModificationTemplate[]{CoreModificationTemplate.EN, CoreModificationTemplate.DEOXY}),
    HCOH_EN("HCOH_EN", "[en]", false, 'n', StereoConfiguration.Nonchiral.getStereosymbol(), CoreModificationTemplate.EN),
    CH3("CH3", "CH3 [methyl group]", true, 'm', StereoConfiguration.Nonchiral.getStereosymbol(), CoreModificationTemplate.DEOXY),
    UNKNOWN("X", "unknown", false, 'x', StereoConfiguration.Unknown.getStereosymbol(), (CoreModificationTemplate)null);

    private String groupName;
    private String displayName;
    private boolean headTail;
    private char stereoSymbol;
    private char extStereoSymbol;
    private ArrayList<CoreModificationTemplate> coreMods;

    private BasetypeBuilderGroup(String nameStr, String displayStr, boolean ht, char extStereoChar, char stereoChar, CoreModificationTemplate mod1) {
        this(nameStr, displayStr, ht, extStereoChar, stereoChar, new CoreModificationTemplate[]{mod1});
    }

    private BasetypeBuilderGroup(String nameStr, String displayStr, boolean ht, char extStereoChar, char stereoChar, CoreModificationTemplate[] modArr) {
        this.setGroupName(nameStr);
        this.setDisplayName(displayStr);
        this.setHeadTail(ht);
        this.setExtStereoSymbol(extStereoChar);
        this.setStereoSymbol(stereoChar);
        this.setCoreMods(new ArrayList<CoreModificationTemplate>());
        if (modArr != null) {
            for (CoreModificationTemplate mod : modArr) {
                if (mod == null) continue;
                this.getCoreMods().add(mod);
            }
        }
    }

    public boolean isHeadTail() {
        return this.headTail;
    }

    public boolean isBody() {
        return !this.headTail;
    }

    public void setHeadTail(boolean ht) {
        this.headTail = ht;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String nameStr) {
        this.groupName = nameStr;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayNameStr) {
        this.displayName = displayNameStr;
    }

    public char getStereoSymbol() {
        return this.stereoSymbol;
    }

    public void setStereoSymbol(char stereoChar) {
        this.stereoSymbol = stereoChar;
    }

    public char getExtStereoSymbol() {
        return this.extStereoSymbol;
    }

    public String getExtStereoSymbolStr() {
        return "" + this.getExtStereoSymbol();
    }

    public void setExtStereoSymbol(char extStereoChar) {
        this.extStereoSymbol = extStereoChar;
    }

    public ArrayList<CoreModificationTemplate> getCoreMods() {
        return this.coreMods;
    }

    public int getCoreModCount() {
        if (this.getCoreMods() == null) {
            return 0;
        }
        return this.getCoreMods().size();
    }

    public void setCoreMods(ArrayList<CoreModificationTemplate> coreModList) {
        this.coreMods = coreModList;
    }

    public boolean hasCoreModification(CoreModificationTemplate modTmpl) {
        return this.getCoreMods() != null && this.getCoreMods().contains((Object)modTmpl);
    }

    public static boolean hasCoreModification(List<BasetypeBuilderGroup> groupList, CoreModificationTemplate modTmpl) {
        if (groupList != null) {
            for (BasetypeBuilderGroup bbg : groupList) {
                if (!bbg.hasCoreModification(modTmpl)) continue;
                return true;
            }
        }
        return false;
    }

    public static BasetypeBuilderGroup forName(String name) {
        for (BasetypeBuilderGroup group : BasetypeBuilderGroup.values()) {
            if (!group.groupName.equals(name)) continue;
            return group;
        }
        return null;
    }

    public static BasetypeBuilderGroup forExtStereoSymbol(char extStereoChar) {
        for (BasetypeBuilderGroup group : BasetypeBuilderGroup.values()) {
            if (group.getExtStereoSymbol() != extStereoChar) continue;
            return group;
        }
        return null;
    }

    public static BasetypeBuilderGroup forCoreModifications(List<CoreModificationTemplate> modList, Boolean headTailFlag) {
        if (modList != null) {
            for (BasetypeBuilderGroup bbgroup : BasetypeBuilderGroup.values()) {
                if (headTailFlag != null && bbgroup.isHeadTail() != headTailFlag.booleanValue() || bbgroup.getCoreModCount() != modList.size()) continue;
                boolean coreModsMatch = true;
                for (CoreModificationTemplate mod : modList) {
                    if (bbgroup.hasCoreModification(mod)) continue;
                    coreModsMatch = false;
                    break;
                }
                if (!coreModsMatch) continue;
                return bbgroup;
            }
        }
        return null;
    }
}

