/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridEditor;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.dialog.MassSpecStandardQuantApplyDialog;
import org.grits.toolbox.entry.ms.preference.IMSPreferenceWithStandardQuant;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.MassSpecPreferenceLoader;
import org.grits.toolbox.entry.ms.preference.MassSpecStandardQuantFile;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuant;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuantPeak;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MassSpecStandardQuantPreferenceUI
extends Composite {
    protected static final Logger logger = Logger.getLogger(MassSpecStandardQuantPreferenceUI.class);
    public static final String PAGE_COMPLETE_PROPERTY = "Page Complete";
    protected boolean isComplete = true;
    protected String errorMessage = null;
    protected IPropertyChangeListener listener = null;
    protected GridLayout gridLayout = null;
    protected Label lblSelectStandardQuant = null;
    protected Combo cmbSelectStandardQuant = null;
    protected String sCurrentStandardQuant = null;
    protected Button btnExportXML = null;
    protected Button btnImportXML = null;
    protected Button btnCreateNew = null;
    protected Button btnEditCurrent = null;
    protected Button btnDeleteCurrent = null;
    protected Button btnResetCurrent = null;
    protected Label lblSeparator = null;
    protected Label lblStandardQuantName = null;
    protected Text txtStandardQuantName = null;
    protected String sStandardQuantName = null;
    protected Label lblDescription = null;
    protected Text txtDescription = null;
    protected String sDescription = null;
    protected Label lblMassTolerance = null;
    protected String sMSLevel = null;
    protected Text txtMassTolerance = null;
    protected Double dMassTolerance = null;
    protected Label lblToleranceType = null;
    protected Button btnTolerancePPM = null;
    protected Button btnToleranceDalton = null;
    protected Boolean bIsPPM = false;
    protected Grid gridSpecialPeaksGrid = null;
    protected Point gridSpecialPeaksGridSize = null;
    protected List<GridItem> gridItemsSpecialPeaks = null;
    protected MassSpecStandardQuant currentStandardQuant = null;
    protected Button btnRemoveSelected = null;
    protected Button btnRemoveAllRows = null;
    protected Label lblAddStandardQuantFromFile = null;
    protected Text txtAddStandardQuantFromFile = null;
    protected Button btnAddStandardQuantFromFile = null;
    protected String sStandardQuantFilePath = null;
    protected Button btnSaveAsDefault = null;
    protected boolean bAddSaveAsDefault = false;
    protected boolean bIsDirty = false;
    protected boolean bIsEditingTable = false;
    protected GridEditor editor = null;
    protected IMSPreferenceWithStandardQuant localStandardQuant = null;
    protected IMSPreferenceWithStandardQuant storedStandardQuant = null;
    protected IMSPreferenceWithStandardQuant entryStandardQuant = null;
    protected Entry massSpecEntry = null;
    protected MassSpecMultiPageViewer contextViewer = null;

    public MassSpecStandardQuantPreferenceUI(Composite parent, int style, IPropertyChangeListener listener, boolean bAddSaveAsDefault) {
        super(parent, style);
        this.listener = listener;
        this.bAddSaveAsDefault = bAddSaveAsDefault;
        this.initStoredStandardQuant();
    }

    public static IMSPreferenceWithStandardQuant loadWorkspacePreferences() {
        try {
            return MassSpecPreferenceLoader.getMassSpecPreferences();
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting the mass spec preferences", (Throwable)ex);
            return null;
        }
    }

    public void initLocalStandardQuant() {
        this.localStandardQuant = new MassSpecPreference();
        MassSpecUISettings msSettings = MassSpecStandardQuantPreferenceUI.getMassSpecUISettingsFromEntry(this.massSpecEntry);
        MassSpecStandardQuantPreferenceUI.initStandardQuantFromEntry(msSettings, this.localStandardQuant);
        this.entryStandardQuant = new MassSpecPreference();
        MassSpecStandardQuantPreferenceUI.initStandardQuantFromEntry(msSettings, this.entryStandardQuant);
    }

    public static MassSpecUISettings getMassSpecUISettingsFromEntry(Entry entry) {
        Property p = entry.getProperty();
        if (p != null) {
            return ((MassSpecEntityProperty)p).getMassSpecParentProperty().getMassSpecMetaData();
        }
        return null;
    }

    public static void initStandardQuantFromEntry(MassSpecUISettings msSettings, IMSPreferenceWithStandardQuant standardQuant) {
        ((MassSpecPreference)standardQuant).setStandardQuant(new ArrayList<MassSpecStandardQuant>());
        ArrayList<String> localStandardQuantAdded = new ArrayList<String>();
        if (msSettings != null) {
            List<MassSpecStandardQuant> l = msSettings.getStandardQuant();
            if (l != null && !l.isEmpty()) {
                for (MassSpecStandardQuant curStandardQuant : l) {
                    standardQuant.getStandardQuant().add((MassSpecStandardQuant)curStandardQuant.clone());
                    localStandardQuantAdded.add(curStandardQuant.getStandardQuantName());
                }
            }
            ((MassSpecPreference)standardQuant).setStandardQuantText(MassSpecPreference.createStandardQuantText(standardQuant.getStandardQuant()));
        }
    }

    public void initStoredStandardQuant() {
        this.storedStandardQuant = MassSpecStandardQuantPreferenceUI.loadWorkspacePreferences();
    }

    public IMSPreferenceWithStandardQuant getStoredStandardQuant() {
        return this.storedStandardQuant;
    }

    public void setEntry(Entry massSpecEntry) {
        this.massSpecEntry = massSpecEntry;
    }

    public Entry getEntry() {
        return this.massSpecEntry;
    }

    public void setLocalStandardQuant(IMSPreferenceWithStandardQuant localStandardQuant) {
        this.localStandardQuant = localStandardQuant;
    }

    public IMSPreferenceWithStandardQuant getLocalStandardQuant() {
        return this.localStandardQuant;
    }

    public void setEntryStandardQuant(IMSPreferenceWithStandardQuant entryStandardQuant) {
        this.entryStandardQuant = entryStandardQuant;
    }

    public IMSPreferenceWithStandardQuant getEntryStandardQuant() {
        return this.entryStandardQuant;
    }

    public MassSpecMultiPageViewer getContextViewer() {
        return this.contextViewer;
    }

    public void setContextViewer(MassSpecMultiPageViewer contextViewer) {
        this.contextViewer = contextViewer;
    }

    public void initComponents() {
        this.initGridLayout();
        this.setLayout((Layout)this.gridLayout);
        this.addSelectStandardQuantItem(this);
        this.addDeleteCurrent(this);
        this.addResetCurrent(this);
        this.addEditCurrent(this);
        this.addCreateNewItem(this);
        this.addSeparatorLine1(this);
        this.addStandardQuantNameItem(this);
        this.addDescriptionItem(this);
        this.addMassToleranceItem(this);
        this.addToleranceTypeItem(this);
        this.addPeakListItem(this);
        this.addRemoveRowComponents(this);
        this.addRemoveAllRowsComponents(this);
        this.addStandardQuantFileItem(this);
        this.addSaveSettingsItem(this, this.bAddSaveAsDefault);
        this.setEditEnabled(false);
        this.setResetEnabled();
    }

    protected Entry getEntryForCurrentViewer() {
        MassSpecMultiPageViewer viewer = this.getCurrentViewer();
        if (viewer == null) {
            return null;
        }
        return viewer.getEntry();
    }

    public MassSpecMultiPageViewer getCurrentViewer() {
        if (this.getContextViewer() == null) {
            return null;
        }
        try {
            MassSpecMultiPageViewer viewer;
            EPartService partService = this.getContextViewer().getPartService();
            MPart mPart = partService.getActivePart();
            if (mPart != null && mPart.getParent() != null && mPart.equals(mPart.getParent().getSelectedElement()) && mPart.getObject() instanceof MassSpecMultiPageViewer && (viewer = (MassSpecMultiPageViewer)((Object)mPart.getObject())).getEntry().getProperty() != null && viewer.getEntry().getProperty() instanceof MassSpecEntityProperty) {
                return viewer;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected void mergePreferences() {
        if (this.getStoredStandardQuant() != null && this.getStoredStandardQuant().getStandardQuant() != null) {
            int i = 0;
            while (i < this.getStoredStandardQuant().getStandardQuant().size()) {
                MassSpecStandardQuant storedStdQuant = this.getStoredStandardQuant().getStandardQuant().get(i);
                boolean bFound = false;
                int j = 0;
                while (j < this.getLocalStandardQuant().getStandardQuant().size()) {
                    MassSpecStandardQuant localStdQuant = this.getLocalStandardQuant().getStandardQuant().get(j);
                    if (storedStdQuant.getStandardQuantName().equals(localStdQuant.getStandardQuantName())) {
                        bFound = true;
                        break;
                    }
                    ++j;
                }
                if (!bFound) {
                    this.getLocalStandardQuant().getStandardQuant().add(storedStdQuant);
                }
                ++i;
            }
        }
    }

    public boolean getSaveAsDefault() {
        return this.bAddSaveAsDefault && this.btnSaveAsDefault.getSelection();
    }

    public void save() {
        this.mergePreferences();
        this.getLocalStandardQuant().saveValues();
        this.initStoredStandardQuant();
        this.initLocalStandardQuant();
    }

    protected void initGridLayout() {
        this.gridLayout = new GridLayout(6, false);
    }

    public void setSelectedItem(String _sStandardQuantName) {
        int i = 0;
        while (i < this.cmbSelectStandardQuant.getItemCount()) {
            String sText = this.cmbSelectStandardQuant.getItem(i);
            if (sText.trim().equals(_sStandardQuantName.trim())) {
                this.cmbSelectStandardQuant.select(i);
                if (this.cmbSelectStandardQuant.getText().trim().equals("")) break;
                String selStdQuantName = this.cmbSelectStandardQuant.getText().trim();
                MassSpecStandardQuant selStdQuant = null;
                MassSpecStandardQuant prefStdQuant = MassSpecStandardQuantApplyDialog.getCurrentStdQuant(selStdQuantName, this.storedStandardQuant);
                MassSpecStandardQuant localStdQuant = MassSpecStandardQuantApplyDialog.getCurrentStdQuant(selStdQuantName, this.localStandardQuant);
                if (localStdQuant != null) {
                    selStdQuant = localStdQuant;
                } else if (prefStdQuant != null) {
                    selStdQuant = prefStdQuant;
                } else {
                    return;
                }
                this.processSelection(selStdQuant);
                break;
            }
            ++i;
        }
    }

    public void processSelection(MassSpecStandardQuant desiredPreferences) {
        if (this.cancelIfDirty()) {
            return;
        }
        this.setEditEnabled(false);
        this.currentStandardQuant = null;
        if (desiredPreferences != null) {
            this.btnEditCurrent.setEnabled(true);
            this.btnDeleteCurrent.setEnabled(true);
            this.setCurrentStandardQuantValues(desiredPreferences);
            this.setResetEnabled();
        } else {
            this.setPageComplete(true);
        }
    }

    protected void addSelectStandardQuantItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 2, 1);
        this.lblSelectStandardQuant = new Label(parent, 0);
        this.lblSelectStandardQuant.setText("Current Quantification Set");
        this.lblSelectStandardQuant.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 4, 1);
        this.cmbSelectStandardQuant = new Combo(parent, 8);
        this.cmbSelectStandardQuant.setLayoutData((Object)gd2);
        this.sCurrentStandardQuant = null;
        this.initStoredStandardQuantList();
        this.cmbSelectStandardQuant.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!MassSpecStandardQuantPreferenceUI.this.cmbSelectStandardQuant.getText().trim().equals("")) {
                    String selStdQuantName = MassSpecStandardQuantPreferenceUI.this.cmbSelectStandardQuant.getText().trim();
                    MassSpecStandardQuant selStdQuant = null;
                    MassSpecStandardQuant prefStdQuant = MassSpecStandardQuantApplyDialog.getCurrentStdQuant(selStdQuantName, MassSpecStandardQuantPreferenceUI.this.storedStandardQuant);
                    MassSpecStandardQuant localStdQuant = MassSpecStandardQuantApplyDialog.getCurrentStdQuant(selStdQuantName, MassSpecStandardQuantPreferenceUI.this.localStandardQuant);
                    if (localStdQuant != null) {
                        selStdQuant = localStdQuant;
                    } else if (prefStdQuant != null) {
                        selStdQuant = prefStdQuant;
                    } else {
                        return;
                    }
                    MassSpecStandardQuantPreferenceUI.this.processSelection(selStdQuant);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cmbSelectStandardQuant.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
        if (this.getContextViewer() != null) {
            this.cmbSelectStandardQuant.addPaintListener((PaintListener)new StandardQuantPaintListener(this));
        }
    }

    protected boolean cancelIfDirty() {
        boolean bContinue;
        return this.bIsDirty && !(bContinue = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Values Changed", (String)"The values in the current selection have changed. Discard?"));
    }

    protected boolean confirmRestore() {
        boolean bContinue = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Reset Peaks", (String)"This will reload values in preferences. Local changes will be lost. Continue?");
        return bContinue;
    }

    protected List<MassSpecStandardQuant> getPreferenceStandardQuant(Object preferences) {
        return ((MassSpecPreference)preferences).getStandardQuant();
    }

    protected void setPreferenceStandardQuant(Object preferences, List<MassSpecStandardQuant> standardQuantList) {
        ((MassSpecPreference)preferences).setStandardQuant(standardQuantList);
    }

    public void initStoredStandardQuantList() {
        int iItemCount;
        int i;
        String sToSelect = "";
        if (this.cmbSelectStandardQuant.getItems().length != 0) {
            this.cmbSelectStandardQuant.removeAll();
        }
        this.cmbSelectStandardQuant.add("");
        if (this.getStoredStandardQuant() != null && this.getStoredStandardQuant().getStandardQuant() != null) {
            i = 0;
            while (i < this.getStoredStandardQuant().getStandardQuant().size()) {
                MassSpecStandardQuant stdQuant = this.getStoredStandardQuant().getStandardQuant().get(i);
                this.cmbSelectStandardQuant.add(stdQuant.getStandardQuantName());
                if (this.currentStandardQuant != null && stdQuant.getStandardQuantName().equals(this.currentStandardQuant.getStandardQuantName())) {
                    iItemCount = this.cmbSelectStandardQuant.getItemCount();
                    sToSelect = this.cmbSelectStandardQuant.getItem(iItemCount - 1);
                }
                ++i;
            }
        }
        if (this.getContextViewer() != null && this.getLocalStandardQuant() != null && this.getPreferenceStandardQuant(this.getLocalStandardQuant()) != null) {
            i = 0;
            while (i < this.getPreferenceStandardQuant(this.getLocalStandardQuant()).size()) {
                MassSpecStandardQuant prefStdQuant = this.getPreferenceStandardQuant(this.getLocalStandardQuant()).get(i);
                MassSpecStandardQuantApplyDialog.setComboEntryForTempStdQuant(prefStdQuant, this.cmbSelectStandardQuant, this.entryStandardQuant.getStandardQuant(), this.storedStandardQuant.getStandardQuant());
                if (this.currentStandardQuant != null && prefStdQuant.getStandardQuantName().equals(this.currentStandardQuant.getStandardQuantName())) {
                    iItemCount = this.cmbSelectStandardQuant.getItemCount();
                    sToSelect = this.cmbSelectStandardQuant.getItem(iItemCount - 1);
                }
                ++i;
            }
        }
        int iPrevSelInx = this.cmbSelectStandardQuant.indexOf(sToSelect);
        this.cmbSelectStandardQuant.select(iPrevSelInx);
    }

    protected void addDeleteCurrent(Composite parent) {
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.btnDeleteCurrent = new Button(parent, 0);
        this.btnDeleteCurrent.setText("Delete Selected");
        this.btnDeleteCurrent.setLayoutData((Object)gd3);
        this.btnDeleteCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                boolean bVal = MessageDialog.openConfirm((Shell)MassSpecStandardQuantPreferenceUI.this.getShell(), (String)"Delete Selected?", (String)"Delete selected. Are you sure?");
                if (bVal) {
                    int iSelInx = MassSpecStandardQuantPreferenceUI.this.cmbSelectStandardQuant.getSelectionIndex();
                    MassSpecStandardQuant localStdQuant = MassSpecStandardQuantApplyDialog.getCurrentStdQuant(MassSpecStandardQuantPreferenceUI.this.cmbSelectStandardQuant.getItem(iSelInx), MassSpecStandardQuantPreferenceUI.this.localStandardQuant);
                    MassSpecStandardQuantPreferenceUI.this.getPreferenceStandardQuant(MassSpecStandardQuantPreferenceUI.this.getLocalStandardQuant()).remove(localStdQuant);
                    MassSpecStandardQuantPreferenceUI.this.cmbSelectStandardQuant.remove(iSelInx);
                    MassSpecStandardQuantPreferenceUI.this.clearValues();
                    MassSpecStandardQuantPreferenceUI.this.setEditEnabled(false);
                    MassSpecStandardQuantPreferenceUI.this.currentStandardQuant = null;
                    MassSpecStandardQuantPreferenceUI.this.setPageComplete(true);
                    MassSpecStandardQuantPreferenceUI.this.setResetEnabled();
                    MassSpecStandardQuantPreferenceUI.this.setRemoveAllRowsEnabled();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnDeleteCurrent.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void addResetCurrent(Composite parent) {
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.btnResetCurrent = new Button(parent, 0);
        this.btnResetCurrent.setText("Restore Preferences");
        this.btnResetCurrent.setLayoutData((Object)gd3);
        this.btnResetCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                boolean bVal = MassSpecStandardQuantPreferenceUI.this.confirmRestore();
                if (bVal) {
                    int iSelInx = MassSpecStandardQuantPreferenceUI.this.cmbSelectStandardQuant.getSelectionIndex();
                    MassSpecStandardQuant prefStandardQuant = MassSpecStandardQuantApplyDialog.getCurrentStdQuant(MassSpecStandardQuantPreferenceUI.this.cmbSelectStandardQuant.getItem(iSelInx), MassSpecStandardQuantPreferenceUI.this.getStoredStandardQuant());
                    MassSpecStandardQuant localStandardQuant = MassSpecStandardQuantApplyDialog.getCurrentStdQuant(MassSpecStandardQuantPreferenceUI.this.cmbSelectStandardQuant.getItem(iSelInx), MassSpecStandardQuantPreferenceUI.this.getLocalStandardQuant());
                    localStandardQuant.setStandardQuantPeaks(prefStandardQuant.getStandardQuantPeaks());
                    if (!MassSpecStandardQuantPreferenceUI.this.cmbSelectStandardQuant.getText().trim().equals("")) {
                        String selStandardQuantName = MassSpecStandardQuantPreferenceUI.this.cmbSelectStandardQuant.getText().trim();
                        MassSpecStandardQuant storedStandardQuant = MassSpecStandardQuantApplyDialog.getCurrentStdQuant(selStandardQuantName, MassSpecStandardQuantPreferenceUI.this.getStoredStandardQuant());
                        MassSpecStandardQuantPreferenceUI.this.processSelection(storedStandardQuant);
                    }
                    MassSpecStandardQuantPreferenceUI.this.initStoredStandardQuantList();
                    MassSpecStandardQuantPreferenceUI.this.setRemoveAllRowsEnabled();
                    MassSpecStandardQuantPreferenceUI.this.setPageComplete(true);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnDeleteCurrent.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void showInvalidImportFileMessage() {
        ErrorUtils.createErrorMessageBox((Shell)this.getShell(), (String)"Not a valid Mass Spec Custom StandardQuant XML file.");
    }

    protected void addEditCurrent(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnEditCurrent = new Button(parent, 0);
        this.btnEditCurrent.setText("Edit Selected");
        this.btnEditCurrent.setLayoutData((Object)gd1);
        this.btnEditCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MassSpecStandardQuantPreferenceUI.this.setEditEnabled(true);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnEditCurrent.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected MassSpecStandardQuant getNewMassSpecStandardQuant() {
        return new MassSpecStandardQuant();
    }

    protected void addCreateNewItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnCreateNew = new Button(parent, 0);
        this.btnCreateNew.setText("Create New");
        this.btnCreateNew.setLayoutData((Object)gd1);
        this.btnCreateNew.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (MassSpecStandardQuantPreferenceUI.this.cancelIfDirty()) {
                    return;
                }
                MassSpecStandardQuantPreferenceUI.this.setEditEnabled(true);
                MassSpecStandardQuantPreferenceUI.this.btnEditCurrent.setEnabled(false);
                MassSpecStandardQuantPreferenceUI.this.clearValues();
                MassSpecStandardQuantPreferenceUI.this.currentStandardQuant = MassSpecStandardQuantPreferenceUI.this.getNewMassSpecStandardQuant();
                MassSpecStandardQuantPreferenceUI.this.setResetEnabled();
                MassSpecStandardQuantPreferenceUI.this.setRemoveAllRowsEnabled();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnCreateNew.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void addSeparatorLine1(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, false, 6, 1);
        this.lblSeparator = new Label(parent, 258);
        this.lblSeparator.setLayoutData((Object)gd1);
    }

    protected void setCurrentStandardQuantValues(MassSpecStandardQuant selStdQuant) {
        if (selStdQuant == null) {
            return;
        }
        this.currentStandardQuant = selStdQuant;
        this.txtStandardQuantName.setText(selStdQuant.getStandardQuantName());
        this.txtDescription.setText(selStdQuant.getDescription());
        this.txtMassTolerance.setText(selStdQuant.getMassTolerance().toString());
        if (selStdQuant.getIsPPM().booleanValue()) {
            this.btnTolerancePPM.setSelection(true);
        } else {
            this.btnToleranceDalton.setSelection(true);
        }
        this.initPeakListValues(selStdQuant, -1, -1);
        this.setIsDirty(false);
    }

    public void setEditEnabled(boolean _bVal) {
        this.btnDeleteCurrent.setEnabled(_bVal);
        this.btnEditCurrent.setEnabled(_bVal);
        this.lblStandardQuantName.setEnabled(_bVal);
        this.txtStandardQuantName.setEnabled(_bVal);
        this.lblDescription.setEnabled(_bVal);
        this.txtDescription.setEnabled(_bVal);
        this.lblMassTolerance.setEnabled(_bVal);
        this.lblToleranceType.setEnabled(_bVal);
        this.btnTolerancePPM.setEnabled(_bVal);
        this.btnToleranceDalton.setEnabled(_bVal);
        this.txtMassTolerance.setEnabled(_bVal);
        this.gridSpecialPeaksGrid.setEnabled(_bVal);
        this.lblAddStandardQuantFromFile.setEnabled(_bVal);
        this.btnAddStandardQuantFromFile.setEnabled(_bVal);
        this.gridSpecialPeaksGrid.redraw();
    }

    public void setResetEnabled() {
        this.btnResetCurrent.setEnabled(this.cmbSelectStandardQuant.getText().trim().endsWith(" (differs from preferences)"));
    }

    public void clearValues() {
        this.txtStandardQuantName.setText("");
        this.txtDescription.setText("");
        this.txtMassTolerance.setText("");
        this.gridSpecialPeaksGrid.clearAll(true);
        this.txtAddStandardQuantFromFile.setText("<Please Browse for your file>");
        this.cmbSelectStandardQuant.select(0);
        this.btnRemoveSelected.setEnabled(false);
        this.btnRemoveAllRows.setEnabled(false);
        this.setIsDirty(false);
    }

    protected void addStandardQuantNameItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblStandardQuantName = new Label(parent, 0);
        this.lblStandardQuantName.setText("Name of Quantification Set");
        this.lblStandardQuantName.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 5, 1);
        this.txtStandardQuantName = new Text(parent, 2048);
        this.txtStandardQuantName.setLayoutData((Object)gd2);
        this.txtStandardQuantName.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                MassSpecStandardQuantPreferenceUI.this.setIsDirty(true);
                if (MassSpecStandardQuantPreferenceUI.this.isReadyToFinish()) {
                    MassSpecStandardQuantPreferenceUI.this.setPageComplete(true);
                } else {
                    MassSpecStandardQuantPreferenceUI.this.setPageComplete(false);
                }
            }
        });
        this.txtStandardQuantName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void addDescriptionItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 5);
        this.lblDescription = new Label(parent, 0);
        this.lblDescription.setText("Description");
        this.lblDescription.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true, 5, 5);
        this.txtDescription = new Text(parent, 2626);
        this.txtDescription.setText("");
        this.txtDescription.setLayoutData((Object)gd2);
        this.txtDescription.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                MassSpecStandardQuantPreferenceUI.this.setIsDirty(true);
                if (MassSpecStandardQuantPreferenceUI.this.isReadyToFinish()) {
                    MassSpecStandardQuantPreferenceUI.this.setPageComplete(true);
                } else {
                    MassSpecStandardQuantPreferenceUI.this.setPageComplete(false);
                }
            }
        });
        this.txtDescription.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    public void setIsDirty(boolean bIsDirty) {
        this.bIsDirty = bIsDirty;
    }

    protected void addMassToleranceItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblMassTolerance = new Label(parent, 0);
        this.lblMassTolerance.setText("Mass Tolerance to Match Peak");
        this.lblMassTolerance.setLayoutData((Object)gd1);
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.txtMassTolerance = new Text(parent, 2048);
        this.txtMassTolerance.setLayoutData((Object)gd3);
        this.txtMassTolerance.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MassSpecStandardQuantPreferenceUI.this.setIsDirty(true);
                if (MassSpecStandardQuantPreferenceUI.this.isReadyToFinish()) {
                    MassSpecStandardQuantPreferenceUI.this.setPageComplete(true);
                } else {
                    MassSpecStandardQuantPreferenceUI.this.setPageComplete(false);
                }
            }
        });
        this.txtMassTolerance.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
        GridData gd4 = new GridData(4, 4, false, false, 4, 1);
        Label dummy4 = new Label(parent, 0);
        dummy4.setLayoutData((Object)gd4);
    }

    protected void addToleranceTypeItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblToleranceType = new Label(parent, 0);
        this.lblToleranceType.setText("Tolerance Type");
        this.lblToleranceType.setLayoutData((Object)gd1);
        Composite cmp = new Composite(parent, 0);
        GridData cmpGD = new GridData(768);
        cmpGD.horizontalSpan = 4;
        cmp.setLayoutData((Object)cmpGD);
        cmp.setLayout((Layout)new RowLayout());
        this.btnTolerancePPM = new Button(cmp, 16);
        this.btnTolerancePPM.setText("PPM");
        this.btnTolerancePPM.setSelection(true);
        this.btnToleranceDalton = new Button(cmp, 16);
        this.btnToleranceDalton.setText("Dalton");
        GridData gd4 = new GridData(4, 4, false, false, 1, 1);
        Label dummy4 = new Label(parent, 0);
        dummy4.setLayoutData((Object)gd4);
        this.btnToleranceDalton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MassSpecStandardQuantPreferenceUI.this.setIsDirty(true);
                if (MassSpecStandardQuantPreferenceUI.this.isReadyToFinish()) {
                    MassSpecStandardQuantPreferenceUI.this.setPageComplete(true);
                } else {
                    MassSpecStandardQuantPreferenceUI.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnToleranceDalton.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
        this.btnTolerancePPM.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MassSpecStandardQuantPreferenceUI.this.setIsDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnTolerancePPM.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected int getColNumberForGridColumn(GridColumn col) {
        int i = 0;
        while (i < this.getHeaderColumns().length) {
            if (col.getText().equals(this.getHeaderColumns()[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getRowNumberForItem(GridItem item) {
        int i = 0;
        while (i < this.gridSpecialPeaksGrid.getItems().length) {
            GridItem gi = this.gridSpecialPeaksGrid.getItem(i);
            if (gi.equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void addPeakListItem(Composite parent) {
        this.gridSpecialPeaksGrid = new Grid((Composite)this, 2816);
        this.gridSpecialPeaksGrid.setHeaderVisible(true);
        GridData gd_gridSpecialPeaksGrid = new GridData(4, 4, true, true, 6, 10);
        gd_gridSpecialPeaksGrid.heightHint = 150;
        this.gridSpecialPeaksGrid.setLayoutData((Object)gd_gridSpecialPeaksGrid);
        this.initGridColumns();
        this.initPeakListValues(null, -1, -1);
        this.editor = new GridEditor(this.gridSpecialPeaksGrid);
        this.gridSpecialPeaksGrid.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
                MassSpecStandardQuantPreferenceUI.this.setRemoveAllRowsEnabled();
                Point pt = new Point(e.x, e.y);
                GridColumn col = MassSpecStandardQuantPreferenceUI.this.gridSpecialPeaksGrid.getColumn(pt);
                GridItem item = MassSpecStandardQuantPreferenceUI.this.gridSpecialPeaksGrid.getItem(pt);
                if (item == null && col != null) {
                    int iColNum = MassSpecStandardQuantPreferenceUI.this.getColNumberForGridColumn(col);
                    int iSortOrder = 128;
                    if (col.getSort() == 128) {
                        iSortOrder = 1024;
                    }
                    MassSpecStandardQuantPreferenceUI.this.updateCurrentStandardQuantPeakData();
                    MassSpecStandardQuantPreferenceUI.this.initPeakListValues(MassSpecStandardQuantPreferenceUI.this.currentStandardQuant, iColNum, iSortOrder);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                MassSpecStandardQuantPreferenceUI.this.setIsDirty(true);
                MassSpecStandardQuantPreferenceUI.this.bIsEditingTable = true;
                Control oldEditor = MassSpecStandardQuantPreferenceUI.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                Point pt = new Point(e.x, e.y);
                final GridItem item = MassSpecStandardQuantPreferenceUI.this.gridSpecialPeaksGrid.getItem(pt);
                final Point cell = MassSpecStandardQuantPreferenceUI.this.gridSpecialPeaksGrid.getCell(pt);
                if (item == null || cell == null) {
                    return;
                }
                MassSpecStandardQuantPreferenceUI.this.gridSpecialPeaksGrid.deselect(cell.y);
                final Text newEditor = new Text((Composite)MassSpecStandardQuantPreferenceUI.this.gridSpecialPeaksGrid, 2052);
                String curText = item.getText(cell.x);
                newEditor.setText(curText);
                MassSpecStandardQuantPreferenceUI.this.editor.setEditor((Control)newEditor, item, cell.x);
                MassSpecStandardQuantPreferenceUI.this.editor.grabHorizontal = true;
                MassSpecStandardQuantPreferenceUI.this.editor.grabVertical = true;
                newEditor.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                        item.setText(cell.x, newEditor.getText());
                        if (MassSpecStandardQuantPreferenceUI.this.isValidCellValue(cell.x, newEditor.getText()) && MassSpecStandardQuantPreferenceUI.this.isReadyToFinish()) {
                            MassSpecStandardQuantPreferenceUI.this.setPageComplete(true);
                        } else {
                            MassSpecStandardQuantPreferenceUI.this.setPageComplete(false);
                        }
                    }

                    public void keyPressed(KeyEvent e) {
                    }
                });
                newEditor.forceFocus();
                newEditor.setSelection(newEditor.getText().length());
                newEditor.selectAll();
                int iRowNum = MassSpecStandardQuantPreferenceUI.this.getRowNumberForItem(item);
                if (iRowNum == MassSpecStandardQuantPreferenceUI.this.gridSpecialPeaksGrid.getItemCount() - 1) {
                    MassSpecStandardQuantPreferenceUI.this.addBlankRows(1);
                }
            }
        });
    }

    protected boolean isValidCellValue(int x, String sValue) {
        if (x == 0) {
            double dVal = -1.0;
            try {
                dVal = Double.parseDouble(sValue);
            }
            catch (NumberFormatException numberFormatException) {}
            if (dVal < 0.0) {
                this.setErrorMessage("m/z value must be a valid, positive double value");
                return false;
            }
        } else if (x == 1) {
            int iVal = -1;
            try {
                iVal = Integer.parseInt(sValue);
            }
            catch (NumberFormatException numberFormatException) {}
            if (iVal < 1) {
                this.setErrorMessage("MS level value must be a valid, positive integer > 1");
                return false;
            }
        }
        return true;
    }

    protected void disposeEditor() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
            this.editor.setEditor(null);
            this.bIsEditingTable = false;
        }
    }

    protected void setDeleteSelectedEnabled() {
        GridItem item;
        if (this.gridSpecialPeaksGrid != null && this.gridSpecialPeaksGrid.getSelectionIndex() != -1 && (item = this.gridSpecialPeaksGrid.getItem(this.gridSpecialPeaksGrid.getSelectionIndex())) != null) {
            int iItemCnt = this.getHeaderColumns().length;
            int i = 0;
            while (i < iItemCnt) {
                if (!item.getText(i).equals("")) {
                    this.btnRemoveSelected.setEnabled(true);
                    return;
                }
                ++i;
            }
        }
        this.btnRemoveSelected.setEnabled(false);
    }

    protected void setRemoveAllRowsEnabled() {
        if (this.gridSpecialPeaksGrid != null && this.gridSpecialPeaksGrid.getItems().length > 0) {
            int i = 0;
            while (i < this.gridSpecialPeaksGrid.getItems().length) {
                GridItem item = this.gridSpecialPeaksGrid.getItem(i);
                if (!item.getText(0).trim().equals("")) {
                    this.btnRemoveAllRows.setEnabled(true);
                    return;
                }
                ++i;
            }
        }
        this.btnRemoveAllRows.setEnabled(false);
    }

    protected void addRemoveRowComponents(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnRemoveSelected = new Button(parent, 0);
        this.btnRemoveSelected.setText("Remove Row");
        this.btnRemoveSelected.setLayoutData((Object)gd1);
        this.btnRemoveSelected.setEnabled(false);
        this.btnRemoveSelected.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int iSelRow = MassSpecStandardQuantPreferenceUI.this.gridSpecialPeaksGrid.getSelectionIndex();
                if (iSelRow != -1) {
                    MassSpecStandardQuantPreferenceUI.this.gridSpecialPeaksGrid.getItem(iSelRow);
                    MassSpecStandardQuantPreferenceUI.this.gridItemsSpecialPeaks.remove(iSelRow);
                    MassSpecStandardQuantPreferenceUI.this.gridSpecialPeaksGrid.remove(iSelRow);
                }
                MassSpecStandardQuantPreferenceUI.this.setIsDirty(true);
                MassSpecStandardQuantPreferenceUI.this.btnRemoveSelected.setEnabled(false);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnRemoveSelected.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
            }
        });
    }

    protected void addRemoveAllRowsComponents(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnRemoveAllRows = new Button(parent, 0);
        this.btnRemoveAllRows.setText("Remove All Rows");
        this.btnRemoveAllRows.setLayoutData((Object)gd1);
        GridData gd4 = new GridData(4, 4, true, false, 4, 1);
        Label dummy4 = new Label(parent, 0);
        dummy4.setLayoutData((Object)gd4);
        this.btnRemoveAllRows.setEnabled(false);
        this.btnRemoveAllRows.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int iVal = ErrorUtils.createMessageBoxReturn((Shell)MassSpecStandardQuantPreferenceUI.this.getShell(), (String)"Confirmation", (String)"Are you sure?");
                if (iVal == 1) {
                    MassSpecStandardQuantPreferenceUI.this.gridSpecialPeaksGrid.disposeAllItems();
                }
                MassSpecStandardQuantPreferenceUI.this.setIsDirty(true);
                MassSpecStandardQuantPreferenceUI.this.btnRemoveSelected.setEnabled(false);
                MassSpecStandardQuantPreferenceUI.this.btnRemoveAllRows.setEnabled(false);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnRemoveSelected.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
            }
        });
    }

    protected void addStandardQuantFileItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblAddStandardQuantFromFile = new Label(parent, 0);
        this.lblAddStandardQuantFromFile.setText("Add StandardQuant From File");
        this.lblAddStandardQuantFromFile.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 4, 1);
        this.txtAddStandardQuantFromFile = new Text(parent, 2048);
        this.txtAddStandardQuantFromFile.setText("<Please Browse for your file>");
        this.txtAddStandardQuantFromFile.setLayoutData((Object)gd2);
        this.txtAddStandardQuantFromFile.setEnabled(false);
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.btnAddStandardQuantFromFile = new Button(parent, 0);
        this.btnAddStandardQuantFromFile.setText("Browse");
        this.btnAddStandardQuantFromFile.setLayoutData((Object)gd3);
        this.btnAddStandardQuantFromFile.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileDialog fd = new FileDialog(MassSpecStandardQuantPreferenceUI.this.getShell(), 4096);
                fd.setText("Please select file for import");
                fd.setFilterNames(new String[]{"Tab-delimited (.txt)", "All files"});
                fd.setFilterExtensions(new String[]{"*.txt", "*.*"});
                String sPath = fd.open();
                if (sPath != null) {
                    MassSpecStandardQuantPreferenceUI.this.readTxtFile(sPath);
                    MassSpecStandardQuantPreferenceUI.this.initPeakListValues(MassSpecStandardQuantPreferenceUI.this.currentStandardQuant, -1, -1);
                    MassSpecStandardQuantPreferenceUI.this.txtAddStandardQuantFromFile.setText(sPath);
                    MassSpecStandardQuantPreferenceUI.this.setRemoveAllRowsEnabled();
                    MassSpecStandardQuantPreferenceUI.this.setIsDirty(true);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnAddStandardQuantFromFile.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
            }
        });
    }

    protected void readTxtFile(String sPath) {
        MassSpecStandardQuantFile.readTxtFile(this.currentStandardQuant, sPath);
    }

    protected void addSaveSettingsItem(Composite parent, boolean bAddItem) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        if (bAddItem) {
            this.btnSaveAsDefault = new Button(parent, 32);
            this.btnSaveAsDefault.setText("Save in workspace preferences");
            this.btnSaveAsDefault.setLayoutData((Object)gd1);
            this.btnSaveAsDefault.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MassSpecStandardQuantPreferenceUI.this.setIsDirty(true);
                    MassSpecStandardQuantPreferenceUI.this.disposeEditor();
                    MassSpecStandardQuantPreferenceUI.this.setDeleteSelectedEnabled();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        }
        GridData gd4 = new GridData(4, 4, true, false, 5, 1);
        Label dummy4 = new Label(parent, 0);
        dummy4.setLayoutData((Object)gd4);
    }

    protected void addBottomButtonsItem(Composite parent) {
    }

    protected MassSpecStandardQuantPeak getNewMassSpecStandardQuantPeak() {
        return new MassSpecStandardQuantPeak();
    }

    protected void updateCurrentStandardQuantPeakData() {
        if (this.currentStandardQuant != null) {
            HashMap<Double, MassSpecStandardQuantPeak> standardQuantPeaks = new HashMap<Double, MassSpecStandardQuantPeak>();
            int i = 0;
            while (i < this.gridSpecialPeaksGrid.getItems().length) {
                GridItem gi = this.gridSpecialPeaksGrid.getItem(i);
                if (!this.isBlankRow(gi)) {
                    MassSpecStandardQuantPeak peak = this.getNewMassSpecStandardQuantPeak();
                    try {
                        this.fillPeak(gi, peak);
                        Double dMz = Double.parseDouble(gi.getText(0).trim());
                        standardQuantPeaks.put(dMz, peak);
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
            this.currentStandardQuant.setStandardQuantPeaks(standardQuantPeaks);
        }
    }

    protected void addCurrentStandardQuant() {
        if (this.currentStandardQuant == null) {
            return;
        }
        MassSpecStandardQuant toDelete = null;
        int i = 0;
        while (i < this.getPreferenceStandardQuant(this.getLocalStandardQuant()).size()) {
            MassSpecStandardQuant curStandardQuant = this.getPreferenceStandardQuant(this.getLocalStandardQuant()).get(i);
            if (curStandardQuant.getStandardQuantName().equals(this.currentStandardQuant.getStandardQuantName())) {
                toDelete = curStandardQuant;
            }
            ++i;
        }
        if (toDelete != null) {
            this.getPreferenceStandardQuant(this.getLocalStandardQuant()).remove(toDelete);
        }
        this.getPreferenceStandardQuant(this.getLocalStandardQuant()).add(this.currentStandardQuant);
    }

    protected String[] getHeaderColumns() {
        return MassSpecStandardQuantFile.HEADER_COLUMN_LABELS;
    }

    protected void initGridColumns() {
        GridColumn[] cols = new GridColumn[this.getHeaderColumns().length];
        int i = 0;
        while (i < this.getHeaderColumns().length) {
            cols[i] = new GridColumn(this.gridSpecialPeaksGrid, 0);
            cols[i].setText(this.getHeaderColumns()[i]);
            cols[i].setWidth(this.getDefaultColumnWidth(i));
            ++i;
        }
        if (this.btnRemoveSelected != null) {
            this.btnRemoveSelected.setEnabled(false);
        }
    }

    protected int getDefaultColumnWidth(int _iColNum) {
        if (_iColNum == 0) {
            return 100;
        }
        if (_iColNum == 1) {
            return 100;
        }
        if (_iColNum == 2) {
            return 200;
        }
        return 50;
    }

    protected void fillRow(GridItem gi, MassSpecStandardQuantPeak peak) {
        int j = 0;
        try {
            if (peak == null || peak.getPeakMz() == null) {
                return;
            }
            gi.setText(j++, peak != null ? Double.toString(peak.getPeakMz()) : "");
            gi.setText(j++, peak != null ? Integer.toString(peak.getMSLevel()) : "");
            gi.setText(j++, peak != null ? peak.getPeakLabel() : "");
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected boolean isBlankRow(GridItem gi) {
        int i = 0;
        while (i < this.getHeaderColumns().length) {
            if (!gi.getText(i).equals("")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void fillPeak(GridItem gi, MassSpecStandardQuantPeak peak) {
        try {
            if (this.isBlankRow(gi)) {
                return;
            }
            int j = 0;
            peak.setPeakMz(Double.parseDouble(gi.getText(j++)));
            peak.setMSLevel(Integer.parseInt(gi.getText(j++)));
            peak.setPeakLabel(gi.getText(j++));
        }
        catch (NumberFormatException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected List<MassSpecStandardQuantPeak> getSortedPeaks(MassSpecStandardQuant standardQuant, int iSortCol, int sortDir) {
        if (standardQuant != null) {
            ArrayList<Double> sortNumericKeys = new ArrayList<Double>();
            ArrayList<String> sortStringKeys = new ArrayList<String>();
            Collection<MassSpecStandardQuantPeak> peakCollection = standardQuant.getStandardQuantPeaks().values();
            for (MassSpecStandardQuantPeak peak : peakCollection) {
                if (iSortCol <= 0) {
                    sortNumericKeys.add(peak.getPeakMz());
                    continue;
                }
                if (iSortCol == 1) {
                    sortNumericKeys.add(Double.valueOf(peak.getMSLevel().intValue()));
                    continue;
                }
                sortStringKeys.add(peak.getPeakLabel());
            }
            if (iSortCol >= 0) {
                if (sortDir == 128) {
                    Collections.sort(sortNumericKeys);
                    Collections.sort(sortStringKeys);
                } else {
                    Collections.sort(sortNumericKeys, Collections.reverseOrder());
                    Collections.sort(sortStringKeys, Collections.reverseOrder());
                }
            }
            ArrayList<String> list = sortNumericKeys.isEmpty() ? sortStringKeys : sortNumericKeys;
            ArrayList<MassSpecStandardQuantPeak> sortedList = new ArrayList<MassSpecStandardQuantPeak>();
            int i = 0;
            while (i < list.size()) {
                Object oVal = list.get(i);
                for (MassSpecStandardQuantPeak peak : peakCollection) {
                    if (sortedList.contains(peak)) continue;
                    if (iSortCol <= 0) {
                        if ((Double)oVal != peak.getPeakMz()) continue;
                        sortedList.add(peak);
                        continue;
                    }
                    if (iSortCol == 1) {
                        if (((Double)oVal).intValue() != peak.getMSLevel().intValue()) continue;
                        sortedList.add(peak);
                        continue;
                    }
                    if (!((String)oVal).equals(peak.getPeakLabel())) continue;
                    sortedList.add(peak);
                }
                ++i;
            }
            return sortedList;
        }
        return null;
    }

    protected void initPeakListValues(MassSpecStandardQuant standardQuant, int iSortCol, int iSortOrder) {
        if (this.gridItemsSpecialPeaks == null) {
            this.gridItemsSpecialPeaks = new ArrayList<GridItem>();
        }
        if (standardQuant != null) {
            this.removeBlankRows();
            int i = 0;
            while (i < this.getHeaderColumns().length) {
                GridColumn col = this.gridSpecialPeaksGrid.getColumn(i);
                col.setSort(0);
                ++i;
            }
            List<MassSpecStandardQuantPeak> lSortedList = this.getSortedPeaks(standardQuant, iSortCol, iSortOrder);
            int i2 = 0;
            while (i2 < lSortedList.size()) {
                GridItem gi = new GridItem(this.gridSpecialPeaksGrid, 0);
                MassSpecStandardQuantPeak peak = lSortedList.get(i2);
                this.fillRow(gi, peak);
                this.gridItemsSpecialPeaks.add(gi);
                ++i2;
            }
            if (iSortOrder >= 0) {
                this.gridSpecialPeaksGrid.getColumn(iSortCol).setSort(iSortOrder);
            }
        }
        this.addBlankRows(3);
    }

    protected void addBlankRows(int iNumRows) {
        int iStart = this.gridSpecialPeaksGrid.getItemCount();
        int iEnd = iStart + iNumRows;
        int i = iStart;
        while (i < iEnd) {
            GridItem gi = new GridItem(this.gridSpecialPeaksGrid, 0);
            this.fillRow(gi, null);
            this.gridItemsSpecialPeaks.add(gi);
            ++i;
        }
    }

    protected void removeBlankRows() {
        ArrayList<Integer> iBlankRows = new ArrayList<Integer>();
        int iEnd = this.gridSpecialPeaksGrid.getItemCount();
        int i = 0;
        while (i < iEnd) {
            GridItem gi = this.gridSpecialPeaksGrid.getItem(i);
            boolean bDone = false;
            int j = 0;
            while (j < this.getHeaderColumns().length) {
                String sVal = gi.getText(j);
                if (sVal != null && !sVal.trim().equals("")) {
                    bDone = true;
                    break;
                }
                ++j;
            }
            if (!bDone) {
                iBlankRows.add(i);
            }
            ++i;
        }
        if (!iBlankRows.isEmpty()) {
            int[] iRows = new int[iBlankRows.size()];
            int iCnt = 0;
            int i2 = 0;
            while (i2 < iBlankRows.size()) {
                iRows[iCnt++] = (Integer)iBlankRows.get(i2);
                ++i2;
            }
            this.gridSpecialPeaksGrid.remove(iRows);
        }
    }

    public void updateSettings() {
        this.disposeEditor();
        if (this.currentStandardQuant != null) {
            this.currentStandardQuant.setStandardQuantName(this.sStandardQuantName);
            this.currentStandardQuant.setDescription(this.sDescription);
            this.currentStandardQuant.setMassTolerance(this.dMassTolerance);
            this.currentStandardQuant.setIsPPM(this.bIsPPM);
            this.updateCurrentStandardQuantPeakData();
        }
    }

    public void updatePreferences() {
        if (this.currentStandardQuant != null) {
            this.addCurrentStandardQuant();
        }
        this.setIsDirty(false);
    }

    public void updateUI() {
        this.initStoredStandardQuantList();
        this.setEditEnabled(false);
        if (this.cmbSelectStandardQuant.getSelectionIndex() == -1) {
            this.cmbSelectStandardQuant.select(this.cmbSelectStandardQuant.getItemCount() - 1);
        } else {
            this.cmbSelectStandardQuant.select(this.cmbSelectStandardQuant.getSelectionIndex());
        }
        this.btnEditCurrent.setEnabled(true);
        this.btnExportXML.setEnabled(true);
        this.btnDeleteCurrent.setEnabled(true);
        this.setDeleteSelectedEnabled();
        this.setRemoveAllRowsEnabled();
        this.setResetEnabled();
    }

    protected void handleEdit() {
        if (this.gridSpecialPeaksGrid.getSelectionIndices().length > 1) {
            this.setErrorMessage("You can edit only one specialPeak at a time");
            return;
        }
        if (this.isReadyToFinish()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    protected boolean isReadyToFinish() {
        this.sStandardQuantName = null;
        this.sDescription = null;
        this.sMSLevel = null;
        this.dMassTolerance = null;
        this.bIsPPM = null;
        if (this.txtStandardQuantName.getText().trim().equals("")) {
            this.setErrorMessage("StandardQuant name cannot be empty");
            return false;
        }
        this.sStandardQuantName = this.txtStandardQuantName.getText().trim();
        this.sDescription = this.txtDescription.getText().trim();
        boolean bPass = true;
        if (!this.txtMassTolerance.getText().trim().equals("")) {
            try {
                this.dMassTolerance = Double.parseDouble(this.txtMassTolerance.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                bPass = false;
            }
            if (this.dMassTolerance <= 0.0) {
                bPass = false;
            }
        } else {
            bPass = false;
        }
        if (!bPass) {
            this.setErrorMessage("Mass tolerance must be a valid, positive number");
            return false;
        }
        this.bIsPPM = this.btnTolerancePPM.getSelection() ? Boolean.TRUE : Boolean.FALSE;
        if (this.gridItemsSpecialPeaks == null || this.gridItemsSpecialPeaks.isEmpty()) {
            this.setErrorMessage("No peaks specified!");
            return false;
        }
        int i = 0;
        while (i < this.gridSpecialPeaksGrid.getItems().length) {
            GridItem gi = this.gridSpecialPeaksGrid.getItem(i);
            if (!this.isBlankRow(gi)) {
                int j = 0;
                while (j < this.getHeaderColumns().length) {
                    String sText = gi.getText(j);
                    if (!this.isValidCellValue(j, sText)) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setPageComplete(boolean isComplete) {
        PropertyChangeEvent e = new PropertyChangeEvent((Object)this, PAGE_COMPLETE_PROPERTY, (Object)this.isComplete, (Object)isComplete);
        this.isComplete = isComplete;
        this.listener.propertyChange(e);
    }

    public boolean isPageCompete() {
        return this.isComplete;
    }

    public class StandardQuantPaintListener
    implements PaintListener {
        MassSpecStandardQuantPreferenceUI parent = null;

        public StandardQuantPaintListener(MassSpecStandardQuantPreferenceUI parent) {
            this.parent = parent;
        }

        public void paintControl(PaintEvent e) {
            Entry entry = MassSpecStandardQuantPreferenceUI.this.getEntryForCurrentViewer();
            if (entry != null && !entry.equals(this.parent.getEntry())) {
                this.parent.setEntry(entry);
                this.parent.initLocalStandardQuant();
                this.parent.initStoredStandardQuantList();
            }
        }
    }
}

