/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.extquantfiles.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.grits.toolbox.entry.ms.extquantfiles.process.ExternalQuantColumnInfo;
import org.grits.toolbox.entry.ms.extquantfiles.process.QuantFileProcessor;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationPeak;
import org.grits.toolbox.ms.file.extquant.data.ComparatorQuantPeakMatch;
import org.grits.toolbox.ms.file.extquant.data.ExternalQuantSettings;
import org.grits.toolbox.ms.file.extquant.data.QuantPeak;
import org.grits.toolbox.ms.file.extquant.data.QuantPeakData;
import org.grits.toolbox.ms.file.extquant.data.QuantPeakMatch;
import org.grits.toolbox.ms.file.reader.impl.InvalidFileFormatException;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;

public class CustomAnnotationDataProcessor
extends QuantFileProcessor {
    private static final Logger logger = Logger.getLogger(CustomAnnotationDataProcessor.class);
    protected MassSpecCustomAnnotation msca = null;
    protected Scan curScan = null;
    protected HashMap<Integer, List<Peak>> hmPeakList = null;

    public CustomAnnotationDataProcessor(ExternalQuantSettings a_parameter) {
        super(a_parameter);
    }

    public void setCustomAnnotationPeakList() {
        if (this.getMassSpecCustomAnnotation() == null || this.getMassSpecCustomAnnotation() == null) {
            return;
        }
        this.hmPeakList = new HashMap();
        Collection<MassSpecCustomAnnotationPeak> customPeaks = this.getMassSpecCustomAnnotation().getAnnotatedPeaks().values();
        for (MassSpecCustomAnnotationPeak customPeak : customPeaks) {
            Peak p = new Peak();
            p.setMz(customPeak.getPeakMz());
            p.setIntensity(Double.valueOf(1.0));
            List<Object> lPeaks = null;
            if (!this.hmPeakList.containsKey(customPeak.getMSLevel())) {
                lPeaks = new ArrayList();
                this.hmPeakList.put(customPeak.getMSLevel(), lPeaks);
            } else {
                lPeaks = this.hmPeakList.get(customPeak.getMSLevel());
            }
            lPeaks.add(p);
        }
    }

    public void setPeakList(HashMap<Integer, List<Peak>> lPeakList) {
        this.hmPeakList = lPeakList;
    }

    public HashMap<Integer, List<Peak>> getPeakList() {
        return this.hmPeakList;
    }

    public List<Peak> getPeakList(Integer iMSLevel) {
        return this.hmPeakList.get(iMSLevel);
    }

    public void setCurScan(Scan curScan) {
        this.curScan = curScan;
    }

    public Scan getCurScan() {
        return this.curScan;
    }

    @Override
    public void loadExternalData() {
        if (this.m_settings.getTargetScanNumber() != null) {
            try {
                this.m_quantPeakData = this.read();
                List lQPM = this.m_quantPeakData.generateAllMatches();
                Collections.sort(lQPM, new ComparatorQuantPeakMatch());
                this.m_quantPeakMatches.put(this.curScan.getScanNo(), lQPM);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void generateAllMatches() {
        if (this.m_quantPeakData != null) {
            try {
                List lQPM = this.m_quantPeakData.generateAllMatches();
                Collections.sort(lQPM, new ComparatorQuantPeakMatch());
                this.m_quantPeakMatches.put(this.curScan.getScanNo(), lQPM);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void clearPeakData(List<CustomExtraData> lCED) {
        if (lCED == null || lCED.isEmpty()) {
            return;
        }
        for (Peak p : this.getCurScan().getPeaklist()) {
            ArrayList<String> sToDelete = new ArrayList<String>();
            for (String sKey : p.getDoubleProp().keySet()) {
                for (CustomExtraData ced : lCED) {
                    if (!sKey.equals(ced.getKey())) continue;
                    sToDelete.add(sKey);
                }
            }
            for (String sKey : sToDelete) {
                p.getDoubleProp().remove(sKey);
            }
            sToDelete.clear();
            for (String sKey : p.getIntegerProp().keySet()) {
                for (CustomExtraData ced : lCED) {
                    if (!sKey.equals(ced.getKey())) continue;
                    sToDelete.add(sKey);
                }
            }
            for (String sKey : sToDelete) {
                p.getIntegerProp().remove(sKey);
            }
            sToDelete.clear();
            for (String sKey : p.getStringProp().keySet()) {
                for (CustomExtraData ced : lCED) {
                    if (!sKey.equals(ced.getKey())) continue;
                    sToDelete.add(sKey);
                }
            }
            for (String sKey : sToDelete) {
                p.getStringProp().remove(sKey);
            }
        }
    }

    public QuantPeakData read() {
        QuantPeakData qpd = new QuantPeakData();
        try {
            for (Peak p : this.getCurScan().getPeaklist()) {
                QuantPeak qp = QuantPeak.getQuantPeakData((double)p.getMz());
                double dTol = QuantPeakMatch.getDaTolerance((double)p.getMz(), (double)this.getSettings().getIntensityCorrectionValue(), (boolean)this.getSettings().isIntensityCorrectionPpm());
                QuantPeakMatch qpm = QuantPeakMatch.findQuantPeakMatch((QuantPeak)qp, (double)p.getMz(), this.getPeakList(this.getCurScan().getMsLevel()), (double)dTol);
                if (qpm == null) continue;
                qp.add(qpm);
                qpd.add(qp);
            }
        }
        catch (InvalidFileFormatException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return qpd;
    }

    public boolean matchCorrectedPeaks(Map<Integer, Scan> _mScans, boolean _bRequirePrecursorPeak) {
        Scan t_scanToProcess = null;
        boolean bUpdated = false;
        if (this.m_quantPeakData.getScanNo() != -1) {
            t_scanToProcess = _mScans.get(this.m_quantPeakData.getScanNo());
        } else {
            for (Scan t_scan : _mScans.values()) {
                if (t_scan.getMsLevel() != 1) continue;
                t_scanToProcess = t_scan;
                this.m_quantPeakData.setScanNo(t_scan.getScanNo().intValue());
                break;
            }
        }
        if (t_scanToProcess != null && t_scanToProcess.getPeaklist() != null) {
            for (Peak t_peak : t_scanToProcess.getPeaklist()) {
                QuantPeakMatch cPeak;
                if (_bRequirePrecursorPeak && !t_peak.getIsPrecursor() || (cPeak = this.findExternalPeak(t_peak.getMz())) == null) continue;
                this.findExternalPeak(t_peak.getMz());
                bUpdated |= this.setExternalPeakData(t_peak, cPeak);
            }
        }
        return bUpdated;
    }

    @Override
    public boolean setExternalPeakData(Peak a_peak, QuantPeakMatch cPeak) {
        Double dKey = cPeak.getMzMostAbundant();
        String sLabel = dKey.toString();
        if (this.getMassSpecCustomAnnotation().getAnnotatedPeaks().containsKey(dKey)) {
            sLabel = this.getMassSpecCustomAnnotation().getAnnotatedPeaks().get(dKey).getPeakLabel();
        }
        String sIntKey = ExternalQuantColumnInfo.getExternalQuantIntensity(dKey.toString(), sLabel).getKey();
        String sMzKey = ExternalQuantColumnInfo.getExternalQuantIntensityMz(dKey.toString(), sLabel).getKey();
        boolean bAdd = true;
        if (a_peak.getDoubleProp().containsKey(sIntKey) && a_peak.getDoubleProp().containsKey(sMzKey)) {
            bAdd = false;
            Double cfr_ignored_0 = (Double)a_peak.getDoubleProp().get(sIntKey);
            Double dVal2 = a_peak.getIntensity();
            if (dVal2 != null) {
                bAdd = true;
            }
            Double cfr_ignored_1 = (Double)a_peak.getDoubleProp().get(sMzKey);
            dVal2 = a_peak.getMz();
            if (dVal2 != null) {
                bAdd = true;
            }
        }
        if (bAdd) {
            this.fillPeakData(a_peak, cPeak);
        }
        return bAdd;
    }

    public void setMassSpecCustomAnnotation(MassSpecCustomAnnotation msca) {
        this.msca = msca;
    }

    public MassSpecCustomAnnotation getMassSpecCustomAnnotation() {
        return this.msca;
    }

    protected void fillPeakData(Peak a_peak, QuantPeakMatch cPeak) {
        Double dKey = cPeak.getMzMostAbundant();
        String sLabel = dKey.toString();
        if (this.getMassSpecCustomAnnotation().getAnnotatedPeaks().containsKey(dKey)) {
            sLabel = this.getMassSpecCustomAnnotation().getAnnotatedPeaks().get(dKey).getPeakLabel();
        }
        String sIntKey = ExternalQuantColumnInfo.getExternalQuantIntensity(dKey.toString(), sLabel).getKey();
        String sMzKey = ExternalQuantColumnInfo.getExternalQuantIntensityMz(dKey.toString(), sLabel).getKey();
        a_peak.addDoubleProp(sIntKey, a_peak.getIntensity());
        a_peak.addDoubleProp(sMzKey, a_peak.getMz());
    }

    protected void clearPeakData(Peak a_peak, QuantPeakMatch cPeak) {
        Double dKey = cPeak.getMzMostAbundant();
        String sLabel = dKey.toString();
        if (this.getMassSpecCustomAnnotation().getAnnotatedPeaks().containsKey(dKey)) {
            sLabel = this.getMassSpecCustomAnnotation().getAnnotatedPeaks().get(dKey).getPeakLabel();
        }
        String sIntKey = ExternalQuantColumnInfo.getExternalQuantIntensity(dKey.toString(), sLabel).getKey();
        String sMzKey = ExternalQuantColumnInfo.getExternalQuantIntensityMz(dKey.toString(), sLabel).getKey();
        a_peak.getDoubleProp().remove(sIntKey);
        a_peak.getDoubleProp().remove(sMzKey);
    }
}

