/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MassSpecViewerDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(MassSpecViewerDialog.class);
    private Entry massSpecEntry;
    private List<IPropertyChangeListener> listeners = null;
    private MassSpecMultiPageViewer contextViewer = null;

    public MassSpecViewerDialog(Shell parentShell, MassSpecMultiPageViewer contextViewer) {
        super(parentShell);
        this.contextViewer = contextViewer;
    }

    public Property getEntryParentProperty() {
        try {
            Entry entry = this.getEntryForCurrentViewer();
            MassSpecEntityProperty msep = (MassSpecEntityProperty)entry.getProperty();
            MassSpecProperty pp = msep.getMassSpecParentProperty();
            return pp;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public Entry getMassSpecEntry() {
        return this.massSpecEntry;
    }

    public void setMassSpecEntry(Entry massSpecEntry) {
        this.massSpecEntry = massSpecEntry;
    }

    public MassSpecMultiPageViewer getCurrentViewer() {
        try {
            MassSpecMultiPageViewer viewer;
            EPartService partService = this.getContextViewer().getPartService();
            MPart mPart = partService.getActivePart();
            if (mPart != null && mPart.equals(mPart.getParent().getSelectedElement()) && mPart.getObject() instanceof MassSpecMultiPageViewer && (viewer = (MassSpecMultiPageViewer)((Object)mPart.getObject())).getEntry().getProperty() != null && viewer.getEntry().getProperty() instanceof MassSpecEntityProperty) {
                return viewer;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected Entry getEntryForCurrentViewer() {
        MassSpecMultiPageViewer viewer = this.getCurrentViewer();
        if (viewer == null) {
            return null;
        }
        return viewer.getEntry();
    }

    public MassSpecMultiPageViewer getContextViewer() {
        return this.contextViewer;
    }

    public void addListener(IPropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPropertyChangeListener>();
        }
        this.listeners.add(listener);
    }

    public List<IPropertyChangeListener> getListeners() {
        return this.listeners;
    }
}

