/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridEditor;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.entry.ms.dialog.IDynamicTableProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.StandardQuantColumnInfo;
import org.grits.toolbox.entry.ms.property.FileLockManager;
import org.grits.toolbox.entry.ms.property.FileLockingUtils;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantAlias;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MassSpecStandardQuantFileGrid
extends Grid
implements IDynamicTableProcessor {
    private static final Logger logger = Logger.getLogger(MassSpecStandardQuantFileGrid.class);
    protected List<MSPropertyDataFile> storedStdQuantFiles = null;
    protected List<MSPropertyDataFile> appliedStdQuantFiles = null;
    protected FileLockManager fileLockManager = null;
    private static String[] columnHeaders = new String[]{"Selected", "MS File", "Type", "Purpose", "Alias"};
    protected GridEditor editor = null;
    protected boolean bIsEditingTable = false;
    private static int CELL_EDIT_COLUMN = 4;
    public static final String PROPERTY_WIN_CLOSED = "Window Closed";
    protected String lastUpdatedQuantFile = null;
    private String lockFilePath = null;
    protected String sStdQuantName = null;
    private MassSpecMultiPageViewer contextViewer = null;
    private Color bgColor = null;

    public MassSpecStandardQuantFileGrid(Composite parent, MassSpecMultiPageViewer contextViewer) {
        super(parent, 2816);
        this.contextViewer = contextViewer;
        this.loadStandardQuantificationFiles();
        this.fileLockManager = this.loadLockFile();
    }

    public MassSpecMultiPageViewer getCurrentViewer() {
        try {
            MassSpecMultiPageViewer viewer;
            EPartService partService = this.getContextViewer().getPartService();
            MPart mPart = partService.getActivePart();
            if (mPart != null && mPart.equals(mPart.getParent().getSelectedElement()) && mPart.getObject() instanceof MassSpecMultiPageViewer && (viewer = (MassSpecMultiPageViewer)((Object)mPart.getObject())).getEntry().getProperty() != null && viewer.getEntry().getProperty() instanceof MassSpecEntityProperty) {
                return viewer;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected Entry getEntryForCurrentViewer() {
        MassSpecMultiPageViewer viewer = this.getCurrentViewer();
        if (viewer == null) {
            return null;
        }
        return viewer.getEntry();
    }

    public MassSpecMultiPageViewer getContextViewer() {
        return this.contextViewer;
    }

    private FileLockManager loadLockFile() {
        Entry entry = this.getEntryForCurrentViewer();
        MassSpecEntityProperty msep = (MassSpecEntityProperty)entry.getProperty();
        MassSpecProperty pp = msep.getMassSpecParentProperty();
        try {
            this.lockFilePath = pp.getLockFilePath(entry);
            this.fileLockManager = FileLockingUtils.readLockFile(this.lockFilePath);
        }
        catch (IOException | JAXBException e) {
            logger.error((Object)"Cannot load the lock file", e);
            this.fileLockManager = null;
        }
        return this.fileLockManager;
    }

    public Property getEntryParentProperty() {
        try {
            Entry entry = this.getEntryForCurrentViewer();
            MassSpecEntityProperty msep = (MassSpecEntityProperty)entry.getProperty();
            MassSpecProperty pp = msep.getMassSpecParentProperty();
            return pp;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected List<MSPropertyDataFile> getStandardQuantificationFiles() {
        MassSpecUISettings entrySettings = this.getEntrySettings();
        ArrayList<MSPropertyDataFile> fileList = new ArrayList<MSPropertyDataFile>();
        fileList.addAll(entrySettings.getAnnotationFiles());
        fileList.addAll(entrySettings.getQuantificationFiles());
        return fileList;
    }

    protected MassSpecUISettings getEntrySettings() {
        MassSpecProperty msp = (MassSpecProperty)this.getEntryParentProperty();
        MassSpecMetaData entrySettings = msp.getMassSpecMetaData();
        return entrySettings;
    }

    protected void loadStandardQuantificationFiles() {
        this.storedStdQuantFiles = this.getStandardQuantificationFiles();
    }

    private MSPropertyDataFile getPropertyFileByName(String sGridFileName) {
        int i = 0;
        while (i < this.storedStdQuantFiles.size()) {
            MSPropertyDataFile mspdf;
            String sFileName;
            PropertyDataFile pdf = this.storedStdQuantFiles.get(i);
            if (pdf instanceof MSPropertyDataFile && (sFileName = MSPropertyDataFile.getFormattedName(mspdf = (MSPropertyDataFile)pdf)).equals(sGridFileName)) {
                return mspdf;
            }
            ++i;
        }
        return null;
    }

    public void updateAppliedFileList(String sCurIntStdQuant) {
        MassSpecUISettings entrySettings = this.getEntrySettings();
        int i = 0;
        while (i < this.getItems().length) {
            GridItem gi = this.getItem(i);
            String sGridFileName = gi.getText(1);
            MSPropertyDataFile mspdf = this.getPropertyFileByName(sGridFileName);
            if (mspdf != null) {
                String sFilePath = mspdf.getName();
                String sFileName = MSPropertyDataFile.getFormattedName(mspdf);
                String sExtQuantType = MassSpecUISettings.getExternalQuantType(mspdf);
                String sAlias = sFileName;
                mspdf.getPurposeString();
                boolean isInUse = false;
                if (sCurIntStdQuant != null) {
                    ExternalQuantFileToAlias mExtAliases;
                    ExternalQuantFileToAlias mAliases = entrySettings.getInternalQuantFileToAlias(sCurIntStdQuant, mspdf);
                    if (mAliases != null && mAliases.getSourceDataFileNameToAlias().containsKey(sFilePath)) {
                        ExternalQuantAlias aliasInfo = mAliases.getSourceDataFileNameToAlias().get(sFilePath);
                        sAlias = aliasInfo.getAlias();
                        isInUse = true;
                    }
                    if (!isInUse && (mExtAliases = entrySettings.getExternalQuantToAliasByQuantType(sExtQuantType)) != null && mExtAliases.getSourceDataFileNameToAlias().containsKey(sFilePath)) {
                        ExternalQuantAlias aliasInfo = mExtAliases.getSourceDataFileNameToAlias().get(sFilePath);
                        sAlias = aliasInfo.getAlias();
                    }
                }
                gi.setChecked(0, isInUse);
                gi.setText(4, sAlias);
                this.sStdQuantName = sCurIntStdQuant;
            }
            ++i;
        }
    }

    public void initializeGrid() {
        this.setLinesVisible(true);
        this.setHeaderVisible(true);
        int i = 0;
        while (i < columnHeaders.length) {
            GridColumn column = null;
            if (i == 0) {
                column = new GridColumn((Grid)this, 0x1000020);
                column.setCheckable(true);
            } else {
                column = new GridColumn((Grid)this, 0);
            }
            column.setText(columnHeaders[i]);
            ++i;
        }
        this.getEntrySettings();
        this.editor = new GridEditor((Grid)this);
        i = 0;
        while (i < this.storedStdQuantFiles.size()) {
            PropertyDataFile pdf = this.storedStdQuantFiles.get(i);
            if (!(pdf instanceof MSPropertyDataFile)) {
                logger.error((Object)"Property data file not of correct type!");
            } else {
                String sFileName;
                MSPropertyDataFile mspdf = (MSPropertyDataFile)pdf;
                String sAlias = sFileName = MSPropertyDataFile.getFormattedName(mspdf);
                String sPurpose = mspdf.getPurposeString();
                GridItem item = new GridItem((Grid)this, 0);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        logger.debug((Object)"Did you click the cell?");
                    }
                });
                item.setText(1, sFileName);
                item.setText(2, mspdf.getType());
                item.setText(3, sPurpose);
                item.setText(4, sAlias);
            }
            ++i;
        }
        i = 0;
        while (i < columnHeaders.length) {
            this.getColumn(i).pack();
            ++i;
        }
        final MassSpecStandardQuantFileGrid me = this;
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
                MassSpecStandardQuantFileGrid.this.disposeEditor();
                Point pt = new Point(e.x, e.y);
                GridColumn col = MassSpecStandardQuantFileGrid.this.getColumn(pt);
                GridItem item = MassSpecStandardQuantFileGrid.this.getItem(pt);
                if (item == null && col != null) {
                    MassSpecStandardQuantFileGrid.this.getColNumberForGridColumn(col);
                    if (col.getSort() == 128) {
                        // empty if block
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                MassSpecStandardQuantFileGrid.this.bIsEditingTable = true;
                Control oldEditor = MassSpecStandardQuantFileGrid.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                Point pt = new Point(e.x, e.y);
                final GridItem item = MassSpecStandardQuantFileGrid.this.getItem(pt);
                final Point cell = MassSpecStandardQuantFileGrid.this.getCell(pt);
                if (item == null || cell == null) {
                    return;
                }
                if (cell.x != CELL_EDIT_COLUMN) {
                    return;
                }
                MassSpecStandardQuantFileGrid.this.deselect(cell.y);
                final Text newEditor = new Text((Composite)me, 2052);
                String curText = item.getText(cell.x);
                newEditor.setText(curText);
                MassSpecStandardQuantFileGrid.this.editor.setEditor((Control)newEditor, item, cell.x);
                MassSpecStandardQuantFileGrid.this.editor.grabHorizontal = true;
                MassSpecStandardQuantFileGrid.this.editor.grabVertical = true;
                newEditor.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                        item.setText(cell.x, newEditor.getText());
                    }

                    public void keyPressed(KeyEvent e) {
                    }
                });
                newEditor.forceFocus();
                newEditor.setSelection(newEditor.getText().length());
                newEditor.selectAll();
            }
        });
        this.setEnabled(false);
        this.bgColor = this.getBackground();
    }

    protected void disposeEditor() {
        if (this.editor == null) {
            return;
        }
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
            this.editor.setEditor(null);
            this.bIsEditingTable = false;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.setBackground(this.bgColor);
            this.updateAppliedFileList(null);
        }
    }

    protected int getNumSelectedEntries() {
        int iCnt = 0;
        int i = 0;
        while (i < this.getItems().length) {
            GridItem gi = this.getItem(i);
            boolean isInUse = gi.getChecked(0);
            if (isInUse) {
                ++iCnt;
            }
            ++i;
        }
        return iCnt;
    }

    public Map<String, String> getSelectedQuantFileAliases() {
        try {
            HashMap<String, String> mFiles = new HashMap<String, String>();
            int i = 0;
            while (i < this.getItems().length) {
                GridItem gi = this.getItem(i);
                String sGridFileName = gi.getText(1);
                String sGridAlias = gi.getText(4);
                boolean isInUse = gi.getChecked(0);
                if (isInUse) {
                    mFiles.put(sGridFileName, sGridAlias);
                }
                ++i;
            }
            return mFiles;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean updateIntQuantFileSettings() {
        boolean bChanged = false;
        try {
            MassSpecUISettings entrySettings = this.getEntrySettings();
            Property msp = this.getEntryParentProperty();
            Entry entry = this.findParentEntry(this.getEntryForCurrentViewer(), msp);
            int i = 0;
            while (i < this.getItems().length) {
                GridItem gi = this.getItem(i);
                String sGridFileName = gi.getText(1);
                String sGridAlias = gi.getText(4);
                boolean isInUse = gi.getChecked(0);
                int j = 0;
                while (j < this.storedStdQuantFiles.size()) {
                    PropertyDataFile pdf = this.storedStdQuantFiles.get(j);
                    if (!(pdf instanceof MSPropertyDataFile)) {
                        logger.error((Object)"Property data file not of correct type!");
                    } else {
                        MSPropertyDataFile mspdf = (MSPropertyDataFile)pdf;
                        String sFilePath = mspdf.getName();
                        String sFileName = MSPropertyDataFile.getFormattedName(mspdf);
                        if (sGridFileName.equals(sFileName)) {
                            boolean bThisChanged;
                            String sExtQuantType = MassSpecUISettings.getExternalQuantType(mspdf);
                            boolean wasInUse = false;
                            String sAlias = sFileName;
                            ExternalQuantFileToAlias mAliases = entrySettings.getInternalQuantFileToAlias(this.sStdQuantName, mspdf);
                            if (mAliases != null && mAliases.getSourceDataFileNameToAlias().containsKey(sFilePath)) {
                                ExternalQuantAlias aliasInfo = mAliases.getSourceDataFileNameToAlias().get(sFilePath);
                                sAlias = aliasInfo.getAlias();
                                wasInUse = true;
                            }
                            boolean wasInUseForExternalQuant = false;
                            ExternalQuantFileToAlias mExtQuantAliases = entrySettings.getExternalQuantToAliasByQuantType(sExtQuantType);
                            if (mExtQuantAliases != null && mExtQuantAliases.getSourceDataFileNameToAlias().containsKey(sFilePath)) {
                                wasInUseForExternalQuant = true;
                            }
                            boolean bl = bThisChanged = isInUse ^ wasInUse || !sAlias.equals(sGridAlias);
                            if (bThisChanged) {
                                this.lastUpdatedQuantFile = null;
                                if (!isInUse) {
                                    entrySettings.removeInternalStandardQuantFile(this.sStdQuantName, mspdf);
                                    this.fileLockManager.removeLock(sFilePath, entry);
                                    FileLockingUtils.writeLockFile(this.fileLockManager, this.lockFilePath);
                                    if (!wasInUseForExternalQuant && entrySettings.getSourceDataFileList() != null && entrySettings.getSourceDataFileList().contains((Object)mspdf)) {
                                        entrySettings.getSourceDataFileList().remove((Object)mspdf);
                                    }
                                    mAliases = entrySettings.getInternalQuantFileToAlias(this.sStdQuantName, mspdf);
                                    entrySettings.updateQuantAliasKeyInfo(mspdf, mAliases, StandardQuantColumnInfo.QUANT_PREFIX);
                                } else {
                                    ExternalQuantAlias eqa = new ExternalQuantAlias();
                                    eqa.setAlias(sGridAlias);
                                    entrySettings.addInternalStandardQuantFile(this.sStdQuantName, mspdf, eqa);
                                    mAliases = entrySettings.getInternalQuantFileToAlias(this.sStdQuantName, mspdf);
                                    entrySettings.updateQuantAliasKeyInfo(mspdf, mAliases, StandardQuantColumnInfo.QUANT_PREFIX);
                                    this.fileLockManager.lockFile(sFilePath, entry);
                                    FileLockingUtils.writeLockFile(this.fileLockManager, this.lockFilePath);
                                    if (!(wasInUseForExternalQuant || entrySettings.getSourceDataFileList() != null && entrySettings.getSourceDataFileList().contains((Object)mspdf))) {
                                        entrySettings.addSourceFile(mspdf);
                                    }
                                    this.lastUpdatedQuantFile = sGridFileName;
                                }
                                bChanged = true;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            bChanged = false;
        }
        return bChanged;
    }

    private Entry findParentEntry(Entry entry, Property msp) {
        Entry parent = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project");
        Entry entryFound = null;
        if (parent != null) {
            for (Entry e : parent.getChildren()) {
                entryFound = this.findEntryWithProperty(e, msp);
                if (entryFound != null) break;
            }
        }
        return entryFound;
    }

    private Entry findEntryWithProperty(Entry entry, Property msp) {
        if (entry.getProperty().equals(msp)) {
            return entry;
        }
        Entry entryFound = null;
        for (Entry e : entry.getChildren()) {
            entryFound = this.findEntryWithProperty(e, msp);
            if (entryFound != null) break;
        }
        return entryFound;
    }

    protected void updateSettings() {
        MassSpecProperty property = (MassSpecProperty)this.getEntryParentProperty();
        try {
            Entry projectEntry = this.getEntryForCurrentViewer();
            String settingsFile = String.valueOf(MassSpecProperty.getFullyQualifiedFolderName(projectEntry)) + File.separator + property.getMSSettingsFile().getName();
            property.marshallSettingsFile(settingsFile, property.getMassSpecMetaData());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void updateViewer() {
        try {
            MassSpecMultiPageViewer viewer = this.getCurrentViewer();
            List<String> sKeyVals = this.getColumnKeyLabels();
            viewer.reLoadScansTab(sKeyVals);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected int getColNumberForGridColumn(GridColumn col) {
        int i = 0;
        while (i < columnHeaders.length) {
            if (col.getText().equals(columnHeaders[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getRowNumberForItem(GridItem item) {
        int i = 0;
        while (i < this.getItems().length) {
            GridItem gi = this.getItem(i);
            if (gi.equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public List<String> getColumnKeyLabels() {
        if (this.lastUpdatedQuantFile == null) {
            return null;
        }
        ArrayList<String> sKeys = new ArrayList<String>();
        sKeys.add(this.lastUpdatedQuantFile);
        return sKeys;
    }
}

