/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.forms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eurocarbdb.application.glycanbuilder.CoreType;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TerminalType;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.CoreDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.ResidueDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.TerminalDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.utils.ResidueOperationUtils;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasWithToolBarComposite;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.FormAbstract;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.Messages;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.MultiPageFormAbstract;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.GlycanIconProvider;

public class AddStructureForm
extends FormAbstract
implements GlycanIconProvider.IconUpdateListener {
    private Map<ResidueType, Button> m_mapResTypeToButton = new HashMap<ResidueType, Button>();
    private Map<CoreType, Button> m_mapCoreTypeToButton = new HashMap<CoreType, Button>();
    private Map<TerminalType, Button> m_mapTerminalTypeToButton = new HashMap<TerminalType, Button>();
    private Button m_btnChangeRedEnd;

    public AddStructureForm(MultiPageFormAbstract parent, String tabText) {
        super(parent, tabText);
        this.createControl();
        GlycanIconProvider.addIconUpdateListener(this);
        final AddStructureForm toRemove = this;
        this.getForm().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GlycanIconProvider.removeIconUpdateListener(toRemove);
            }
        });
        this.residueIconUpdated();
        this.glycanIconUpdated();
    }

    private void createControl() {
        Button btn;
        ExpandableComposite group;
        this.getForm().setText(Messages.getString("AddStructure.title"));
        Composite sectionClient = this.createNewSection(Messages.getString("AddStructure.core"));
        for (String sup : CoreDictionary.getSuperclasses()) {
            group = this.createExpandableComposite(sectionClient);
            group.setText(sup);
            for (CoreType coreType : CoreDictionary.getCores(sup)) {
                btn = this.createIconButton((Composite)group.getClient(), null, 0x1000008);
                btn.setToolTipText(coreType.getDescription());
                this.m_mapCoreTypeToButton.put(coreType, btn);
            }
        }
        sectionClient = this.createNewSection(Messages.getString("AddStructure.residue_ms"));
        this.createResidueSection(sectionClient, true);
        sectionClient = this.createNewSection(Messages.getString("AddStructure.residue_other"));
        this.createResidueSection(sectionClient, false);
        sectionClient = this.createNewSection(Messages.getString("AddStructure.terminal"));
        for (String sup : TerminalDictionary.getSuperclasses()) {
            group = this.createExpandableComposite(sectionClient);
            group.setText(sup);
            for (TerminalType terminalType : TerminalDictionary.getTerminals(sup)) {
                btn = this.createIconButton((Composite)group.getClient(), null, 0x1000008);
                btn.setToolTipText(terminalType.getDescription());
                this.m_mapTerminalTypeToButton.put(terminalType, btn);
            }
        }
        Composite comp = this.getToolkit().createComposite(this.getForm().getBody());
        comp.setLayout((Layout)new GridLayout(1, false));
        Button btn2 = this.getToolkit().createButton(comp, Messages.getString("AddStructure.reducing_end"), 72);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 50;
        btn2.setLayoutData((Object)data);
        this.m_btnChangeRedEnd = btn2;
    }

    private void createResidueSection(Composite sectionClient, boolean isSaccharide) {
        for (String sup : ResidueDictionary.getSuperclasses()) {
            if (sup.equals("Reducing end")) continue;
            ExpandableComposite group = this.createExpandableComposite(sectionClient);
            group.setText(sup);
            boolean hasContents = false;
            for (ResidueType type : ResidueDictionary.getResidues(sup)) {
                if (type.isSaccharide() != isSaccharide) continue;
                Button btn = this.createIconButton((Composite)group.getClient(), null, 0x1000008);
                btn.setToolTipText(type.getDescription());
                this.m_mapResTypeToButton.put(type, btn);
                hasContents = true;
            }
            if (hasContents) continue;
            group.dispose();
        }
    }

    private Button createIconButton(Composite parent, String text, int style) {
        Button btn = this.getToolkit().createButton(parent, text, style);
        ColumnLayoutData data = new ColumnLayoutData();
        data.horizontalAlignment = 1;
        btn.setLayoutData((Object)data);
        btn.setBackground(Display.getCurrent().getSystemColor(22));
        return btn;
    }

    public void addSelectionListenersForCanvas(final GlycanCanvasWithToolBarComposite canvas) {
        Button btn;
        SelectionAdapter listenerUpdateView = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.updateView();
            }
        };
        for (final ResidueType resType : this.m_mapResTypeToButton.keySet()) {
            btn = this.m_mapResTypeToButton.get(resType);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!ResidueOperationUtils.canAddResidueToCanvas(canvas.getGlycanCanvas(), new Residue(resType))) {
                        AddStructureForm.this.openErrorDialog();
                        return;
                    }
                    canvas.getGlycanCanvas().addResidue(new Residue(resType));
                    canvas.getGlycanCanvas().getBuilderWorkspace().getResidueHistory().add(resType);
                }
            });
            btn.addSelectionListener((SelectionListener)listenerUpdateView);
        }
        for (final CoreType coreType : this.m_mapCoreTypeToButton.keySet()) {
            btn = this.m_mapCoreTypeToButton.get(coreType);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Residue root = coreType.newCore();
                        if (!ResidueOperationUtils.canAddResidueToCanvas(canvas.getGlycanCanvas(), root)) {
                            throw new Exception();
                        }
                        canvas.getGlycanCanvas().addResidue(root);
                        canvas.getGlycanCanvas().getCurrentGlycanLabel().resetSelection();
                    }
                    catch (Exception exception) {
                        AddStructureForm.this.openErrorDialog();
                    }
                }
            });
            btn.addSelectionListener((SelectionListener)listenerUpdateView);
        }
        for (final TerminalType termType : this.m_mapTerminalTypeToButton.keySet()) {
            btn = this.m_mapTerminalTypeToButton.get(termType);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Residue root = termType.newTerminal();
                        if (!ResidueOperationUtils.canAddResidueToCanvas(canvas.getGlycanCanvas(), root)) {
                            throw new Exception();
                        }
                        canvas.getGlycanCanvas().addResidue(termType.newTerminal());
                    }
                    catch (Exception exception) {
                        AddStructureForm.this.openErrorDialog();
                    }
                }
            });
            btn.addSelectionListener((SelectionListener)listenerUpdateView);
        }
        this.m_btnChangeRedEnd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (canvas.getGlycanCanvas().getCurrentGlycanLabel() == null) {
                    return;
                }
                canvas.getGlycanCanvas().getCurrentGlycanLabel().changeReducingEndType();
            }
        });
        this.m_btnChangeRedEnd.addSelectionListener((SelectionListener)listenerUpdateView);
    }

    private void openErrorDialog() {
        MessageBox box = new MessageBox(this.getForm().getShell(), 33);
        box.setMessage("The structure can not be added.");
        box.open();
    }

    @Override
    public void residueIconUpdated() {
        for (ResidueType type : ResidueDictionary.allResidues()) {
            Button btn = this.m_mapResTypeToButton.get(type);
            if (btn == null) continue;
            btn.setImage(GlycanIconProvider.getResidueIcon(type));
        }
        this.getForm().layout();
    }

    @Override
    public void glycanIconUpdated() {
        Button btn;
        HashMap<String, List<Button>> mapSuperToButtons = new HashMap<String, List<Button>>();
        for (CoreType coreType : CoreDictionary.getCores()) {
            btn = this.m_mapCoreTypeToButton.get(coreType);
            if (btn != null) {
                btn.setImage(GlycanIconProvider.getGlycanCoreIcon(coreType));
            }
            if (mapSuperToButtons.get(coreType.getSuperclass()) == null) {
                mapSuperToButtons.put(coreType.getSuperclass(), new ArrayList());
            }
            ((List)mapSuperToButtons.get(coreType.getSuperclass())).add(btn);
        }
        this.equalHight(mapSuperToButtons);
        mapSuperToButtons.clear();
        for (TerminalType terminalType : TerminalDictionary.getTerminals()) {
            btn = this.m_mapTerminalTypeToButton.get(terminalType);
            if (btn != null) {
                btn.setImage(GlycanIconProvider.getGlycanTerminalIcon(terminalType));
            }
            if (mapSuperToButtons.get(terminalType.getSuperclass()) == null) {
                mapSuperToButtons.put(terminalType.getSuperclass(), new ArrayList());
            }
            ((List)mapSuperToButtons.get(terminalType.getSuperclass())).add(btn);
        }
        this.equalHight(mapSuperToButtons);
        this.getForm().layout();
    }

    private void equalHight(Map<String, List<Button>> mapSuperToButtons) {
        for (String strSuper : mapSuperToButtons.keySet()) {
            List<Button> lButtons = mapSuperToButtons.get(strSuper);
            int iMaxHeight = 0;
            for (Button btn : lButtons) {
                Point size = btn.computeSize(-1, -1);
                if (iMaxHeight >= size.y) continue;
                iMaxHeight = size.y;
            }
            for (Button btn : lButtons) {
                ColumnLayoutData data = new ColumnLayoutData();
                data.horizontalAlignment = 1;
                data.heightHint = iMaxHeight;
                btn.setLayoutData((Object)data);
            }
        }
    }

    public void updateIconImages() {
        this.residueIconUpdated();
        this.glycanIconUpdated();
    }
}

