/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.canvas;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.grits.toolbox.tools.glycanbuilder.core.structure.document.GlycanDocument;
import org.grits.toolbox.tools.glycanbuilder.core.structure.document.GlycanInfo;
import org.grits.toolbox.tools.glycanbuilder.core.workspace.BuilderWorkspaceSWT;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasInterface;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasListenerProvider;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanLabelForCanvas;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.Pager;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.ClipUtils;

public class GlycanCanvasComposite
extends Composite
implements GlycanCanvasInterface {
    private ScrolledComposite m_compositeCanvasParent;
    private Composite m_compositeCanvas;
    private Pager m_pager;
    private boolean m_bShowPager;
    private BuilderWorkspaceSWT m_bws;
    private GlycanDocument m_doc;
    private GlycanLabelForCanvas m_lblCurrent;
    private List<GlycanLabelForCanvas> m_lLabels;
    private List<GlycanLabelForCanvas> m_lSelected;
    private List<MouseListener> m_lMouseListeners;

    public GlycanCanvasComposite(Composite parent) {
        super(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.m_bws = new BuilderWorkspaceSWT((Device)parent.getDisplay());
        this.m_bws.setNotation("snfg");
        this.m_bws.getGraphicOptions().SHOW_MASSES = true;
        this.m_bws.getGraphicOptions().SHOW_REDEND = true;
        this.m_doc = this.m_bws.getGlycanDocument();
        this.m_pager = new Pager();
        this.m_pager.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlycanCanvasComposite.this.loadDocument();
                GlycanCanvasComposite.this.updateView(false);
            }
        });
        this.m_bShowPager = false;
        this.initCanvas();
        this.initLabels();
        this.m_lMouseListeners = new ArrayList<MouseListener>();
    }

    protected void initCanvas() {
        this.m_compositeCanvasParent = new ScrolledComposite((Composite)this, 768);
        this.m_compositeCanvasParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_compositeCanvasParent.setExpandHorizontal(true);
        this.m_compositeCanvasParent.setExpandVertical(true);
        this.m_compositeCanvas = new Composite((Composite)this.m_compositeCanvasParent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = Math.max(0, this.m_bws.getGraphicOptions().MARGIN_TOP - 10);
        layout.marginBottom = Math.max(0, this.m_bws.getGraphicOptions().MARGIN_BOTTOM - 5);
        layout.marginLeft = Math.max(0, this.m_bws.getGraphicOptions().MARGIN_LEFT / 2 - 3);
        layout.marginRight = Math.max(0, this.m_bws.getGraphicOptions().MARGIN_RIGHT - 5);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        layout.verticalSpacing = this.m_bws.getGraphicOptions().MARGIN_TOP;
        this.m_compositeCanvas.setLayout((Layout)layout);
        GlycanCanvasListenerProvider.addListenersToCanvas(this);
        this.m_compositeCanvasParent.setContent((Control)this.m_compositeCanvas);
    }

    public void showPager(boolean bShowPager) {
        this.m_bShowPager = bShowPager;
        this.loadDocument();
    }

    private void initLabels() {
        this.initSelection();
        if (this.m_lLabels != null) {
            for (GlycanLabelForCanvas label : this.m_lLabels) {
                label.dispose();
            }
        }
        this.m_lLabels = new ArrayList<GlycanLabelForCanvas>();
    }

    public void initSelection() {
        this.m_lSelected = new ArrayList<GlycanLabelForCanvas>();
        this.m_lblCurrent = null;
    }

    public void initAllSelection() {
        this.initSelection();
        for (GlycanLabelForCanvas label : this.m_lLabels) {
            label.initSelection();
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.m_compositeCanvas.dispose();
        super.dispose();
        this.m_bws = null;
        if (this.m_lLabels != null) {
            for (GlycanLabelForCanvas l : this.m_lLabels) {
                l.dispose();
            }
        }
        this.m_lLabels = null;
        this.m_lblCurrent = null;
    }

    public Composite getControl() {
        return this.m_compositeCanvas;
    }

    public List<GlycanLabelForCanvas> getAllGlycanLabels() {
        ArrayList<GlycanLabelForCanvas> copy = new ArrayList<GlycanLabelForCanvas>();
        copy.addAll(this.m_lLabels);
        return copy;
    }

    public List<GlycanLabelForCanvas> getSelectedGlycanLabels() {
        ArrayList<GlycanLabelForCanvas> copy = new ArrayList<GlycanLabelForCanvas>();
        copy.addAll(this.m_lSelected);
        return this.m_lSelected;
    }

    public boolean colorDuplicatedIDs() {
        boolean bHasDuplicatedID = false;
        Iterator<GlycanLabelForCanvas> iterator = this.getAllGlycanLabels().iterator();
        while (iterator.hasNext()) {
            GlycanLabelForCanvas l;
            boolean bHasUniqueID = (l = iterator.next()).hasUniqueID();
            l.colorDatabaseID(!bHasUniqueID);
            bHasDuplicatedID |= !bHasUniqueID;
        }
        return bHasDuplicatedID;
    }

    public void addCanvasMouseListner(MouseListener listener) {
        if (listener == null) {
            return;
        }
        this.m_lMouseListeners.add(listener);
        this.m_compositeCanvas.addMouseListener(listener);
        for (GlycanLabelForCanvas lbl : this.m_lLabels) {
            lbl.getControl().addMouseListener(listener);
        }
    }

    public void removeCanvasMouseListener(MouseListener listener) {
        if (listener == null || !this.m_lMouseListeners.contains(listener)) {
            return;
        }
        this.m_lMouseListeners.remove(listener);
        this.m_compositeCanvas.removeMouseListener(listener);
        for (GlycanLabelForCanvas lbl : this.m_lLabels) {
            lbl.getControl().removeMouseListener(listener);
        }
    }

    @Override
    public BuilderWorkspaceSWT getBuilderWorkspace() {
        return this.m_bws;
    }

    @Override
    public void performResidueSelection(MouseEvent e) {
        if (e.button == 3) {
            return;
        }
        this.initAllSelection();
    }

    public void setSelection(GlycanLabelForCanvas label) {
        this.initAllSelection();
        this.addSelection(label);
    }

    public void addOrRemoveSelection(GlycanLabelForCanvas label) {
        if (!this.m_lSelected.contains(label)) {
            this.addSelection(label);
        } else if (!label.hasSelectedResidues()) {
            this.m_lSelected.remove(label);
            this.m_lblCurrent = !this.m_lSelected.isEmpty() ? this.m_lSelected.get(this.m_lSelected.size() - 1) : null;
        }
    }

    public void addSelection(GlycanLabelForCanvas label) {
        if (this.m_lSelected.contains(label)) {
            return;
        }
        this.m_lSelected.add(label);
        this.m_lblCurrent = label;
    }

    @Override
    public void selectAll() {
        this.initSelection();
        for (GlycanLabelForCanvas label : this.m_lLabels) {
            this.m_lSelected.add(label);
            label.selectAllResidues();
        }
    }

    @Override
    public void resetSelection() {
        this.initAllSelection();
    }

    @Override
    public boolean hasSelection() {
        for (GlycanLabelForCanvas l : this.getAllGlycanLabels()) {
            if (!l.hasSelectedResidues()) continue;
            return true;
        }
        return !this.getSelectedGlycanLabels().isEmpty();
    }

    @Override
    public List<Glycan> getAllGlycans() {
        ArrayList<Glycan> t_lGlycan = new ArrayList<Glycan>();
        for (GlycanLabelForCanvas lbl : this.m_lLabels) {
            t_lGlycan.add(lbl.getGlycan());
        }
        return t_lGlycan;
    }

    @Override
    public List<Glycan> getSelectedGlycans() {
        ArrayList<Glycan> lClonedGlycans = new ArrayList<Glycan>();
        for (GlycanLabelForCanvas label : this.m_lSelected) {
            if (!label.hasSelectedResidues()) {
                lClonedGlycans.add(label.getGlycan().clone());
                continue;
            }
            lClonedGlycans.addAll(label.extractSelection());
        }
        return lClonedGlycans;
    }

    public boolean addGlycan(Residue resRoot) {
        Glycan gNew = new Glycan(resRoot, true, this.m_bws.getDefaultMassOptions());
        this.addGlycan(gNew);
        if (this.m_lblCurrent != null) {
            this.m_lblCurrent.setSelection(this.m_lblCurrent.getGlycan().getRoot(false));
        }
        return true;
    }

    @Override
    public boolean addGlycan(Glycan glycan) {
        if (glycan == null) {
            return false;
        }
        this.m_doc.addStructure(this.correctGlycan(glycan));
        this.loadDocument();
        return true;
    }

    public boolean addGlycans(List<Glycan> lGlycans) {
        if (lGlycans == null) {
            return false;
        }
        ArrayList<GlycanInfo> toAdd = new ArrayList<GlycanInfo>();
        for (Glycan glycan : lGlycans) {
            if (glycan == null) continue;
            toAdd.add(this.correctGlycan(glycan));
        }
        this.m_doc.addStructures(toAdd);
        this.loadDocument();
        return true;
    }

    private GlycanInfo correctGlycan(Glycan glycan) {
        if (glycan == null) {
            return null;
        }
        if (!glycan.getRoot().isReducingEnd()) {
            glycan = new Glycan(glycan.getRoot(), true, glycan.getMassOptions());
        }
        return new GlycanInfo(glycan);
    }

    protected void addGlycanLabel(GlycanInfo glycan) {
        GlycanLabelForCanvas label = this.getNewGlycanLabel(glycan);
        for (MouseListener listener : this.m_lMouseListeners) {
            label.getControl().addMouseListener(listener);
        }
        this.m_lLabels.add(label);
        this.m_lblCurrent = label;
    }

    protected GlycanLabelForCanvas getNewGlycanLabel(GlycanInfo glycan) {
        return new GlycanLabelForCanvas(this, glycan);
    }

    @Override
    public boolean addResidue(Residue res) {
        if (this.m_lblCurrent != null && this.m_lblCurrent.addResidueToCurrentResidue(res)) {
            return true;
        }
        this.addGlycan(res);
        return true;
    }

    public void setCurrentGlycanLabel(GlycanLabelForCanvas label) {
        if (label != null && !this.m_lLabels.contains(label)) {
            this.m_lLabels.add(label);
        }
        this.m_lblCurrent = label;
    }

    public GlycanLabelForCanvas getCurrentGlycanLabel() {
        return this.m_lblCurrent;
    }

    public void removeGlycanlabel(GlycanLabelForCanvas label) {
        if (!this.m_lLabels.contains(label)) {
            return;
        }
        this.m_lLabels.remove(label);
        if (this.m_lSelected.contains(label)) {
            this.m_lSelected.remove(label);
        }
        if (this.m_lblCurrent != null && this.m_lblCurrent.equals(label)) {
            this.m_lblCurrent = null;
        }
        label.dispose();
    }

    public void loadDocument() {
        int nStructure = this.m_doc.getStructures().size();
        if (!this.m_bShowPager && nStructure == 0) {
            this.initLabels();
            if (!this.m_pager.isDisposed()) {
                this.m_pager.dispose();
            }
            return;
        }
        this.initSelection();
        this.m_pager.setNumberOfTotalElements(nStructure);
        AbstractList lGlycansToShow = new ArrayList();
        if (this.m_bShowPager || nStructure > this.m_pager.getNumberOfElementsPerPage()) {
            this.m_pager.updatePager(this);
            int iCurrentPage = this.m_pager.getCurrentPageNumber();
            int fromIndex = (iCurrentPage - 1) * this.m_pager.getNumberOfElementsPerPage();
            int toIndex = Math.min(iCurrentPage * this.m_pager.getNumberOfElementsPerPage(), nStructure);
            lGlycansToShow.addAll(this.m_doc.getStructures().subList(fromIndex, toIndex));
        } else {
            if (!this.m_pager.isDisposed()) {
                this.m_pager.dispose();
                this.layout();
            }
            lGlycansToShow = this.m_doc.getStructures();
        }
        int i = 0;
        for (GlycanInfo glycan : lGlycansToShow) {
            if (i < this.m_lLabels.size()) {
                this.m_lLabels.get(i).setGlycan(glycan);
            } else {
                this.addGlycanLabel(glycan);
            }
            ++i;
        }
        while (this.m_lLabels.size() > i) {
            this.removeGlycanlabel(this.m_lLabels.get(this.m_lLabels.size() - 1));
        }
    }

    public void saveDocument() {
        this.m_doc.saveState();
    }

    public void resetDocument() {
        this.m_doc.reset();
        this.loadDocument();
    }

    @Override
    public void undo() {
        if (this.m_doc.undo()) {
            this.loadDocument();
        }
    }

    @Override
    public void redo() {
        if (this.m_doc.redo()) {
            this.loadDocument();
        }
    }

    @Override
    public boolean canCut() {
        return this.hasSelection();
    }

    @Override
    public boolean canCopy() {
        return this.hasSelection();
    }

    @Override
    public boolean canPaste() {
        return ClipUtils.canGetGlycanFromClipboard();
    }

    @Override
    public boolean canDelete() {
        return this.hasSelection();
    }

    @Override
    public void cut() {
        this.copy();
        this.delete();
    }

    @Override
    public void copy() {
        ClipUtils.copyToClipboard(this.getSelectedGlycans(), this.m_bws);
    }

    @Override
    public void paste() {
        List<Glycan> lGlycans = ClipUtils.getGlycansFromClipboard(this.m_bws.getDefaultMassOptions());
        if (lGlycans.isEmpty()) {
            return;
        }
        if (this.m_lblCurrent == null || !this.m_lblCurrent.addGlycansToCurrentResidue(lGlycans)) {
            this.addGlycans(lGlycans);
        }
    }

    @Override
    public void delete() {
        boolean hasSelection = false;
        for (GlycanLabelForCanvas l : this.getAllGlycanLabels()) {
            if (!l.hasSelectedResidues()) continue;
            hasSelection = true;
            break;
        }
        ArrayList<GlycanInfo> lToBeRemoved = new ArrayList<GlycanInfo>();
        for (GlycanLabelForCanvas l : this.getAllGlycanLabels()) {
            if (!hasSelection && this.getSelectedGlycanLabels().contains(l)) {
                lToBeRemoved.add(l.getGlycanInfo());
                continue;
            }
            if (!l.hasSelectedResidues()) continue;
            l.removeResidues();
            if (!l.getGlycan().isEmpty()) continue;
            lToBeRemoved.add(l.getGlycanInfo());
        }
        this.m_doc.removeStructures(lToBeRemoved);
        this.loadDocument();
    }

    @Override
    public void updateView(boolean force) {
        this.redrawGlycans(force);
        this.resetSize();
        this.m_compositeCanvas.forceFocus();
    }

    public void updateView() {
        this.updateView(true);
    }

    private void redrawGlycans(boolean force) {
        for (GlycanLabelForCanvas l : this.m_lLabels) {
            l.redrawGlycan(force);
        }
    }

    private void resetSize() {
        Point size = this.m_compositeCanvas.computeSize(-1, -1);
        this.m_compositeCanvasParent.setMinSize(size);
        this.m_compositeCanvas.setSize(size);
    }
}

