/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.structure.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eurocarbdb.application.glycanbuilder.CoreType;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TerminalType;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasComposite;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasInterface;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanLabel;

public class ResidueOperationUtils {
    public static final String ADD = "Add";
    public static final String CHANGE = "Change";
    public static final String INSERT = "Insert";

    public static List<Residue> getPath(Residue a, Residue b) {
        Stack<Residue> pra = new Stack<Residue>();
        Residue nav = a;
        while (nav != null) {
            pra.push(nav);
            nav = nav.getParent();
        }
        Stack<Residue> prb = new Stack<Residue>();
        nav = b;
        while (nav != null) {
            prb.push(nav);
            nav = nav.getParent();
        }
        if (pra.peek() != prb.peek()) {
            return new ArrayList<Residue>();
        }
        Residue common = null;
        while (!pra.empty() && !prb.empty() && pra.peek() == prb.peek()) {
            common = (Residue)pra.pop();
            prb.pop();
        }
        pra.push(common);
        ArrayList<Residue> path = new ArrayList<Residue>();
        Iterator i = pra.iterator();
        while (i.hasNext()) {
            path.add((Residue)i.next());
        }
        while (!prb.empty()) {
            path.add((Residue)prb.pop());
        }
        return path;
    }

    public static List<Glycan> extractSelection(List<Residue> lResSelected, MassOptions defaultMassOptions) {
        ArrayList<Residue> lRoots = new ArrayList<Residue>();
        ArrayList<Residue> lAntennae = new ArrayList<Residue>();
        for (Residue cur : lResSelected) {
            Residue par = cur.getParent();
            if (par != null && lResSelected.contains(par) && !par.isBracket()) continue;
            if (cur.isAntenna()) {
                lAntennae.add(cur);
                continue;
            }
            if (cur.isBracket()) continue;
            lRoots.add(cur);
        }
        ArrayList<Residue> lClonedRoots = new ArrayList<Residue>();
        for (Residue root : lRoots) {
            Residue rootCloned = ResidueOperationUtils.cloneStructure(root, lResSelected, true);
            if (rootCloned.isReducingEnd() && !rootCloned.hasChildren()) continue;
            lClonedRoots.add(rootCloned);
        }
        HashSet<Residue> lAssignedAntennae = new HashSet<Residue>();
        ArrayList<Glycan> lClonedGlycans = new ArrayList<Glycan>();
        for (Residue resClonedRoot : lClonedRoots) {
            Glycan glycanCloned = new Glycan(resClonedRoot, false, defaultMassOptions);
            lClonedGlycans.add(glycanCloned);
            for (Residue resAntennae : lAntennae) {
                lAssignedAntennae.add(resAntennae);
                glycanCloned.addAntenna(ResidueOperationUtils.cloneStructure(resAntennae, lResSelected, true));
            }
        }
        for (Residue resAntenna : lAntennae) {
            if (lAssignedAntennae.contains(resAntenna)) continue;
            Residue resClonedAntennae = ResidueOperationUtils.cloneStructure(resAntenna, lResSelected, true);
            lClonedGlycans.add(new Glycan(resClonedAntennae, false, defaultMassOptions));
        }
        for (Glycan s : lClonedGlycans) {
            s.removeUnpairedRepetitions();
        }
        return lClonedGlycans;
    }

    private static Residue cloneStructure(Residue resRoot, List<Residue> lRess, boolean addAttachment) {
        if (resRoot == null) {
            return null;
        }
        if (!(!addAttachment || resRoot.isReducingEnd() || resRoot.getParent() != null && resRoot.getParent().isReducingEnd())) {
            Residue resRootCloned = ResidueDictionary.createAttachPoint();
            resRootCloned.addChild(ResidueOperationUtils.cloneStructure(resRoot, lRess, false), (Collection)resRoot.getParentLinkage().getBonds());
            return resRootCloned;
        }
        Residue resRootCloned = resRoot.cloneResidue();
        for (Linkage link : resRoot.getChildrenLinkages()) {
            Residue resChild = link.getChildResidue();
            if (!lRess.contains(resChild)) continue;
            resRootCloned.addChild(ResidueOperationUtils.cloneStructure(resChild, lRess, false), (Collection)link.getBonds());
        }
        return resRootCloned;
    }

    public static boolean addResidue(Residue resCurrent, Residue resToAdd) {
        if (resCurrent == null) {
            return false;
        }
        return resCurrent.addChild(resToAdd);
    }

    public static boolean changeResidueType(Residue resCurrent, ResidueType resType, boolean isComposition) {
        if (resCurrent == null || resCurrent.hasParent() && !resType.canHaveParent() || !resCurrent.hasParent() && !resType.canBeReducingEnd() || resCurrent.hasChildren() && !resType.canHaveChildren() || isComposition) {
            return false;
        }
        resCurrent.setType(resType);
        return true;
    }

    public static boolean removeResidue(Residue resCurrent, Glycan glycan) {
        if (resCurrent == null) {
            return false;
        }
        if (!glycan.contains(resCurrent)) {
            return false;
        }
        return glycan.removeResidue(resCurrent);
    }

    public static boolean removeResidues(Glycan glycan, List<Residue> lResToRemove) {
        if (lResToRemove == null || lResToRemove.isEmpty()) {
            return false;
        }
        return glycan.removeResidues(lResToRemove);
    }

    public static boolean addGlycans(Residue resCurrent, Glycan glycanCurrent, List<Glycan> lGlycanToAdd) {
        if (!ResidueOperationUtils.canAddGlycansToResidue(resCurrent, glycanCurrent.isComposition(), lGlycanToAdd)) {
            return false;
        }
        return ResidueOperationUtils.addGlycansToResidue(resCurrent, glycanCurrent, lGlycanToAdd);
    }

    public static boolean canAddGlycansToResidue(Residue resCurrent, boolean isComposition, List<Glycan> lGlycanToAdd) {
        if (resCurrent == null) {
            return false;
        }
        if (isComposition) {
            return false;
        }
        if (resCurrent.isAntenna() || resCurrent.isBracket()) {
            for (Glycan s : lGlycanToAdd) {
                if (!s.isFuzzy()) continue;
                return false;
            }
        }
        if (resCurrent.isInRepetition()) {
            for (Glycan s : lGlycanToAdd) {
                if (!s.hasRepetition()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean addGlycansToResidue(Residue resCurrent, Glycan glycanCurrent, List<Glycan> lGlycanToAdd) {
        if (lGlycanToAdd == null || lGlycanToAdd.isEmpty()) {
            return false;
        }
        if (glycanCurrent == null || resCurrent == null || resCurrent.isReducingEnd()) {
            return false;
        }
        for (Glycan structure : lGlycanToAdd) {
            resCurrent.addChild(structure.getRoot());
        }
        LinkedList<Residue> brackets = new LinkedList<Residue>();
        for (Glycan structure : lGlycanToAdd) {
            if (structure.getBracket() == null) continue;
            boolean found = false;
            for (Residue res : brackets) {
                if (!structure.getBracket().subtreeEquals(res)) continue;
                found = true;
            }
            if (found) continue;
            brackets.add(structure.getBracket());
        }
        for (Residue b : brackets) {
            for (Linkage link : b.getChildrenLinkages()) {
                glycanCurrent.addAntenna(link.getChildResidue(), (Collection)link.getBonds());
            }
        }
        return true;
    }

    public static Residue insertResidueBefore(Residue resCurrent, boolean isComposition, Residue resToInsert) {
        if (resToInsert == null || resCurrent == null || resCurrent.getParent() == null || isComposition) {
            return null;
        }
        if (!resCurrent.insertParent(resToInsert)) {
            return null;
        }
        return resToInsert;
    }

    public static Residue insertResidueBefore(Residue resCurrent, boolean isComposition, List<Residue> lLinkedRes, Residue resToInsert) {
        if (resToInsert == null || resCurrent == null || resCurrent.getParent() == null || isComposition) {
            return null;
        }
        if (!resCurrent.insertParent(resToInsert)) {
            return null;
        }
        if (lLinkedRes != null) {
            for (Residue r : lLinkedRes) {
                r.insertParent(resToInsert.cloneResidue());
            }
        }
        return resToInsert;
    }

    private static boolean changeReducingEndTypePVT(Glycan glycan, ResidueType resTypeNew) {
        if (glycan != null) {
            return glycan.setReducingEndType(resTypeNew);
        }
        return false;
    }

    public static boolean changeReducingEndType(List<Glycan> lGlycans, ResidueType resTypeNew) {
        boolean changed = false;
        for (Glycan s : lGlycans) {
            changed |= ResidueOperationUtils.changeReducingEndTypePVT(s, resTypeNew);
        }
        return changed;
    }

    public static boolean changeReducingEndType(Glycan currentGlycan, ResidueType resTypeNew) {
        return ResidueOperationUtils.changeReducingEndTypePVT(currentGlycan, resTypeNew);
    }

    public static boolean createRepetition(Residue resSelectedLast, List<Residue> lRepResidues) throws Exception {
        if (lRepResidues == null || lRepResidues.size() == 0) {
            return false;
        }
        Residue first = null;
        Residue last = resSelectedLast;
        for (Residue r : lRepResidues) {
            if (r.isReducingEnd()) {
                throw new Exception("The repeating unit cannot contain the reducing end");
            }
            if (r.isBracket()) {
                throw new Exception("The repeating unit cannot contain the bracket");
            }
            if (r.isCleavage()) {
                throw new Exception("The repeating unit cannot contain a cleavage");
            }
            if (r.isRepetition()) {
                throw new Exception("Repeating units cannot be nested");
            }
            if (r.getParent() != null && !lRepResidues.contains(r.getParent())) {
                if (first == null) {
                    first = r;
                } else {
                    throw new Exception("The residue forming the repeating unit must be all linked together.");
                }
            }
            if (resSelectedLast != null || !r.isSaccharide() || r.getNoChildren() <= 0) continue;
            int links_out = 0;
            for (Linkage l : r.getChildrenLinkages()) {
                if (lRepResidues.contains(l.getChildResidue())) continue;
                ++links_out;
            }
            if (links_out <= 0) continue;
            if (last == null) {
                last = r;
                continue;
            }
            throw new Exception("There are more than one residue in the repeating units with children not in the repeating unit. Check that all the residues in the repeating unit have been selected.");
        }
        if (first == null) {
            throw new Exception("No available start point for the repeating unit.");
        }
        if (first.isInRepetition()) {
            throw new Exception("Repeating units cannot be nested");
        }
        if (first.isAntenna()) {
            throw new Exception("Repeating units cannot be in an antenna");
        }
        if (last == null) {
            if (lRepResidues.size() == 1) {
                last = first;
            } else {
                return false;
            }
        }
        Residue start = ResidueDictionary.createStartRepetition();
        start.setAnomericCarbon(first.getAnomericCarbon());
        start.setParentLinkage(first.getParentLinkage());
        first.insertParent(start, (Collection)first.getParentLinkage().getBonds());
        Residue end = ResidueDictionary.createEndRepetition();
        end.setParentLinkage(new Linkage(last, end, new char[]{first.getParentLinkage().getParentPositionsSingle()}));
        last.addChild(end, (Collection)end.getParentLinkage().getBonds());
        Iterator il = last.iterator();
        while (il.hasNext()) {
            Linkage child_link = (Linkage)il.next();
            if (child_link.getChildResidue() == end || lRepResidues.contains(child_link.getChildResidue())) continue;
            end.getChildrenLinkages().add(child_link);
            child_link.setParentResidue(end);
            il.remove();
        }
        start.setEndRepitionResidue(end);
        return true;
    }

    public static boolean canAddResidueToCanvas(GlycanCanvasInterface canvas, Residue resToAdd) {
        GlycanLabel label = null;
        if (canvas instanceof GlycanLabel) {
            label = (GlycanLabel)canvas;
        } else if (canvas instanceof GlycanCanvasComposite) {
            label = ((GlycanCanvasComposite)canvas).getCurrentGlycanLabel();
        }
        if (label == null || label.getCurrentResidue() == null) {
            return true;
        }
        return ResidueOperationUtils.canModifyResidue(label.getCurrentResidue(), resToAdd, ADD);
    }

    public static boolean canAddCoreStructure(Residue res, CoreType coreType) {
        try {
            return ResidueOperationUtils.canModifyResidue(res, coreType.newCore(), ADD);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean canAddTerminal(Residue res, TerminalType termType) {
        try {
            return ResidueOperationUtils.canModifyResidue(res, termType.newTerminal(), ADD);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean canAddResidue(Residue res, ResidueType resType) {
        return ResidueOperationUtils.canModifyResidue(res, new Residue(resType), ADD);
    }

    public static boolean canModifyResidueToLabel(GlycanLabel label, Residue resToAdd, String mode) {
        return ResidueOperationUtils.canModifyResidue(label.getCurrentResidue(), resToAdd, mode) || ResidueOperationUtils.canInsertResidue(label.getCurrentLinkage(), resToAdd, mode);
    }

    public static boolean canModifyResidue(Residue resCurrent, Residue resToAdd, String mode) {
        if (resCurrent == null || resToAdd == null) {
            return false;
        }
        if (mode.equals(ADD)) {
            if (!ResidueOperationUtils.canAddChild(resCurrent, resToAdd)) {
                return false;
            }
        } else if (mode.equals(INSERT) || mode.equals(CHANGE)) {
            Residue resParent = resCurrent.getParent();
            if (!ResidueOperationUtils.canAddChild(resParent, resToAdd)) {
                return false;
            }
            if (mode.equals(INSERT)) {
                if (!ResidueOperationUtils.canAddChild(resToAdd, resCurrent)) {
                    return false;
                }
            } else if (mode.equals(CHANGE)) {
                for (Linkage linChild : resCurrent.getChildrenLinkages()) {
                    Residue resChild = linChild.getChildResidue();
                    if (ResidueOperationUtils.canAddChild(resToAdd, resChild)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean canInsertResidue(Linkage linCurrent, Residue resToAdd, String mode) {
        if (linCurrent == null || resToAdd == null) {
            return false;
        }
        if (!mode.equals(INSERT)) {
            return false;
        }
        if (!ResidueOperationUtils.canAddChild(linCurrent.getParentResidue(), resToAdd)) {
            return false;
        }
        return ResidueOperationUtils.canAddChild(resToAdd, linCurrent.getChildResidue());
    }

    public static boolean canAddChild(Residue resParent, Residue resChild) {
        if (resParent == null) {
            return false;
        }
        if (!resParent.canAddChild(resChild)) {
            return false;
        }
        Residue resChildChild = resChild;
        while (resChildChild.isAttachPoint()) {
            if (!resChildChild.hasChildren()) {
                return false;
            }
            resChildChild = ((Linkage)resChildChild.getChildrenLinkages().get(0)).getChildResidue();
        }
        while (resChildChild.isReducingEnd() && !resChildChild.canHaveParent()) {
            resChildChild = resChildChild.firstChild();
        }
        if (!resParent.canHaveChildren() || !resChildChild.canHaveParent()) {
            return false;
        }
        return resParent.isSaccharide() || resChildChild.isSaccharide();
    }
}

