/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.structure.utils;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.Residue;

public class GlycanSelectionState {
    private Glycan m_glycan;
    private HashSet<Residue> m_setSelectedResidues;
    private HashSet<Linkage> m_setSelectedLinkages;

    public GlycanSelectionState(Glycan glycan) {
        this.m_glycan = glycan;
        this.m_setSelectedResidues = new HashSet();
        this.m_setSelectedLinkages = new HashSet();
    }

    public void addResidue(Residue res) {
        if (!this.m_glycan.contains(res)) {
            return;
        }
        this.m_setSelectedResidues.add(res);
    }

    public void addLinkage(Linkage lin) {
        if (!this.m_glycan.contains(lin.getParentResidue()) || !this.m_glycan.contains(lin.getChildResidue())) {
            return;
        }
        this.m_setSelectedLinkages.add(lin);
    }

    public HashSet<Residue> getSelectedResidues() {
        return this.m_setSelectedResidues;
    }

    public HashSet<Linkage> getSelectedLinkages() {
        return this.m_setSelectedLinkages;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GlycanSelectionState)) {
            return false;
        }
        GlycanSelectionState other = (GlycanSelectionState)obj;
        if (!this.m_glycan.equalsStructure(other.m_glycan)) {
            return true;
        }
        if (this.m_setSelectedResidues.isEmpty() && !other.m_setSelectedResidues.isEmpty() || !this.m_setSelectedResidues.isEmpty() && other.m_setSelectedResidues.isEmpty()) {
            return true;
        }
        if (!this.m_setSelectedResidues.isEmpty() && !other.m_setSelectedResidues.isEmpty()) {
            if (this.m_setSelectedResidues.size() != other.m_setSelectedResidues.size()) {
                return true;
            }
            TreeSet<Integer> setResPos1 = new TreeSet<Integer>();
            for (Residue res : this.m_setSelectedResidues) {
                setResPos1.add(GlycanSelectionState.getResidueIndex(this.m_glycan, res));
            }
            TreeSet<Integer> setResPos2 = new TreeSet<Integer>();
            for (Residue res : other.m_setSelectedResidues) {
                setResPos2.add(GlycanSelectionState.getResidueIndex(other.m_glycan, res));
            }
            if (!setResPos1.toString().equals(setResPos2.toString())) {
                return true;
            }
        }
        if (this.m_setSelectedLinkages.isEmpty() && !other.m_setSelectedLinkages.isEmpty() || !this.m_setSelectedLinkages.isEmpty() && other.m_setSelectedLinkages.isEmpty()) {
            return true;
        }
        if (!this.m_setSelectedLinkages.isEmpty() && !other.m_setSelectedLinkages.isEmpty()) {
            if (this.m_setSelectedLinkages.size() != other.m_setSelectedLinkages.size()) {
                return true;
            }
            TreeSet<Integer> setOldResPos = new TreeSet<Integer>();
            for (Linkage lin : this.m_setSelectedLinkages) {
                setOldResPos.add(GlycanSelectionState.getResidueIndex(this.m_glycan, lin.getChildResidue()));
            }
            TreeSet<Integer> setResPos = new TreeSet<Integer>();
            for (Linkage lin : other.m_setSelectedLinkages) {
                setResPos.add(GlycanSelectionState.getResidueIndex(other.m_glycan, lin.getChildResidue()));
            }
            if (!setOldResPos.toString().equals(setResPos.toString())) {
                return true;
            }
        }
        return false;
    }

    private static int getResidueIndex(Glycan glycan, Residue res) {
        if (!glycan.contains(res)) {
            return -1;
        }
        Residue parent = glycan.getRoot();
        int iIndex = 1;
        LinkedList<Residue> lChildren = new LinkedList<Residue>();
        lChildren.add(parent);
        while (!lChildren.isEmpty()) {
            parent = (Residue)lChildren.removeFirst();
            if (parent.equals(res)) break;
            int i = 0;
            while (i < parent.getNoChildren()) {
                lChildren.add(parent.getChildAt(i));
                ++i;
            }
            ++iIndex;
        }
        return iIndex;
    }
}

