/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.gelato.AnalyteStructureAnnotation;
import org.grits.toolbox.ms.annotation.gelato.AnnotateFragments;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.structure.GelatoAnalyte;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.FeatureSelection;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScansAnnotation;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.tools.INotifyingProcess;
import org.grits.toolbox.widgets.tools.NotifyingProcessUtil;

public abstract class AnalyteMatcher
implements INotifyingProcess {
    private static final Logger logger = Logger.getLogger(AnalyteMatcher.class);
    protected Data data;
    protected boolean isCanceled = false;
    protected List<IProgressListener> lProgressListeners;
    protected boolean bCancel = false;
    protected AnalyteStructureAnnotation parent = null;
    protected Map<Double, Integer> mPeakMatched = new HashMap<Double, Integer>();
    protected int curScanNum = -1;

    public abstract Feature getNewFeatureObject();

    public abstract AnnotateFragments getNewAnnotateFragmentsObject();

    public AnalyteMatcher(int curScanNum, AnalyteStructureAnnotation parent) {
        this.parent = parent;
        this.curScanNum = curScanNum;
    }

    public Data getData() {
        return this.data;
    }

    public int getScanNum() {
        return this.curScanNum;
    }

    protected boolean calculateScores(ScansAnnotation scanAnnotations, Annotation annotation, Feature feature, int iPrecursorScan) {
        return AnalyteMatcher.calculateScores(this.getData(), scanAnnotations, annotation, feature, iPrecursorScan);
    }

    public static boolean calculateScores(Data data, ScansAnnotation scanAnnotations, Annotation annotation, Feature feature, int iPrecursorScan) {
        try {
            double dCountingScore = 0.0;
            double dIntensityScore = 0.0;
            double dRawCountingScore = 0.0;
            double dRawIntensityScore = 0.0;
            if (iPrecursorScan > 0 && scanAnnotations.getScanAnnotations().get(iPrecursorScan) != null) {
                HashMap<String, Integer> uniqueAnnotations = new HashMap<String, Integer>();
                for (Feature f : (List)scanAnnotations.getScanAnnotations().get(iPrecursorScan)) {
                    if (f.getParentId() != null && !f.getParentId().equals(feature.getId())) continue;
                    String sRowId = ((FeatureSelection)f.getFeatureSelections().get(0)).getRowId();
                    int iInx = sRowId.indexOf(":");
                    if (iInx > 0) {
                        sRowId = sRowId.substring(0, iInx);
                    }
                    uniqueAnnotations.put(sRowId, 1);
                }
                double dNumAnnotPeaks = uniqueAnnotations.keySet().size();
                dCountingScore = dNumAnnotPeaks / (double)((Scan)data.getScans().get(iPrecursorScan)).getPeaklist().size();
                dRawCountingScore = dNumAnnotPeaks / (double)((Scan)data.getScans().get(iPrecursorScan)).getTotalNumPeaks().intValue();
                double annotatedIntensity = 0.0;
                double totalIntensity = 0.0;
                for (Peak p : ((Scan)data.getScans().get(iPrecursorScan)).getPeaklist()) {
                    totalIntensity += p.getIntensity().doubleValue();
                }
                if (uniqueAnnotations.keySet() != null && uniqueAnnotations.keySet().size() != 0) {
                    for (Peak p : ((Scan)data.getScans().get(iPrecursorScan)).getPeaklist()) {
                        String sPeakId;
                        if (p.getIntensity() == null || p.getIntensity() < 0.0 || !uniqueAnnotations.containsKey(sPeakId = Integer.toString(p.getId()))) continue;
                        annotatedIntensity += p.getIntensity().doubleValue();
                    }
                }
                dIntensityScore = annotatedIntensity / totalIntensity;
                dRawIntensityScore = annotatedIntensity / ((Scan)data.getScans().get(iPrecursorScan)).getTotalIntensity();
            }
            annotation.getScores().put(Integer.toString(iPrecursorScan), dCountingScore);
            feature.getDoubleProp().put(GlycanStructureAnnotation.countingScoreData.getKey(), dCountingScore);
            feature.getDoubleProp().put(GlycanStructureAnnotation.intensityScoreData.getKey(), dIntensityScore);
            feature.getDoubleProp().put(GlycanStructureAnnotation.rawCountingScoreData.getKey(), dRawCountingScore);
            feature.getDoubleProp().put(GlycanStructureAnnotation.rawIntensityScoreData.getKey(), dRawIntensityScore);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    protected void handleUnscoredPeak(Peak parentPeak) {
    }

    public List<Integer> getMatchingSubScans(Data data, int iCurScanNum, Peak parentPeak) {
        ArrayList<Integer> iMatchingScans = new ArrayList<Integer>();
        List<Integer> lScans = GelatoUtils.getSubScanForPrecursor(this.getData(), iCurScanNum, parentPeak);
        if (!lScans.isEmpty()) {
            for (Integer iSubScanNum : lScans) {
                iMatchingScans.add(iSubScanNum);
            }
        }
        return iMatchingScans;
    }

    public boolean scorePeakToFeature(Data data, double analyteMz, String analyteType, GelatoAnalyte analyte, Annotation annotation, ScansAnnotation scanAnnotation, Feature parentFeature, List<IonSettings> lParentAdducts, List<Integer> lParentAdductCounts, int iParentCharge, List<IonSettings> lParentIonExchanges, List<Integer> lParentExchangeCounts, int iParentExchangeCount, List<MoleculeSettings> lParentNeutralLosses, List<Integer> lParentNeutralLossCounts, int iParentNeutralLossCount, AnalyteSettings settings, Peak parentPeak, int iParentScanNum, String tempPath) {
        try {
            List<Integer> lScans = GelatoUtils.getSubScanForPrecursor(data, iParentScanNum, parentPeak);
            if (lScans.isEmpty()) {
                Feature feature = this.getNewFeatureObject();
                GelatoUtils.populateNewFeature(feature, data, analyte.getAnalyte().getAnalyteStringRepresentation(), parentPeak.getMz(), analyteMz, iParentCharge, analyteType, lParentAdducts, lParentAdductCounts, lParentIonExchanges, lParentExchangeCounts, lParentNeutralLosses, lParentNeutralLossCounts, null, parentPeak.getId(), annotation, parentFeature);
                AnalyteMatcher.addAnnotationToScan(data, scanAnnotation, iParentScanNum, annotation, feature);
                return false;
            }
            Scan scan = (Scan)data.getScans().get(iParentScanNum);
            boolean bRes = false;
            for (Integer iSubScanNum : lScans) {
                GlycanFeature feature = new GlycanFeature();
                GelatoUtils.populateNewFeature((Feature)feature, data, analyte.getAnalyte().getAnalyteStringRepresentation(), parentPeak.getMz(), analyteMz, iParentCharge, analyteType, lParentAdducts, lParentAdductCounts, lParentIonExchanges, lParentExchangeCounts, lParentNeutralLosses, lParentNeutralLossCounts, iSubScanNum, parentPeak.getId(), annotation, parentFeature);
                AnalyteMatcher.addAnnotationToScan(data, scanAnnotation, iParentScanNum, annotation, (Feature)feature);
                if (iSubScanNum == null || data.getScans().get(iSubScanNum) == null || ((Scan)data.getScans().get(iSubScanNum)).getPrecursor() == null) continue;
                AnnotateFragments annFragments = this.getNewAnnotateFragmentsObject();
                annFragments.annotateFragments(scanAnnotation, iSubScanNum, (Feature)feature, lParentAdducts, lParentAdductCounts, iParentCharge, lParentIonExchanges, lParentExchangeCounts, iParentExchangeCount, lParentNeutralLosses, lParentNeutralLossCounts, iParentNeutralLossCount, annotation, data, settings, tempPath);
                boolean bCurRes = AnalyteMatcher.calculateScores(data, scanAnnotation, annotation, (Feature)feature, iSubScanNum);
                bRes |= bCurRes;
            }
            return bRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error matching glycans in matchGlycanStructure2.", (Throwable)e);
            return false;
        }
    }

    protected Peak getMostAbundantPeak(List<Peak> lPeaks) {
        double dMaxInt = Double.MIN_VALUE;
        Peak maxPeak = null;
        for (Peak peak : lPeaks) {
            if (!(peak.getIntensity() > dMaxInt)) continue;
            dMaxInt = peak.getIntensity();
            maxPeak = peak;
        }
        return maxPeak;
    }

    public static void addAnnotationToScan(Data data, ScansAnnotation scanAnnotations, int iScanNum, Annotation annotation, Feature feature) {
        try {
            if (scanAnnotations.getScanAnnotations().get(iScanNum) == null) {
                ArrayList<Feature> features = new ArrayList<Feature>();
                features.add(feature);
                scanAnnotations.getScanAnnotations().put(iScanNum, features);
            } else if (!((List)scanAnnotations.getScanAnnotations().get(iScanNum)).contains(feature)) {
                ((List)scanAnnotations.getScanAnnotations().get(iScanNum)).add(feature);
            }
            if (data.getAnnotatedScan().get(iScanNum) == null) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(annotation.getStringId());
                data.getAnnotatedScan().put(iScanNum, ids);
            } else if (!((List)data.getAnnotatedScan().get(iScanNum)).contains(annotation.getStringId())) {
                ((List)data.getAnnotatedScan().get(iScanNum)).add(annotation.getStringId());
            }
            if (!data.getAnnotation().contains(annotation)) {
                data.getAnnotation().add(annotation);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error matching glycans in matchGlycanStructure.", (Throwable)e);
        }
    }

    public Map<Double, Integer> getPeakMatched() {
        return this.mPeakMatched;
    }

    public void setScanNum(int curScanNum) {
        this.curScanNum = curScanNum;
    }

    public boolean matchAnalyteStructure(boolean _polarity, Data data, int iParentScanNum, ScansAnnotation scanAnnotations, GelatoAnalyte gelatoAnalyte, String glycanType, Annotation annotation, Feature parentFeature, List<IonSettings> lAdductsToAnalyze, List<Integer> lAdductsToAnalyzeCounts, List<IonSettings> lExchangesToAnalyze, List<Integer> lExchangesToAnalyzeCounts, List<MoleculeSettings> lNeutralLossesToAnalyze, List<Integer> lNeutralLossesToAnalyzeCounts, AnalyteSettings settings, String tempPath) {
        try {
            logger.debug((Object)("Structure: " + gelatoAnalyte.getAnalyte().getAnalyteStringRepresentation()));
            this.data = data;
            if (this.getScanNum() != iParentScanNum) {
                this.getPeakMatched().clear();
                this.setScanNum(iParentScanNum);
            }
            double[] analyteInfo = GelatoUtils.getAnalyteMzAndCharge(gelatoAnalyte.getAnalyte(), settings, lAdductsToAnalyze, lAdductsToAnalyzeCounts, lExchangesToAnalyze, lExchangesToAnalyzeCounts, lNeutralLossesToAnalyze, lNeutralLossesToAnalyzeCounts);
            double analyteMz = analyteInfo[0];
            int iParentCharge = (int)analyteInfo[1];
            int iNumParentExchanges = (int)analyteInfo[2];
            int iNumParentLosses = (int)analyteInfo[3];
            int iStartInx = 0;
            if (this.getPeakMatched().containsKey(analyteMz)) {
                iStartInx = this.getPeakMatched().get(analyteMz);
            }
            Scan scan = (Scan)this.getData().getScans().get(this.getScanNum());
            this.setMaxValue(scan.getPeaklist().size());
            boolean bRes = false;
            for (int iPeakInx = iStartInx; iPeakInx < scan.getPeaklist().size(); ++iPeakInx) {
                if (this.isCanceled) {
                    return false;
                }
                Peak aPeak = (Peak)scan.getPeaklist().get(iPeakInx);
                this.updateListeners("Processing peak m/z: " + (aPeak != null ? aPeak.getMz() : "null"), iPeakInx);
                if (scan.getPolarity() != null && !scan.getPolarity().equals(_polarity)) continue;
                int[] iPeakMatchInfo = GelatoUtils.getMatchingPeak(scan, iPeakInx, analyteMz, data.getDataHeader().getMethod(), true);
                if (iPeakMatchInfo != null && iPeakMatchInfo[1] != -1) {
                    logger.debug((Object)("Glycan: " + gelatoAnalyte + ", glycan m/z: " + analyteMz + ", Scan: " + this.getScanNum()));
                    logger.debug((Object)("\tPeak match:  peak id: " + aPeak.getId() + ", peak m/z: " + aPeak.getMz()));
                    Peak peak = (Peak)scan.getPeaklist().get(iPeakMatchInfo[1]);
                    logger.debug((Object)("\t\tFinal peak id: " + peak.getId() + ", Final peak mz: " + peak.getMz()));
                    if (this.getData().getDataHeader().getMethod().getTrustMzCharge().booleanValue()) {
                        int iPrecursorCharge = -1;
                        if (peak.getPrecursorCharge() != null) {
                            iPrecursorCharge = peak.getPrecursorCharge();
                        }
                        if (iPrecursorCharge != -1 && peak.getPrecursorCharge() != iParentCharge) {
                            this.updateListeners("Processing peak m/z: " + (aPeak != null ? aPeak.getMz() : "null"), iPeakInx + 1);
                            continue;
                        }
                    }
                    bRes = true;
                    boolean bScored = this.scorePeakToFeature(data, analyteMz, glycanType, gelatoAnalyte, annotation, scanAnnotations, parentFeature, lAdductsToAnalyze, lAdductsToAnalyzeCounts, iParentCharge, lExchangesToAnalyze, lExchangesToAnalyzeCounts, iNumParentExchanges, lNeutralLossesToAnalyze, lNeutralLossesToAnalyzeCounts, iNumParentLosses, settings, peak, this.getScanNum(), tempPath);
                    if (!((Scan)this.getData().getScans().get(this.getScanNum())).getAnnotatedPeaks().containsKey(peak.getId()) || !((Boolean)((Scan)this.getData().getScans().get(this.getScanNum())).getAnnotatedPeaks().get(peak.getId())).booleanValue()) {
                        int iNumAnnot = ((Scan)this.getData().getScans().get(this.getScanNum())).getNumAnnotatedPeaks() != null ? ((Scan)this.getData().getScans().get(this.getScanNum())).getNumAnnotatedPeaks() : 0;
                        ((Scan)this.getData().getScans().get(this.getScanNum())).setNumAnnotatedPeaks(Integer.valueOf(iNumAnnot + 1));
                        ((Scan)this.getData().getScans().get(this.getScanNum())).getAnnotatedPeaks().put(peak.getId(), Boolean.TRUE);
                    }
                    this.getPeakMatched().put(analyteMz, iPeakMatchInfo[1]);
                    iPeakInx = scan.getPeaklist().size();
                    continue;
                }
                this.handleUnscoredPeak(aPeak);
            }
            this.updateListeners("Done!", scan.getPeaklist().size());
            return bRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error matching glycans in matchGlycanStructure.", (Throwable)e);
            return false;
        }
    }

    public void setProgressListeners(List<IProgressListener> lProgressListeners) {
        this.lProgressListeners = lProgressListeners;
    }

    public void addProgressListeners(IProgressListener lProgressListener) {
        this.lProgressListeners.add(lProgressListener);
    }

    public List<IProgressListener> getProgressListeners() {
        return this.lProgressListeners;
    }

    public boolean isCanceled() {
        return this.bCancel;
    }

    public void setCanceled(boolean bCancel) {
        this.bCancel = bCancel;
    }

    public void updateListeners(String _sMsg, int _iVal) {
        NotifyingProcessUtil.updateListeners(this.getProgressListeners(), (String)_sMsg, (int)_iVal);
    }

    public void updateErrorListener(String _sMsg) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg);
    }

    public void updateErrorListener(String _sMsg, Throwable t) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg, (Throwable)t);
    }

    public void setMaxValue(int _iVal) {
        NotifyingProcessUtil.setMaxValue(this.getProgressListeners(), (int)_iVal);
    }

    public void setProgressType(IProgressListener.ProgressType progressType) {
        NotifyingProcessUtil.setProgressType(this.getProgressListeners(), (IProgressListener.ProgressType)progressType);
    }
}

