/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.property.list.IListProperty;

public abstract class VirtualEntry<M> {
    private String id;
    private Object originalParent;
    private String label;
    private IObservableList list;
    private IListProperty property;

    public VirtualEntry(String id, IListProperty property, Object originalParent, String label) {
        this.id = id;
        this.originalParent = originalParent;
        this.label = label;
        this.property = property;
        this.list = new WritableList();
        IObservableList origList = property.observe(originalParent);
        this.list.addAll(this.cleanedList(origList));
        IListChangeListener listener = event -> {
            if (!this.list.isDisposed()) {
                List<Object> clean = this.cleanedList(event.getObservableList());
                ListDiff diff = Diffs.computeListDiff((List)this.list, clean);
                diff.applyTo((List)this.list);
            }
        };
        origList.addListChangeListener(listener);
    }

    public IListProperty getProperty() {
        return this.property;
    }

    private List<Object> cleanedList(IObservableList list) {
        ArrayList<Object> l = new ArrayList<Object>(list.size());
        for (Object o : list) {
            if (!this.accepted(o)) continue;
            l.add(o);
        }
        return l;
    }

    protected abstract boolean accepted(M var1);

    public IObservableList getList() {
        return this.list;
    }

    public Object getOriginalParent() {
        return this.originalParent;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.label;
    }
}

