/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.GouraudShadingContext;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType4;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import org.apache.pdfbox.pdmodel.graphics.shading.Vertex;
import org.apache.pdfbox.util.Matrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Type4ShadingContext
extends GouraudShadingContext {
    private static final Log LOG = LogFactory.getLog(Type4ShadingContext.class);
    private final int bitsPerFlag;

    public Type4ShadingContext(PDShadingType4 shading, ColorModel cm, AffineTransform xform, Matrix ctm, int pageHeight, Rectangle dBounds) throws IOException {
        super(shading, cm, xform, ctm, pageHeight, dBounds);
        LOG.debug("Type4ShadingContext");
        this.bitsPerFlag = shading.getBitsPerFlag();
        LOG.debug("bitsPerFlag: " + this.bitsPerFlag);
        xform.scale(1.0, -1.0);
        xform.translate(0.0, -pageHeight);
        this.triangleList = this.getTriangleList(xform, ctm);
        this.pixelTable = this.calcPixelTable();
    }

    private ArrayList<ShadedTriangle> getTriangleList(AffineTransform xform, Matrix ctm) throws IOException {
        PDShadingType4 freeTriangleShadingType = (PDShadingType4)this.shading;
        COSDictionary cosDictionary = freeTriangleShadingType.getCOSDictionary();
        PDRange rangeX = freeTriangleShadingType.getDecodeForParameter(0);
        PDRange rangeY = freeTriangleShadingType.getDecodeForParameter(1);
        PDRange[] colRange = new PDRange[this.numberOfColorComponents];
        for (int i = 0; i < this.numberOfColorComponents; ++i) {
            colRange[i] = freeTriangleShadingType.getDecodeForParameter(2 + i);
        }
        ArrayList<ShadedTriangle> list = new ArrayList<ShadedTriangle>();
        long maxSrcCoord = (long)Math.pow(2.0, this.bitsPerCoordinate) - 1L;
        long maxSrcColor = (long)Math.pow(2.0, this.bitsPerColorComponent) - 1L;
        COSStream cosStream = (COSStream)cosDictionary;
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(cosStream.getUnfilteredStream());
        int flag = 0;
        try {
            flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
        }
        catch (EOFException ex) {
            LOG.error(ex);
        }
        while (true) {
            try {
                switch (flag) {
                    case 0: {
                        Vertex p0 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, ctm, xform);
                        flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
                        if (flag != 0) {
                            LOG.error("bad triangle: " + flag);
                        }
                        Vertex p1 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, ctm, xform);
                        mciis.readBits(this.bitsPerFlag);
                        if (flag != 0) {
                            LOG.error("bad triangle: " + flag);
                        }
                        Vertex p2 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, ctm, xform);
                        Point2D[] ps = new Point2D[]{p0.point, p1.point, p2.point};
                        float[][] cs = new float[][]{p0.color, p1.color, p2.color};
                        list.add(new ShadedTriangle(ps, cs));
                        flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
                        break;
                    }
                    case 1: {
                        int lastIndex = list.size() - 1;
                        if (lastIndex < 0) {
                            LOG.error("broken data stream: " + list.size());
                            break;
                        }
                        ShadedTriangle preTri = list.get(lastIndex);
                        Vertex p2 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, ctm, xform);
                        Point2D[] ps = new Point2D[]{preTri.corner[1], preTri.corner[2], p2.point};
                        float[][] cs = new float[][]{preTri.color[1], preTri.color[2], p2.color};
                        list.add(new ShadedTriangle(ps, cs));
                        flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
                        break;
                    }
                    case 2: {
                        int lastIndex = list.size() - 1;
                        if (lastIndex < 0) {
                            LOG.error("broken data stream: " + list.size());
                            break;
                        }
                        ShadedTriangle preTri = list.get(lastIndex);
                        Vertex p2 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, ctm, xform);
                        Point2D[] ps = new Point2D[]{preTri.corner[0], preTri.corner[2], p2.point};
                        float[][] cs = new float[][]{preTri.color[0], preTri.color[2], p2.color};
                        list.add(new ShadedTriangle(ps, cs));
                        flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
                        break;
                    }
                    default: {
                        LOG.warn("bad flag: " + flag);
                        break;
                    }
                }
            }
            catch (EOFException ex) {
                mciis.close();
                return list;
            }
        }
    }
}

