/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.applications.ms.glycopeakfinder.calculation.io;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.ParameterException;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.ParameterParsingException;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.AnnotationEntity;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationDerivatisation;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationFragment;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationIon;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationMolecule;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationParameter;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationPeak;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.PeakAnnotation;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.Persubstitution;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.Scan;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.SpectraType;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class CalcParameterXml {
    private String m_strFile = "http://www.dkfz.de/spec/EuroCarbDB/applications/ms-tools/GlycoPeakfinder/schema/exchange.xsd";

    public void setSchema(String string) {
        this.m_strFile = string;
    }

    public CalculationParameter importParameter(File file) throws JDOMException, IOException, ParameterException, ParameterParsingException {
        Document document = new SAXBuilder().build(file);
        Element element = document.getRootElement();
        return this.importParameter(element);
    }

    public CalculationParameter importParameter(String string) throws JDOMException, IOException, ParameterException, ParameterParsingException {
        StringReader stringReader = new StringReader(string);
        Document document = new SAXBuilder().build((Reader)stringReader);
        Element element = document.getRootElement();
        return this.importParameter(element);
    }

    public CalculationParameter importParameter(Element element) throws ParameterException, ParameterParsingException {
        ArrayList<Integer> arrayList;
        Iterator iterator;
        CalculationMolecule calculationMolecule;
        CalculationParameter calculationParameter = new CalculationParameter();
        String string = "";
        string = element.getAttributeValue("persubstitution");
        if (string != null) {
            calculationParameter.setPersubstitution(Persubstitution.forAbbr(string.trim()));
        }
        if ((string = element.getAttributeValue("max_annotation_per_peak")) != null) {
            calculationParameter.setMaxAnnotationPerPeak(Integer.parseInt(string));
        }
        if ((string = element.getAttributeValue("spectra_type")) == null) {
            throw new ParameterParsingException("Attribute spectra_type missing.");
        }
        calculationParameter.setSpectraType(SpectraType.forName(string.trim()));
        string = element.getAttributeValue("mass_type");
        if (string != null) {
            if (string.trim().equals("average")) {
                calculationParameter.setMonoisotopic(false);
            } else {
                calculationParameter.setMonoisotopic(true);
            }
        }
        if ((string = element.getAttributeValue("accuracy")) == null) {
            throw new ParameterParsingException("Attribute accuracy missing.");
        }
        try {
            calculationParameter.setAccuracy(Double.parseDouble(string.trim()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterParsingException("Attribute accuracy is not a float number.");
        }
        string = element.getAttributeValue("accuracy_type");
        if (string == null) {
            throw new ParameterParsingException("Attribute accuracy_type missing.");
        }
        if (string.trim().equals("ppm")) {
            calculationParameter.setAccuracyPpm(true);
        } else {
            calculationParameter.setAccuracyPpm(false);
        }
        string = element.getAttributeValue("mass_shift");
        if (string == null) {
            calculationParameter.setMassShift(0.0);
        } else {
            try {
                calculationParameter.setMassShift(Double.parseDouble(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterParsingException("Attribute mass_shift is not a float number.");
            }
        }
        string = element.getAttributeValue("completion_red");
        if (string == null) {
            throw new ParameterParsingException("Attribute completion_red missing.");
        }
        try {
            calculationParameter.setCompletionRed(Double.parseDouble(string.trim()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterParsingException("Attribute completion_red is not a float number.");
        }
        string = element.getAttributeValue("completion_nonred");
        if (string == null) {
            throw new ParameterParsingException("Attribute completion_nonred missing.");
        }
        try {
            calculationParameter.setCompletionNonRed(Double.parseDouble(string.trim()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterParsingException("Attribute completion_nonred is not a float number.");
        }
        Element element2 = element.getChild("residues");
        ArrayList<CalculationMolecule> arrayList2 = new ArrayList<CalculationMolecule>();
        if (element2 == null) {
            throw new ParameterParsingException("Tag residues missing.");
        }
        for (Element element3 : element2.getChildren("residue")) {
            calculationMolecule = new CalculationMolecule();
            arrayList2.add(calculationMolecule);
            string = element3.getAttributeValue("id");
            if (string == null) {
                throw new ParameterParsingException("Attribute id for tag residue missing.");
            }
            calculationMolecule.setId(string.trim());
            string = element3.getAttributeValue("mass");
            if (string == null) {
                throw new ParameterParsingException("Attribute mass for tag residue missing.");
            }
            try {
                calculationMolecule.setMass(Double.parseDouble(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterParsingException("Attribute mass of tag residue is not a float number.");
            }
            string = element3.getAttributeValue("min");
            if (string == null) {
                throw new ParameterParsingException("Attribute min for tag residue missing.");
            }
            try {
                calculationMolecule.setMin(Integer.parseInt(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterParsingException("Attribute min of tag residue is not a number.");
            }
            string = element3.getAttributeValue("max");
            if (string == null) {
                throw new ParameterParsingException("Attribute max for tag residue missing.");
            }
            try {
                calculationMolecule.setMax(Integer.parseInt(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterParsingException("Attribute max of tag residue is not a number.");
            }
        }
        calculationParameter.setResidues(arrayList2);
        element2 = element.getChild("scan");
        if (element2 == null) {
            throw new ParameterParsingException("Tag scan missing.");
        }
        calculationParameter.setScan(this.parseScan(element2));
        element2 = element.getChild("fragments");
        ArrayList arrayList3 = new ArrayList();
        ArrayList<CalculationFragment> arrayList4 = new ArrayList<CalculationFragment>();
        if (element2 != null) {
            for (Element element3 : element2.getChildren("fragment")) {
                iterator = new CalculationFragment();
                string = element3.getAttributeValue("id");
                if (string == null) {
                    throw new ParameterParsingException("Attribute id of tag fragment missing.");
                }
                ((CalculationFragment)((Object)iterator)).setId(string.trim());
                string = element3.getAttributeValue("mass");
                if (string == null) {
                    throw new ParameterParsingException("Attribute mass of tag fragment missing.");
                }
                try {
                    ((CalculationFragment)((Object)iterator)).setMass(Double.parseDouble(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterParsingException("Attribute mass of tag fragment is not a number.");
                }
                string = element3.getAttributeValue("fragment_type");
                if (string == null) {
                    throw new ParameterParsingException("Attribute fragment_type of tag fragment missing.");
                }
                ((CalculationFragment)((Object)iterator)).setFragmentType(string);
                string = element3.getAttributeValue("type");
                if (string == null) {
                    throw new ParameterParsingException("Attribute tpye of tag fragment missing.");
                }
                if (string.trim().equals("reducing")) {
                    arrayList3.add(iterator);
                } else if (string.trim().equals("non-reducing")) {
                    arrayList4.add((CalculationFragment)((Object)iterator));
                }
                if ((string = element3.getAttributeValue("residue")) == null) continue;
                ((CalculationFragment)((Object)iterator)).setResidueId(string.trim());
            }
            calculationParameter.setFragmentsRed(arrayList3);
            calculationParameter.setFragmentsNonRed(arrayList4);
            arrayList = new ArrayList();
            for (Element element3 : element2.getChildren("level")) {
                string = element3.getAttributeValue("number");
                if (string == null) {
                    throw new ParameterParsingException("Attribute number of tag level missing.");
                }
                try {
                    arrayList.add(Integer.parseInt(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterParsingException("Attribute number of tag level is not a number.");
                }
            }
            calculationParameter.setMultiFragments(arrayList);
            string = element2.getAttributeValue("non_red_diff");
            if (string == null) {
                throw new ParameterParsingException("Attribute non_red_diff missing.");
            }
            try {
                calculationParameter.setNonReducingDifference(Double.parseDouble(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterParsingException("Attribute non_red_diff is not a float number.");
            }
        }
        element2 = element.getChild("ions");
        ArrayList<CalculationIon> arrayList5 = new ArrayList<CalculationIon>();
        arrayList = new ArrayList<Integer>();
        if (element2 == null) {
            throw new ParameterParsingException("Tag ions missing.");
        }
        for (Element element3 : element2.getChildren()) {
            if (element3.getName().equals("ion")) {
                string = element3.getAttributeValue("id");
                iterator = new CalculationIon();
                if (string == null) {
                    throw new ParameterParsingException("Attribute id of tag ion missing.");
                }
                ((CalculationIon)((Object)iterator)).setId(string.trim());
                string = element3.getAttributeValue("mass");
                if (string == null) {
                    throw new ParameterParsingException("Attribute mass for tag ion missing.");
                }
                try {
                    ((CalculationIon)((Object)iterator)).setMass(Double.parseDouble(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterParsingException("Attribute mass of tag ion is not a float number.");
                }
                string = element3.getAttributeValue("charge");
                if (string == null) {
                    throw new ParameterParsingException("Attribute charge for tag ion missing.");
                }
                try {
                    ((CalculationIon)((Object)iterator)).setCharge(Integer.parseInt(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterParsingException("Attribute charge of tag ion is not a float number.");
                }
                arrayList5.add((CalculationIon)((Object)iterator));
                continue;
            }
            if (!element3.getName().equals("charge")) continue;
            string = element3.getAttributeValue("count");
            if (string == null) {
                throw new ParameterParsingException("Attribute count of tag charge missing.");
            }
            try {
                arrayList.add(Integer.parseInt(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterParsingException("Attribute count of tag charge is not a number.");
            }
        }
        calculationParameter.setCharges(arrayList);
        calculationParameter.setIons(arrayList5);
        element2 = element.getChild("ionexchange");
        arrayList5 = new ArrayList();
        arrayList = new ArrayList();
        if (element2 != null) {
            for (Element element3 : element2.getChildren()) {
                if (element3.getName().equals("ion")) {
                    string = element3.getAttributeValue("id");
                    iterator = new CalculationIon();
                    if (string == null) {
                        throw new ParameterParsingException("Attribute id of tag ion missing.");
                    }
                    ((CalculationIon)((Object)iterator)).setId(string.trim());
                    string = element3.getAttributeValue("mass");
                    if (string == null) {
                        throw new ParameterParsingException("Attribute mass for tag ion missing.");
                    }
                    try {
                        ((CalculationIon)((Object)iterator)).setMass(Double.parseDouble(string.trim()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParameterParsingException("Attribute mass of tag ion is not a float number.");
                    }
                    string = element3.getAttributeValue("charge");
                    if (string == null) {
                        throw new ParameterParsingException("Attribute charge for tag ion missing.");
                    }
                    try {
                        ((CalculationIon)((Object)iterator)).setCharge(Integer.parseInt(string.trim()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParameterParsingException("Attribute charge of tag ion is not a float number.");
                    }
                    arrayList5.add((CalculationIon)((Object)iterator));
                    continue;
                }
                if (!element3.getName().equals("quantity")) continue;
                string = element3.getAttributeValue("count");
                if (string == null) {
                    throw new ParameterParsingException("Attribute count of tag quantity missing.");
                }
                try {
                    arrayList.add(Integer.parseInt(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterParsingException("Attribute count of tag quantity is not a number.");
                }
            }
            calculationParameter.setIonExchangeCount(arrayList);
            calculationParameter.setIonExchangeIon(arrayList5);
            string = element2.getAttributeValue("exchange_ion_mass");
            if (string == null) {
                throw new ParameterParsingException("Attribute exchange_ion_mass missing.");
            }
            try {
                calculationParameter.setExchangeIonMass(Double.parseDouble(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterParsingException("Attribute exchange_ion_mass is not a float number.");
            }
        }
        element2 = element.getChild("derivatisation");
        ArrayList arrayList6 = new ArrayList();
        if (element2 == null) {
            throw new ParameterParsingException("Tag derivatisation missing.");
        }
        for (Element element3 : element2.getChildren("derivative")) {
            CalculationDerivatisation calculationDerivatisation = new CalculationDerivatisation();
            string = element3.getAttributeValue("id");
            if (string == null) {
                throw new ParameterParsingException("Attribute id of tag derivative missing.");
            }
            calculationDerivatisation.setId(string);
            string = element3.getAttributeValue("mass");
            if (string == null) {
                throw new ParameterParsingException("Attribute mass for tag derivative missing.");
            }
            try {
                calculationDerivatisation.setMass(Double.parseDouble(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterParsingException("Attribute mass of tag derivative is not a float number.");
            }
            arrayList6.add(calculationDerivatisation);
        }
        calculationParameter.setDerivatisation(arrayList6);
        element2 = element.getChild("molecules");
        if (element2 != null) {
            arrayList2 = new ArrayList();
            ArrayList<CalculationMolecule> arrayList7 = new ArrayList<CalculationMolecule>();
            for (Element element3 : element2.getChildren("molecule")) {
                calculationMolecule = new CalculationMolecule();
                string = element3.getAttributeValue("id");
                if (string == null) {
                    throw new ParameterParsingException("Attribute id for tag molecule missing.");
                }
                calculationMolecule.setId(string.trim());
                string = element3.getAttributeValue("mass");
                if (string == null) {
                    throw new ParameterParsingException("Attribute mass for tag molecule missing.");
                }
                try {
                    calculationMolecule.setMass(Double.parseDouble(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterParsingException("Attribute mass of tag molecule is not a float number.");
                }
                string = element3.getAttributeValue("min");
                if (string == null) {
                    throw new ParameterParsingException("Attribute min for tag molecule missing.");
                }
                try {
                    calculationMolecule.setMin(Integer.parseInt(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterParsingException("Attribute min of tag molecule is not a number.");
                }
                string = element3.getAttributeValue("max");
                if (string == null) {
                    throw new ParameterParsingException("Attribute max for tag molecule missing.");
                }
                try {
                    calculationMolecule.setMax(Integer.parseInt(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterParsingException("Attribute max of tag molecule is not a number.");
                }
                string = element3.getAttributeValue("type");
                if (string == null) {
                    throw new ParameterParsingException("Attribute type for tag molecule missing.");
                }
                if (string.trim().equals("gain")) {
                    arrayList2.add(calculationMolecule);
                    continue;
                }
                if (!string.trim().equals("loss")) continue;
                arrayList7.add(calculationMolecule);
            }
            calculationParameter.setGainMolecules(arrayList2);
            calculationParameter.setLossMolecules(arrayList7);
        }
        return calculationParameter;
    }

    private Scan parseScan(Element element) throws ParameterParsingException {
        Scan scan = new Scan();
        String string = element.getAttributeValue("id");
        if (string == null) {
            throw new ParameterParsingException("Attribute id of tag scan missing.");
        }
        try {
            scan.setId(Integer.parseInt(string.trim()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterParsingException("Attribute id of tag scan is not a number.");
        }
        string = element.getAttributeValue("precursor");
        if (string != null) {
            try {
                scan.setPrecursorMass(Double.parseDouble(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterParsingException("Attribute precursor of tag scan is not a number.");
            }
        }
        ArrayList<CalculationPeak> arrayList = new ArrayList<CalculationPeak>();
        ArrayList<Scan> arrayList2 = new ArrayList<Scan>();
        for (Element element2 : element.getChildren()) {
            if (element2.getName().equals("scan")) {
                arrayList2.add(this.parseScan(element2));
                continue;
            }
            if (!element2.getName().equals("peak")) continue;
            CalculationPeak calculationPeak = new CalculationPeak();
            string = element2.getAttributeValue("mz");
            if (string == null) {
                throw new ParameterParsingException("Attribute mz of tag peak missing.");
            }
            try {
                calculationPeak.setMz(Double.parseDouble(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterParsingException("Attribute mz of tag peak is not a number.");
            }
            string = element2.getAttributeValue("intensity");
            if (string == null) {
                throw new ParameterParsingException("Attribute intensity of tag peak missing.");
            }
            try {
                calculationPeak.setIntensity(Double.parseDouble(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterParsingException("Attribute intensity of tag peak is not a number.");
            }
            string = element2.getAttributeValue("charge");
            if (string != null) {
                try {
                    calculationPeak.setCharge(Integer.parseInt(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterParsingException("Attribute charge of tag peak is not a number.");
                }
            }
            if ((string = element2.getAttributeValue("annotation_count")) != null) {
                try {
                    calculationPeak.setAnnotationCount(Integer.parseInt(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterParsingException("Attribute annotation_count of tag peak is not a number.");
                }
            }
            ArrayList<PeakAnnotation> arrayList3 = new ArrayList<PeakAnnotation>();
            for (Element element3 : element2.getChildren("annotation")) {
                PeakAnnotation peakAnnotation = new PeakAnnotation();
                string = element3.getAttributeValue("mz");
                if (string == null) {
                    throw new ParameterParsingException("Attribute mz of tag annotation missing.");
                }
                try {
                    peakAnnotation.setMass(Double.parseDouble(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParameterParsingException("Attribute mz of tag peak is not a number.");
                }
                string = element3.getAttributeValue("derivative");
                if (string != null) {
                    peakAnnotation.setDerivatisation(string.trim());
                }
                ArrayList<AnnotationEntity> arrayList4 = new ArrayList<AnnotationEntity>();
                ArrayList<AnnotationEntity> arrayList5 = new ArrayList<AnnotationEntity>();
                ArrayList<AnnotationEntity> arrayList6 = new ArrayList<AnnotationEntity>();
                ArrayList<AnnotationEntity> arrayList7 = new ArrayList<AnnotationEntity>();
                ArrayList<AnnotationEntity> arrayList8 = new ArrayList<AnnotationEntity>();
                ArrayList<AnnotationEntity> arrayList9 = new ArrayList<AnnotationEntity>();
                for (Element element4 : element3.getChildren("entry")) {
                    AnnotationEntity annotationEntity = new AnnotationEntity();
                    string = element4.getAttributeValue("id");
                    if (string == null) {
                        throw new ParameterParsingException("Attribute id of tag entry missing.");
                    }
                    annotationEntity.setId(string.trim());
                    string = element4.getAttributeValue("number");
                    if (string == null) {
                        throw new ParameterParsingException("Attribute number of tag entry missing.");
                    }
                    try {
                        annotationEntity.setNumber(Integer.parseInt(string.trim()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParameterParsingException("Attribute number of tag entry is not a number.");
                    }
                    string = element4.getAttributeValue("type");
                    if (string == null) {
                        throw new ParameterParsingException("Attribute type of tag entry missing.");
                    }
                    if ((string = string.trim()).equals("residue")) {
                        arrayList4.add(annotationEntity);
                        continue;
                    }
                    if (string.equals("fragment")) {
                        arrayList5.add(annotationEntity);
                        continue;
                    }
                    if (string.equals("ion")) {
                        arrayList6.add(annotationEntity);
                        continue;
                    }
                    if (string.equals("ionexchange")) {
                        arrayList7.add(annotationEntity);
                        continue;
                    }
                    if (string.equals("gain")) {
                        arrayList8.add(annotationEntity);
                        continue;
                    }
                    if (!string.equals("loss")) continue;
                    arrayList9.add(annotationEntity);
                }
                peakAnnotation.setResidues(arrayList4);
                peakAnnotation.setFragments(arrayList5);
                peakAnnotation.setIons(arrayList6);
                peakAnnotation.setIonExchange(arrayList7);
                peakAnnotation.setGain(arrayList8);
                peakAnnotation.setLoss(arrayList9);
                arrayList3.add(peakAnnotation);
            }
            calculationPeak.setAnnotation(arrayList3);
            if (calculationPeak.getAnnotationCount() == 0) {
                calculationPeak.setAnnotationCount(arrayList3.size());
            } else if (calculationPeak.getAnnotationCount() < arrayList3.size()) {
                throw new ParameterParsingException("Attribute annotation_count is smaller than the real number of annotations.");
            }
            arrayList.add(calculationPeak);
        }
        scan.setSubScan(arrayList2);
        scan.setPeaks(arrayList);
        return scan;
    }

    public String exportParameter(CalculationParameter calculationParameter) throws IOException {
        Document document = new Document();
        Element element = new Element("glycopeakfinder_calculation");
        Namespace namespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        element.addNamespaceDeclaration(namespace);
        element.setAttribute(new Attribute("noNamespaceSchemaLocation", this.m_strFile, namespace));
        this.exportParameter(element, calculationParameter);
        document.setRootElement(element);
        Format format = Format.getPrettyFormat();
        format.setEncoding("iso-8859-1");
        XMLOutputter xMLOutputter = new XMLOutputter(format);
        StringWriter stringWriter = new StringWriter();
        xMLOutputter.output(document, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public void exportParameter(Element element, CalculationParameter calculationParameter) {
        Element element2;
        Element element3 = new Element("residues");
        for (CalculationMolecule calculationMolecule : calculationParameter.getResidues()) {
            element2 = new Element("residue");
            element2.setAttribute("id", calculationMolecule.getId());
            element2.setAttribute("mass", Double.toString(calculationMolecule.getMass()));
            element2.setAttribute("min", Integer.toString(calculationMolecule.getMin()));
            element2.setAttribute("max", Integer.toString(calculationMolecule.getMax()));
            element3.addContent((Content)element2);
        }
        element.addContent((Content)element3);
        this.exportScan(element, calculationParameter.getScan());
        element.setAttribute("spectra_type", calculationParameter.getSpectraType().getName());
        if (calculationParameter.getMonoisotopic()) {
            element3.setAttribute("mass_type", "monoisotopic");
        } else {
            element3.setAttribute("mass_type", "average");
        }
        element.setAttribute("persubstitution", calculationParameter.getPersubstitution().getAbbr());
        element.setAttribute("max_annotation_per_peak", Integer.toString(calculationParameter.getMaxAnnotationPerPeak()));
        if (calculationParameter.getFragmentsNonRed().size() + calculationParameter.getFragmentsRed().size() > 0) {
            element3 = new Element("fragments");
            element3.setAttribute("non_red_diff", Double.toString(calculationParameter.getNonReducingDifference()));
            for (CalculationFragment calculationFragment : calculationParameter.getFragmentsRed()) {
                element2 = new Element("fragment");
                element2.setAttribute("type", "reducing");
                element2.setAttribute("fragment_type", calculationFragment.getFragmentType());
                element2.setAttribute("id", calculationFragment.getId());
                element2.setAttribute("mass", Double.toString(calculationFragment.getMass()));
                if (calculationFragment.getResidueId() != null) {
                    element2.setAttribute("residue", calculationFragment.getResidueId());
                }
                element3.addContent((Content)element2);
            }
            for (CalculationFragment calculationFragment : calculationParameter.getFragmentsNonRed()) {
                element2 = new Element("fragment");
                element2.setAttribute("type", "non-reducing");
                element2.setAttribute("fragment_type", calculationFragment.getFragmentType());
                element2.setAttribute("id", calculationFragment.getId());
                element2.setAttribute("mass", Double.toString(calculationFragment.getMass()));
                if (calculationFragment.getResidueId() != null) {
                    element2.setAttribute("residue", calculationFragment.getResidueId());
                }
                element3.addContent((Content)element2);
            }
            for (Integer n : calculationParameter.getMultiFragments()) {
                element2 = new Element("level");
                element2.setAttribute("number", n.toString());
                element3.addContent((Content)element2);
            }
            element.addContent((Content)element3);
        }
        element.setAttribute("accuracy", Double.toString(calculationParameter.getAccuracy()));
        if (calculationParameter.getAccuracyPpm()) {
            element.setAttribute("accuracy_type", "ppm");
        } else {
            element.setAttribute("accuracy_type", "u");
        }
        element3 = new Element("ions");
        for (CalculationIon calculationIon : calculationParameter.getIons()) {
            element2 = new Element("ion");
            element2.setAttribute("id", calculationIon.getId());
            element2.setAttribute("mass", Double.toString(calculationIon.getMass()));
            element2.setAttribute("charge", calculationIon.getCharge().toString());
            element3.addContent((Content)element2);
        }
        Iterator<Integer> iterator = calculationParameter.getCharges().iterator();
        while (iterator.hasNext()) {
            element2 = new Element("charge");
            element2.setAttribute("count", iterator.next().toString());
            element3.addContent((Content)element2);
        }
        element.addContent((Content)element3);
        if (calculationParameter.getIonExchangeIon().size() > 0) {
            element3 = new Element("ionexchange");
            element3.setAttribute("exchange_ion_mass", Double.toString(calculationParameter.getExchangeIonMass()));
            for (CalculationIon calculationIon : calculationParameter.getIonExchangeIon()) {
                element2 = new Element("ion");
                element2.setAttribute("id", calculationIon.getId());
                element2.setAttribute("mass", Double.toString(calculationIon.getMass()));
                element2.setAttribute("charge", calculationIon.getCharge().toString());
                element3.addContent((Content)element2);
            }
            Iterator<Integer> iterator2 = calculationParameter.getIonExchangeCount().iterator();
            while (iterator2.hasNext()) {
                element2 = new Element("quantity");
                element2.setAttribute("count", iterator2.next().toString());
                element3.addContent((Content)element2);
            }
            element.addContent((Content)element3);
        }
        element.setAttribute("mass_shift", Double.toString(calculationParameter.getMassShift()));
        element3 = new Element("derivatisation");
        for (CalculationDerivatisation calculationDerivatisation : calculationParameter.getDerivatisation()) {
            element2 = new Element("derivative");
            element2.setAttribute("id", calculationDerivatisation.getId());
            element2.setAttribute("mass", Double.toString(calculationDerivatisation.getMass()));
            element3.addContent((Content)element2);
        }
        element.addContent((Content)element3);
        element3 = new Element("molecules");
        for (CalculationMolecule calculationMolecule : calculationParameter.getGainMolecules()) {
            element2 = new Element("molecule");
            element2.setAttribute("type", "gain");
            element2.setAttribute("id", calculationMolecule.getId());
            element2.setAttribute("mass", Double.toString(calculationMolecule.getMass()));
            element2.setAttribute("min", Integer.toString(calculationMolecule.getMin()));
            element2.setAttribute("max", Integer.toString(calculationMolecule.getMax()));
            element3.addContent((Content)element2);
        }
        for (CalculationMolecule calculationMolecule : calculationParameter.getLossMolecules()) {
            element2 = new Element("molecule");
            element2.setAttribute("type", "loss");
            element2.setAttribute("id", calculationMolecule.getId());
            element2.setAttribute("mass", Double.toString(calculationMolecule.getMass()));
            element2.setAttribute("min", Integer.toString(calculationMolecule.getMin()));
            element2.setAttribute("max", Integer.toString(calculationMolecule.getMax()));
            element3.addContent((Content)element2);
        }
        element.addContent((Content)element3);
        element.setAttribute("completion_red", Double.toString(calculationParameter.getCompletionRed()));
        element.setAttribute("completion_nonred", Double.toString(calculationParameter.getCompletionNonRed()));
    }

    private void exportScan(Element element, Scan scan) {
        Element element2 = new Element("scan");
        element2.setAttribute("id", scan.getId().toString());
        if (scan.getPrecusorMass() != null) {
            element2.setAttribute("precursor", scan.getPrecusorMass().toString());
        }
        for (CalculationPeak calculationPeak : scan.getPeaks()) {
            Element element3 = new Element("peak");
            element3.setAttribute("mz", Double.toString(calculationPeak.getMz()));
            element3.setAttribute("intensity", Double.toString(calculationPeak.getIntensity()));
            element3.setAttribute("annotation_count", Integer.toString(calculationPeak.getAnnotationCount()));
            if (calculationPeak.getCharge() != null) {
                element3.setAttribute("charge", Integer.toString(calculationPeak.getCharge()));
            }
            for (PeakAnnotation peakAnnotation : calculationPeak.getAnnotation()) {
                Element element4;
                Element element5 = new Element("annotation");
                for (AnnotationEntity annotationEntity : peakAnnotation.getResidues()) {
                    element4 = new Element("entry");
                    element4.setAttribute("id", annotationEntity.getId());
                    element4.setAttribute("type", "residue");
                    element4.setAttribute("number", Integer.toString(annotationEntity.getNumber()));
                    element5.addContent((Content)element4);
                }
                for (AnnotationEntity annotationEntity : peakAnnotation.getFragments()) {
                    element4 = new Element("entry");
                    element4.setAttribute("id", annotationEntity.getId());
                    element4.setAttribute("type", "fragment");
                    element4.setAttribute("number", Integer.toString(annotationEntity.getNumber()));
                    element5.addContent((Content)element4);
                }
                for (AnnotationEntity annotationEntity : peakAnnotation.getIons()) {
                    element4 = new Element("entry");
                    element4.setAttribute("id", annotationEntity.getId());
                    element4.setAttribute("type", "ion");
                    element4.setAttribute("number", Integer.toString(annotationEntity.getNumber()));
                    element5.addContent((Content)element4);
                }
                for (AnnotationEntity annotationEntity : peakAnnotation.getIonExchange()) {
                    element4 = new Element("entry");
                    element4.setAttribute("id", annotationEntity.getId());
                    element4.setAttribute("type", "ionexchange");
                    element4.setAttribute("number", Integer.toString(annotationEntity.getNumber()));
                    element5.addContent((Content)element4);
                }
                for (AnnotationEntity annotationEntity : peakAnnotation.getGain()) {
                    element4 = new Element("entry");
                    element4.setAttribute("id", annotationEntity.getId());
                    element4.setAttribute("type", "gain");
                    element4.setAttribute("number", Integer.toString(annotationEntity.getNumber()));
                    element5.addContent((Content)element4);
                }
                for (AnnotationEntity annotationEntity : peakAnnotation.getLoss()) {
                    element4 = new Element("entry");
                    element4.setAttribute("id", annotationEntity.getId());
                    element4.setAttribute("type", "loss");
                    element4.setAttribute("number", Integer.toString(annotationEntity.getNumber()));
                    element5.addContent((Content)element4);
                }
                if (peakAnnotation.getDerivatisation() != null) {
                    element5.setAttribute("derivative", peakAnnotation.getDerivatisation());
                }
                element5.setAttribute("mz", Double.toString(peakAnnotation.getMass()));
                element3.addContent((Content)element5);
            }
            element2.addContent((Content)element3);
        }
        Iterator<Object> iterator = scan.getSubScan().iterator();
        while (iterator.hasNext()) {
            this.exportScan(element2, (Scan)iterator.next());
        }
        element.addContent((Content)element2);
    }
}

