/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.FragmentSettingsForm;
import org.grits.toolbox.ms.om.data.Fragment;

public abstract class FragmentPerOptionForm
extends TitleAreaDialog {
    protected Button btnB;
    protected Button btnY;
    protected Button btnC;
    protected Button btnZ;
    protected Button btnA;
    protected Button btnX;
    protected Button btnAdd;
    protected FragmentSettingsForm parentForm = null;
    private int addCnt = 0;

    public FragmentPerOptionForm(Shell parentShell, FragmentSettingsForm parentForm) {
        super(parentShell);
        this.parentForm = parentForm;
    }

    protected void setDirty(boolean _bModified, boolean _bValid) {
        if (_bModified && _bValid) {
            ++this.addCnt;
        }
        this.btnAdd.setEnabled(_bValid);
        Button bOK = this.getButton(0);
        if (!_bValid) {
            bOK.setText(IDialogConstants.CANCEL_LABEL);
        } else if (!_bModified && _bValid && this.addCnt > 0) {
            bOK.setText(IDialogConstants.FINISH_LABEL);
        } else {
            bOK.setText(IDialogConstants.CLOSE_LABEL);
        }
    }

    protected abstract String getFormTitle();

    protected abstract void addPreFragmentControls(Composite var1);

    protected abstract void addPostFragmentControls(Composite var1);

    protected abstract void addButtonEventListeners();

    protected void addFragmentControls(Composite container) {
        Label label_2 = new Label(container, 0);
        label_2.setText("Glyco Cleavages");
        this.btnB = new Button(container, 32);
        this.btnB.setSelection(true);
        this.btnB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FragmentPerOptionForm.this.setDirty(true, FragmentPerOptionForm.this.validatInput());
            }
        });
        this.btnB.setText("B");
        new Label(container, 0);
        this.btnY = new Button(container, 32);
        this.btnY.setSelection(true);
        this.btnY.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FragmentPerOptionForm.this.setDirty(true, FragmentPerOptionForm.this.validatInput());
            }
        });
        this.btnY.setText("Y");
        new Label(container, 0);
        this.btnC = new Button(container, 32);
        this.btnC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FragmentPerOptionForm.this.setDirty(true, FragmentPerOptionForm.this.validatInput());
            }
        });
        this.btnC.setText("C");
        new Label(container, 0);
        this.btnZ = new Button(container, 32);
        this.btnZ.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FragmentPerOptionForm.this.setDirty(true, FragmentPerOptionForm.this.validatInput());
            }
        });
        this.btnZ.setText("Z");
        Label label_3 = new Label(container, 0);
        label_3.setText("Cross Ring Cleavages");
        this.btnA = new Button(container, 32);
        this.btnA.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FragmentPerOptionForm.this.setDirty(true, FragmentPerOptionForm.this.validatInput());
            }
        });
        this.btnA.setText("A");
        new Label(container, 0);
        this.btnX = new Button(container, 32);
        this.btnX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FragmentPerOptionForm.this.setDirty(true, FragmentPerOptionForm.this.validatInput());
            }
        });
        this.btnX.setText("X");
    }

    protected void addAddButton(Composite container) {
        this.btnAdd = new Button(container, 8);
        this.btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.btnAdd.setText("Add");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.getFormTitle());
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        this.addPreFragmentControls(container);
        this.addFragmentControls(container);
        this.addPostFragmentControls(container);
        this.addAddButton(container);
        this.addButtonEventListeners();
        new Label(container, 0);
        new Label(container, 0);
        return area;
    }

    public List<Fragment> getFragments() {
        Fragment fragment;
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        if (this.btnB.getSelection()) {
            fragment = new Fragment();
            fragment.setNumber("-1");
            fragment.setType("B");
            fragments.add(fragment);
        }
        if (this.btnY.getSelection()) {
            fragment = new Fragment();
            fragment.setNumber("-1");
            fragment.setType("Y");
            fragments.add(fragment);
        }
        if (this.btnC.getSelection()) {
            fragment = new Fragment();
            fragment.setNumber("-1");
            fragment.setType("C");
            fragments.add(fragment);
        }
        if (this.btnZ.getSelection()) {
            fragment = new Fragment();
            fragment.setNumber("-1");
            fragment.setType("Z");
            fragments.add(fragment);
        }
        if (this.btnA.getSelection()) {
            fragment = new Fragment();
            fragment.setNumber("-1");
            fragment.setType("A");
            fragments.add(fragment);
        }
        if (this.btnX.getSelection()) {
            fragment = new Fragment();
            fragment.setNumber("-1");
            fragment.setType("X");
            fragments.add(fragment);
        }
        return fragments;
    }

    public boolean validatInput() {
        if (!(this.btnB.getSelection() || this.btnY.getSelection() || this.btnC.getSelection() || this.btnZ.getSelection() || this.btnA.getSelection() || this.btnX.getSelection())) {
            this.setErrorMessage("Please select at least one glyco cleavage type or cross ring type");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(450, 500);
    }
}

