/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSEdgeComparator;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class ModAltToUndUnit {
    private ArrayList<ModificationAlternative> antennae = new ArrayList();
    private ArrayList<ModificationAlternative> undefinedLinkages = new ArrayList();
    private ArrayList<ModificationAlternative> undefinedSubstituents = new ArrayList();
    private GlyContainer glyCo;
    private HashMap<WURCSComponent, Node> backbone2Node;

    public ModAltToUndUnit(GlyContainer _glyco, HashMap<WURCSComponent, Node> _backbone2Node) {
        this.glyCo = _glyco;
        this.backbone2Node = _backbone2Node;
    }

    public GlyContainer getGlycan() {
        return this.glyCo;
    }

    public ArrayList<ModificationAlternative> getAntennae() {
        return this.antennae;
    }

    public ArrayList<ModificationAlternative> getUndefinedLinkages() {
        return this.undefinedLinkages;
    }

    public ArrayList<ModificationAlternative> getUndefinedSubstituents() {
        return this.undefinedSubstituents;
    }

    public void start(LinkedList<Backbone> _backbones) throws GlycanException, WURCSFormatException {
        for (Backbone bb : _backbones) {
            this.parseFragments(bb);
        }
        this.backboneToUndefinedUnit();
    }

    private void parseFragments(Backbone _backbone) throws GlycanException, WURCSFormatException {
        if (_backbone.getChildEdges().isEmpty()) {
            return;
        }
        for (WURCSEdge cEdge : _backbone.getChildEdges()) {
            if (!(cEdge.getNextComponent() instanceof ModificationAlternative)) continue;
            ModificationAlternative modAlt = (ModificationAlternative)cEdge.getNextComponent();
            this.extractUndefinedLinkages(modAlt);
            this.extractUndefinedSubstituents(modAlt);
            if (this.antennae.contains(modAlt)) continue;
            this.antennae.add(modAlt);
        }
    }

    private boolean isCrossLinkedSubstituent(Modification _mod) throws GlycanException, WURCSFormatException {
        if (_mod.getMAPCode().equals("")) {
            return false;
        }
        return SubstituentUtility.MAPToInterface(_mod.getMAPCode()) instanceof BaseCrossLinkedTemplate;
    }

    private void extractUndefinedLinkages(ModificationAlternative t_modAlt) throws GlycanException {
        if (this.undefinedLinkages.contains(t_modAlt)) {
            return;
        }
        if (t_modAlt.getLeadInEdges().size() != t_modAlt.getLeadOutEdges().size()) {
            return;
        }
        LinkedList t_lInEdges = t_modAlt.getLeadInEdges();
        LinkedList t_lOutEdges = t_modAlt.getLeadOutEdges();
        WURCSEdgeComparator t_compEdges = new WURCSEdgeComparator();
        Collections.sort(t_lInEdges, t_compEdges);
        Collections.sort(t_lOutEdges, t_compEdges);
        int nEdges = t_lInEdges.size();
        int i = 0;
        while (i < nEdges) {
            WURCSEdge t_edgeOut;
            WURCSEdge t_edgeIn = (WURCSEdge)t_lInEdges.get(i);
            int t_iComp = t_compEdges.compare(t_edgeIn, t_edgeOut = (WURCSEdge)t_lOutEdges.get(i));
            if (t_iComp != 0) {
                return;
            }
            ++i;
        }
        if (!t_modAlt.canOmitMAP()) {
            throw new GlycanException("Undefined linkage with substituent cannot be handled.");
        }
        this.undefinedLinkages.add(t_modAlt);
    }

    private void extractUndefinedSubstituents(ModificationAlternative t_modAlt) throws GlycanException {
        if (this.undefinedSubstituents.contains(t_modAlt)) {
            return;
        }
        if (t_modAlt.getLeadInEdges().isEmpty() || !t_modAlt.getLeadOutEdges().isEmpty()) {
            return;
        }
        if (t_modAlt.getMAPCode().isEmpty()) {
            return;
        }
        this.undefinedSubstituents.add(t_modAlt);
    }

    private void backboneToUndefinedUnit() throws GlycanException, WURCSFormatException {
        for (ModificationAlternative modAlt : this.antennae) {
            GlycanUndefinedUnit und = new GlycanUndefinedUnit();
            Iterator iterator = modAlt.getLeadInEdges().iterator();
            if (iterator.hasNext()) {
                Node fragRoot;
                WURCSEdge inEdge = (WURCSEdge)iterator.next();
                if (!modAlt.getMAPCode().equals("")) {
                    fragRoot = SubstituentUtility.MAPToSubstituent((Modification)modAlt);
                    und.addNode(fragRoot);
                } else {
                    fragRoot = this.backbone2Node.get(this.extractFragmentRoot(inEdge));
                    und.addNode(fragRoot);
                }
                for (WURCSEdge acceptorWE : inEdge.getNextComponent().getParentEdges()) {
                    Node coreNode = this.backbone2Node.get(acceptorWE.getBackbone());
                    und.addParentNode(coreNode);
                }
                Edge acceptorEdge = new Edge();
                Linkage linkage = new Linkage();
                ArrayList<Integer> acceptorPos = new ArrayList<Integer>();
                ArrayList<Integer> donorPos = new ArrayList<Integer>();
                if (modAlt.getMAPCode().equals("")) {
                    Backbone fragBB = this.extractFragmentRoot(inEdge);
                    fragRoot = this.backbone2Node.get(fragBB);
                    fragRoot.addParentEdge(acceptorEdge);
                    acceptorEdge.setChild(fragRoot);
                    donorPos.add(fragBB.getAnomericPosition());
                } else {
                    fragRoot = und.getNodes().get(0);
                    fragRoot.addParentEdge(acceptorEdge);
                    acceptorEdge.setSubstituent(fragRoot);
                    donorPos.add(0);
                }
                for (LinkagePosition lp : inEdge.getLinkages()) {
                    acceptorPos.add(lp.getBackbonePosition());
                }
                linkage.setParentLinkages(acceptorPos);
                linkage.setChildLinkages(donorPos);
                acceptorEdge.addGlycosidicLinkage(linkage);
                und.setConnection(acceptorEdge);
            }
            this.glyCo.addGlycanUndefinedUnit(und);
        }
        if (this.glyCo.getUndefinedUnit().size() != this.antennae.size()) {
            throw new GlycanException("Parse fragment did not correctly performed.");
        }
    }

    private Backbone extractFragmentRoot(WURCSEdge _inEdge) {
        if (!_inEdge.getNextComponent().getChildEdges().isEmpty()) {
            return ((WURCSEdge)_inEdge.getNextComponent().getChildEdges().get(0)).getBackbone();
        }
        for (WURCSEdge acceptorEdge : _inEdge.getNextComponent().getParentEdges()) {
            if (!acceptorEdge.getBackbone().isRoot()) continue;
            int numGlycosidic = 0;
            for (WURCSEdge ce : acceptorEdge.getBackbone().getChildEdges()) {
                Modification mod;
                if (ce.getNextComponent() instanceof ModificationAlternative || !(ce.getNextComponent() instanceof Modification) || (mod = (Modification)ce.getNextComponent()).isRing() || !mod.getMAPCode().equals("") || !mod.isGlycosidic()) continue;
                ++numGlycosidic;
            }
            if (numGlycosidic != 0) continue;
            return acceptorEdge.getBackbone();
        }
        return null;
    }
}

