/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.Glycan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanGraph;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;

public class GlycanUndefinedUnit
implements GlycanGraph {
    private ArrayList<Node> parents = new ArrayList();
    private Edge connection = null;
    private ArrayList<Node> children = new ArrayList();
    public static final double UNKNOWN = -1.0;
    private double probabilityLow = 100.0;
    private double probabilityHigh = 100.0;

    public GlycanUndefinedUnit() {
        this.parents.clear();
        this.children.clear();
    }

    @Override
    public ArrayList<Node> getRootNodes() throws GlycanException {
        ArrayList<Node> ret = new ArrayList<Node>();
        Iterator<Node> iterator = this.getNodes().iterator();
        while (iterator.hasNext()) {
            Node unit;
            Node root = unit = iterator.next();
            Edge parent = root.getParentEdge();
            if (root instanceof Substituent || this.isComposition()) {
                ret.add(root);
                continue;
            }
            if (parent != null && parent.getParent() == null) {
                ret.add(root);
                continue;
            }
            if (parent == null || parent.isReverseEdge()) continue;
            ret.add(root);
        }
        if (ret.size() == 1) {
            return ret;
        }
        throw new GlycanException("Node seems not to have at least one root residue");
    }

    @Override
    public Iterator<Node> getNodeIterator() {
        return this.children.iterator();
    }

    @Override
    public boolean isConnected() throws GlycanException {
        ArrayList<Node> roots = this.getRootNodes();
        return roots.size() <= 1;
    }

    @Override
    public boolean removeNode(Node _node) throws GlycanException {
        Node residue;
        if (_node == null) {
            throw new GlycanException("Invalid residue.");
        }
        Edge linkage2 = _node.getParentEdge();
        if (linkage2 != null) {
            residue = linkage2.getParent();
            if (residue == null) {
                throw new GlycanException("A linkage with a null parent exists.");
            }
            residue.removeChildEdge(linkage2);
        }
        for (Edge linkage2 : _node.getChildEdges()) {
            residue = linkage2.getChild();
            if (residue == null) {
                throw new GlycanException("A linkage with a null child exists.");
            }
            residue.removeParentEdge(linkage2);
        }
        return this.children.remove(_node);
    }

    @Override
    public ArrayList<Node> getNodes() {
        ArrayList<Node> ret = new ArrayList<Node>();
        Iterator<Node> iterNode = this.getNodeIterator();
        while (iterNode.hasNext()) {
            Node node = iterNode.next();
            ret.add(node);
        }
        return ret;
    }

    @Override
    public ArrayList<Edge> getEdges() {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        Iterator<Node> iterNode = this.getNodeIterator();
        while (iterNode.hasNext()) {
            Node node = iterNode.next();
            for (Edge edge : node.getChildEdges()) {
                ret.add(edge);
            }
        }
        return ret;
    }

    @Override
    public boolean addNode(Node _node) throws GlycanException {
        if (_node == null) {
            throw new GlycanException("Invalid residue.");
        }
        if (!this.children.contains(_node)) {
            return this.children.add(_node);
        }
        return false;
    }

    @Override
    public boolean addNode(Node _parent, Edge _linkage, Node _child) throws GlycanException {
        if (_parent == null || _child == null) {
            throw new GlycanException("Invalid residue");
        }
        if (_linkage == null) {
            throw new GlycanException("Invalid linkage");
        }
        if (!this.containsNode(_parent)) {
            this.addNode(_parent);
        }
        if (!this.containsNode(_child)) {
            this.addNode(_child);
        }
        _child.addParentEdge(_linkage);
        _parent.addChildEdge(_linkage);
        _linkage.setChild(_child);
        _linkage.setParent(_parent);
        return true;
    }

    @Override
    public boolean addNodeWithSubstituent(Node _parent, Edge _linkage, Substituent _child) throws GlycanException {
        if (_parent == null || _child == null) {
            throw new GlycanException("Invalid residue");
        }
        if (_linkage == null) {
            throw new GlycanException("Invalid residue");
        }
        if (!this.containsNode(_parent)) {
            this.addNode(_parent);
        }
        if (!this.containsNode(_parent)) {
            throw new GlycanException("Critical error imposible to add residue.");
        }
        _parent.addChildEdge(_linkage);
        _linkage.setSubstituent(_child);
        return true;
    }

    @Override
    public boolean addEdge(Node _parent, Node _child, Edge _linkage) throws GlycanException {
        return this.addNode(_parent, _linkage, _child);
    }

    @Override
    public boolean containsNode(Node _node) {
        return this.children.contains(_node);
    }

    @Override
    public boolean isParent(Node _parent, Node _current) {
        Node parent = _current.getParentNode();
        if (parent == null) {
            return false;
        }
        if (parent == _parent) {
            return true;
        }
        return this.isParent(_parent, parent);
    }

    @Override
    public boolean removeEdge(Edge _edge) throws GlycanException {
        if (_edge == null) {
            return false;
        }
        Node child = _edge.getChild();
        Node parent = _edge.getParent();
        if (child == null || parent == null) {
            throw new GlycanException("The edge contains null values");
        }
        if (child.getParentEdge() != _edge) {
            throw new GlycanException("The child attachement is not correct");
        }
        ArrayList<Edge> edges = parent.getChildEdges();
        if (!edges.contains(_edge)) {
            throw new GlycanException("The parent attachement is not correct");
        }
        child.removeParentEdge(_edge);
        parent.removeChildEdge(_edge);
        return true;
    }

    public void setConnection(Edge _edge) {
        this.connection = _edge;
    }

    public Edge getConnection() {
        return this.connection;
    }

    public double getProbabilityHigh() {
        return this.probabilityHigh;
    }

    public double getProbabilityLow() {
        return this.probabilityLow;
    }

    public void setProbability(double _high, double _low) throws GlycanException {
        if (_low > _high) {
            throw new GlycanException("The lower border of a probability must be smaller or equal than the upper border.");
        }
        this.probabilityHigh = _high;
        this.probabilityLow = _low;
    }

    public void setProbability(double _probability) {
        this.probabilityHigh = _probability;
        this.probabilityLow = _probability;
    }

    protected void setParentNodes(ArrayList<Node> _parents) throws GlycanException {
        if (this.parents == null) {
            throw new GlycanException("Parent are Null");
        }
        this.parents.clear();
        Iterator<Node> iterNode = _parents.iterator();
        while (iterNode.hasNext()) {
            this.addParentNode(iterNode.next());
        }
    }

    public boolean addParentNode(Node _parent) {
        if (this.parents.contains(_parent)) {
            return false;
        }
        return this.parents.add(_parent);
    }

    public Iterator<Node> getParentIterator() {
        return this.parents.iterator();
    }

    public ArrayList<Node> getParents() {
        ArrayList<Node> ret = new ArrayList<Node>();
        Iterator<Node> iterNode = this.getParentIterator();
        while (iterNode.hasNext()) {
            Node node = iterNode.next();
            ret.add(node);
        }
        return ret;
    }

    @Override
    public boolean isComposition() {
        return this.connection == null;
    }

    public GlycanUndefinedUnit copy() throws GlycanException {
        GlycanUndefinedUnit und = new GlycanUndefinedUnit();
        HashMap<Node, Node> copyIndex = new HashMap<Node, Node>();
        for (Node node : this.getNodes()) {
            for (Edge parentEdge : node.getParentEdges()) {
                if (parentEdge.getChild() == null || parentEdge.getParent() == null) continue;
                if (!copyIndex.containsKey(parentEdge.getChild())) {
                    Node copyChild = parentEdge.getChild().copy();
                    copyIndex.put(parentEdge.getChild(), copyChild);
                }
                if (copyIndex.containsKey(parentEdge.getParent())) continue;
                Node copyParent = parentEdge.getParent().copy();
                copyIndex.put(parentEdge.getParent(), copyParent);
            }
        }
        und.setParentNodes(this.parents);
        if (this.connection != null) {
            und.setConnection(this.connection.copy());
        }
        und.setProbability(this.probabilityHigh, this.probabilityLow);
        for (Node node : this.getNodes()) {
            if (node.getParentEdges().isEmpty()) {
                Node copyNode = node.copy();
                und.addNode(copyNode);
            }
            for (Edge parentEdge : node.getParentEdges()) {
                Edge copyEdge = parentEdge.copy();
                Node copyChild = null;
                if (copyIndex.containsKey(parentEdge.getChild())) {
                    copyChild = (Node)copyIndex.get(parentEdge.getChild());
                } else {
                    if (parentEdge.getChild() != null) {
                        copyChild = parentEdge.getChild().copy();
                    }
                    if (parentEdge.getSubstituent() != null) {
                        copyChild = parentEdge.getSubstituent().copy();
                    }
                }
                Node copyParent = copyIndex.containsKey(parentEdge.getParent()) ? (Node)copyIndex.get(parentEdge.getParent()) : null;
                if (parentEdge.getChild() != null && parentEdge.getSubstituent() != null) {
                    Node copySub = parentEdge.getSubstituent().copy();
                    copyEdge.setSubstituent(copySub);
                }
                if (copyParent instanceof Monosaccharide) {
                    und.addNode(copyParent, copyEdge, copyChild);
                    continue;
                }
                copyChild.addParentEdge(copyEdge);
                und.addNode(copyChild);
            }
        }
        return und;
    }
}

