/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.utility;

import java.io.File;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.entry.archive.model.ArchivedFile;

public class UtilityFileName {
    private static Logger logger = Logger.getLogger(UtilityFileName.class);

    public static String generateUniqueFileName(File parentFolder, String suggestedName) {
        String[] nameParts;
        boolean unique = false;
        String uniqueName = null;
        int i = 0;
        while ((nameParts = suggestedName.split("\\.")).length > 0) {
            UtilityFileName.appendSuffix(nameParts, "_" + i);
            uniqueName = "";
            String[] stringArray = nameParts;
            int n = nameParts.length;
            int n2 = 0;
            while (n2 < n) {
                String namePart = stringArray[n2];
                if (namePart != null) {
                    uniqueName = String.valueOf(uniqueName) + namePart + ".";
                }
                ++n2;
            }
            uniqueName = uniqueName.substring(0, uniqueName.length() - 1);
            unique = UtilityFileName.checkUnique(parentFolder, uniqueName);
            ++i;
            if (!unique) continue;
        }
        return uniqueName;
    }

    private static void appendSuffix(String[] nameParts, String suffix) {
        int i = 0;
        boolean appended = false;
        while (i < nameParts.length && !appended) {
            if (!nameParts[i].isEmpty()) {
                nameParts[i] = String.valueOf(nameParts[i]) + suffix;
                appended = true;
            }
            ++i;
        }
    }

    public static boolean checkUnique(File parentFolder, String fileName) {
        boolean unique = true;
        File[] fileArray = parentFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File childFile = fileArray[n2];
            logger.debug((Object)("Matching " + fileName + " with : " + childFile.getName()));
            if (childFile.getName().equals(fileName)) {
                unique = false;
                break;
            }
            ++n2;
        }
        return unique;
    }

    public static HashSet<String> getExistingNames(List<ArchivedFile> inputArchivedFiles, File archiveFolder) throws Exception {
        HashSet<String> existingNames = new HashSet<String>();
        if (inputArchivedFiles != null) {
            for (ArchivedFile archiveFile : inputArchivedFiles) {
                existingNames.add(archiveFile.getTypicalArchivedFile().getFileName());
            }
        }
        if (archiveFolder != null && archiveFolder.isDirectory()) {
            File[] fileArray = archiveFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File archive = fileArray[n2];
                existingNames.add(archive.getName());
                ++n2;
            }
        }
        return existingNames;
    }

    public static String getFileSize(File file) {
        String fileSize = "0 KB";
        if (file != null) {
            DecimalFormat df = new DecimalFormat("#.##");
            if (file != null && file.exists()) {
                long size = file.length();
                fileSize = (float)size < 1024.0f ? String.valueOf(df.format(size)) + " B" : ((float)size < 1048576.0f ? String.valueOf(df.format((float)size / 1024.0f)) + " KB" : ((float)size < 1.0737418E9f ? String.valueOf(df.format((float)size / 1048576.0f)) + " MB" : String.valueOf(df.format((float)size / 1.0737418E9f)) + " GB"));
            }
        }
        return fileSize;
    }
}

