/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.property;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.DeleteUtils;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.archive.command.NewArchive;
import org.grits.toolbox.entry.archive.config.ImageRegistry;
import org.grits.toolbox.entry.archive.io.ArchivePropertyWriter;
import org.grits.toolbox.entry.archive.utility.UtilityZip;

public class ArchiveProperty
extends Property {
    private static Logger logger = Logger.getLogger(ArchiveProperty.class);
    public static final String CURRENT_VERSION = "1.0";
    public static final String TYPE = "org.grits.toolbox.property.archive";
    protected static PropertyWriter writer = new ArchivePropertyWriter();
    private int viewerRank = 500;

    public PropertyDataFile getArchiveFile() {
        PropertyDataFile archiveFile = null;
        for (PropertyDataFile dataFile : this.dataFiles) {
            if (!"archive_folder".equals(dataFile.getType())) continue;
            archiveFile = dataFile;
            break;
        }
        return archiveFile;
    }

    public void setArchiveFile(PropertyDataFile propertyDataFile) {
        this.dataFiles = Arrays.asList(propertyDataFile);
    }

    public String getType() {
        return TYPE;
    }

    public PropertyWriter getWriter() {
        return writer;
    }

    public ImageDescriptor getImage() {
        return ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.archive", ImageRegistry.ArchiveImage.BOOKS_ICON);
    }

    public void delete(Entry entry) {
        logger.debug((Object)"Deleting Archive Entry");
        if (entry != null && entry.getProperty().getType().equals(TYPE)) {
            try {
                File archiveFolder = ArchiveProperty.getFolderForArchiveEntry(entry);
                if (archiveFolder != null) {
                    DeleteUtils.delete((File)archiveFolder);
                }
            }
            catch (IOException e) {
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot Delete Entry", (Exception)e);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        logger.debug((Object)"Deleting Archive Entry");
    }

    public Object clone() {
        return null;
    }

    public Property getParentProperty() {
        return null;
    }

    public static File getFolderForArchiveEntry(Entry entry) {
        File archiveFolder = null;
        logger.debug((Object)"Start : Retrieving Archive Folder for Entry.");
        if (entry != null && entry.getProperty().getType().equals(TYPE)) {
            try {
                ArchiveProperty archiveProperty = (ArchiveProperty)entry.getProperty();
                String archiveFolderName = archiveProperty.getArchiveFile().getName();
                Entry projectEntry = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project");
                String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
                String folderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + projectEntry.getDisplayName() + File.separator + "Archive" + File.separator + archiveFolderName;
                archiveFolder = new File(folderLocation);
            }
            catch (Exception e) {
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot retrieve archive folder", (Exception)e);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        logger.debug((Object)"End : Retrieving Archive Folder for Entry.");
        return archiveFolder;
    }

    public boolean isRenamable() {
        return false;
    }

    public int getViewerRank() {
        return this.viewerRank;
    }

    public void setViewerRank(int viewerRank) {
        this.viewerRank = viewerRank;
    }

    public void makeACopy(Entry currentEntry, Entry destinationEntry) throws IOException {
        try {
            File currentArchiveFolder = ArchiveProperty.getFolderForArchiveEntry(currentEntry);
            if (!currentArchiveFolder.exists()) {
                throw new FileNotFoundException("Could not find archive file for selected archive \"" + currentEntry.getDisplayName() + "\" in project \"" + DataModelSearch.findParentByType((Entry)currentEntry, (String)"org.grits.toolbox.property.project").getDisplayName() + "\"");
            }
            File destinationArchive = NewArchive.getArchiveDirectory(DataModelSearch.findParentByType((Entry)destinationEntry.getParent(), (String)"org.grits.toolbox.property.project"));
            String newArchiveFolderName = NewArchive.generateFolderName(destinationArchive.list());
            File newArchiveFolder = new File(destinationArchive, newArchiveFolderName);
            UtilityZip.copyDirectory(currentArchiveFolder, newArchiveFolder);
            ArrayList<PropertyDataFile> dataFiles = new ArrayList<PropertyDataFile>();
            PropertyDataFile currentArchiveDataFile = this.getArchiveFile();
            dataFiles.add(new PropertyDataFile(newArchiveFolderName, currentArchiveDataFile.getVersion(), currentArchiveDataFile.getType()));
            ArchiveProperty archiveProperty = new ArchiveProperty();
            archiveProperty.setDataFiles(dataFiles);
            archiveProperty.setRemoved(!this.exists());
            archiveProperty.setVersion(this.getVersion());
            archiveProperty.setViewerRank(this.getViewerRank());
            destinationEntry.setProperty((Property)archiveProperty);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new IOException("Error copying archive information.\n" + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new IOException("Error copying archive information.\n" + ex.getMessage(), ex);
        }
    }
}

