/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions;

import java.io.File;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.archive.config.ImageRegistry;
import org.grits.toolbox.entry.archive.editor.ArchiveEntryEditor;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.FileArchivePage;
import org.grits.toolbox.entry.archive.model.ArchivedFile;
import org.grits.toolbox.entry.archive.utility.UniqueNameValidator;
import org.grits.toolbox.entry.archive.utility.UtilityFileName;
import org.grits.toolbox.entry.archive.utility.UtilityZip;

public class UpdateArchivedFile
extends Action {
    private static Logger logger = Logger.getLogger(UpdateArchivedFile.class);
    private FileArchivePage page = null;

    public UpdateArchivedFile(FileArchivePage fileArchivePage) {
        this.page = fileArchivePage;
        this.setText("Update");
        this.setToolTipText("Update the File");
        this.setImageDescriptor(ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.archive", ImageRegistry.ArchiveImage.UPDATE_ICON));
    }

    public void run() {
        block10: {
            logger.debug((Object)"Start - Updating  Archive File");
            TreeViewer treeViewer = this.page.getLeftSideTreeViewer();
            if (!treeViewer.getSelection().isEmpty()) {
                ArchivedFile selectedArchivedFile = (ArchivedFile)((TreeSelection)treeViewer.getSelection()).getFirstElement();
                List inputArchivedFiles = (List)treeViewer.getInput();
                ArchiveEntryEditor archiveEntryEditor = this.page.getEditor();
                File archiveFolder = archiveEntryEditor.getArchiveFolder();
                try {
                    String previousName = selectedArchivedFile.getTypicalArchivedFile().getFileName();
                    HashSet<String> existingNames = UtilityFileName.getExistingNames(inputArchivedFiles, archiveFolder);
                    existingNames.remove(previousName);
                    FileDialog updateDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                    String location = null;
                    location = updateDialog.open();
                    if (location == null) break block10;
                    File sourceFile = Paths.get(location, new String[0]).toFile();
                    if (sourceFile.exists()) {
                        String newName = sourceFile.getName();
                        boolean uniqueName = !existingNames.contains(newName);
                        boolean quitUpdate = false;
                        while (!uniqueName && !quitUpdate) {
                            InputDialog renameDialog = new InputDialog(Display.getCurrent().getActiveShell(), "RenameArchivedFile", "Please give a unique name to this archive", newName, (IInputValidator)new UniqueNameValidator(existingNames));
                            if (renameDialog.open() == 0) {
                                newName = renameDialog.getValue();
                            } else {
                                quitUpdate = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Name not Unique", (String)"Do you want to quit updating the archive file?");
                            }
                            boolean bl = uniqueName = !existingNames.contains(newName);
                        }
                        if (uniqueName) {
                            File oldFile = new File(archiveFolder, previousName);
                            File newFile = new File(archiveFolder, newName);
                            UtilityZip.copyFile(sourceFile, newFile);
                            Date modifiedDate = archiveEntryEditor.renameArchive(previousName, newName);
                            selectedArchivedFile.setModifiedDate(modifiedDate);
                            selectedArchivedFile.getTypicalArchivedFile().setFileName(newName);
                            treeViewer.refresh();
                            treeViewer.setSelection(treeViewer.getSelection());
                            if (!newName.equals(previousName)) {
                                oldFile.delete();
                            }
                            logger.info((Object)("Updated successfully : " + selectedArchivedFile.getTypicalArchivedFile().getFileName()));
                        }
                        break block10;
                    }
                    logger.debug((Object)("Updated unsuccessful : " + selectedArchivedFile.getTypicalArchivedFile().getFileName()));
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"UpdateArchivedFile Unsuccessful", (String)"The source file is not valid.");
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"UpdateArchivedFile Unsuccessful", (String)"The archive file could not be updated.");
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"No File Selected", (String)"Please select a file to update.");
            }
        }
    }
}

