/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages.archivedemail.actions;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.archive.config.ImageRegistry;
import org.grits.toolbox.entry.archive.dialog.email.AddEmailDialog;
import org.grits.toolbox.entry.archive.editor.ArchiveEntryEditor;
import org.grits.toolbox.entry.archive.editor.pages.archivedemail.EmailArchivePage;
import org.grits.toolbox.entry.archive.model.ArchivedBasicEmail;

public class AddArchivedEmail
extends Action {
    private static Logger logger = Logger.getLogger(AddArchivedEmail.class);
    private EmailArchivePage page = null;

    public AddArchivedEmail(EmailArchivePage emailArchivePage) {
        this.page = emailArchivePage;
        this.setText("Add an email");
        this.setToolTipText("Add a new email");
        this.setImageDescriptor(ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.archive", ImageRegistry.ArchiveImage.ADD_EMAIL_ICON));
    }

    public void run() {
        block5: {
            logger.debug((Object)"Start - Uploading  Archive Email");
            ArchiveEntryEditor archiveEntryEditor = this.page.getEditor();
            TreeViewer treeViewer = this.page.getLeftSideTreeViewer();
            List inputArchivedEmails = (List)treeViewer.getInput();
            try {
                AddEmailDialog addEmailDialog = new AddEmailDialog(Display.getCurrent().getActiveShell(), null);
                if (addEmailDialog.open() != 0) break block5;
                ArchivedBasicEmail newArchivedEmail = addEmailDialog.getArchivedEmail();
                if (newArchivedEmail != null) {
                    try {
                        inputArchivedEmails.add(newArchivedEmail);
                        archiveEntryEditor.markDirty();
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error uploading email to archive.\n" + ex.getMessage()), (Throwable)ex);
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Upload Error", (String)"The email could not be uploaded to GRITS. Please report this error to the development team");
                    }
                }
                treeViewer.refresh();
                treeViewer.setSelection((ISelection)new StructuredSelection((Object)newArchivedEmail));
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Upload Error", (String)"The email could not be uploaded to GRITS. Please report this error to the development team");
            }
        }
        logger.debug((Object)"End - Uploading  Archive Email");
    }
}

