/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.dialog.uploadfile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.FileArchivePage;
import org.grits.toolbox.entry.archive.model.ArchivedFile;
import org.grits.toolbox.entry.archive.utility.UtilityZip;

public class DownloadAsZipDialog
extends TitleAreaDialog {
    private static Logger logger = Logger.getLogger(DownloadAsZipDialog.class);
    private static final long MAX_DOWNLOAD_FILE_SIZE = 0x80000000L;
    private FileArchivePage fileArchivePage = null;
    protected Set<String> existingNames = null;
    private Text locationText = null;
    private Button overwrite = null;
    private CheckboxTableViewer checkboxTableViewer = null;

    public DownloadAsZipDialog(FileArchivePage fileArchivePage) {
        super(Display.getCurrent().getActiveShell());
        this.fileArchivePage = fileArchivePage;
    }

    public void create() {
        super.create();
        this.setTitle("Download File");
        this.setMessage("Download File From the Archive");
        this.getShell().setText("Download");
        this.getButton(0).setText("Download");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 2048);
        container.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout layout = new GridLayout(4, false);
        layout.marginTop = 10;
        layout.marginBottom = 40;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        container.setLayout((Layout)layout);
        this.locationText = new Text(container, 2049);
        GridData textData = new GridData(4, 1, true, false);
        textData.horizontalSpan = 3;
        textData.minimumWidth = 450;
        this.locationText.setLayoutData((Object)textData);
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText(" Browse Location ");
        GridData browseButtonGridData = new GridData(128);
        browseButtonGridData.horizontalSpan = 1;
        browseFileButton.setLayoutData((Object)browseButtonGridData);
        Label label = new Label(container, 8);
        GridData labelData = new GridData(16384);
        labelData.horizontalSpan = 3;
        label.setLayoutData((Object)labelData);
        this.overwrite = new Button(container, 32);
        this.overwrite.setText("Overwrite Existing");
        this.overwrite.setSelection(false);
        this.overwrite.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DownloadAsZipDialog.this.verifyInput();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DownloadAsZipDialog.this.verifyInput();
            }
        });
        Label selectFilesLabel = new Label(container, 0);
        selectFilesLabel.setText("Select Files");
        GridData fileLabelData = new GridData(16384);
        fileLabelData.horizontalSpan = 4;
        selectFilesLabel.setLayoutData((Object)fileLabelData);
        Table table = new Table(container, 68356);
        this.checkboxTableViewer = new CheckboxTableViewer(table, "Select", false);
        TableViewerColumn tableColumn2 = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 4, 1);
        tableColumn2.getColumn().setText("Files");
        tableColumn2.getColumn().setWidth(400);
        GridData tableData = new GridData();
        tableData.horizontalSpan = 4;
        tableData.horizontalAlignment = 4;
        tableData.heightHint = 200;
        this.checkboxTableViewer.getTable().setLayoutData((Object)tableData);
        this.checkboxTableViewer.getTable().setHeaderVisible(true);
        this.checkboxTableViewer.getTable().setLinesVisible(true);
        this.checkboxTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof ArchivedFile && columnIndex == 1) {
                    return ((ArchivedFile)element).getTypicalArchivedFile().getFileName();
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.checkboxTableViewer.setInput((Object)((List)this.fileArchivePage.getLeftSideTreeViewer().getInput()));
        this.checkboxTableViewer.refresh();
        browseFileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DownloadAsZipDialog.this.setErrorMessage(null);
                String selected = null;
                FileDialog fileDialog = new FileDialog(DownloadAsZipDialog.this.getShell(), 8192);
                fileDialog.setOverwrite(true);
                fileDialog.setText("Save Location");
                fileDialog.setFilterExtensions(new String[]{".zip"});
                fileDialog.setFileName("");
                selected = fileDialog.open();
                try {
                    if (selected != null) {
                        DownloadAsZipDialog.this.locationText.setText(selected);
                    }
                }
                catch (InvalidPathException invalidPathException) {
                    DownloadAsZipDialog.this.setErrorMessage("Select a valid location");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.locationText.setText("");
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    File sourceFile = Paths.get(DownloadAsZipDialog.this.locationText.getText().trim(), new String[0]).toFile();
                    if (sourceFile != null && sourceFile.getParentFile() != null) {
                        DownloadAsZipDialog.this.existingNames = new HashSet<String>(Arrays.asList(sourceFile.getParentFile().list()));
                        DownloadAsZipDialog.this.verifyInput();
                    } else {
                        DownloadAsZipDialog.this.setErrorMessage("Please select a valid location to download.");
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    DownloadAsZipDialog.this.setErrorMessage("Please select a valid location to download.");
                }
            }
        });
        browseFileButton.setFocus();
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected void verifyInput() {
        this.setErrorMessage(null);
        String location = this.locationText.getText().trim();
        if (location.isEmpty()) {
            this.setErrorMessage("Please select a valid location to download.");
        } else {
            try {
                File file = new File(location);
                if (!file.isDirectory() && file.getParentFile() != null) {
                    String downloadFileName;
                    File parentDirectory = file.getParentFile();
                    if (parentDirectory == null || !parentDirectory.exists()) {
                        this.setErrorMessage("The selected directory does not exist. Please select a valid directory to download.");
                    }
                    if ((downloadFileName = file.getName()) == null || downloadFileName.isEmpty()) {
                        this.setErrorMessage("The file name cannot be empty. Please choose a valid name for the download file.");
                    } else if (this.existingNames.contains(downloadFileName) && !this.overwrite.getSelection()) {
                        this.setErrorMessage("The file name already exists. You need to check overwrite to overwrite the existing file in the selected folder.");
                    }
                } else {
                    this.setErrorMessage("Please select a valid location to download.");
                }
            }
            catch (InvalidPathException invalidPathException) {
                this.setErrorMessage("Select a valid location");
            }
        }
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        this.getButton(0).setEnabled(newErrorMessage == null);
    }

    protected void okPressed() {
        if (!this.locationText.getText().isEmpty()) {
            try {
                if (!this.locationText.getText().endsWith(".zip")) {
                    this.locationText.setText(String.valueOf(this.locationText.getText()) + ".zip");
                }
                Paths.get(this.locationText.getText(), new String[0]).toFile();
                ArchivedFile archivedFile = null;
                File downloadFile = null;
                try {
                    FileOutputStream fos = new FileOutputStream(new File(this.locationText.getText()));
                    ZipOutputStream zipOutputStream = new ZipOutputStream(fos);
                    String notDownloadedMessage = "";
                    Object[] objectArray = this.checkboxTableViewer.getCheckedElements();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object checkedElement = objectArray[n2];
                        if (checkedElement instanceof ArchivedFile) {
                            try {
                                archivedFile = (ArchivedFile)checkedElement;
                                downloadFile = new File(this.fileArchivePage.getEditor().getArchiveFolder(), archivedFile.getTypicalArchivedFile().getFileName());
                                if (downloadFile.isDirectory()) {
                                    UtilityZip.addDirectory(downloadFile, downloadFile.getName(), zipOutputStream, null);
                                } else if (downloadFile.isFile()) {
                                    if (downloadFile.length() < 0x80000000L) {
                                        UtilityZip.addFile(downloadFile, downloadFile.getName(), zipOutputStream, null);
                                    } else {
                                        notDownloadedMessage = String.valueOf(notDownloadedMessage) + (notDownloadedMessage.length() > 200 ? "" : String.valueOf(downloadFile.getName()) + "'s size (" + (float)downloadFile.length() / 1.0737418E9f + "GB) is greater than " + 0x80000000L + " GB.\n");
                                    }
                                } else {
                                    logger.debug((Object)(String.valueOf(downloadFile.getName()) + " file type not known and could not be zipped."));
                                }
                            }
                            catch (Exception exception) {
                                logger.error((Object)("Error downloading " + downloadFile.getName()));
                            }
                        }
                        ++n2;
                    }
                    zipOutputStream.close();
                    fos.close();
                    if (!notDownloadedMessage.isEmpty()) {
                        if (notDownloadedMessage.length() > 200) {
                            notDownloadedMessage = String.valueOf(notDownloadedMessage) + ".....";
                        }
                        MessageDialog.openWarning((Shell)this.getShell(), (String)"Download Problems", (String)("These folders could not be downloaded. Try downloading them separately :\n\n" + notDownloadedMessage));
                    }
                    super.okPressed();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (InvalidPathException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                this.setErrorMessage("Select a valid location");
            }
        } else {
            this.setErrorMessage("Select a valid location");
        }
    }
}

