/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.dialog.newentry;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.DataModelHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.utilShare.sort.EntryComparator;
import org.grits.toolbox.entry.archive.config.IConfig;
import org.grits.toolbox.entry.archive.dialog.newentry.EntryContentProvider;
import org.grits.toolbox.entry.archive.dialog.newentry.EntryLabelProvider;

public class NewArchiveDialog
extends Dialog {
    private Entry parentEntry = null;
    private TreeViewer treeViewer = null;

    public NewArchiveDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
        if (this.treeViewer != null && this.parentEntry != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.parentEntry));
        }
    }

    public Control createDialogArea(Composite parent) {
        this.getShell().setText("Select Entry");
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer(parent, 2820);
        this.treeViewer.setContentProvider((IContentProvider)new EntryContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new EntryLabelProvider());
        this.treeViewer.setComparator((ViewerComparator)new EntryComparator());
        GridData treeData = new GridData();
        treeData.minimumHeight = 200;
        treeData.heightHint = 400;
        treeData.widthHint = 400;
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        treeData.horizontalAlignment = 4;
        this.treeViewer.getTree().setLayoutData((Object)treeData);
        this.treeViewer.setInput((Object)DataModelHandler.instance().getRoot());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection treeSelection;
                NewArchiveDialog.this.getButton(0).setEnabled(false);
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && (treeSelection = (TreeSelection)selection).size() == 1) {
                    boolean canHaveArchive;
                    Entry entry = (Entry)treeSelection.getFirstElement();
                    boolean bl = canHaveArchive = entry.getProperty() instanceof ProjectProperty ? ((ProjectProperty)entry.getProperty()).isOpen() : IConfig.ARCHIVABLE_PLUGINS.contains(entry.getProperty().getType());
                    if (canHaveArchive) {
                        for (Entry child : entry.getChildren()) {
                            if (!child.getProperty().getType().equals("org.grits.toolbox.property.archive")) continue;
                            canHaveArchive = false;
                            break;
                        }
                        if (canHaveArchive) {
                            NewArchiveDialog.this.getButton(0).setEnabled(true);
                            NewArchiveDialog.this.parentEntry = entry;
                        }
                    }
                }
            }
        });
        this.treeViewer.getTree().setFocus();
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public void cancelPressed() {
        super.cancelPressed();
    }

    public Entry getParentEntry() {
        return this.parentEntry;
    }

    public void setParentEntry(Entry parentEntry) {
        this.parentEntry = parentEntry;
    }
}

