/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.array;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.WURCSFramework.util.WURCSDataConverter;
import org.glycoinfo.WURCSFramework.util.WURCSNumberUtils;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIP;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.LIN;
import org.glycoinfo.WURCSFramework.wurcs.array.LIP;
import org.glycoinfo.WURCSFramework.wurcs.array.LIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.MOD;
import org.glycoinfo.WURCSFramework.wurcs.array.MS;
import org.glycoinfo.WURCSFramework.wurcs.array.RES;
import org.glycoinfo.WURCSFramework.wurcs.array.UniqueRES;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;

public class WURCSImporter {
    public WURCSArray extractWURCSArray(String a_strWURCS) throws WURCSFormatException {
        return this.extractWURCSArray(a_strWURCS, true);
    }

    public WURCSArray extractWURCSArray(String a_strWURCS, boolean a_bCheckStrict) throws WURCSFormatException {
        String t_strVersion = "";
        int t_numUniqueRES = 0;
        int t_numRES = 0;
        int t_numLIN = 0;
        boolean t_bIsComposition = false;
        String t_strUniqueRESs = "";
        String t_strRESSequence = "";
        String t_strLINs = "";
        String strExp = "WURCS=(.+)/(\\d+),(\\d+),(\\d+)(\\+)?/\\[(.+)\\]/([\\d\\-<>]+)/(.*)";
        Matcher t_oMatcher = Pattern.compile(strExp).matcher(a_strWURCS);
        int t_iVersion = 1;
        int t_iNumuRES = 2;
        int t_iNumRES = 3;
        int t_iNumLIN = 4;
        int t_iComposition = 5;
        int t_iUniqueRESs = 6;
        int t_iResSequenses = 7;
        int t_iLINs = 8;
        if (!t_oMatcher.find()) {
            throw new WURCSFormatException("Not match as WURCS in class WURCSImporter(extractWURCSArray).", a_strWURCS);
        }
        t_strVersion = t_oMatcher.group(t_iVersion);
        t_numUniqueRES = Integer.parseInt(t_oMatcher.group(t_iNumuRES));
        t_numRES = Integer.parseInt(t_oMatcher.group(t_iNumRES));
        t_numLIN = Integer.parseInt(t_oMatcher.group(t_iNumLIN));
        t_bIsComposition = t_oMatcher.group(t_iComposition) != null;
        t_strUniqueRESs = t_oMatcher.group(t_iUniqueRESs);
        t_strRESSequence = t_oMatcher.group(t_iResSequenses);
        t_strLINs = t_oMatcher.group(t_iLINs);
        WURCSArray t_objWURCSContainer = new WURCSArray(t_strVersion, t_numUniqueRES, t_numRES, t_numLIN, t_bIsComposition);
        String[] t_aURESs = t_strUniqueRESs.split("\\]\\[");
        HashSet<String> t_aURESsCheck = new HashSet<String>();
        int count = 0;
        for (String t_strURES : t_aURESs) {
            if (t_strURES.length() == 0) continue;
            ++count;
            if (a_bCheckStrict && t_aURESsCheck.contains(t_strURES)) {
                throw new WURCSFormatException("Duplicated UniqueRES is found in class WURCSImporter(extractWURCSArray).", t_strURES);
            }
            t_aURESsCheck.add(t_strURES);
            UniqueRES t_oURES = this.extractUniqueRES(t_strURES, count);
            t_objWURCSContainer.addUniqueRES(t_oURES);
        }
        if (a_bCheckStrict && t_numUniqueRES != count) {
            throw new WURCSFormatException("Number of UniqueRES is not correct  in class WURCSImporter(extractWURCSArray).", t_numUniqueRES + " vs " + count);
        }
        TreeSet<Integer> t_aUsedURESID = new TreeSet<Integer>();
        count = 1;
        int t_iRep = 0;
        LinkedList<Integer> t_aRepIDs = new LinkedList<Integer>();
        for (int i = 0; i < t_strRESSequence.length(); ++i) {
            char t_cSeq = t_strRESSequence.charAt(i);
            if (t_cSeq == '-') {
                ++count;
            }
            if (t_cSeq == '<') {
                t_aRepIDs.addLast(++t_iRep);
            }
            if (t_cSeq == '>') {
                t_aRepIDs.removeLast();
            }
            if (!Character.isDigit(t_cSeq)) continue;
            String t_strRES = "";
            char t_cSeqNext = t_cSeq;
            while (Character.isDigit(t_cSeqNext)) {
                t_strRES = t_strRES + t_cSeqNext;
                if (++i > t_strRESSequence.length() - 1) break;
                t_cSeqNext = t_strRESSequence.charAt(i);
            }
            --i;
            int t_iRESID = Integer.parseInt(t_strRES);
            t_aUsedURESID.add(t_iRESID);
            if (t_iRESID > t_numUniqueRES) {
                throw new WURCSFormatException("Exceeded UniqueRES ID is found in RES sequence  in class WURCSImporter(extractWURCSArray).", t_iRESID + " in " + t_strRESSequence);
            }
            RES t_objRES = new RES(t_iRESID, WURCSDataConverter.convertRESIDToIndex(count));
            if (!t_aRepIDs.isEmpty()) {
                t_objRES.setRepeatIDs(t_aRepIDs);
            }
            t_objWURCSContainer.addRES(t_objRES);
        }
        if (t_aUsedURESID.size() < t_numUniqueRES) {
            throw new WURCSFormatException("Some UniqueRES is not used in RES sequence  in class WURCSImporter(extractWURCSArray).", t_aUsedURESID.toString());
        }
        if (a_bCheckStrict && t_numRES != count) {
            throw new WURCSFormatException("Number of RES is not correct  in class WURCSImporter(extractWURCSArray).", t_numRES + " vs " + count);
        }
        if (t_strLINs == null || t_strLINs.equals("")) {
            return t_objWURCSContainer;
        }
        String[] t_aLINs = t_strLINs.split("_");
        count = 0;
        for (String t_strLIN : t_aLINs) {
            ++count;
            t_objWURCSContainer.addLIN(this.extractLIN(t_strLIN));
        }
        if (a_bCheckStrict && t_numLIN != count) {
            throw new WURCSFormatException("Number of LIN is not correct  in class WURCSImporter(extractWURCSArray) .", t_numLIN + " vs " + count);
        }
        return t_objWURCSContainer;
    }

    public UniqueRES extractUniqueRES(String a_strURES, int a_iURESID) throws WURCSFormatException {
        return new UniqueRES(a_iURESID, this.extractMS(a_strURES));
    }

    public MS extractMS(String a_strMS) throws WURCSFormatException {
        String[] t_aSplitMS = a_strMS.split("_");
        String[] t_aSplitSC = t_aSplitMS[0].split("-");
        String t_strSkeletonCode = t_aSplitSC[0];
        int t_iAnomericPosition = 0;
        char t_cAnomericSymbol = 'o';
        if (t_aSplitSC.length > 1) {
            String strExp = "(\\?|[0-9]+)([abudxo])";
            Matcher matchAnomerInfo = Pattern.compile(strExp).matcher(t_aSplitSC[1]);
            if (!matchAnomerInfo.find()) {
                throw new WURCSFormatException("Error in extract anomeric information in class WURCSImporter(extractUniqueRES).", a_strMS);
            }
            t_iAnomericPosition = matchAnomerInfo.group(1).equals("?") ? -1 : Integer.parseInt(matchAnomerInfo.group(1));
            t_cAnomericSymbol = matchAnomerInfo.group(2).toCharArray()[0];
        }
        MS t_oMS = new MS(t_strSkeletonCode, t_iAnomericPosition, t_cAnomericSymbol);
        for (int i = 1; i < t_aSplitMS.length; ++i) {
            String t_strMOD = t_aSplitMS[i];
            MOD t_oMOD = this.extractMOD(t_strMOD);
            t_oMS.addMOD(t_oMOD);
        }
        return t_oMS;
    }

    public MOD extractMOD(String a_strMOD) throws WURCSFormatException {
        String t_strMAP = "";
        String t_strLIPs = a_strMOD;
        if (a_strMOD.contains("*")) {
            t_strMAP = a_strMOD.substring(a_strMOD.indexOf("*"));
            t_strLIPs = a_strMOD.substring(0, a_strMOD.indexOf("*"));
        }
        MOD t_oMOD = new MOD(t_strMAP);
        for (String t_strLIP : t_strLIPs.split("-")) {
            t_oMOD.addLIPs(this.extractLIPs(t_strLIP));
        }
        return t_oMOD;
    }

    public LIPs extractLIPs(String a_strLIPs) throws WURCSFormatException {
        LinkedList<LIP> t_aLIPs = new LinkedList<LIP>();
        for (String t_strLIP : a_strLIPs.split("\\|")) {
            t_aLIPs.addLast(this.extractLIP(t_strLIP));
        }
        return new LIPs(t_aLIPs);
    }

    public LIP extractLIP(String a_strLIP) throws WURCSFormatException {
        double[] t_aProbs;
        String SCPosition = "(\\?|[0-9]+)";
        String direction = "([nudtezx])?";
        String MAPPosition = "(\\?|[0-9]+)?";
        String prob = "(%(.+)%)?";
        String strExp = "^" + prob + SCPosition + direction + MAPPosition + prob + "$";
        Matcher size = Pattern.compile(strExp).matcher(a_strLIP);
        if (!size.find()) {
            throw new WURCSFormatException("Not match as LIP in class WURCSImporter(extractLIP).", a_strLIP);
        }
        String t_strSCPos = size.group(3);
        String t_strDirection = size.group(4);
        String t_strMAPPos = size.group(5);
        int t_iSCPos = 0;
        char t_cDirection = ' ';
        int t_iMAPPos = 0;
        if (t_strSCPos.equals("?")) {
            t_strSCPos = "-1";
        }
        if (!WURCSNumberUtils.isInteger(t_strSCPos)) {
            throw new WURCSFormatException("SkeletonCode position must be number in LIP  in class WURCSImporter(extractLIP).", a_strLIP);
        }
        t_iSCPos = Integer.parseInt(t_strSCPos);
        if (t_strDirection != null) {
            t_cDirection = t_strDirection.charAt(0);
        }
        if (t_strMAPPos != null) {
            if (t_strMAPPos.equals("?")) {
                t_strMAPPos = "-1";
            }
            if (!WURCSNumberUtils.isInteger(t_strMAPPos)) {
                throw new WURCSFormatException("MAP position must be number in LIP  in class WURCSImporter(extractLIP).", a_strLIP);
            }
            t_iMAPPos = Integer.parseInt(t_strMAPPos);
        }
        LIP t_oLIP = new LIP(t_iSCPos, t_cDirection, t_iMAPPos);
        String t_strBackboneProb = size.group(2);
        String t_strModificationProb = size.group(7);
        if (t_strBackboneProb != null) {
            t_aProbs = this.extractProbabilities(t_strBackboneProb);
            t_oLIP.setBackboneProbabilityLower(t_aProbs[0]);
            t_oLIP.setBackboneProbabilityUpper(t_aProbs[1]);
        }
        if (t_strModificationProb != null) {
            t_aProbs = this.extractProbabilities(t_strModificationProb);
            t_oLIP.setModificationProbabilityLower(t_aProbs[0]);
            t_oLIP.setModificationProbabilityUpper(t_aProbs[1]);
        }
        return t_oLIP;
    }

    public LIN extractLIN(String a_strLIN) throws WURCSFormatException {
        String[] t_aGLIPs;
        String t_strLIN = a_strLIN;
        String t_strRep = "";
        if (a_strLIN.contains("~")) {
            t_strRep = a_strLIN.split("~")[1];
            t_strLIN = a_strLIN.split("~")[0];
        }
        String t_strMAP = "";
        if (t_strLIN.contains("*")) {
            t_strMAP = t_strLIN.substring(t_strLIN.indexOf(42));
            t_strLIN = t_strLIN.substring(0, t_strLIN.indexOf(42));
        }
        LIN t_objLIN = new LIN(t_strMAP);
        for (String t_strGLIP : t_aGLIPs = t_strLIN.split("\\-")) {
            t_objLIN.addGLIPs(this.extractGLIPs(t_strGLIP));
        }
        if (t_strRep.equals("")) {
            return t_objLIN;
        }
        int[] t_aRep = this.extractRepeat(t_strRep);
        t_objLIN.setMinRepeatCount(t_aRep[0]);
        t_objLIN.setMaxRepeatCount(t_aRep[1]);
        t_objLIN.setRepeatingUnit(true);
        return t_objLIN;
    }

    public GLIPs extractGLIPs(String a_strGLIPs) throws WURCSFormatException {
        String[] GLIPList;
        String strAlternative = "";
        if (a_strGLIPs.contains("}")) {
            strAlternative = "}";
            a_strGLIPs = a_strGLIPs.replace("}", "");
        } else if (a_strGLIPs.contains("{")) {
            strAlternative = "{";
            a_strGLIPs = a_strGLIPs.replace("{", "");
        }
        LinkedList<GLIP> t_aGLIP = new LinkedList<GLIP>();
        for (String GLIP2 : GLIPList = a_strGLIPs.split("\\|")) {
            t_aGLIP.addLast(this.extractGLIP(GLIP2));
        }
        GLIPs t_oGLIPs = new GLIPs(t_aGLIP);
        if (!strAlternative.equals("")) {
            t_oGLIPs.setAlternative(strAlternative);
        }
        return t_oGLIPs;
    }

    public GLIP extractGLIP(String a_strGLIP) throws WURCSFormatException {
        double[] t_aProbs;
        String nodeIndex = "(\\?|[a-zA-Z]+)";
        String SCPosition = "(\\?|[0-9]+)";
        String direction = "([nudtezx])?";
        String MAPPosition = "(\\?|[0-9]+)?";
        String prob = "(%(.+)%)?";
        String strExp = "^" + prob + nodeIndex + SCPosition + direction + MAPPosition + prob + "$";
        Matcher size = Pattern.compile(strExp).matcher(a_strGLIP);
        if (!size.find()) {
            throw new WURCSFormatException("Not match as GLIP in class WURCSImporter(extractGLIP).", a_strGLIP);
        }
        String t_strRESIndex = size.group(3);
        String t_strSCPos = size.group(4);
        String t_strDirection = size.group(5);
        String t_strMAPPos = size.group(6);
        int t_iSC_Position = 0;
        char t_cDirection = ' ';
        int t_iModStarPositionOnMAP = 0;
        String string = t_strSCPos = t_strSCPos.equals("?") ? "-1" : t_strSCPos;
        if (!WURCSNumberUtils.isInteger(t_strSCPos)) {
            throw new WURCSFormatException("SkeletonCode position must be number in GLIP in class WURCSImporter(extractGLIP).", a_strGLIP);
        }
        t_iSC_Position = Integer.parseInt(t_strSCPos);
        if (t_strDirection != null && t_strDirection.length() > 0) {
            t_cDirection = t_strDirection.charAt(0);
        }
        if (t_strMAPPos != null) {
            String string2 = t_strMAPPos = t_strMAPPos.equals("?") ? "-1" : t_strMAPPos;
            if (!WURCSNumberUtils.isInteger(t_strMAPPos)) {
                throw new WURCSFormatException("MAP position must be number in GLIP in class WURCSImporter(extractGLIP).", a_strGLIP);
            }
            t_iModStarPositionOnMAP = Integer.parseInt(t_strMAPPos);
        }
        GLIP t_oGLIP = new GLIP(t_strRESIndex, t_iSC_Position, t_cDirection, t_iModStarPositionOnMAP);
        String t_strBackboneProb = size.group(2);
        String t_strModificationProb = size.group(8);
        if (t_strBackboneProb != null) {
            t_aProbs = this.extractProbabilities(t_strBackboneProb);
            t_oGLIP.setBackboneProbabilityLower(t_aProbs[0]);
            t_oGLIP.setBackboneProbabilityUpper(t_aProbs[1]);
        }
        if (t_strModificationProb != null) {
            t_aProbs = this.extractProbabilities(t_strModificationProb);
            t_oGLIP.setModificationProbabilityLower(t_aProbs[0]);
            t_oGLIP.setModificationProbabilityUpper(t_aProbs[1]);
        }
        return t_oGLIP;
    }

    private double[] extractProbabilities(String a_strProb) throws WURCSFormatException {
        double[] t_adProbs = new double[]{1.0, 1.0};
        String[] t_asProbs = a_strProb.split("-");
        if (t_asProbs[0].matches("[^\\?\\.0-9]")) {
            throw new WURCSFormatException("Not match as probability in LIP/GLIP in class WURCSImporter(extractProbabilities).", a_strProb);
        }
        if (t_asProbs[0].equals("?")) {
            t_asProbs[0] = "-1";
        }
        if (!WURCSNumberUtils.isDouble(t_asProbs[0])) {
            throw new WURCSFormatException("probability must be double type number in class WURCSImporter(extractProbabilities).", a_strProb);
        }
        t_adProbs[0] = Double.parseDouble(t_asProbs[0]);
        t_adProbs[1] = t_adProbs[0];
        if (t_asProbs.length > 1) {
            if (t_asProbs[1].matches("[^\\?\\.0-9]")) {
                throw new WURCSFormatException("Not match as probability in LIP/GLIP in class WURCSImporter(extractProbabilities).", a_strProb);
            }
            if (t_asProbs[1].equals("?")) {
                t_asProbs[1] = "-1";
            }
            if (!WURCSNumberUtils.isDouble(t_asProbs[1])) {
                throw new WURCSFormatException("probability must be double type number in class WURCSImporter(extractProbabilities).", a_strProb);
            }
            t_adProbs[1] = Double.parseDouble(t_asProbs[1]);
        }
        return t_adProbs;
    }

    private int[] extractRepeat(String a_strRepeat) throws WURCSFormatException {
        int[] t_aiReps = new int[]{1, 1};
        String[] t_asRep = a_strRepeat.split("-");
        if (t_asRep[0].equals("n")) {
            t_asRep[0] = "-1";
        }
        if (!WURCSNumberUtils.isInteger(t_asRep[0])) {
            throw new WURCSFormatException("in class WURCSImporter(extractProbabilities). Repeat unit is must be a number or \"n\".", "~" + a_strRepeat);
        }
        t_aiReps[0] = Integer.parseInt(t_asRep[0]);
        t_aiReps[1] = t_aiReps[0];
        if (t_asRep.length == 1) {
            return t_aiReps;
        }
        if (t_asRep[1].equals("n")) {
            t_asRep[1] = "-1";
        }
        if (!WURCSNumberUtils.isInteger(t_asRep[1])) {
            throw new WURCSFormatException("in class WURCSImporter(extractProbabilities). Repeat unit is must be number or \"n\".", "~" + a_strRepeat);
        }
        t_aiReps[1] = Integer.parseInt(t_asRep[1]);
        int temp_iMin = -1;
        if (t_aiReps[0] > t_aiReps[1] && t_aiReps[1] != -1) {
            temp_iMin = t_aiReps[1];
            t_aiReps[1] = t_aiReps[0];
            t_aiReps[0] = temp_iMin;
        }
        return t_aiReps;
    }
}

