/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.applications.ms.glycopeakfinder.calculation.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import jxl.CellView;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.PageOrientation;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationDerivatisation;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationFragment;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationIon;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationMolecule;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationParameter;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationPeak;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.PeakAnnotation;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.Persubstitution;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.SpectraType;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.util.AnnotationToString;

public class XLSExporter {
    private CalculationParameter m_objParameter = null;

    public void export(CalculationParameter calculationParameter, ByteArrayOutputStream byteArrayOutputStream) throws IOException, WriteException {
        this.m_objParameter = calculationParameter;
        WritableWorkbook writableWorkbook = Workbook.createWorkbook((OutputStream)byteArrayOutputStream);
        WritableSheet writableSheet = writableWorkbook.createSheet("Settings", 0);
        this.formatSettingsPage(writableSheet);
        this.createSettingSheet(writableSheet);
        writableSheet = writableWorkbook.createSheet("Results", 1);
        this.formatResultPage(writableSheet);
        this.createResultSheet(writableSheet);
        writableSheet.setPageSetup(PageOrientation.LANDSCAPE);
        writableWorkbook.write();
        writableWorkbook.close();
    }

    private void formatResultPage(WritableSheet writableSheet) throws RowsExceededException, WriteException {
        CellView cellView = new CellView();
        cellView.setSize(3000);
        WritableFont writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        WritableCellFormat writableCellFormat = new WritableCellFormat(writableFont);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(0, cellView);
        cellView = new CellView();
        cellView.setSize(3000);
        writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        writableCellFormat = new WritableCellFormat(writableFont);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(1, cellView);
        cellView = new CellView();
        cellView.setSize(9000);
        writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        writableCellFormat = new WritableCellFormat(writableFont);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(2, cellView);
        cellView = new CellView();
        cellView.setSize(4000);
        writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        writableCellFormat = new WritableCellFormat(writableFont);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(3, cellView);
        cellView = new CellView();
        cellView.setSize(4000);
        writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        writableCellFormat = new WritableCellFormat(writableFont);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(4, cellView);
        cellView = new CellView();
        cellView.setSize(4000);
        writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        writableCellFormat = new WritableCellFormat(writableFont);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(5, cellView);
        cellView = new CellView();
        cellView.setSize(3000);
        writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        writableCellFormat = new WritableCellFormat(writableFont);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(6, cellView);
        cellView = new CellView();
        cellView.setSize(3000);
        writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        writableCellFormat = new WritableCellFormat(writableFont);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(7, cellView);
    }

    private void formatSettingsPage(WritableSheet writableSheet) throws RowsExceededException, WriteException {
        CellView cellView = new CellView();
        cellView.setSize(10000);
        WritableFont writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat writableCellFormat = new WritableCellFormat(writableFont);
        writableCellFormat.setAlignment(Alignment.LEFT);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(0, cellView);
        cellView = new CellView();
        cellView.setSize(6000);
        writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        writableCellFormat = new WritableCellFormat(writableFont);
        writableCellFormat.setAlignment(Alignment.LEFT);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(1, cellView);
        cellView = new CellView();
        cellView.setSize(4000);
        writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        writableCellFormat = new WritableCellFormat(writableFont);
        writableCellFormat.setAlignment(Alignment.LEFT);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(2, cellView);
        cellView = new CellView();
        cellView.setSize(3000);
        writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        writableCellFormat = new WritableCellFormat(writableFont);
        writableCellFormat.setAlignment(Alignment.LEFT);
        cellView.setFormat((CellFormat)writableCellFormat);
        writableSheet.setColumnView(3, cellView);
        writableSheet.mergeCells(0, 0, 3, 0);
    }

    private void createResultSheet(WritableSheet writableSheet) throws RowsExceededException, WriteException {
        WritableCellFormat writableCellFormat;
        WritableCell writableCell;
        PeakAnnotation peakAnnotation2;
        int n;
        AnnotationToString annotationToString = new AnnotationToString();
        int n2 = 0;
        CalculationPeak calculationPeak2 = null;
        Label label = null;
        Number number = null;
        if (this.m_objParameter.getSpectraType() == SpectraType.MS2 && this.m_objParameter.getScan().getPrecusorMass() != null) {
            label = new Label(0, n2, "Precursor:");
            writableSheet.addCell((WritableCell)label);
            n = this.writeHeadline(writableSheet, ++n2);
            n2 += n + 1;
            for (CalculationPeak calculationPeak2 : this.getPrecursorPeaks()) {
                number = new Number(0, n2, calculationPeak2.getMz());
                writableSheet.addCell((WritableCell)number);
                if (calculationPeak2.getIntensity() != 0.0) {
                    number = new Number(1, n2, calculationPeak2.getMz());
                    writableSheet.addCell((WritableCell)number);
                } else {
                    label = new Label(1, n2, "n/a");
                    writableSheet.addCell((WritableCell)label);
                }
                for (PeakAnnotation peakAnnotation2 : calculationPeak2.getAnnotation()) {
                    if (peakAnnotation2.getFragments().size() != 0) continue;
                    label = new Label(2, n2, annotationToString.composition(peakAnnotation2));
                    writableSheet.addCell((WritableCell)label);
                    label = new Label(3, n2, annotationToString.smallMolecules(peakAnnotation2));
                    writableSheet.addCell((WritableCell)label);
                    label = new Label(4, n2, annotationToString.chargedIon(peakAnnotation2));
                    writableSheet.addCell((WritableCell)label);
                    label = new Label(5, n2, annotationToString.ion(peakAnnotation2));
                    writableSheet.addCell((WritableCell)label);
                    number = new Number(6, n2, peakAnnotation2.getMass());
                    writableSheet.addCell((WritableCell)number);
                    number = new Number(7, n2, this.getDeviation(peakAnnotation2.getMass(), calculationPeak2.getMz()));
                    writableSheet.addCell((WritableCell)number);
                    ++n2;
                }
                if (calculationPeak2.getAnnotationCount() != calculationPeak2.getAnnotation().size()) {
                    label = new Label(2, n2, String.format("This peak has %d annotations. Only the first %d are shown.", calculationPeak2.getAnnotationCount(), calculationPeak2.getAnnotation().size()));
                    writableSheet.addCell((WritableCell)label);
                    writableCell = writableSheet.getWritableCell(2, n2);
                    peakAnnotation2 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
                    peakAnnotation2.setColour(Colour.RED);
                    writableCellFormat = new WritableCellFormat((WritableFont)peakAnnotation2);
                    writableCell.setCellFormat((CellFormat)writableCellFormat);
                    writableSheet.mergeCells(2, n2, 7, n2);
                }
                if (calculationPeak2.getAnnotation().size() == 0) {
                    ++n2;
                }
                ++n2;
            }
            label = new Label(0, n2, "Peaklist:");
            writableSheet.addCell((WritableCell)label);
            ++n2;
        }
        n = this.writeHeadline(writableSheet, n2);
        n2 += n + 1;
        for (CalculationPeak calculationPeak2 : this.m_objParameter.getScan().getPeaks()) {
            number = new Number(0, n2, calculationPeak2.getMz());
            writableSheet.addCell((WritableCell)number);
            if (calculationPeak2.getIntensity() != 0.0) {
                number = new Number(1, n2, calculationPeak2.getMz());
                writableSheet.addCell((WritableCell)number);
            } else {
                label = new Label(1, n2, "n/a");
                writableSheet.addCell((WritableCell)label);
            }
            for (PeakAnnotation peakAnnotation2 : calculationPeak2.getAnnotation()) {
                if (this.m_objParameter.getSpectraType() == SpectraType.MS2 && peakAnnotation2.getFragments().size() == 0) continue;
                label = new Label(2, n2, annotationToString.composition(peakAnnotation2));
                writableSheet.addCell((WritableCell)label);
                label = new Label(3, n2, annotationToString.smallMolecules(peakAnnotation2));
                writableSheet.addCell((WritableCell)label);
                label = new Label(4, n2, annotationToString.chargedIon(peakAnnotation2));
                writableSheet.addCell((WritableCell)label);
                label = new Label(5, n2, annotationToString.ion(peakAnnotation2));
                writableSheet.addCell((WritableCell)label);
                number = new Number(6, n2, peakAnnotation2.getMass());
                writableSheet.addCell((WritableCell)number);
                number = new Number(7, n2, this.getDeviation(peakAnnotation2.getMass(), calculationPeak2.getMz()));
                writableSheet.addCell((WritableCell)number);
                ++n2;
            }
            if (calculationPeak2.getAnnotationCount() != calculationPeak2.getAnnotation().size()) {
                label = new Label(2, n2, String.format("This peak has %d annotations. Only the first %d are shown.", calculationPeak2.getAnnotationCount(), calculationPeak2.getAnnotation().size()));
                writableSheet.addCell((WritableCell)label);
                writableCell = writableSheet.getWritableCell(2, n2);
                peakAnnotation2 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
                peakAnnotation2.setColour(Colour.RED);
                writableCellFormat = new WritableCellFormat((WritableFont)peakAnnotation2);
                writableCell.setCellFormat((CellFormat)writableCellFormat);
                writableSheet.mergeCells(2, n2, 7, n2);
                if (calculationPeak2.getAnnotation().size() > 0) {
                    ++n2;
                }
            }
            if (calculationPeak2.getAnnotation().size() == 0) {
                ++n2;
            }
            ++n2;
        }
    }

    private double getDeviation(double d, double d2) {
        if (d > 0.0) {
            return (d - d2) * 1000000.0 / d;
        }
        return 0.0;
    }

    private int writeHeadline(WritableSheet writableSheet, int n) throws RowsExceededException, WriteException {
        WritableFont writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat writableCellFormat = new WritableCellFormat(writableFont);
        writableCellFormat.setBackground(Colour.LIGHT_ORANGE);
        Label label = new Label(0, n, "Mass");
        writableSheet.addCell((WritableCell)label);
        WritableCell writableCell = writableSheet.getWritableCell(0, n);
        writableCell.setCellFormat((CellFormat)writableCellFormat);
        label = new Label(1, n, "Intensity");
        writableSheet.addCell((WritableCell)label);
        writableCell = writableSheet.getWritableCell(1, n);
        writableCell.setCellFormat((CellFormat)writableCellFormat);
        label = new Label(2, n, "Composition");
        writableSheet.addCell((WritableCell)label);
        writableCell = writableSheet.getWritableCell(2, n);
        writableCell.setCellFormat((CellFormat)writableCellFormat);
        label = new Label(3, n, "Small\r\nmolecules");
        writableSheet.addCell((WritableCell)label);
        writableCell = writableSheet.getWritableCell(3, n);
        writableCell.setCellFormat((CellFormat)writableCellFormat);
        label = new Label(4, n, "Charged\r\nIon(s)");
        writableSheet.addCell((WritableCell)label);
        writableCell = writableSheet.getWritableCell(4, n);
        writableCell.setCellFormat((CellFormat)writableCellFormat);
        label = new Label(5, n, "Ion\r\ntype");
        writableSheet.addCell((WritableCell)label);
        writableCell = writableSheet.getWritableCell(5, n);
        writableCell.setCellFormat((CellFormat)writableCellFormat);
        label = new Label(6, n, "Mass\r\ncalculated");
        writableSheet.addCell((WritableCell)label);
        writableCell = writableSheet.getWritableCell(6, n);
        writableCell.setCellFormat((CellFormat)writableCellFormat);
        label = new Label(7, n, "Deviation\r\n(ppm)");
        writableSheet.addCell((WritableCell)label);
        writableCell = writableSheet.getWritableCell(7, n);
        writableCell.setCellFormat((CellFormat)writableCellFormat);
        return 1;
    }

    private ArrayList<CalculationPeak> getPrecursorPeaks() {
        ArrayList<CalculationPeak> arrayList = new ArrayList<CalculationPeak>();
        for (CalculationPeak calculationPeak : this.m_objParameter.getScan().getPeaks()) {
            if (!this.containsProfileInformation(calculationPeak)) continue;
            arrayList.add(calculationPeak);
        }
        return arrayList;
    }

    private boolean containsProfileInformation(CalculationPeak calculationPeak) {
        Iterator<PeakAnnotation> iterator = calculationPeak.getAnnotation().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getFragments().size() != 0) continue;
            return true;
        }
        return false;
    }

    private void createSettingSheet(WritableSheet writableSheet) throws RowsExceededException, WriteException {
        int n = 0;
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.applyPattern("yyyy.MM.dd-hh.mm");
        Label label = new Label(0, n, "Glyco-Peakfinder Excel Report\r\n" + simpleDateFormat.format(date));
        writableSheet.addCell((WritableCell)label);
        WritableCell writableCell = writableSheet.getWritableCell(0, 0);
        WritableFont writableFont = new WritableFont(WritableFont.ARIAL, 18, WritableFont.BOLD);
        WritableCellFormat writableCellFormat = new WritableCellFormat(writableFont);
        writableCellFormat.setAlignment(Alignment.CENTRE);
        writableCell.setCellFormat((CellFormat)writableCellFormat);
        label = new Label(0, n += 2, "Spectrum type:");
        writableSheet.addCell((WritableCell)label);
        label = new Label(1, n, this.getSpectrumTypeName(this.m_objParameter.getSpectraType()));
        writableSheet.addCell((WritableCell)label);
        label = new Label(0, n += 2, "Mass type:");
        writableSheet.addCell((WritableCell)label);
        label = this.m_objParameter.getMonoisotopic() ? new Label(1, n, "monoisotopic") : new Label(1, n, "average");
        writableSheet.addCell((WritableCell)label);
        label = new Label(0, n += 2, "Accuracy:");
        writableSheet.addCell((WritableCell)label);
        Number number = new Number(1, n, this.m_objParameter.getAccuracy());
        writableSheet.addCell((WritableCell)number);
        label = this.m_objParameter.getAccuracyPpm() ? new Label(2, n, "ppm") : new Label(2, n, "u");
        writableSheet.addCell((WritableCell)label);
        n += 2;
        if (this.m_objParameter.getMassShift() != 0.0) {
            label = new Label(0, n, "Mass shift:");
            writableSheet.addCell((WritableCell)label);
            number = new Number(1, n, this.m_objParameter.getMassShift());
            writableSheet.addCell((WritableCell)number);
            n += 2;
        }
        label = new Label(0, n, "Modification of complete structure:");
        writableSheet.addCell((WritableCell)label);
        label = new Label(1, n, this.getPersubstTypeName(this.m_objParameter.getPersubstitution()));
        writableSheet.addCell((WritableCell)label);
        label = new Label(0, n += 2, "Reducing end:");
        writableSheet.addCell((WritableCell)label);
        for (CalculationDerivatisation object : this.m_objParameter.getDerivatisation()) {
            label = new Label(1, n, object.getId());
            writableSheet.addCell((WritableCell)label);
            number = new Number(2, n, object.getMass());
            writableSheet.addCell((WritableCell)number);
            ++n;
        }
        label = new Label(0, n += 2, "Peaks:");
        writableSheet.addCell((WritableCell)label);
        label = new Label(1, n, String.format("%d peak(s)", this.m_objParameter.getScan().getPeaks().size()));
        writableSheet.addCell((WritableCell)label);
        label = new Label(2, n, this.getMinMaxPeakString());
        writableSheet.addCell((WritableCell)label);
        ++n;
        if ((this.m_objParameter.getSpectraType() == SpectraType.MSxMS || this.m_objParameter.getSpectraType() == SpectraType.MS2) && this.m_objParameter.getScan().getPrecusorMass() != null) {
            label = new Label(0, n, "Precursor:");
            writableSheet.addCell((WritableCell)label);
            number = new Number(1, n, this.m_objParameter.getScan().getPrecusorMass().doubleValue());
            writableSheet.addCell((WritableCell)number);
        }
        label = new Label(0, n += 2, "Residues:");
        writableSheet.addCell((WritableCell)label);
        for (CalculationMolecule calculationMolecule : this.m_objParameter.getResidues()) {
            label = new Label(1, n, calculationMolecule.getId());
            writableSheet.addCell((WritableCell)label);
            number = new Number(2, n, calculationMolecule.getMass());
            writableSheet.addCell((WritableCell)number);
            label = new Label(3, n, String.format("%d - %d", calculationMolecule.getMin(), calculationMolecule.getMax()));
            writableSheet.addCell((WritableCell)label);
            ++n;
        }
        label = new Label(0, ++n, "Charged ions:");
        writableSheet.addCell((WritableCell)label);
        for (CalculationIon calculationIon : this.m_objParameter.getIons()) {
            label = new Label(1, n, calculationIon.getId());
            writableSheet.addCell((WritableCell)label);
            number = new Number(2, n, calculationIon.getMass());
            writableSheet.addCell((WritableCell)number);
            number = new Number(3, n, (double)calculationIon.getCharge().intValue());
            writableSheet.addCell((WritableCell)number);
            ++n;
        }
        label = new Label(0, ++n, "Charge state:");
        writableSheet.addCell((WritableCell)label);
        Iterator<Object> iterator = this.m_objParameter.getCharges().iterator();
        while (iterator.hasNext()) {
            number = new Number(1, n, (double)((Integer)iterator.next()).intValue());
            writableSheet.addCell((WritableCell)number);
            ++n;
        }
        if (this.m_objParameter.getIonExchangeIon().size() > 0) {
            label = new Label(0, ++n, "Ion exchange ions:");
            writableSheet.addCell((WritableCell)label);
            for (CalculationIon calculationIon : this.m_objParameter.getIonExchangeIon()) {
                label = new Label(1, n, calculationIon.getId());
                writableSheet.addCell((WritableCell)label);
                number = new Number(2, n, calculationIon.getMass());
                writableSheet.addCell((WritableCell)number);
                number = new Number(3, n, (double)calculationIon.getCharge().intValue());
                writableSheet.addCell((WritableCell)number);
                ++n;
            }
            label = new Label(0, ++n, "Number of exchanges:");
            writableSheet.addCell((WritableCell)label);
            iterator = this.m_objParameter.getIonExchangeCount().iterator();
            while (iterator.hasNext()) {
                number = new Number(1, n, (double)((Integer)iterator.next()).intValue());
                writableSheet.addCell((WritableCell)number);
                ++n;
            }
        }
        if (this.m_objParameter.getSpectraType() != SpectraType.Profile) {
            label = new Label(0, ++n, "Fragments:");
            writableSheet.addCell((WritableCell)label);
            iterator = this.getFragmentList();
            Iterator iterator2 = ((ArrayList)((Object)iterator)).iterator();
            while (iterator2.hasNext()) {
                label = new Label(1, n, (String)iterator2.next());
                writableSheet.addCell((WritableCell)label);
                ++n;
            }
        }
        if (this.m_objParameter.getGainMolecules().size() > 0) {
            label = new Label(0, ++n, "Gain of molecule:");
            writableSheet.addCell((WritableCell)label);
            for (CalculationMolecule calculationMolecule : this.m_objParameter.getGainMolecules()) {
                label = new Label(1, n, calculationMolecule.getId());
                writableSheet.addCell((WritableCell)label);
                number = new Number(2, n, calculationMolecule.getMass());
                writableSheet.addCell((WritableCell)number);
                label = new Label(3, n, String.format("%d - %d", calculationMolecule.getMin(), calculationMolecule.getMax()));
                writableSheet.addCell((WritableCell)label);
                ++n;
            }
        }
        if (this.m_objParameter.getLossMolecules().size() > 0) {
            label = new Label(0, ++n, "Lose of molecule:");
            writableSheet.addCell((WritableCell)label);
            for (CalculationMolecule calculationMolecule : this.m_objParameter.getLossMolecules()) {
                label = new Label(1, n, calculationMolecule.getId());
                writableSheet.addCell((WritableCell)label);
                number = new Number(2, n, calculationMolecule.getMass());
                writableSheet.addCell((WritableCell)number);
                label = new Label(3, n, String.format("%d - %d", calculationMolecule.getMin(), calculationMolecule.getMax()));
                writableSheet.addCell((WritableCell)label);
                ++n;
            }
        }
    }

    private ArrayList<String> getFragmentList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CalculationFragment calculationFragment : this.m_objParameter.getFragmentsRed()) {
            if (arrayList.contains(calculationFragment.getFragmentType())) continue;
            arrayList.add(calculationFragment.getFragmentType());
        }
        for (CalculationFragment calculationFragment : this.m_objParameter.getFragmentsNonRed()) {
            if (arrayList.contains(calculationFragment.getFragmentType())) continue;
            arrayList.add(calculationFragment.getFragmentType());
        }
        return arrayList;
    }

    private String getMinMaxPeakString() {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        for (CalculationPeak calculationPeak : this.m_objParameter.getScan().getPeaks()) {
            if (bl) {
                d2 = calculationPeak.getMz();
                d = calculationPeak.getMz();
                bl = false;
                continue;
            }
            if (d2 < calculationPeak.getMz()) {
                d2 = calculationPeak.getMz();
            }
            if (!(d > calculationPeak.getMz())) continue;
            d = calculationPeak.getMz();
        }
        return String.format("%.4f - %.4f", d, d2);
    }

    private String getPersubstTypeName(Persubstitution persubstitution) {
        return persubstitution.getName();
    }

    private String getSpectrumTypeName(SpectraType spectraType) {
        return spectraType.getName();
    }
}

