/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.workspace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.workspace.WorkspaceHistoryEntry;
import org.grits.toolbox.core.workspace.WorkspaceHistoryFileHandler;
import org.jdom.JDOMException;

public class WorkspaceDialog {
    private Shell parent;
    private int flag = 1;
    private String path = null;
    private List<WorkspaceHistoryEntry> history = new ArrayList<WorkspaceHistoryEntry>();
    private final String INITSTR = "<Choose workspace folder>";
    private Button OKbutton;
    private static final Logger logger = Logger.getLogger(WorkspaceDialog.class);

    public WorkspaceDialog(Shell parentShell) {
        this.parent = parentShell;
        parentShell.setText("Select Workspace");
        Monitor primary = parentShell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = parentShell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        parentShell.setLocation(x, y);
        this.createContents(parentShell);
        parentShell.pack();
    }

    public int open() {
        this.parent.open();
        while (!this.parent.isDisposed()) {
            if (this.parent.getDisplay().readAndDispatch()) continue;
            this.parent.getDisplay().sleep();
        }
        return this.flag;
    }

    private void createContents(Shell shell) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.parent.setLayout((Layout)gridLayout);
        GridData workspaceData = new GridData(4, 4, true, false);
        Label label = new Label((Composite)shell, 0);
        label.setText("Workspace:");
        label.setLayoutData((Object)workspaceData);
        Combo combo = new Combo((Composite)shell, 4);
        GridData comboData = new GridData(4, 4, true, false);
        comboData.grabExcessHorizontalSpace = true;
        comboData.horizontalAlignment = 4;
        comboData.minimumWidth = 200;
        combo.setLayoutData((Object)comboData);
        this.createCombo(shell, combo);
        this.createBrowseButton(shell, combo);
        this.createOKButton(shell, combo);
        this.createCANCELButton(shell);
    }

    private void createCANCELButton(Shell shell) {
        GridData cancelData = new GridData();
        Button CancelButton = new Button((Composite)shell, 8);
        cancelData.horizontalAlignment = 4;
        CancelButton.setText("Cancel");
        CancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkspaceDialog.this.flag = 1;
                WorkspaceDialog.this.parent.close();
            }
        });
        CancelButton.setLayoutData((Object)cancelData);
    }

    private void createOKButton(final Shell shell, final Combo combo) {
        GridData okData = new GridData();
        okData.grabExcessHorizontalSpace = true;
        okData.horizontalAlignment = 3;
        okData.horizontalSpan = 2;
        this.OKbutton = new Button((Composite)shell, 8);
        this.OKbutton.setText("    OK    ");
        this.path = combo.getText();
        if (this.path.equals("") || this.path.equals("<Choose workspace folder>")) {
            this.OKbutton.setEnabled(false);
        } else {
            this.OKbutton.setEnabled(true);
        }
        this.OKbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkspaceDialog.this.path = combo.getText();
                if (WorkspaceDialog.this.path.equals("") || WorkspaceDialog.this.path.equals("<Choose workspace folder>") || WorkspaceDialog.this.path.contains("<Choose workspace folder>")) {
                    MessageDialog.openInformation((Shell)shell, (String)"Error", (String)"Please select a location for workspace.");
                } else {
                    File newLocation = new File(WorkspaceDialog.this.path);
                    boolean folderExists = newLocation.exists();
                    if (!folderExists) {
                        folderExists = newLocation.mkdir();
                    }
                    boolean existsInHistoryFile = false;
                    int i = 0;
                    while (i < WorkspaceDialog.this.history.size()) {
                        if (((WorkspaceHistoryEntry)WorkspaceDialog.this.history.get(i)).getPath().equals(WorkspaceDialog.this.path)) {
                            existsInHistoryFile = true;
                            break;
                        }
                        ++i;
                    }
                    if (folderExists) {
                        try {
                            WorkspaceHistoryFileHandler.updateHistoryXMLFile(WorkspaceDialog.this.path, existsInHistoryFile);
                        }
                        catch (IOException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            MessageDialog.openInformation((Shell)shell, (String)"Error", (String)e.getMessage());
                        }
                        catch (JDOMException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            MessageDialog.openInformation((Shell)shell, (String)"Error", (String)e.getMessage());
                        }
                    } else {
                        logger.error((Object)"Invalid file name, Please choose another name for the workspace.");
                        MessageDialog.openInformation((Shell)shell, (String)"Invalid Folder Name", (String)"Invalid folder name. \nPlease choose another name for the workspace.");
                    }
                    WorkspaceDialog.this.flag = 0;
                    WorkspaceDialog.this.parent.close();
                }
            }
        });
        this.OKbutton.setLayoutData((Object)okData);
    }

    private void createCombo(Shell shell, final Combo combo) {
        MessageBox messageBox2;
        MessageBox messageBox;
        try {
            this.history = WorkspaceHistoryFileHandler.readHistoryFile();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            messageBox = new MessageBox(shell, 32);
            messageBox.setText("Error");
            messageBox.setMessage("Error while reading history xml file. Create a new history file");
            messageBox.open();
            try {
                WorkspaceHistoryFileHandler.createHistoryXMLFile();
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
                messageBox2 = new MessageBox(shell, 32);
                messageBox2.setText("Error while creating history xml file");
                messageBox2.setMessage(e1.getMessage());
                messageBox2.open();
                this.flag = 1;
                this.parent.close();
            }
        }
        try {
            if (WorkspaceHistoryFileHandler.getLastActiveHistory() != null) {
                combo.setText(WorkspaceHistoryFileHandler.getLastActiveHistory());
            } else {
                combo.setText("<Choose workspace folder>");
            }
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            messageBox = new MessageBox(shell, 32);
            messageBox.setText("Error");
            messageBox.setMessage("Error while reading history xml file. Create a new history file");
            messageBox.open();
            try {
                WorkspaceHistoryFileHandler.createHistoryXMLFile();
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
                messageBox2 = new MessageBox(shell, 32);
                messageBox2.setText("Error while creating history xml file");
                messageBox2.setMessage(e1.getMessage());
                messageBox2.open();
                this.flag = 1;
                this.parent.close();
            }
        }
        int i = 0;
        while (i < this.history.size()) {
            combo.add(this.history.get(i).getPath(), i);
            ++i;
        }
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String text = combo.getText();
                if (combo.indexOf(text) < 0) {
                    combo.add(text);
                    Object[] items = combo.getItems();
                    Arrays.sort(items);
                    combo.setItems((String[])items);
                }
            }
        });
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkspaceDialog.this.path = combo.getText();
                if (WorkspaceDialog.this.path.equals("") || WorkspaceDialog.this.path.equals("<Choose workspace folder>")) {
                    WorkspaceDialog.this.OKbutton.setEnabled(false);
                } else {
                    WorkspaceDialog.this.OKbutton.setEnabled(true);
                }
            }
        });
        combo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\r') {
                    WorkspaceDialog.this.OKbutton.notifyListeners(13, new Event());
                }
            }
        });
    }

    private void createBrowseButton(final Shell shell, final Combo combo) {
        GridData browseButtonData = new GridData();
        Button button = new Button((Composite)shell, 8);
        button.setLayoutData((Object)browseButtonData);
        button.setText("Browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(shell);
                dlg.setFilterPath(null);
                dlg.setText("Directory explorer");
                dlg.setMessage("Select a directory");
                String dir = dlg.open();
                if (dir != null) {
                    combo.setText(dir.trim());
                    WorkspaceDialog.this.path = dir;
                }
            }
        });
    }

    public String getPath() {
        return this.path;
    }
}

