/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utils;

import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class FileCopyProgressDialog {
    private static Logger logger = Logger.getLogger(FileCopyProgressDialog.class);
    public ProgressBar progressBar = null;
    private long totalByteCopied = 0L;
    protected long totalSize = 100L;
    private final String[] copyDots = new String[]{".   ", "..  ", "... "};

    public FileCopyProgressDialog(File fileToArchive) {
        if (fileToArchive != null && fileToArchive.exists()) {
            this.init();
            this.totalSize = this.getFileSize(fileToArchive);
            logger.debug((Object)this.totalSize);
        }
    }

    private long getFileSize(File file) {
        if (file.isFile()) {
            return file.length();
        }
        if (file.isDirectory()) {
            long totalBytes = 0L;
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                totalBytes += childFile.isFile() ? childFile.length() : this.getFileSize(childFile);
                ++n2;
            }
            return totalBytes;
        }
        return 0L;
    }

    public void init() {
        Shell shell = new Shell(Display.getCurrent().getActiveShell());
        shell.setLocation(600, 400);
        this.progressBar = new ProgressBar((Composite)shell, 65536);
        this.progressBar.getShell().setSize(330, 80);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setSelection(0);
        this.progressBar.getShell().setText("File Copy (Progress 0%)");
        this.progressBar.setBounds(10, 10, 300, 20);
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public long getCurrentProgress() {
        return this.totalByteCopied;
    }

    public void openProgressBar() {
        logger.debug((Object)"Opening progress bar");
        this.progressBar.getShell().open();
    }

    public void updateProgressBar(long byteIncrement) {
        this.totalByteCopied += byteIncrement;
        logger.debug((Object)("total increments " + this.totalByteCopied));
        this.progressBar.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!FileCopyProgressDialog.this.progressBar.isDisposed()) {
                    int copyPercentage = (int)(100.0f * ((float)FileCopyProgressDialog.this.totalByteCopied / (float)FileCopyProgressDialog.this.totalSize));
                    FileCopyProgressDialog.this.progressBar.setSelection(copyPercentage);
                    FileCopyProgressDialog.this.progressBar.getShell().setText("File Copy (Copying" + FileCopyProgressDialog.this.copyDots[copyPercentage % 3] + copyPercentage + "%)");
                    logger.debug((Object)(String.valueOf(copyPercentage) + "%"));
                }
            }
        });
    }

    public void closeProgressBar() {
        logger.debug((Object)"Disposing progress bar");
        this.progressBar.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FileCopyProgressDialog.this.progressBar.getShell().isDisposed()) {
                    FileCopyProgressDialog.this.progressBar.getShell().dispose();
                }
            }
        });
    }
}

