/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;
import org.grits.toolbox.core.part.toolitem.SaveTask;
import org.grits.toolbox.core.preference.project.AddEditTaskDialog;
import org.grits.toolbox.core.preference.share.MultiChoicePreference;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.TableColumnComparatorListener;
import org.grits.toolbox.core.utilShare.sort.TableViewerComparator;

public class TasklistPreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(TasklistPreference.class);
    private MultiChoicePreference<ProjectTasklist> tasklistPreference = null;
    public List<ProjectTasklist> defaultTasklist = null;
    public List<ProjectTasklist> otherTasklist = null;
    private CheckboxTableViewer checkboxTableViewer = null;
    private Button addButton = null;
    private Button editButton = null;
    private Button removeButton = null;
    private AddEditTaskDialog dialog = null;

    private void loadValues() {
        logger.info((Object)("Loading preference " + ProjectPreferenceStore.ParameterizedPreference.TASKLIST.getPreferenceName()));
        this.tasklistPreference = ProjectPreferenceStore.getMultiChoicePreference(ProjectPreferenceStore.ParameterizedPreference.TASKLIST);
        ProjectTasklist copiedTasklist = null;
        this.defaultTasklist = new ArrayList<ProjectTasklist>();
        for (ProjectTasklist tasklist : this.tasklistPreference.getSelectedValues()) {
            copiedTasklist = tasklist.getACopy();
            copiedTasklist.setAddByDefault(true);
            this.defaultTasklist.add(copiedTasklist);
        }
        this.otherTasklist = new ArrayList<ProjectTasklist>();
        for (ProjectTasklist tasklist : this.tasklistPreference.getOtherValues()) {
            copiedTasklist = tasklist.getACopy();
            copiedTasklist.setAddByDefault(false);
            this.otherTasklist.add(copiedTasklist);
        }
        this.dialog = new AddEditTaskDialog(this.getShell());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.marginBottom = 8;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 10;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        this.createTablePart(container);
        this.createButtonPart(container);
        this.loadValues();
        this.initializeTable();
        return container;
    }

    private void createTablePart(Composite container) {
        Table tasklistsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 3;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 150;
        tableLayouData.heightHint = 300;
        tasklistsTable.setLayoutData((Object)tableLayouData);
        this.checkboxTableViewer = new CheckboxTableViewer(tasklistsTable, "Default");
        TableViewerColumn tableColumn2 = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 4, 1);
        tableColumn2.getColumn().setText("Tasklist");
        tableColumn2.getColumn().setWidth(300);
        this.checkboxTableViewer.getTable().setHeaderVisible(true);
        this.checkboxTableViewer.getTable().setLinesVisible(true);
        this.checkboxTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                if (columnIndex == 1 && element instanceof ProjectTasklist) {
                    ProjectTasklist tasklist = (ProjectTasklist)element;
                    value = String.valueOf(tasklist.getTask()) + " (";
                    value = String.valueOf(value) + (tasklist.getPerson() == null || tasklist.getPerson().isEmpty() ? " -- " : tasklist.getPerson());
                    value = String.valueOf(value) + ")";
                }
                return value;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.checkboxTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)TasklistPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    ProjectTasklist selectedTasklist = (ProjectTasklist)selection.getFirstElement();
                    TasklistPreference.this.dialog.setTasklist(selectedTasklist.getACopy());
                    if (TasklistPreference.this.dialog.open() == 0) {
                        ProjectTasklist editedTasklist = TasklistPreference.this.dialog.getTasklist();
                        List tasklists = (List)TasklistPreference.this.checkboxTableViewer.getInput();
                        tasklists.set(tasklists.indexOf(selectedTasklist), editedTasklist);
                        TasklistPreference.this.checkboxTableViewer.refresh();
                        TasklistPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)editedTasklist));
                    }
                }
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectTasklist projectTasklist = (ProjectTasklist)event.getElement();
                boolean checked = event.getChecked();
                projectTasklist.setAddByDefault(checked);
                TasklistPreference.this.checkboxTableViewer.setChecked(projectTasklist, checked);
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof ProjectTasklist) {
                    return ((ProjectTasklist)element).isAddByDefault();
                }
                return false;
            }
        });
        this.addViewerComparator(this.checkboxTableViewer);
    }

    private void initializeTable() {
        ArrayList<ProjectTasklist> input = new ArrayList<ProjectTasklist>();
        input.addAll(this.otherTasklist);
        input.addAll(this.defaultTasklist);
        this.checkboxTableViewer.setInput(input);
        this.checkboxTableViewer.refresh();
    }

    private void addViewerComparator(TableViewer tableViewer) {
        tableViewer.setComparator((ViewerComparator)new TableViewerComparator());
        int totalColumns = tableViewer.getTable().getColumns().length;
        int i = 0;
        while (i < totalColumns) {
            tableViewer.getTable().getColumn(i).addSelectionListener((SelectionListener)new TableColumnComparatorListener(tableViewer));
            ++i;
        }
    }

    private void createButtonPart(Composite container) {
        Composite composite = new Composite(container, 4);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.marginTop = 20;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 10;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.addButton = this.createButton(composite, "Add");
        this.editButton = this.createButton(composite, "Edit");
        this.removeButton = this.createButton(composite, "Delete");
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List tasklists = (List)TasklistPreference.this.checkboxTableViewer.getInput();
                TasklistPreference.this.dialog.setTasklist(null);
                if (TasklistPreference.this.dialog.open() == 0) {
                    ProjectTasklist newTasklist = TasklistPreference.this.dialog.getTasklist();
                    tasklists.add(newTasklist);
                    TasklistPreference.this.checkboxTableViewer.refresh();
                    TasklistPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)newTasklist));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)TasklistPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    ProjectTasklist selectedTasklist = (ProjectTasklist)selection.getFirstElement();
                    TasklistPreference.this.dialog.setTasklist(selectedTasklist.getACopy());
                    if (TasklistPreference.this.dialog.open() == 0) {
                        ProjectTasklist editedTasklist = TasklistPreference.this.dialog.getTasklist();
                        List tasklists = (List)TasklistPreference.this.checkboxTableViewer.getInput();
                        tasklists.set(tasklists.indexOf(selectedTasklist), editedTasklist);
                        TasklistPreference.this.checkboxTableViewer.refresh();
                        TasklistPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)editedTasklist));
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List tasklists = (List)TasklistPreference.this.checkboxTableViewer.getInput();
                StructuredSelection selection = (StructuredSelection)TasklistPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    ProjectTasklist selectedTasklist = (ProjectTasklist)selection.getFirstElement();
                    int selectionIndex = TasklistPreference.this.checkboxTableViewer.getTable().getSelectionIndex();
                    tasklists.remove(selectedTasklist);
                    TasklistPreference.this.checkboxTableViewer.refresh();
                    selectionIndex = Math.max(selectionIndex - 1, 0);
                    TasklistPreference.this.checkboxTableViewer.getTable().select(selectionIndex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private Button createButton(Composite composite, String buttonLabel) {
        Button button = new Button(composite, 0);
        button.setText(buttonLabel);
        GridData addButtonData = new GridData(0x1000008, 1, true, true, 1, 1);
        addButtonData.widthHint = 80;
        button.setLayoutData((Object)addButtonData);
        GridData compositeLayoutData = new GridData(0x1000008, 1, true, true);
        compositeLayoutData.horizontalSpan = 3;
        compositeLayoutData.verticalSpan = 1;
        composite.setLayoutData((Object)compositeLayoutData);
        return button;
    }

    protected void performDefaults() {
        this.defaultTasklist = new ArrayList<ProjectTasklist>();
        this.otherTasklist = new ArrayList<ProjectTasklist>();
        this.initializeTable();
        super.performDefaults();
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("There is an error in \"Task List\" preference values. Please fix before saving! Error: " + errorMessage));
        }
        return errorMessage == null ? this.save() : false;
    }

    private String validateInput() {
        String errorMessage = null;
        List tableInput = (List)this.checkboxTableViewer.getInput();
        ArrayList<ProjectTasklist> tasklists = new ArrayList<ProjectTasklist>();
        for (ProjectTasklist projectTasklist : tableInput) {
            if (!SaveTask.isUnique(tasklists, projectTasklist)) {
                errorMessage = "Similar Tasks : " + projectTasklist.getTask() + " ( " + projectTasklist.getPerson() + " )";
                break;
            }
            tasklists.add(projectTasklist);
        }
        return errorMessage;
    }

    private boolean save() {
        List tableInput = (List)this.checkboxTableViewer.getInput();
        this.defaultTasklist = new ArrayList<ProjectTasklist>();
        this.otherTasklist = new ArrayList<ProjectTasklist>();
        for (ProjectTasklist projectTasklist : tableInput) {
            if (this.checkboxTableViewer.getChecked(projectTasklist)) {
                this.defaultTasklist.add(projectTasklist);
                continue;
            }
            this.otherTasklist.add(projectTasklist);
        }
        this.tasklistPreference.setSelectedValues(this.defaultTasklist);
        this.tasklistPreference.setOtherValues(this.otherTasklist);
        return this.tasklistPreference.savePreference();
    }
}

