/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.part.provider;

import java.text.SimpleDateFormat;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.grits.toolbox.core.datamodel.property.project.ProjectEvent;

public class EventsLabelProvider
implements ITableLabelProvider {
    public static final String DATE_FORMAT = "MM/dd/yyyy";
    private SimpleDateFormat simpleDateFormat = null;

    public void addListener(ILabelProviderListener listener) {
        this.simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = null;
        if (element instanceof ProjectEvent) {
            ProjectEvent event = (ProjectEvent)element;
            switch (columnIndex) {
                case 0: {
                    value = event.getProjectAction().getAction();
                    break;
                }
                case 1: {
                    if (event.getEventDate() == null) break;
                    value = this.simpleDateFormat.format(event.getEventDate());
                    break;
                }
                case 2: {
                    value = event.getDescription();
                }
            }
        }
        return value;
    }
}

