/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel.io.project;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.apache.poi.util.IOUtils;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectDetailsHandler;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.project.ProjectDetails;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

@Singleton
public class ProjectFileWriter {
    private static final Logger logger = Logger.getLogger(ProjectFileWriter.class);
    @Inject
    @Named(value="workspace_location")
    static String workspaceLocation;
    @Inject
    private IGritsDataModelService gritsDataModelService;

    private void reset(Entry projectEntry) {
        this.gritsDataModelService.setLastIdentifierForProject(projectEntry, 0);
    }

    public void createProjectFiles(Entry projectEntry, String description) throws IOException {
        if (projectEntry == null || projectEntry.getDisplayName() == null) {
            throw new IOException("Entry or its name cannot be null.");
        }
        this.reset(projectEntry);
        ProjectDetails projectDetails = ProjectDetailsHandler.createDefaultProjectDetails(projectEntry.getDisplayName(), description);
        ProjectDetailsHandler.writeProjectDetails(projectDetails);
        ProjectDetailsHandler.addDetailFileNameToProperty(projectEntry);
        this.createProjectXMLFile(projectEntry);
    }

    public void createProjectFiles(Entry projectEntry, String description, Set<String> keywords) throws IOException {
        if (projectEntry == null || projectEntry.getDisplayName() == null) {
            throw new IOException("Entry or its name cannot be null.");
        }
        this.reset(projectEntry);
        ProjectDetails projectDetails = ProjectDetailsHandler.createDefaultProjectDetails(projectEntry.getDisplayName(), description);
        projectDetails.setKeywords(keywords);
        ProjectDetailsHandler.writeProjectDetails(projectDetails);
        ProjectDetailsHandler.addDetailFileNameToProperty(projectEntry);
        this.createProjectXMLFile(projectEntry);
    }

    public void createProjectXMLFile(Entry projectEntry) throws IOException {
        String projectFolderName;
        File projectFolder;
        if (projectEntry != null && (projectFolder = new File(projectFolderName = String.valueOf(workspaceLocation) + projectEntry.getDisplayName())).exists() && projectFolder.isDirectory()) {
            Element projectElement = new Element("project");
            Document doc = new Document(projectElement);
            doc.setRootElement(projectElement);
            this.addEntryAndProperty(projectEntry, projectElement);
            ProjectFileWriter.createXmlFile(doc, new File(projectFolderName, ".project.xml"));
        }
    }

    private void addEntryAndProperty(Entry currentEntry, Element parentElement) throws IOException {
        Element entryElement = this.addEntry(currentEntry, parentElement);
        this.addProperty(currentEntry, parentElement.getDocument().getRootElement());
        Entry projectEntry = this.findProjectEntry(currentEntry);
        if (projectEntry == null) {
            logger.fatal((Object)("Cannot determine the project for entry: " + currentEntry.getDisplayName()));
            throw new IOException("Cannot determine the project for entry: " + currentEntry.getDisplayName());
        }
        if (currentEntry.getId() == null) {
            Integer identifier = this.gritsDataModelService.getLastIdentifierForProject(projectEntry);
            if (identifier == null) {
                logger.fatal((Object)("Cannot determine the identifier for entry for project: " + projectEntry.getDisplayName()));
                throw new IOException("Cannot determine the identifier for entry for project: " + projectEntry.getDisplayName());
            }
            this.gritsDataModelService.setLastIdentifierForProject(projectEntry, identifier + 1);
        }
        for (Entry child : currentEntry.getChildren()) {
            if (child.getId() == null) {
                Integer identifier = this.gritsDataModelService.getLastIdentifierForProject(projectEntry);
                if (identifier == null) {
                    logger.fatal((Object)("Cannot determine the identifier for entry for project: " + projectEntry.getDisplayName()));
                    throw new IOException("Cannot determine the identifier for entry for project: " + projectEntry.getDisplayName());
                }
                this.gritsDataModelService.setLastIdentifierForProject(projectEntry, identifier + 1);
            }
            this.addEntryAndProperty(child, entryElement);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Element addEntry(Entry currentEntry, Element parentElement) throws IOException {
        Element entryElement = new Element("entry");
        if (currentEntry.getId() != null) {
            entryElement.setAttribute("id", currentEntry.getId().toString());
        } else {
            Entry projectEntry = this.findProjectEntry(currentEntry);
            if (projectEntry == null) {
                logger.fatal((Object)("Cannot determine the project for entry: " + currentEntry.getDisplayName()));
                throw new IOException("Cannot determine the project for entry: " + currentEntry.getDisplayName());
            }
            Integer identifier = this.gritsDataModelService.getLastIdentifierForProject(projectEntry);
            if (identifier == null) {
                logger.fatal((Object)("Cannot determine the identifier for entry for project: " + projectEntry.getDisplayName()));
                throw new IOException("Cannot determine the identifier for entry for project: " + projectEntry.getDisplayName());
            }
            entryElement.setAttribute("id", identifier.toString());
            currentEntry.setId(identifier);
            this.gritsDataModelService.setLastIdentifierForProject(projectEntry, identifier + 1);
        }
        entryElement.setAttribute("name", currentEntry.getDisplayName());
        entryElement.setAttribute("creationTime", ProjectFileHandler.DATEFORMATER.format(currentEntry.getCreationDate()));
        entryElement.setAttribute("type", currentEntry.getEntryType().toString());
        if (currentEntry.getLastEditorId() != null) {
            entryElement.setAttribute("lastEditorId", currentEntry.getLastEditorId());
        }
        parentElement.addContent((Content)entryElement);
        return entryElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addProperty(Entry currentEntry, Element rootElement) throws IOException {
        Element propertyElement = new Element("property");
        if (currentEntry.getId() != null) {
            propertyElement.setAttribute("id", currentEntry.getId().toString());
        } else {
            Entry projectEntry = this.findProjectEntry(currentEntry);
            if (projectEntry == null) {
                logger.fatal((Object)("Cannot determine the project for entry: " + currentEntry.getDisplayName()));
                throw new IOException("Cannot determine the project for entry: " + currentEntry.getDisplayName());
            }
            Integer identifier = this.gritsDataModelService.getLastIdentifierForProject(projectEntry);
            if (identifier == null) {
                logger.fatal((Object)("Cannot determine the identifier for property for project: " + projectEntry.getDisplayName()));
                throw new IOException("Cannot determine the identifier for property for project: " + projectEntry.getDisplayName());
            }
            propertyElement.setAttribute("id", identifier.toString());
            this.gritsDataModelService.setLastIdentifierForProject(projectEntry, identifier + 1);
        }
        String version = currentEntry.getProperty().getVersion();
        version = version == null ? "1.0" : version;
        propertyElement.setAttribute("version", version);
        propertyElement.setAttribute("type", currentEntry.getProperty().getType());
        rootElement.addContent((Content)propertyElement);
        PropertyWriter writer = currentEntry.getProperty().getWriter();
        writer.write(currentEntry.getProperty(), propertyElement);
    }

    protected static void createXmlFile(Document doc, File file) throws IOException {
        FileWriter fileWriter = null;
        try {
            XMLOutputter xmlOutput = new XMLOutputter();
            xmlOutput.setFormat(Format.getPrettyFormat());
            if (file.exists() && file.isHidden() && System.getProperty("os.name").startsWith("Windows")) {
                Files.setAttribute(file.toPath(), "dos:hidden", false, new LinkOption[0]);
            }
            fileWriter = new FileWriter(file);
            xmlOutput.output(doc, (Writer)fileWriter);
            fileWriter.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fileWriter);
    }

    public void renameEntryInProject(File projectXmlFile, Entry entry, String newName) throws IOException {
        if (entry.getDisplayName() == null || entry.getDisplayName().isEmpty() || newName == null || newName.isEmpty()) {
            logger.fatal((Object)("entryName, new Name is null or empty : " + entry.getDisplayName() + ", " + newName));
            throw new IOException("entryName, new Name is null or empty : " + entry.getDisplayName() + ", " + newName);
        }
        if (!projectXmlFile.exists()) {
            logger.fatal((Object)("Project xml file does not exist: " + projectXmlFile.getAbsolutePath()));
            throw new FileNotFoundException("Project xml file does not exist: " + projectXmlFile.getAbsolutePath());
        }
        Document document = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            document = builder.build(projectXmlFile);
        }
        catch (JDOMException e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new IOException("Project xml is not a valid xml file[" + projectXmlFile.getAbsolutePath() + "]: \n" + e.getMessage());
        }
        Element project = document.getRootElement();
        if (!project.getName().equals("project")) {
            logger.fatal((Object)("Project file does not start with project tag " + projectXmlFile.getAbsolutePath()));
            throw new IOException("Project file does not start with project tag " + projectXmlFile.getAbsolutePath());
        }
        Element entryElement = this.matchElementWithEntry(project, entry);
        if (entryElement == null) {
            logger.fatal((Object)("Unable to find entry " + entry.getDisplayName()));
            throw new IOException("Unable to find entry " + entry.getDisplayName());
        }
        entryElement.setAttribute("name", newName);
        try {
            ProjectFileWriter.createXmlFile(document, projectXmlFile);
        }
        catch (IOException e) {
            logger.fatal((Object)("Error occurred while writing to project xml file : " + projectXmlFile.getAbsolutePath() + "\n" + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private Entry findProjectEntry(Entry entry) {
        return this.gritsDataModelService.findParentByType(entry, "org.grits.toolbox.property.project");
    }

    private Element matchElementWithEntry(Element element, Entry entry) {
        Element childElement = null;
        Element thisChildElement = null;
        for (Object child : element.getChildren("entry")) {
            if (child == null || !(child instanceof Element)) continue;
            thisChildElement = (Element)child;
            if (thisChildElement.getAttribute("name").getValue().equals(entry.getDisplayName()) && this.matchUptoProject(thisChildElement, entry)) {
                childElement = thisChildElement;
                break;
            }
            childElement = this.matchElementWithEntry(thisChildElement, entry);
            if (childElement != null) break;
        }
        return childElement;
    }

    private boolean matchUptoProject(Element thisChildElement, Entry entry) {
        boolean match;
        boolean bl = match = thisChildElement != null && thisChildElement.getParentElement() != null && entry != null && entry.getParent() != null;
        if (match) {
            Element parentElement = thisChildElement.getParentElement();
            Entry parentEntry = entry.getParent();
            if (parentElement.getName().equals("project")) {
                match = parentEntry.getProperty().getType().equals("org.grits.toolbox.property.workspace");
            } else {
                match = parentElement.getAttribute("name").getValue().equals(parentEntry.getDisplayName());
                if (match) {
                    match = this.matchUptoProject(parentElement, parentEntry);
                }
            }
        }
        return match;
    }
}

