/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.datamodel.property.project.ProjectDetails;
import org.grits.toolbox.core.datamodel.property.project.ProjectEvent;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;
import org.grits.toolbox.core.preference.share.MultiChoicePreference;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;

public class ProjectDetailsHandler {
    private static final Logger logger = Logger.getLogger(ProjectDetailsHandler.class);

    public static ProjectDetails getProjectDetails(Entry projectEntry) throws IOException {
        block8: {
            if (projectEntry != null && projectEntry.getDisplayName() != null) {
                try {
                    if (!projectEntry.getProperty().getType().equals("org.grits.toolbox.property.project")) break block8;
                    String workspaceFolder = PropertyHandler.getVariable("workspace_location");
                    ProjectProperty projectProperty = (ProjectProperty)projectEntry.getProperty();
                    File projectFolder = new File(String.valueOf(workspaceFolder.substring(0, workspaceFolder.length() - 1)) + File.separator + projectEntry.getDisplayName());
                    ProjectDetails projectDetails = null;
                    File projectDetailsFile = new File(projectFolder, projectProperty.getDetailsFile().getName());
                    if (projectDetailsFile.exists()) {
                        projectDetails = ProjectDetailsHandler.getProjectDetailsFromFile(projectDetailsFile);
                        if (!projectDetails.getEntryName().equals(projectEntry.getDisplayName())) {
                            projectDetails.setEntryName(projectEntry.getDisplayName());
                            ProjectDetailsHandler.writeProjectDetails(projectDetails);
                        }
                    } else {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Missing Project Details", (String)("The project details file is missing. Creating default project details for " + projectEntry.getDisplayName()));
                        try {
                            projectDetails = ProjectDetailsHandler.createDefaultProjectDetails(projectEntry.getDisplayName(), null);
                            ProjectDetailsHandler.writeProjectDetails(projectDetails);
                            ProjectDetailsHandler.addDetailFileNameToProperty(projectEntry);
                        }
                        catch (IOException e) {
                            String errorMessage = "The project details file could not be created for : " + projectEntry.getDisplayName() + ".\n" + e.getMessage();
                            logger.error((Object)errorMessage, (Throwable)e);
                            throw new IOException(errorMessage, e);
                        }
                    }
                    return projectDetails;
                }
                catch (Exception e) {
                    logger.error((Object)("The project xml could not be read for project Entry." + e.getMessage()), (Throwable)e);
                }
            }
        }
        return null;
    }

    public static ProjectDetails createDefaultProjectDetails(String projectEntryName, String description) {
        ProjectDetails projectDetails = null;
        if (projectEntryName != null) {
            logger.debug((Object)("END  : Creating default project details for project " + projectEntryName));
            projectDetails = new ProjectDetails(projectEntryName);
            ArrayList<ProjectCollaborator> collaborators = new ArrayList<ProjectCollaborator>();
            MultiChoicePreference collaboratorPreference = ProjectPreferenceStore.getMultiChoicePreference(ProjectPreferenceStore.ParameterizedPreference.COLLABORATOR);
            for (ProjectCollaborator defaultCollaborator : collaboratorPreference.getSelectedValues()) {
                collaborators.add(defaultCollaborator.getACopy());
            }
            projectDetails.setCollaborators(collaborators);
            ArrayList<ProjectTasklist> tasklist = new ArrayList<ProjectTasklist>();
            MultiChoicePreference tasklistPreference = ProjectPreferenceStore.getMultiChoicePreference(ProjectPreferenceStore.ParameterizedPreference.TASKLIST);
            for (ProjectTasklist defaultTasklist : tasklistPreference.getSelectedValues()) {
                tasklist.add(defaultTasklist.getACopy());
            }
            projectDetails.setTasklists(tasklist);
            ArrayList<ProjectEvent> events = new ArrayList<ProjectEvent>();
            MultiChoicePreference eventPreference = ProjectPreferenceStore.getMultiChoicePreference(ProjectPreferenceStore.ParameterizedPreference.EVENT);
            for (ProjectEvent thisEvent : eventPreference.getSelectedValues()) {
                events.add(thisEvent.getACopy());
            }
            projectDetails.setEvents(events);
            HashSet<String> keywords = new HashSet<String>();
            MultiChoicePreference keywordPreference = ProjectPreferenceStore.getMultiChoicePreference(ProjectPreferenceStore.ParameterizedPreference.KEYWORD);
            keywords.addAll(keywordPreference.getSelectedValues());
            projectDetails.setKeywords(keywords);
            projectDetails.setDescription(description);
            projectDetails.setModificationTime(new Date());
        } else {
            logger.error((Object)"Cannot create default project details for project as projectEntry is null ");
        }
        logger.debug((Object)("END  : Creating default project details for project " + projectEntryName));
        return projectDetails;
    }

    public static boolean writeProjectDetails(ProjectDetails projectDetails) throws IOException {
        if (projectDetails == null || projectDetails.getEntryName() == null) {
            return false;
        }
        boolean updated = false;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProjectDetails.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)projectDetails, (OutputStream)os);
            try {
                String workspaceFolder = PropertyHandler.getVariable("workspace_location");
                String fileLocation = String.valueOf(workspaceFolder.substring(0, workspaceFolder.length() - 1)) + File.separator + projectDetails.getEntryName() + File.separator + "project_details.xml";
                FileWriter fileWriter = new FileWriter(fileLocation);
                fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
                fileWriter.close();
                os.close();
                updated = true;
            }
            catch (IOException e) {
                logger.error((Object)("The changes made could not be written to the file..\n" + e.getMessage()), (Throwable)e);
                throw e;
            }
        }
        catch (JAXBException e) {
            logger.error((Object)("The changes made could not be serialized as xml.\n" + e.getMessage()), (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
        return updated;
    }

    public static void addDetailFileNameToProperty(Entry projectEntry) {
        if (projectEntry != null && projectEntry.getProperty() instanceof ProjectProperty) {
            ProjectProperty projectProperty = (ProjectProperty)projectEntry.getProperty();
            ProjectDetailsHandler.addDetailFileNameToProperty(projectProperty);
        }
    }

    private static void addDetailFileNameToProperty(ProjectProperty projectProperty) {
        if (projectProperty.getDetailsFile() == null) {
            PropertyDataFile propertyDataFile = new PropertyDataFile("project_details.xml", "1.0", "details");
            projectProperty.getDataFiles().add(propertyDataFile);
        }
    }

    private static ProjectDetails getProjectDetailsFromFile(File file) {
        ProjectDetails projectDetails = null;
        try {
            FileInputStream inputStream = new FileInputStream(file.getAbsolutePath());
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProjectDetails.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            projectDetails = (ProjectDetails)unmarshaller.unmarshal((Reader)reader);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("The object could not be read from xml." + e.getMessage()), (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Reading File", (String)"The object could not be read from xml.");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("The object could not be read from xml." + e.getMessage()), (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Reading File", (String)"The object could not be read from xml.");
        }
        catch (JAXBException e) {
            logger.error((Object)("The object could not be read from xml." + e.getMessage()), (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Reading File", (String)"The object could not be read from xml.");
        }
        return projectDetails;
    }
}

