/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.dataShare;

import javax.inject.Inject;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.DataModelHandler;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.core.service.IGritsUIService;

public class PropertyHandler {
    public static final String GRITS_CHARACTER_ENCODING = "UTF-8";
    public static final int LABEL_TEXT_LIMIT = 80;
    public static final int URI_TEXT_LIMIT = 5000;
    public static String descriptionLength = "10000";
    @Inject
    static IGritsUIService gritsUIService;
    protected static String ROOT_ADD;
    protected static String PERSPECTIVE_ID;
    protected static String SIMIAN_CONFIG_LOCATION;
    protected static String SIMIAN_CONFIG_LOCATION_INSTALL;
    protected static ImageShare _instance;
    protected static DataModelHandler dataModel;

    static {
        ROOT_ADD = "";
        PERSPECTIVE_ID = "org.grits.toolbox.core.perspective.projectexplorer";
        SIMIAN_CONFIG_LOCATION = "";
        SIMIAN_CONFIG_LOCATION_INSTALL = "";
        _instance = new ImageShare();
        dataModel = DataModelHandler.instance();
    }

    public static ImageShare getIconRegistry() {
        return _instance;
    }

    public static String getVariable(String name) {
        if (name.equals("workspace_location")) {
            return ROOT_ADD;
        }
        if (name.equals("configuration_location")) {
            return SIMIAN_CONFIG_LOCATION;
        }
        if (name.equals("configuration_location_install")) {
            return SIMIAN_CONFIG_LOCATION_INSTALL;
        }
        if (name.equals("perspective")) {
            return PERSPECTIVE_ID;
        }
        if (name.equals("preference")) {
            return String.valueOf(ROOT_ADD) + ".preference.xml";
        }
        if (name.equals("descriptionLength")) {
            return PropertyLength.DESCRIPTION.length().toString();
        }
        return null;
    }

    public static void setVariable(String name, String value) {
        if (name.equals("workspace_location")) {
            ROOT_ADD = value;
        } else if (name.equals("configuration_location")) {
            SIMIAN_CONFIG_LOCATION = value;
        } else if (name.equals("configuration_location_install")) {
            SIMIAN_CONFIG_LOCATION_INSTALL = value;
        } else if (name.equals("perspective")) {
            PERSPECTIVE_ID = value;
        }
    }

    public static Shell getModalDialog(Shell parent) {
        return new Shell(parent, 67616);
    }

    public static DataModelHandler getDataModel() {
        return dataModel;
    }

    public static void changePerspective(String perspectiveId) {
        gritsUIService.selectPerspective(perspectiveId);
    }

    public static enum PropertyLength {
        DESCRIPTION(10000);

        private final Integer length;

        private PropertyLength(int length) {
            this.length = length;
        }

        private Integer length() {
            return this.length;
        }
    }
}

