/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.wizard;

import edu.brandeis.glycodenovo.datamodel.Save;
import edu.brandeis.glycodenovo.datamodel.SettingForm;
import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.utils.data.CartoonOptions;
import org.grits.toolbox.utils.image.GlycanImageProvider;

public class ExportPage
extends WizardPage {
    private Composite container;
    private SettingForm form;
    private GlycanImageProvider imageProvider;
    private Entry msAnnotationEntry;
    private boolean saved = false;

    protected ExportPage(String pageName, SettingForm form) {
        super(pageName);
        this.form = form;
        this.setTitle("Click the 'Save' button to save result");
        this.imageProvider = new GlycanImageProvider();
        CartoonOptions options = new CartoonOptions("Oxford", "Normal", Double.valueOf(0.5), Integer.valueOf(0), true, false, true);
        this.imageProvider.setCartoonOptions(options);
        new BuilderWorkspace((GlycanRenderer)new GlycanRendererAWT());
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.container.setLayout((Layout)layout);
        Button saveButton = new Button(this.container, 0);
        saveButton.setText("Save");
        saveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportPage.this.saveTXT();
                ExportPage.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)this.container);
    }

    public void saveTXT() {
        DirectoryDialog wizardDialog = new DirectoryDialog(this.container.getShell(), 4);
        wizardDialog.setMessage("Select the location that you want to save result of GlycoDeNovo");
        String path = wizardDialog.open();
        System.out.println(path);
        if (path != null) {
            path = String.valueOf(path) + File.separator;
            this.form.getSpectrum().outputTXT(path, this.form.getCheck2H(), this.form.getCheckGap());
            this.saved = true;
        }
    }

    public void save() {
        Entry msEntry = this.form.getEntry();
        MassSpecProperty prop = (MassSpecProperty)msEntry.getProperty();
        MSPropertyDataFile dataFile = this.form.getDataFile();
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectName = DataModelSearch.findParentByType((Entry)msEntry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String pathToFile = String.valueOf(workspaceLocation) + projectName + File.separator + MassSpecProperty.getFoldername();
        MSFile msFile = dataFile.getMSFileWithReader(pathToFile, prop.getMassSpecMetaData().getMsExperimentType());
        Save save = new Save(this.form, msFile);
        this.msAnnotationEntry = save.save();
    }

    public Entry[] getResult() {
        return new Entry[]{this.form.getEntry(), this.msAnnotationEntry};
    }

    public boolean canFlipToNextPage() {
        return this.msAnnotationEntry != null || this.saved;
    }
}

