/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.datamodel;

import edu.brandeis.glycodenovo.core.CPeak;
import edu.brandeis.glycodenovo.core.CTopology;
import edu.brandeis.glycodenovo.core.CTopologySuperSet;
import edu.brandeis.glycodenovo.core.HLightArrayList;
import edu.brandeis.glycodenovo.datamodel.SettingForm;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.entry.ms.annotation.glycan.property.MSGlycanAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.property.datamodel.MSGlycanAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.annotation.sugar.GlycanExtraInfo;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.DataHeader;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.FeatureSelection;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.GlycanScansAnnotation;
import org.grits.toolbox.ms.om.data.GlycanSettings;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.grits.toolbox.ms.om.data.ScansAnnotation;
import org.grits.toolbox.ms.om.io.xml.AnnotationReader;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;

public class Save {
    private static final Logger logger = Logger.getLogger(Save.class);
    private SettingForm form;
    private BuilderWorkspace bw = new BuilderWorkspace((GlycanRenderer)new GlycanRendererAWT());
    private Data data;
    private AnalyteSettings testAnalyteSettings;
    private List<IonSettings> testAdductsToAnalyze;
    private List<Integer> testAdductsToAnalyzeCnts;
    private AnnotationWriter writer;
    private String tempOutputPath;
    private boolean complementFlag = false;
    private MSFile msFile;
    private int annotationId = 1;

    public Save(SettingForm form, MSFile msFile) {
        this.form = form;
        this.msFile = msFile;
    }

    public Entry save() {
        this.testAnalyteSettings = this.createTestAnalyteSettings();
        this.testAdductsToAnalyze = this.createTestAdducts();
        this.testAdductsToAnalyzeCnts = this.createTestAdductsCnts();
        Entry msAnnotationEntry = new Entry();
        String msAnnotName = this.form.getResName();
        msAnnotationEntry.setDisplayName(msAnnotName);
        File msAnnFile = this.getAnnotationFolder(this.form.getEntry());
        String msAnnotationFolder = msAnnFile.getAbsolutePath();
        MSGlycanAnnotationProperty t_property = new MSGlycanAnnotationProperty();
        MSGlycanAnnotationMetaData metaData = new MSGlycanAnnotationMetaData();
        t_property.setMSAnnotationMetaData((MSAnnotationMetaData)metaData);
        try {
            metaData.setAnnotationId(this.createRandomId(msAnnotationFolder));
        }
        catch (IOException e) {
            logger.error((Object)"Could not generate annotation id", (Throwable)e);
        }
        String description = this.form.getDescription();
        if (description == null) {
            metaData.setDescription("");
        } else {
            metaData.setDescription(description);
        }
        metaData.setVersion("1.0");
        metaData.setName(t_property.getMetaDataFileName());
        msAnnotationEntry.setProperty((Property)t_property);
        Method testMethod = this.createTestMethod();
        this.data = new Data();
        DataHeader dHeader = new DataHeader();
        this.data.setDataHeader(dHeader);
        this.data.getDataHeader().setMethod(testMethod);
        this.addAnnotationCustomExtraData(dHeader);
        this.data.setScans(this.getScans(this.msFile));
        String archiveName = AnnotationWriter.getArchiveFilePath((String)(String.valueOf(msAnnotationFolder) + File.separator + metaData.getAnnotationId()));
        File fWorkspaceFolderFile = this.getTempFolder();
        this.tempOutputPath = fWorkspaceFolderFile.getAbsolutePath();
        this.writer = new AnnotationWriter();
        ArrayList<GlycanFeature> parentFeatures = new ArrayList<GlycanFeature>();
        ArrayList<HLightArrayList<String>> parentDescendants = new ArrayList<HLightArrayList<String>>();
        int num = 1;
        for (Scan scan : this.data.getScans().values()) {
            if (scan.getMsLevel() == 1) {
                Peak precursor = (Peak)scan.getPeaklist().get(0);
                this.complementFlag = false;
                CPeak cpeak = this.form.getSpectrum().getPeakList().get(this.form.getSpectrum().getPeakList().size() - 1);
                if (cpeak == null || cpeak.getInferredSuperSets() == null) continue;
                for (CTopologySuperSet TSS : cpeak.getInferredSuperSets()) {
                    for (CTopology tp : TSS.getTopologies()) {
                        GlycanScansAnnotation glycanScanAnnotation = new GlycanScansAnnotation();
                        String sequence = tp.getGWAFormula();
                        Glycan glycan = Glycan.fromString((String)sequence);
                        if (glycan == null) continue;
                        Annotation annot = this.getAnnotation(glycan, num++);
                        GlycanFeature feature = this.getNewGlycanFeature(((GlycanAnnotation)annot).getId(), sequence, 2, "T", precursor.getMz(), cpeak.getCharge().intValue(), precursor, null);
                        String key = "ScoreMap";
                        HashMap<String, Double> scoreMap = new HashMap<String, Double>();
                        scoreMap.put(key, tp.getScore());
                        feature.setDoubleProp(scoreMap);
                        CustomExtraData myCustumExtraData = new CustomExtraData(key, "IC Score", "score of a topology", CustomExtraData.Type.Double);
                        dHeader.getFeatureCustomExtraData().add(myCustumExtraData);
                        if (cpeak.isComplement()) {
                            for (FeatureSelection featureselection : feature.getFeatureSelections()) {
                                featureselection.setComment("IS Complementary");
                            }
                        }
                        parentFeatures.add(feature);
                        HLightArrayList<String> descendants = new HLightArrayList<String>();
                        tp.getDescendantGWAFormula(descendants);
                        parentDescendants.add(descendants);
                        GlycanStructure glycanStructure = new GlycanStructure();
                        glycanStructure.setGWBSequence(glycan.toString());
                        glycanStructure.setSequence(glycan.toGlycoCTCondensed());
                        glycanStructure.setSequenceFormat(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED);
                        glycanStructure.setId(Integer.toString(annot.getId()));
                        glycanScanAnnotation.setStringAnnotationId(glycanStructure.getId());
                        this.addAnnotationToScan(glycanScanAnnotation, 1, glycanStructure, feature);
                        if (!this.data.getAnnotation().contains(annot)) {
                            this.data.getAnnotation().add(annot);
                        }
                        if (!glycanScanAnnotation.getScanAnnotations().isEmpty()) {
                            try {
                                this.writer.writeAnnotationsPerAnalyte((ScansAnnotation)glycanScanAnnotation, this.tempOutputPath);
                            }
                            catch (IOException e) {
                                logger.error((Object)"Cannot write annotation for scan", (Throwable)e);
                            }
                        }
                        if (((Scan)this.data.getScans().get(scan.getScanNo())).getAnnotatedPeaks().containsKey(precursor.getId()) && ((Boolean)((Scan)this.data.getScans().get(scan.getScanNo())).getAnnotatedPeaks().get(precursor.getId())).booleanValue()) continue;
                        int iNumAnnot = ((Scan)this.data.getScans().get(scan.getScanNo())).getNumAnnotatedPeaks() != null ? ((Scan)this.data.getScans().get(scan.getScanNo())).getNumAnnotatedPeaks() : 0;
                        ((Scan)this.data.getScans().get(scan.getScanNo())).setNumAnnotatedPeaks(Integer.valueOf(iNumAnnot + 1));
                        ((Scan)this.data.getScans().get(scan.getScanNo())).getAnnotatedPeaks().put(precursor.getId(), Boolean.TRUE);
                    }
                }
                continue;
            }
            if (scan.getPeaklist() == null || scan.getPeaklist().isEmpty()) continue;
            for (Peak p : scan.getPeaklist()) {
                this.complementFlag = false;
                CPeak cpeak = this.findCPeak(p);
                if (cpeak != null && cpeak.getInferredTopologies() != null) {
                    for (CTopology tp : cpeak.getInferredTopologies()) {
                        GlycanScansAnnotation glycanScanAnnotation = new GlycanScansAnnotation();
                        String sequence = tp.getGWAFormula();
                        Glycan glycan = Glycan.fromString((String)sequence);
                        if (glycan == null) continue;
                        Annotation annot = this.getAnnotation(glycan, num++);
                        GlycanStructure glycanStructure = new GlycanStructure();
                        glycanStructure.setGWBSequence(glycan.toString());
                        glycanStructure.setSequence(glycan.toGlycoCTCondensed());
                        glycanStructure.setSequenceFormat(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED);
                        glycanStructure.setId(Integer.toString(annot.getId()));
                        glycanScanAnnotation.setStringAnnotationId(glycanStructure.getId());
                        int pIdx = 0;
                        while (pIdx < parentFeatures.size()) {
                            HLightArrayList descendents = (HLightArrayList)parentDescendants.get(pIdx);
                            if (descendents.indexOf(sequence) >= 0) {
                                GlycanFeature parent = (GlycanFeature)parentFeatures.get(pIdx);
                                GlycanFeature feature = this.getNewGlycanFeature(parent.getAnnotationId(), sequence, null, tp.getType(), p.getMz(), cpeak.getCharge().intValue(), p, (Feature)parent);
                                parent.getGlycanFragment().add(feature);
                                this.addAnnotationToScan(glycanScanAnnotation, 2, glycanStructure, feature);
                                String key = "ScoreMap";
                                HashMap<String, Double> scoreMap = new HashMap<String, Double>();
                                scoreMap.put(key, tp.getScore());
                                feature.setDoubleProp(scoreMap);
                                CustomExtraData myCustumExtraData = new CustomExtraData(key, "IC Score", "score of a topology", CustomExtraData.Type.Double);
                                dHeader.getFeatureCustomExtraData().add(myCustumExtraData);
                                if (cpeak.isComplement()) {
                                    for (FeatureSelection featureselection : feature.getFeatureSelections()) {
                                        featureselection.setComment("IS Complementary");
                                    }
                                }
                            }
                            ++pIdx;
                        }
                        if (!this.data.getAnnotation().contains(annot)) {
                            this.data.getAnnotation().add(annot);
                        }
                        if (!glycanScanAnnotation.getScanAnnotations().isEmpty()) {
                            try {
                                this.writer.writeAnnotationsPerAnalyte((ScansAnnotation)glycanScanAnnotation, this.tempOutputPath);
                            }
                            catch (IOException e) {
                                logger.error((Object)"Cannot write annotation for scan", (Throwable)e);
                            }
                        }
                        if (((Scan)this.data.getScans().get(scan.getScanNo())).getAnnotatedPeaks().containsKey(p.getId()) && ((Boolean)((Scan)this.data.getScans().get(scan.getScanNo())).getAnnotatedPeaks().get(p.getId())).booleanValue()) continue;
                        int iNumAnnot = ((Scan)this.data.getScans().get(scan.getScanNo())).getNumAnnotatedPeaks() != null ? ((Scan)this.data.getScans().get(scan.getScanNo())).getNumAnnotatedPeaks() : 0;
                        ((Scan)this.data.getScans().get(scan.getScanNo())).setNumAnnotatedPeaks(Integer.valueOf(iNumAnnot + 1));
                        ((Scan)this.data.getScans().get(scan.getScanNo())).getAnnotatedPeaks().put(p.getId(), Boolean.TRUE);
                    }
                    continue;
                }
                if (cpeak != null) continue;
                System.out.println("Could not find matching peak for " + p.getMz());
            }
        }
        this.populateScanFeatureData(this.tempOutputPath);
        try {
            this.writer.generateScansAnnotationFiles(this.tempOutputPath, this.data, archiveName, true, true, true, true);
        }
        catch (IOException e) {
            logger.error((Object)"Cannot generate annotation files", (Throwable)e);
        }
        MSPropertyDataFile dataFile = this.getMSPropertyDataFile();
        t_property.getMSAnnotationMetaData().addAnnotationFile(dataFile);
        PropertyDataFile msMetaData = MSAnnotationProperty.getNewSettingsFile((String)t_property.getMetaDataFileName(), (MSAnnotationMetaData)t_property.getMSAnnotationMetaData());
        t_property.getDataFiles().add(msMetaData);
        this.addResultFileToMetaData(dHeader.getMethod().getMsType(), (MSAnnotationProperty)t_property, archiveName);
        MSAnnotationProperty.marshallSettingsFile((String)(String.valueOf(t_property.getAnnotationFolder(this.form.getEntry())) + File.separator + t_property.getMetaDataFileName()), (MSAnnotationMetaData)t_property.getMSAnnotationMetaData());
        return msAnnotationEntry;
    }

    Annotation getAnnotation(Glycan glycan, int iStrucNum) {
        GlycanAnnotation glycanAnnotation = new GlycanAnnotation();
        glycanAnnotation.setId(Integer.valueOf(iStrucNum));
        glycanAnnotation.setStringId(Integer.toString(iStrucNum));
        glycanAnnotation.setSequenceGWB(glycan.toString().substring(0, glycan.toString().indexOf("$")));
        glycanAnnotation.setSequence(glycan.toGlycoCTCondensed());
        glycanAnnotation.setSequenceFormat(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED);
        GlycanStructureAnnotation.populateExtraInfo((GlycanAnnotation)glycanAnnotation, (Glycan)glycan);
        return glycanAnnotation;
    }

    private CPeak findCPeak(Peak p) {
        HashMap<Double, HashSet<CPeak>> map = this.form.getSpectrum().getOriginalPeaksMap();
        if (map.get(p.getMz()).size() == 0) {
            return null;
        }
        if (map.get(p.getMz()).size() == 1) {
            return map.get(p.getMz()).iterator().next();
        }
        Iterator<CPeak> iterator = map.get(p.getMz()).iterator();
        CPeak currpeak = iterator.next();
        while (iterator.hasNext()) {
            if (currpeak.getInferredSuperSets() != null && !currpeak.getInferredSuperSets().isEmpty()) {
                return currpeak;
            }
            currpeak = iterator.next();
        }
        return currpeak;
    }

    protected HashMap<Integer, Scan> getScans(MSFile msFile) {
        if (msFile.getReader() instanceof IMSAnnotationFileReader) {
            List scans = ((IMSAnnotationFileReader)msFile.getReader()).readMSFile(msFile);
            return GelatoUtils.listToHashMap((List)scans, (double)0.0, null, (double)0.0, null);
        }
        return null;
    }

    private String createRandomId(String msAnnotation) throws IOException {
        File simFolder = new File(msAnnotation);
        if (!simFolder.exists()) {
            simFolder.mkdirs();
        }
        String entryId = MSGlycanAnnotationProperty.getRandomId();
        return entryId;
    }

    private File getAnnotationFolder(Entry msEntry) {
        String workspaceLocation = this.getWorkspaceLocation();
        MSGlycanAnnotationProperty t_property = new MSGlycanAnnotationProperty();
        Entry projectEntry = DataModelSearch.findParentByType((Entry)msEntry, (String)"org.grits.toolbox.property.project");
        String projectName = projectEntry.getDisplayName();
        String msAnnotationFolder = String.valueOf(workspaceLocation) + projectName + File.separator + t_property.getArchiveFolder() + File.separator;
        File msAnnotationFolderFile = new File(msAnnotationFolder);
        msAnnotationFolderFile.mkdirs();
        return msAnnotationFolderFile;
    }

    private String getWorkspaceLocation() {
        return PropertyHandler.getVariable((String)"workspace_location");
    }

    private AnalyteSettings createTestAnalyteSettings() {
        AnalyteSettings analyteSettings = new AnalyteSettings();
        GlycanSettings glycanSettings = new GlycanSettings();
        analyteSettings.setGlycanSettings(glycanSettings);
        return analyteSettings;
    }

    private List<IonSettings> createTestAdducts() {
        ArrayList<IonSettings> testAdductsToAnalyze = new ArrayList<IonSettings>();
        IonSettings testAdduct = new IonSettings("TestAdduct", Double.valueOf(1.0), "Test Glycan Adduct", Integer.valueOf(2), Boolean.TRUE);
        testAdductsToAnalyze.add(testAdduct);
        return testAdductsToAnalyze;
    }

    private List<Integer> createTestAdductsCnts() {
        ArrayList<Integer> testAdductsToAnalyzeCnts = new ArrayList<Integer>();
        testAdductsToAnalyzeCnts.add(1);
        return testAdductsToAnalyzeCnts;
    }

    private Method createTestMethod() {
        Method testMethod = new Method();
        testMethod.setMsType(this.form.getExperimentType());
        testMethod.setAnnotationType("GLYCAN");
        testMethod.setAccuracy(Double.valueOf(500.0));
        testMethod.setAccuracyPpm(Boolean.valueOf(true));
        testMethod.setFragAccuracy(Double.valueOf(500.0));
        testMethod.setFragAccuracyPpm(Boolean.valueOf(true));
        testMethod.setShift(Double.valueOf(0.0));
        return testMethod;
    }

    private void populateScanFeatureData(String glycanFilesPath) {
        AnnotationReader reader = new AnnotationReader();
        GlycanScansAnnotation glycanAnnotation = new GlycanScansAnnotation();
        ScanFeatures scanFeatures = null;
        HashMap<String, Integer> seen = new HashMap<String, Integer>();
        for (Integer scanId : this.data.getAnnotatedScan().keySet()) {
            for (String analyteId : (List)this.data.getAnnotatedScan().get(scanId)) {
                if (seen.containsKey(analyteId)) continue;
                glycanAnnotation = (GlycanScansAnnotation)reader.readAnnotation(glycanFilesPath, analyteId, GlycanScansAnnotation.class);
                if (glycanAnnotation != null) {
                    for (Integer scanId2 : glycanAnnotation.getScanAnnotations().keySet()) {
                        if (this.data.getScanFeatures().containsKey(scanId2)) {
                            scanFeatures = (ScanFeatures)this.data.getScanFeatures().get(scanId2);
                        } else {
                            scanFeatures = new ScanFeatures();
                            scanFeatures.setScanId(scanId2.intValue());
                            scanFeatures.setUsesComplexRowId(Boolean.valueOf(true));
                            scanFeatures.setScanPeaks(new HashSet(((Scan)this.data.getScans().get(scanId2)).getPeaklist()));
                            this.data.getScanFeatures().put(scanId2, scanFeatures);
                        }
                        if (glycanAnnotation.getScanAnnotations().get(scanId2) == null) continue;
                        List lF = (List)glycanAnnotation.getScanAnnotations().get(scanId2);
                        for (Feature f : lF) {
                            boolean found = false;
                            for (Feature scanF : scanFeatures.getFeatures()) {
                                if (!f.getId().equals(scanF.getId())) continue;
                                found = true;
                            }
                            if (found) continue;
                            scanFeatures.getFeatures().add(f);
                        }
                    }
                }
                seen.put(analyteId, 1);
            }
        }
    }

    private void addAnnotationToScan(GlycanScansAnnotation glycanScanAnnotations, int iScanNum, GlycanStructure structure, GlycanFeature feature) {
        try {
            if (glycanScanAnnotations.getScanAnnotations().get(iScanNum) == null) {
                ArrayList<GlycanFeature> glycanFeature = new ArrayList<GlycanFeature>();
                glycanFeature.add(feature);
                glycanScanAnnotations.getScanAnnotations().put(iScanNum, glycanFeature);
            } else if (!((List)glycanScanAnnotations.getScanAnnotations().get(iScanNum)).contains(feature)) {
                ((List)glycanScanAnnotations.getScanAnnotations().get(iScanNum)).add(feature);
            }
            if (this.data.getAnnotatedScan().get(iScanNum) == null) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(structure.getId());
                this.data.getAnnotatedScan().put(iScanNum, ids);
            } else if (!((List)this.data.getAnnotatedScan().get(iScanNum)).contains(structure.getId())) {
                ((List)this.data.getAnnotatedScan().get(iScanNum)).add(structure.getId());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error matching glycans in matchGlycanStructure.", (Throwable)e);
        }
    }

    private GlycanFeature getNewGlycanFeature(Integer annotId, String sSeq, Integer iScanNum, String ionType, double glycanMz, double charge, Peak peak, Feature parentFeature) {
        GlycanFeature feature = new GlycanFeature();
        feature.setId(Integer.toString(this.data.getNextFeatureIndex()));
        feature.setSequence(sSeq);
        feature.setCharge(Integer.valueOf((int)charge));
        double deviation = Math.abs(peak.getMz() - glycanMz) / glycanMz * 1000000.0;
        feature.setDeviation(Double.valueOf(deviation));
        feature.setMz(Double.valueOf(glycanMz));
        String rowId = Feature.getRowId((Integer)peak.getId(), (Integer)iScanNum, (boolean)true);
        FeatureSelection fSelection = new FeatureSelection();
        fSelection.setRowId(rowId);
        fSelection.setComment("Not Complementary");
        feature.getFeatureSelections().add(fSelection);
        feature.setAnnotationId(annotId);
        feature.setPrecursor(Integer.valueOf(-1));
        if (parentFeature != null) {
            feature.setParentId(parentFeature.getId());
        }
        feature.setFragmentType(ionType);
        return feature;
    }

    protected MSAnnotationProperty getMSAnnotationProperty(String msAnnotationFolder) {
        MSGlycanAnnotationProperty t_property = new MSGlycanAnnotationProperty();
        MSGlycanAnnotationMetaData metaData = new MSGlycanAnnotationMetaData();
        t_property.setMSAnnotationMetaData((MSAnnotationMetaData)metaData);
        metaData.setDescription(this.form.getDescription());
        metaData.setVersion("1.0");
        metaData.setName(t_property.getMetaDataFileName());
        return t_property;
    }

    private MSPropertyDataFile getMSPropertyDataFile() {
        return this.form.getDataFile();
    }

    private void addResultFileToMetaData(String sMSType, MSAnnotationProperty msAnnotProperty, String archiveName) {
        if (!sMSType.equals("LC-MS/MS")) {
            File annotationFile = new File(archiveName);
            MSPropertyDataFile pdfFolder = new MSPropertyDataFile(annotationFile.getName(), "1.0", "file", FileCategory.ANNOTATION_CATEGORY, "GELATO", annotationFile.getPath(), new ArrayList());
            msAnnotProperty.getMSAnnotationMetaData().addFile(pdfFolder);
        }
    }

    private File getTempFolder() {
        String workspaceLocation = this.getWorkspaceLocation();
        String t_tempFolder = String.valueOf(workspaceLocation) + ".temp" + File.separator + "GELATO_" + Long.toString(System.currentTimeMillis()) + File.separator;
        File t_tempFolderFile = new File(t_tempFolder);
        t_tempFolderFile.mkdirs();
        return t_tempFolderFile;
    }

    protected void addAnnotationCustomExtraData(DataHeader dataHeader) {
        List lCED = GlycanExtraInfo.getColumns();
        for (CustomExtraData ced : lCED) {
            dataHeader.getAnnotationCustomExtraData().add(ced);
        }
    }
}

