/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.core;

import edu.brandeis.glycodenovo.core.CPeak;
import edu.brandeis.glycodenovo.core.CSpectrum;
import java.util.ArrayList;
import java.util.HashMap;

class DataSignals {
    HashMap<Character, ArrayList<DataUnit>> ionmap = new HashMap();

    DataSignals() {
        this.ionmap.put(Character.valueOf('B'), new ArrayList());
        this.ionmap.put(Character.valueOf('C'), new ArrayList());
        this.ionmap.put(Character.valueOf('Y'), new ArrayList());
        this.ionmap.put(Character.valueOf('Z'), new ArrayList());
        this.ionmap.put(Character.valueOf('O'), new ArrayList());
    }

    ArrayList<DataUnit> get(Character iontype) {
        return this.ionmap.get(iontype);
    }

    void addlast(Character iontype, double mass, int peakID, CPeak complementPeakID, double intensity, ArrayList<ArrayList<Double>> context, int spectrumID, double glycanMass, boolean REM, CSpectrum spectrum) {
        ArrayList<DataUnit> alist = this.ionmap.get(iontype);
        alist.add(new DataUnit(mass));
        alist.get(alist.size() - 1).setparameters(peakID, complementPeakID, intensity, context, spectrumID, glycanMass, REM, spectrum);
    }

    boolean getREM(char iontype, int k) {
        return this.ionmap.get((Object)Character.valueOf((char)iontype)).get((int)k).REM;
    }

    double getGlycanMass(char iontype, int k) {
        return this.ionmap.get((Object)Character.valueOf((char)iontype)).get((int)k).glycanMass;
    }

    double getMass(char iontype, int k) {
        return this.ionmap.get((Object)Character.valueOf((char)iontype)).get((int)k).mass;
    }

    Double getPeakIntensity(char iontype, int k, int m) {
        return this.ionmap.get((Object)Character.valueOf((char)iontype)).get((int)k).context.get(1).get(m);
    }

    ArrayList<ArrayList<Double>> getContext(char iontype, int k) {
        return this.ionmap.get((Object)Character.valueOf((char)iontype)).get((int)k).context;
    }

    int getSpectrumID(char iontype, int k) {
        return this.ionmap.get((Object)Character.valueOf((char)iontype)).get((int)k).spectrumID;
    }

    int getPeakID(char iontype, int k) {
        return this.ionmap.get((Object)Character.valueOf((char)iontype)).get((int)k).peakID;
    }

    private class DataUnit {
        double mass;
        double intensity;
        double glycanMass;
        int peakID;
        int spectrumID;
        CPeak complementPeakID;
        ArrayList<ArrayList<Double>> context;
        boolean REM;
        CSpectrum spectrum;

        DataUnit(double mass) {
            this.mass = mass;
        }

        void setparameters(int peakID, CPeak complementPeakID, double intensity, ArrayList<ArrayList<Double>> context, int spectrumID, double glycanMass, boolean REM, CSpectrum spectrum) {
            this.peakID = peakID;
            this.complementPeakID = complementPeakID;
            this.intensity = intensity;
            this.context = context;
            this.spectrumID = spectrumID;
            this.glycanMass = glycanMass;
            this.REM = REM;
            this.spectrum = spectrum;
        }
    }
}

