/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.core;

import edu.brandeis.glycodenovo.core.CGlycoDeNovo;
import edu.brandeis.glycodenovo.core.CMonosaccharide;
import edu.brandeis.glycodenovo.core.CPeak;
import edu.brandeis.glycodenovo.core.CTopology;
import edu.brandeis.glycodenovo.core.CTopologySuperSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CTopologySet {
    protected String mType;
    protected double mMassPeak;
    protected double mMassLow;
    protected double mMassHigh;
    protected CMonosaccharide mGapMono;
    protected CMonosaccharide mRootMono;
    protected CMonosaccharide[] mBranchGapMonos = new CMonosaccharide[4];
    protected CTopologySuperSet[] mBranches = new CTopologySuperSet[4];
    protected boolean mLegal = true;
    protected int mMinusH;
    protected CGlycoDeNovo mReconstroctor;
    protected boolean mReconstrocted = false;
    protected int mCandidateNum;
    protected List<CTopology> mTopologies;
    protected List<String> mTopologyFormulas;
    protected Map<Integer, Integer> mTargetPeaks = new HashMap<Integer, Integer>();
    private CTopology[] mBranchTopologies = new CTopology[4];

    public CTopologySet(String type, double massCenter, double massLow, double massHigh, CMonosaccharide rootMono, CTopologySuperSet[] branches, CGlycoDeNovo reconstroctor) {
        this.mType = type;
        this.mMassPeak = massCenter;
        this.mMassLow = massLow;
        this.mMassHigh = massHigh;
        this.mRootMono = rootMono;
        this.mBranches = (CTopologySuperSet[])branches.clone();
        this.mReconstroctor = reconstroctor;
    }

    public CTopologySet(String type, double massCenter, double massLow, double massHigh, CMonosaccharide rootMono, CMonosaccharide MissingMono, CTopologySuperSet[] branches, CGlycoDeNovo reconstroctor) {
        this(type, massCenter, massLow, massHigh, rootMono, branches, reconstroctor);
        this.mGapMono = MissingMono;
    }

    public CTopologySet(String type, double massCenter, double massLow, double massHigh, CMonosaccharide rootMono, CTopologySuperSet[] branches, CGlycoDeNovo reconstroctor, int minusH) {
        this(type, massCenter, massLow, massHigh, rootMono, branches, reconstroctor);
        this.mMinusH = minusH;
    }

    public CTopologySet(String type, double massCenter, double massLow, double massHigh, CMonosaccharide rootMono, CMonosaccharide gapMono, CTopologySuperSet[] branches, CGlycoDeNovo reconstroctor, int minusH) {
        this(type, massCenter, massLow, massHigh, rootMono, branches, reconstroctor);
        this.mGapMono = gapMono;
        this.mMinusH = minusH;
    }

    public CTopologySet(String type, double massCenter, double massLow, double massHigh, CMonosaccharide rootMono, CMonosaccharide gapMono, int gapInBranch, CTopologySuperSet[] branches, CGlycoDeNovo reconstroctor, int minusH) {
        this(type, massCenter, massLow, massHigh, rootMono, branches, reconstroctor);
        this.mBranchGapMonos[gapInBranch] = gapMono;
        this.mMinusH = minusH;
    }

    public CTopologySet(String type, double massCenter, double massLow, double massHigh, CMonosaccharide rootMono, CMonosaccharide gapMono, int gapInBranch, CTopologySuperSet[] branches, CGlycoDeNovo reconstroctor) {
        this(type, massCenter, massLow, massHigh, rootMono, branches, reconstroctor);
        this.mBranchGapMonos[gapInBranch] = gapMono;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CTopologySet that = (CTopologySet)o;
        if (Math.abs(this.mMassLow - that.mMassLow) > 1.0E-5) {
            return false;
        }
        if (Math.abs(this.mMassHigh - that.mMassHigh) > 1.0E-5) {
            return false;
        }
        if (this.mRootMono != null ? !this.mRootMono.equals(that.mRootMono) : that.mRootMono != null) {
            return false;
        }
        return Arrays.equals(this.mBranches, that.mBranches) && Arrays.equals(this.mBranchGapMonos, that.mBranchGapMonos);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.mMassPeak);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mMassLow);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mMassHigh);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.mRootMono != null ? this.mRootMono.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.mBranchGapMonos);
        result = 31 * result + Arrays.hashCode(this.mBranches);
        return result;
    }

    void reconstructFormulas() {
        if (this.mReconstrocted) {
            return;
        }
        int k = 0;
        while (k < 4) {
            CTopologySuperSet s = this.mBranches[k];
            if (s == null) break;
            if (!s.mReconstructed) {
                s.reconstructFormulas();
            }
            ++k;
        }
        this.mTopologyFormulas = new ArrayList<String>(2000);
        this.mTopologies = new ArrayList<CTopology>(2000);
        this.mCandidateNum = 0;
        this.recFormula(0);
        this.mReconstrocted = true;
        boolean bl = this.mLegal = this.mCandidateNum > 0;
        if (this.mLegal) {
            this.mTopologyFormulas = this.mTopologyFormulas.subList(0, this.mCandidateNum);
            this.mTopologies = this.mTopologies.subList(0, this.mCandidateNum);
        }
    }

    private void recFormula(int branchIdx) {
        if (branchIdx > 3 || this.mBranches[branchIdx] == null) {
            String gwaFormula;
            String formula;
            int branchCount = branchIdx;
            int[] compositionCountMerged = new int[8];
            compositionCountMerged[this.mRootMono.mClassID - 1] = 1;
            HashSet<CPeak> peaks = new HashSet<CPeak>();
            for (Integer peakIdx : this.mTargetPeaks.keySet()) {
                peaks.add(this.mReconstroctor.mPeaks.get(peakIdx));
            }
            double mass = this.mRootMono.mMass - 18.0105646863 + 1.007276432;
            if (this.mReconstroctor.mPermethylated) {
                mass -= 14.0156500642;
            }
            if (this.mType.equals("T")) {
                mass += this.mReconstroctor.mFinalPeakCompensation;
            }
            if (this.mGapMono == null) {
                formula = this.mRootMono.mClass;
                gwaFormula = "freeEnd--?b1D-" + this.mRootMono.mClass + ",p";
            } else {
                formula = String.valueOf(this.mGapMono.mClass) + " " + this.mRootMono.mClass;
                gwaFormula = "freeEnd--?b1D-" + this.mRootMono.mClass + ",p--4b1D-" + this.mGapMono + ",p";
                int n = this.mGapMono.mClassID - 1;
                compositionCountMerged[n] = compositionCountMerged[n] + 1;
                mass += this.mGapMono.mMass - 18.0105646863;
                if (this.mReconstroctor.mPermethylated) {
                    mass -= 28.0313001284;
                }
            }
            if (branchCount > 0) {
                int j;
                Object[] branchFormulas = new String[branchCount];
                String[] gwaBranchFormulas = new String[branchCount];
                int i = 0;
                while (i < branchCount) {
                    if (this.mGapMono == null ? !CGlycoDeNovo.cLegalGlycosidicBonds[this.mBranchTopologies[i].mRootMonoClassID - 1][this.mRootMono.mClassID - 1] : !CGlycoDeNovo.cLegalGlycosidicBonds[this.mBranchTopologies[i].mRootMonoClassID - 1][this.mGapMono.mClassID - 1]) {
                        return;
                    }
                    mass += this.mBranchTopologies[i].mMass - 1.007276432;
                    if (this.mReconstroctor.mPermethylated) {
                        mass -= 14.0156500642;
                    }
                    peaks.addAll(this.mBranchTopologies[i].mSupportPeaks);
                    j = 0;
                    while (j < compositionCountMerged.length) {
                        int n = j;
                        compositionCountMerged[n] = compositionCountMerged[n] + this.mBranchTopologies[i].mCopositionCount[j];
                        ++j;
                    }
                    if (this.mBranchGapMonos[i] == null) {
                        branchFormulas[i] = this.mBranchTopologies[i].mFormula;
                        gwaBranchFormulas[i] = this.mBranchTopologies[i].mGWAFormula.substring(7);
                    } else {
                        mass += this.mBranchGapMonos[i].mMass - 18.0105646863;
                        if (this.mReconstroctor.mPermethylated) {
                            mass -= 28.0313001284;
                        }
                        branchFormulas[i] = String.valueOf(this.mBranchTopologies[i].mFormula) + " " + this.mBranchGapMonos[i].mClass;
                        gwaBranchFormulas[i] = "--4b1D-" + this.mBranchGapMonos[i].mClass + ",p--4b1D-" + this.mBranchTopologies[i].mGWAFormula.substring(7) + ",p";
                        int n = this.mBranchGapMonos[i].mClassID - 1;
                        compositionCountMerged[n] = compositionCountMerged[n] + 1;
                    }
                    ++i;
                }
                if (this.mMassHigh - this.mMassLow < 1.0E-6 ? Math.abs(mass - this.mMassLow) > this.mReconstroctor.mMassAccuracyDalton : mass <= this.mMassLow || mass >= this.mMassHigh) {
                    return;
                }
                if (branchCount == 1) {
                    formula = String.valueOf(branchFormulas[0]) + " " + formula;
                } else {
                    Arrays.sort(branchFormulas);
                    Object[] objectArray = branchFormulas;
                    int n = branchFormulas.length;
                    j = 0;
                    while (j < n) {
                        Object s = objectArray[j];
                        formula = "[" + (String)s + "] " + formula;
                        ++j;
                    }
                }
                Object gwaFormulaofAllBranches = gwaBranchFormulas[0];
                int i2 = 1;
                while (i2 < gwaBranchFormulas.length) {
                    gwaFormulaofAllBranches = "(" + (String)gwaFormulaofAllBranches + ")" + (String)gwaBranchFormulas[i2];
                    ++i2;
                }
                gwaFormula = String.valueOf(gwaFormula) + (String)gwaFormulaofAllBranches;
            }
            int i = 0;
            while (i < 8) {
                if (compositionCountMerged[i] > this.mReconstroctor.mCompositionCountThreshold[i]) {
                    return;
                }
                ++i;
            }
            for (String mTopologyFormula : this.mTopologyFormulas) {
                if (!mTopologyFormula.equals(formula)) continue;
                return;
            }
            ++this.mCandidateNum;
            this.mTopologyFormulas.add(formula);
            CTopology newTP = new CTopology(formula, gwaFormula, this.mRootMono.mClassID, peaks, peaks.size(), mass, this.mType, compositionCountMerged);
            int i3 = 0;
            while (i3 < branchCount) {
                CTopology temp = newTP.addChild(this.mBranchTopologies[i3]);
                if (temp != this.mBranchTopologies[i3]) {
                    for (CTopology ctp : this.mBranchTopologies[i3].mChildrenTopologies) {
                        newTP.addChild(ctp);
                    }
                }
                ++i3;
            }
            this.mTopologies.add(newTP);
        } else if (!this.mBranches[branchIdx].mTopologies.isEmpty()) {
            Iterator iterator = this.mBranches[branchIdx].mTopologies.iterator();
            while (iterator.hasNext()) {
                CTopology aTp;
                this.mBranchTopologies[branchIdx] = aTp = (CTopology)iterator.next();
                this.recFormula(branchIdx + 1);
            }
        }
    }
}

