/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.ms.om.data.IntensityFilter;
import org.grits.toolbox.ms.om.io.xml.AnnotationReader;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class);
    private static final String configFolderName = "org.grits.toolbox.entry.ms";
    private static final String filterHelpFolderName = "files";
    private static final String FILTER_FILE = "filters-ms.xml";
    public static final URL LIB_URL = Platform.getBundle((String)"org.grits.toolbox.entry.ms.annotation.glycan").getResource("preference");
    public static final URL FILES_URL = Platform.getBundle((String)"org.grits.toolbox.entry.ms.annotation.glycan").getResource("files");
    private static final String FILTER_HELP_FILE = "filterHelpMainPage.htm";
    @Inject
    @Named(value="workspace_location")
    private static String workspaceLocation;
    @Inject
    @Named(value="configuration_location")
    private static String configLocation;

    public static void copyFilterFile() throws IOException {
        File filterFile;
        String configFolderLocation = String.valueOf(configLocation) + File.separator + configFolderName;
        File configFolder = new File(configFolderLocation);
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if (!(filterFile = new File(String.valueOf(configFolderLocation) + File.separator + FILTER_FILE)).exists()) {
            URL resourceFileUrl = FileLocator.toFileURL((URL)LIB_URL);
            String originalJarFilePath = String.valueOf(resourceFileUrl.getPath()) + FILTER_FILE;
            File originalJarFile = new File(originalJarFilePath);
            FileOutputStream configFile = new FileOutputStream(String.valueOf(configFolderLocation) + File.separator + FILTER_FILE);
            Files.copy(originalJarFile.toPath(), configFile);
            configFile.close();
        } else {
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
            contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(FiltersLibrary.class);
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
                URL resourceFileUrl = FileLocator.toFileURL((URL)LIB_URL);
                String originalJarFilePath = String.valueOf(resourceFileUrl.getPath()) + FILTER_FILE;
                FiltersLibrary fromJar = FilterUtils.readCustomFilters((String)originalJarFilePath, (JAXBContext)context);
                FiltersLibrary existing = FilterUtils.readCustomFilters((String)filterFile.getAbsolutePath(), (JAXBContext)context);
                if (FilterUtils.needToCopyFilterLibraryFromJar((FiltersLibrary)fromJar, (FiltersLibrary)existing)) {
                    if (!FilterUtils.mergeFilterLibraries((FiltersLibrary)fromJar, (FiltersLibrary)existing)) {
                        File originalJarFile = new File(originalJarFilePath);
                        File configFile = new File(String.valueOf(configFolderLocation) + File.separator + FILTER_FILE);
                        Files.copy(originalJarFile.toPath(), configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        FilterUtils.updateLibrary((FiltersLibrary)existing, (String)filterFile.getAbsolutePath(), (JAXBContext)context);
                    }
                }
            }
            catch (JAXBException jAXBException) {
                logger.warn((Object)"Could not load the filter xml file from the configuration folder, copying anyway from the jar");
                URL resourceFileUrl = FileLocator.toFileURL((URL)LIB_URL);
                String originalJarFilePath = String.valueOf(resourceFileUrl.getPath()) + FILTER_FILE;
                File originalJarFile = new File(originalJarFilePath);
                File configFile = new File(String.valueOf(configFolderLocation) + File.separator + FILTER_FILE);
                Files.copy(originalJarFile.toPath(), configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                logger.warn((Object)"Merging of the filters failed! Copying anyway from the jar", (Throwable)e);
                URL resourceFileUrl = FileLocator.toFileURL((URL)LIB_URL);
                String originalJarFilePath = String.valueOf(resourceFileUrl.getPath()) + FILTER_FILE;
                File originalJarFile = new File(originalJarFilePath);
                File configFile = new File(String.valueOf(configFolderLocation) + File.separator + FILTER_FILE);
                Files.copy(originalJarFile.toPath(), configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    public static void copyFilterHelpFiles() {
        File configFilesFolder;
        String configFolderLocation = String.valueOf(configLocation) + File.separator + configFolderName;
        File configFolder = new File(configFolderLocation);
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if (!(configFilesFolder = new File(String.valueOf(configFolderLocation) + File.separator + filterHelpFolderName)).exists()) {
            configFilesFolder.mkdirs();
        }
        try {
            URL resourceFileUrl = FileLocator.toFileURL((URL)FILES_URL);
            File originalJarFile = new File(resourceFileUrl.getPath());
            FileUtils.copyFolder(originalJarFile, configFilesFolder);
        }
        catch (Exception e) {
            logger.error((Object)"Could not copy filter help files", (Throwable)e);
        }
    }

    public static void copyFolder(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            String[] files;
            if (!destination.exists()) {
                destination.mkdirs();
            }
            String[] stringArray = files = source.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(source, file);
                File destFile = new File(destination, file);
                FileUtils.copyFolder(srcFile, destFile);
                ++n2;
            }
        } else {
            FileOutputStream configFile = new FileOutputStream(destination);
            Files.copy(source.toPath(), configFile);
            configFile.close();
        }
    }

    public static String getFilterPath() {
        String configFolderLocation = String.valueOf(configLocation) + File.separator + configFolderName;
        return String.valueOf(configFolderLocation) + File.separator + FILTER_FILE;
    }

    public static String getFilterHelpPath() {
        String configFolderLocation = String.valueOf(configLocation) + File.separator + configFolderName;
        return String.valueOf(configFolderLocation) + File.separator + filterHelpFolderName + File.separator + FILTER_HELP_FILE;
    }

    public static FiltersLibrary readFilters(String filePath) throws UnsupportedEncodingException, JAXBException, FileNotFoundException {
        FiltersLibrary library = new FiltersLibrary();
        ArrayList currentFilters = new ArrayList();
        ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
        contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
        contextList.add(FiltersLibrary.class);
        JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
        FiltersLibrary newFilterSet = FilterUtils.readCustomFilters((String)filePath, (JAXBContext)context);
        if (newFilterSet != null) {
            currentFilters.addAll(newFilterSet.getFilters());
        }
        library.setFilters(currentFilters);
        library.setCategories(newFilterSet.getCategories());
        IntensityFilter precursorIntensityFilter = new IntensityFilter();
        precursorIntensityFilter.setDescription("Give a range for precursor intensity");
        precursorIntensityFilter.setLabel("Precursor Intensity");
        precursorIntensityFilter.setName("Precursor Intensity");
        precursorIntensityFilter.setIntensityColumnKey(DMPrecursorPeak.precursor_peak_intensity.name());
        library.getFilters().add(precursorIntensityFilter);
        IntensityFilter peakIntensityFilter = new IntensityFilter();
        peakIntensityFilter.setDescription("Give a range for peak intensity");
        peakIntensityFilter.setLabel("Peak Intensity");
        peakIntensityFilter.setName("Peak Intensity");
        precursorIntensityFilter.setIntensityColumnKey(DMPeak.peak_intensity.name());
        library.getFilters().add(peakIntensityFilter);
        IntensityFilter extractIntensityFilter = new IntensityFilter();
        extractIntensityFilter.setDescription("Give a range for extract total intensity");
        extractIntensityFilter.setLabel("Extract Intensity");
        extractIntensityFilter.setName("Extract Intensity");
        extractIntensityFilter.setIntensityColumnKey("_quant_total_intensity");
        library.getFilters().add(extractIntensityFilter);
        return library;
    }

    public static void updateLibrary(String filterPath, FiltersLibrary filterLibrary) throws JAXBException, IOException {
        ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
        contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
        contextList.add(FiltersLibrary.class);
        JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
        FilterUtils.updateLibrary((FiltersLibrary)filterLibrary, (String)filterPath, (JAXBContext)context);
    }
}

