/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference.viewer;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarImporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationByonicPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.viewer.ComponentSelectionListContentProvider;
import org.grits.toolbox.util.structure.glycan.count.SearchQueryItem;

public class MSGlycanAnnotationByonicPreferencePage
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationByonicPreferencePage.class);
    private TableViewer tableViewer;
    private Button upButton;
    private Button downButton;
    private Button deleteComponent;
    MSGlycanAnnotationByonicPreference preference = null;
    private ComponentsSelectionListAdapter selectionChangedListener;

    protected Control createContents(Composite parent) {
        GridLayout layout = new GridLayout(4, false);
        parent.setLayout((Layout)layout);
        Button addComponent = new Button(parent, 8);
        addComponent.setText("Add");
        GridData gridData = new GridData(16384, 16384, false, false, 1, 1);
        addComponent.setLayoutData((Object)gridData);
        addComponent.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddSequenceDialog d = new AddSequenceDialog(MSGlycanAnnotationByonicPreferencePage.this.getShell(), "Add new component", "Enter the GlycoCT sequence for the new component", "", new IInputValidator(){

                    public String isValid(String newText) {
                        SugarImporterGlycoCTCondensed importer = new SugarImporterGlycoCTCondensed();
                        try {
                            importer.parse(newText);
                        }
                        catch (SugarImporterException e) {
                            return "Sequence is not valid. Reason: " + e.getMessage();
                        }
                        return null;
                    }
                });
                if (d.open() == 0) {
                    String sequence = d.getValue();
                    InputDialog d2 = new InputDialog(MSGlycanAnnotationByonicPreferencePage.this.getShell(), "Add a new component", "Enter a label for the new component", "", new IInputValidator(){

                        public String isValid(String newText) {
                            if (newText == null || newText.trim().isEmpty()) {
                                return "Cannot leave label empty";
                            }
                            if ((this).MSGlycanAnnotationByonicPreferencePage.this.preference != null) {
                                for (SearchQueryItem s : (this).MSGlycanAnnotationByonicPreferencePage.this.preference.getComponents()) {
                                    if (!s.getName().equals(newText)) continue;
                                    return "This component already exists! Enter a different name";
                                }
                            }
                            return null;
                        }
                    });
                    if (d2.open() == 0) {
                        String label = d2.getValue();
                        SearchQueryItem newComponent = new SearchQueryItem(label, sequence);
                        if (MSGlycanAnnotationByonicPreferencePage.this.preference != null) {
                            MSGlycanAnnotationByonicPreferencePage.this.preference.getComponents().add(newComponent);
                            MSGlycanAnnotationByonicPreferencePage.this.tableViewer.refresh();
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deleteComponent = new Button(parent, 8);
        this.deleteComponent.setText("Delete");
        gridData = new GridData(16384, 16384, false, false, 1, 1);
        this.deleteComponent.setLayoutData((Object)gridData);
        this.deleteComponent.setEnabled(false);
        this.deleteComponent.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MSGlycanAnnotationByonicPreferencePage.this.tableViewer.getSelection();
                List selections = selection.toList();
                if (!selections.isEmpty()) {
                    SearchQueryItem component = (SearchQueryItem)selections.get(0);
                    if (MSGlycanAnnotationByonicPreferencePage.this.preference != null) {
                        MSGlycanAnnotationByonicPreferencePage.this.preference.getComponents().remove(component);
                        MSGlycanAnnotationByonicPreferencePage.this.tableViewer.refresh();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(parent, 0);
        this.initComponentsTable(parent);
        return parent;
    }

    private void initComponentsTable(Composite parent) {
        Group tableContainer = new Group(parent, 0);
        tableContainer.setText("");
        GridData gridData1 = GridDataFactory.fillDefaults().grab(true, false).create();
        gridData1.horizontalSpan = 4;
        tableContainer.setLayoutData((Object)gridData1);
        GridLayout layout = new GridLayout(4, false);
        layout.horizontalSpacing = 25;
        layout.marginLeft = 10;
        layout.marginTop = 10;
        tableContainer.setLayout((Layout)layout);
        GridData gridData = new GridData(16384, 16384, false, false, 3, 6);
        gridData.heightHint = 200;
        this.tableViewer = new TableViewer((Composite)tableContainer, 68352);
        this.tableViewer.getTable().setLayoutData((Object)gridData);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        TableViewerColumn orderColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn order = orderColumn.getColumn();
        order.setText("Order");
        order.setWidth(50);
        orderColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SearchQueryItem) {
                    ComponentSelectionListContentProvider cp = (ComponentSelectionListContentProvider)MSGlycanAnnotationByonicPreferencePage.this.tableViewer.getContentProvider();
                    return String.valueOf(cp.getComponents().indexOf(element) + 1);
                }
                return null;
            }
        });
        TableViewerColumn nameColumn = new TableViewerColumn(this.tableViewer, 0);
        nameColumn.getColumn().setText("Label");
        nameColumn.getColumn().setWidth(100);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SearchQueryItem) {
                    return ((SearchQueryItem)element).getName();
                }
                return null;
            }
        });
        TableViewerColumn sequenceColumn = new TableViewerColumn(this.tableViewer, 0);
        sequenceColumn.getColumn().setText("Sequence");
        sequenceColumn.getColumn().setWidth(100);
        sequenceColumn.setLabelProvider((CellLabelProvider)new OwnerDrawLabelProvider(){
            private static final int TEXT_MARGIN = 3;

            protected void erase(Event event, Object element) {
                event.detail &= 0xFFFFFFEF;
            }

            protected void paint(Event event, Object element) {
                if (element instanceof SearchQueryItem) {
                    String text = ((SearchQueryItem)element).getSequence();
                    event.gc.drawText(text, event.x + 3, event.y, true);
                }
            }

            protected void measure(Event event, Object element) {
                if (element instanceof SearchQueryItem) {
                    String text = ((SearchQueryItem)element).getSequence();
                    Point size = event.gc.textExtent(text);
                    event.width = size.x + 6;
                    event.height = Math.max(event.height, size.y + 3);
                }
            }
        });
        this.addUpDownButtons((Composite)tableContainer);
        this.loadPreferences();
        if (this.preference == null) {
            this.tableViewer.setContentProvider((IContentProvider)new ComponentSelectionListContentProvider(new ArrayList<SearchQueryItem>()));
            this.tableViewer.setInput(new ArrayList());
        } else {
            this.tableViewer.setContentProvider((IContentProvider)new ComponentSelectionListContentProvider(this.preference.getComponents()));
            this.tableViewer.setInput(this.preference.getComponents());
        }
        this.selectionChangedListener = new ComponentsSelectionListAdapter();
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionChangedListener);
    }

    private void addUpDownButtons(Composite container) {
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        this.upButton = new Button(container, 8);
        this.upButton.setText("Up");
        GridData gridData = new GridData(16384, 16384, false, false, 1, 1);
        this.upButton.setLayoutData((Object)gridData);
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSelectionListContentProvider cp = (ComponentSelectionListContentProvider)MSGlycanAnnotationByonicPreferencePage.this.tableViewer.getContentProvider();
                cp.up(MSGlycanAnnotationByonicPreferencePage.this.getElementList(), MSGlycanAnnotationByonicPreferencePage.this.tableViewer);
                MSGlycanAnnotationByonicPreferencePage.this.preference.setComponents(cp.getComponents());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.downButton = new Button(container, 8);
        this.downButton.setText("Down");
        gridData = new GridData(16384, 16384, false, false, 1, 1);
        this.downButton.setLayoutData((Object)gridData);
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSelectionListContentProvider cp = (ComponentSelectionListContentProvider)MSGlycanAnnotationByonicPreferencePage.this.tableViewer.getContentProvider();
                cp.down(MSGlycanAnnotationByonicPreferencePage.this.getElementList(), MSGlycanAnnotationByonicPreferencePage.this.tableViewer);
                MSGlycanAnnotationByonicPreferencePage.this.preference.setComponents(cp.getComponents());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(container, 0);
    }

    List<?> getElementList() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        List elements = selection.toList();
        ArrayList elementList = new ArrayList();
        int i = 0;
        while (i < elements.size()) {
            elementList.add(elements.get(i));
            ++i;
        }
        return elementList;
    }

    protected void performDefaults() {
        this.preference = MSGlycanAnnotationByonicPreference.loadDefaultSettings();
        if (this.tableViewer != null) {
            this.tableViewer.setContentProvider((IContentProvider)new ComponentSelectionListContentProvider(this.preference.getComponents()));
            this.tableViewer.setInput(this.preference.getComponents());
        }
    }

    void loadPreferences() {
        try {
            this.preference = MSGlycanAnnotationByonicPreference.getByonicPreferences(MSGlycanAnnotationByonicPreference.getPreferenceEntity());
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            logger.warn((Object)"Preferences are not up to date. Cannot read the old version");
        }
    }

    public boolean performOk() {
        if (this.preference == null) {
            return false;
        }
        return this.preference.save();
    }

    class AddSequenceDialog
    extends InputDialog {
        public AddSequenceDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        }

        protected int getInputTextStyle() {
            return 2562;
        }

        protected Control createDialogArea(Composite parent) {
            Control res = super.createDialogArea(parent);
            ((GridData)this.getText().getLayoutData()).heightHint = 100;
            return res;
        }
    }

    class ComponentsSelectionListAdapter
    implements ISelectionChangedListener {
        ComponentsSelectionListAdapter() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)MSGlycanAnnotationByonicPreferencePage.this.tableViewer.getSelection();
            List selections = selection.toList();
            ComponentSelectionListContentProvider cp = (ComponentSelectionListContentProvider)MSGlycanAnnotationByonicPreferencePage.this.tableViewer.getContentProvider();
            MSGlycanAnnotationByonicPreferencePage.this.upButton.setEnabled(cp.canMoveUp(selections));
            MSGlycanAnnotationByonicPreferencePage.this.downButton.setEnabled(cp.canMoveDown(selections));
            MSGlycanAnnotationByonicPreferencePage.this.deleteComponent.setEnabled(!selections.isEmpty());
        }
    }
}

