/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.utils.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.simian.SimianSVGUtils;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.jat.generation.internal.helpers.ImageConverter;

public class SimianImageConverterOld
extends ImageConverter {
    public static BufferedImage convert(Image srcImage) {
        if (srcImage instanceof BufferedImage) {
            return (BufferedImage)srcImage;
        }
        BufferedImage bimage = new BufferedImage(srcImage.getWidth(null), srcImage.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(srcImage, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage createCartoon(Glycan glycan, GlycanWorkspace gwb, double dScaleFactor, boolean bShowMasses, boolean bShowRedEnd, boolean bNoScaleLessThanOne, int iScaleType) {
        double dScaleTo = bNoScaleLessThanOne && dScaleFactor < 1.0 ? 2.0 : dScaleFactor;
        double dScaleFrom = bNoScaleLessThanOne && dScaleFactor < 1.0 ? dScaleFactor / 2.0 : dScaleFactor;
        BufferedImage img = SimianImageConverterOld.createCartoon(glycan, gwb, dScaleTo, bShowMasses, bShowRedEnd);
        if (bNoScaleLessThanOne && dScaleFactor < 1.0) {
            int width = (int)((double)img.getWidth() * dScaleFrom);
            int height = (int)((double)img.getHeight() * dScaleFrom);
            Image newImage = img.getScaledInstance(width, height, iScaleType);
            BufferedImage newBufferedImage = SimianImageConverterOld.convert(newImage);
            newImage.flush();
            return newBufferedImage;
        }
        return img;
    }

    public static BufferedImage createCartoon(Glycan glycan, GlycanWorkspace gwb, double dScaleFactor, boolean bShowMasses, boolean bShowRedEnd) {
        try {
            BufferedImage img = gwb.getGlycanRenderer().getImage(glycan, true, bShowMasses, bShowRedEnd, dScaleFactor);
            return img;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BufferedImage createImage(Integer a_width, Integer a_height) {
        BufferedImage t_image = new BufferedImage(a_width, a_height, 1);
        Graphics2D g2d = t_image.createGraphics();
        g2d.setColor(Color.white);
        g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, a_width.intValue(), a_height.intValue()));
        g2d.dispose();
        return t_image;
    }

    public static BufferedImage getSVGImage(Glycan structure, GlycanWorkspace gwb) {
        Vector<Glycan> structures = new Vector<Glycan>();
        if (structure != null) {
            structures.add(structure);
        }
        try {
            byte[] svgArray = SimianSVGUtils.getTranscodedSVG(gwb.getGlycanRenderer(), structures, true, true, (Transcoder)new PNGTranscoder());
            ByteArrayInputStream is = new ByteArrayInputStream(svgArray);
            BufferedImage image = ImageIO.read(is);
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

