/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.util.Vector;
import org.eurocarbdb.application.glycoworkbench.Annotation;
import org.eurocarbdb.application.glycoworkbench.Peak;

public class PeakAnnotationMultiple {
    protected Peak peak;
    protected Vector<Vector<Annotation>> annotations;

    public PeakAnnotationMultiple(Peak p, int no_structures) {
        this.peak = p.clone();
        this.annotations = new Vector();
        for (int i = 0; i < no_structures; ++i) {
            this.addStructure();
        }
    }

    public void clearAnnotations() {
        for (Vector<Annotation> v : this.annotations) {
            v.clear();
        }
    }

    public void addStructure() {
        this.annotations.add(new Vector());
    }

    public void insertStructureAt(int s_ind) {
        this.annotations.insertElementAt(new Vector(), s_ind);
    }

    public void removeStructureAt(int s_ind) {
        this.annotations.removeElementAt(s_ind);
    }

    public boolean addAnnotation(int s_ind, Annotation toadd) {
        if (toadd != null && !toadd.isEmpty()) {
            Vector<Annotation> v = this.annotations.elementAt(s_ind);
            for (int i = 0; i < v.size(); ++i) {
                Annotation e = v.elementAt(i);
                int comp = e.compareTo(toadd);
                if (comp == 0) {
                    return false;
                }
                if (comp <= 0) continue;
                v.insertElementAt(toadd, i);
                return true;
            }
            v.add(toadd);
            return true;
        }
        return false;
    }

    public boolean removeAnnotation(int s_ind, Annotation toremove) {
        if (toremove == null || toremove.isEmpty()) {
            return false;
        }
        Vector<Annotation> v = this.annotations.elementAt(s_ind);
        for (int i = 0; i < v.size(); ++i) {
            Annotation e = v.elementAt(i);
            if (!e.equals(toremove)) continue;
            v.removeElementAt(i);
            return true;
        }
        return false;
    }

    public Peak getPeak() {
        return this.peak;
    }

    public double getBestAccuracy(int s_ind) {
        double best_acc = Double.MAX_VALUE;
        for (Annotation e : this.annotations.elementAt(s_ind)) {
            double acc = e.getAccuracy(this.peak);
            if (!(Math.abs(acc) < Math.abs(best_acc))) continue;
            best_acc = acc;
        }
        return best_acc;
    }

    public double getBestAccuracyPPM(int s_ind) {
        double best_acc = Double.MAX_VALUE;
        for (Annotation e : this.annotations.elementAt(s_ind)) {
            double acc = e.getAccuracyPPM(this.peak);
            if (!(Math.abs(acc) < Math.abs(best_acc))) continue;
            best_acc = acc;
        }
        return best_acc;
    }

    public Vector<Vector<Annotation>> getAnnotations() {
        return this.annotations;
    }

    public Vector<Annotation> getAnnotations(int s_ind) {
        return this.annotations.elementAt(s_ind);
    }

    public boolean isAnnotated() {
        for (Vector<Annotation> va : this.annotations) {
            if (va.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isAnnotated(int s_ind) {
        return this.annotations.elementAt(s_ind).size() > 0;
    }
}

