/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.utils.io.old;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.grits.toolbox.core.utilShare.ConvertImageUnits;

public class ExcelWriterHelper {
    public void writeCellImage(Workbook m_objWorkbook, Sheet m_objSheet, int m_iRowCounter, int _iPrefColNum, BufferedImage image, List<Picture> m_images) throws Exception {
        if (_iPrefColNum < 0 || image == null) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", bos);
        Drawing patriarch = m_objSheet.createDrawingPatriarch();
        double imageWidthMM = ConvertImageUnits.widthUnits2Millimetres((short)ConvertImageUnits.pixel2WidthUnits((int)image.getWidth()));
        double imageHeightMM = ConvertImageUnits.widthUnits2Millimetres((short)ConvertImageUnits.pixel2WidthUnits((int)image.getHeight()));
        ClientAnchorDetail columnDetail = this.fitImageToColumns(m_objSheet, _iPrefColNum, imageWidthMM);
        ClientAnchorDetail rowDetail = this.fitImageToRows(m_objSheet, m_iRowCounter, imageHeightMM);
        ClientAnchor anchor = m_objWorkbook.getCreationHelper().createClientAnchor();
        int dx1 = 5;
        int dy1 = 5;
        int dx2 = columnDetail.getInset();
        int dy2 = rowDetail.getInset();
        if (m_objWorkbook instanceof XSSFWorkbook || m_objWorkbook instanceof SXSSFWorkbook) {
            dx1 *= 9525;
            dy1 *= 9525;
            dx2 *= 9525;
            dy2 *= 9525;
        }
        anchor.setDx1(dx1);
        anchor.setDy1(dy1);
        anchor.setDx2(dx2);
        anchor.setDy2(dy2);
        anchor.setCol1(columnDetail.getFromIndex());
        anchor.setRow1(rowDetail.getFromIndex());
        anchor.setCol2(columnDetail.getToIndex());
        anchor.setRow2(rowDetail.getToIndex());
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        int index = m_objWorkbook.addPicture(bos.toByteArray(), 6);
        Picture t_pic = patriarch.createPicture(anchor, index);
        m_images.add(t_pic);
    }

    private ClientAnchorDetail fitImageToColumns(Sheet sheet, int colNumber, double reqImageWidthMM) {
        double colWidthMM = 0.0;
        double colCoordinatesPerMM = 0.0;
        int pictureWidthCoordinates = 0;
        ClientAnchorDetail colClientAnchorDetail = null;
        colWidthMM = ConvertImageUnits.widthUnits2Millimetres((short)((short)sheet.getColumnWidth(colNumber)));
        if (colWidthMM < reqImageWidthMM) {
            sheet.setColumnWidth(colNumber, ConvertImageUnits.millimetres2WidthUnits((double)(reqImageWidthMM + 1.0)));
            colWidthMM = reqImageWidthMM;
            colCoordinatesPerMM = 1023.0 / colWidthMM;
            pictureWidthCoordinates = (int)(reqImageWidthMM * colCoordinatesPerMM);
            colClientAnchorDetail = new ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
        } else {
            colCoordinatesPerMM = 1023.0 / colWidthMM;
            pictureWidthCoordinates = (int)(reqImageWidthMM * colCoordinatesPerMM);
            colClientAnchorDetail = new ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
        }
        return colClientAnchorDetail;
    }

    private ClientAnchorDetail fitImageToRows(Sheet sheet, int rowNumber, double reqImageHeightMM) {
        Row row = null;
        double rowHeightMM = 0.0;
        double rowCoordinatesPerMM = 0.0;
        int pictureHeightCoordinates = 0;
        ClientAnchorDetail rowClientAnchorDetail = null;
        row = sheet.getRow(rowNumber);
        if (row == null) {
            row = sheet.createRow(rowNumber);
        }
        if ((rowHeightMM = (double)row.getHeightInPoints() / 2.83) < reqImageHeightMM) {
            row.setHeightInPoints((float)(reqImageHeightMM * 2.83) + 10.0f);
            rowHeightMM = reqImageHeightMM;
            rowCoordinatesPerMM = 255.0 / rowHeightMM;
            pictureHeightCoordinates = (int)(reqImageHeightMM * rowCoordinatesPerMM);
            rowClientAnchorDetail = new ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
        } else {
            rowCoordinatesPerMM = 255.0 / rowHeightMM;
            pictureHeightCoordinates = (int)(reqImageHeightMM * rowCoordinatesPerMM);
            rowClientAnchorDetail = new ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
        }
        return rowClientAnchorDetail;
    }

    public class ClientAnchorDetail {
        public int fromIndex = 0;
        public int toIndex = 0;
        public int inset = 0;

        public ClientAnchorDetail(int fromIndex, int toIndex, int inset) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.inset = inset;
        }

        public int getFromIndex() {
            return this.fromIndex;
        }

        public int getToIndex() {
            return this.toIndex;
        }

        public int getInset() {
            return this.inset;
        }
    }
}

