/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed;

import org.apache.log4j.Logger;
import org.grits.toolbox.entry.ms.extquantfiles.process.ExtractDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.QuantFileProcessor;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class MassSpecMultiPageViewerWorker
extends GRITSWorker {
    private static final Logger logger = Logger.getLogger(MassSpecMultiPageViewerWorker.class);
    protected int iMajorCount = 0;
    protected MassSpecEntityProperty prop = null;
    private MassSpecMultiPageViewer parentEditor = null;

    public MassSpecMultiPageViewerWorker(MassSpecMultiPageViewer parentEditor, MassSpecEntityProperty prop) {
        this.setParentEditor(parentEditor);
        this.prop = prop;
    }

    public int doWork() {
        int iSuccess;
        this.iMajorCount = 0;
        if ((iSuccess = this.addPropertyPage(this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        if (!this.getParentEditor().hasMSFile(this.prop)) {
            return GRITSProcessStatus.OK;
        }
        if (this.getParentEditor().getMinMSLevel() < 0 && (iSuccess = this.determineMinMSLevel(this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        iSuccess = this.addMSScansTab(this.prop, this.iMajorCount);
        this.iMajorCount += 2;
        if (iSuccess != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        if (this.getParentEditor().needsPeaksView(this.prop)) {
            iSuccess = this.addPeakListPage(this.prop, this.iMajorCount);
            this.iMajorCount += 2;
            if (iSuccess != GRITSProcessStatus.OK) {
                return iSuccess;
            }
        }
        if ((iSuccess = this.addSpectraPage(this.prop, this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        if ((iSuccess = this.addScanHierarcyPage(this.prop, this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        this.updateListeners("Finished MassSpec work!", this.iMajorCount);
        logger.debug((Object)"Finished MassSpec work");
        return iSuccess;
    }

    public MassSpecMultiPageViewer getParentEditor() {
        return this.parentEditor;
    }

    public void setParentEditor(MassSpecMultiPageViewer parentEditor) {
        this.parentEditor = parentEditor;
    }

    public int addPropertyPage(int iProcessCount) {
        try {
            this.updateListeners("Creating property tab (loading)", iProcessCount);
            int iSuccess = this.getParentEditor().addPropertyPage();
            this.updateListeners("Creating property tab (done)", iProcessCount + 1);
            return iSuccess;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS property view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    public int determineMinMSLevel(int iProcessCount) {
        try {
            this.updateListeners("Determining properties of MS files (loading)", iProcessCount);
            int iSuccess = this.getParentEditor().determineMinMSLevel();
            this.updateListeners("Determining properties of MS files (done)", iProcessCount + 1);
            return iSuccess;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to determine properties of file.", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    public int addSpectraPage(MassSpecEntityProperty prop, int iProcessCount) {
        try {
            this.updateListeners("Creating MS spectra tab (loading)", iProcessCount);
            int iSuccess = this.getParentEditor().addSpectraPage(prop);
            this.updateListeners("Creating MS spectra tab (done)", iProcessCount + 1);
            return iSuccess;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open MS property view", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    public int addMSScansTab(MassSpecEntityProperty prop, int iProcessCount) {
        try {
            this.updateListeners("Creating MS Scans tab (loading)", iProcessCount);
            int iSuccess = this.getParentEditor().addMSScansTab_Step1(prop);
            if (iSuccess != GRITSProcessStatus.OK) {
                return iSuccess;
            }
            this.updateListeners("Creating MS Scans tab (populating)", iProcessCount + 1);
            iSuccess = this.getParentEditor().addMSScansTab_Step2();
            this.updateListeners("Creating MS Scans tab (done)", iProcessCount + 2);
            return iSuccess;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open MS Scans view", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    public int addPeakListPage(MassSpecEntityProperty prop, int iProcessCount) {
        try {
            this.updateListeners("Creating MS Peak tab (loading)", iProcessCount);
            int iSuccess = this.getParentEditor().addPeakListPage_Step1(prop);
            if (iSuccess != GRITSProcessStatus.OK) {
                return iSuccess;
            }
            this.updateListeners("Creating MS Peak tab (populating)", iProcessCount + 1);
            iSuccess = this.getParentEditor().addPeakListPage_Step2();
            this.updateListeners("Creating MS Peak tab (done)", iProcessCount + 2);
            return iSuccess;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open MS Peaks view", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected int addExternalQuantPages(MassSpecEntityProperty prop, int iProcessCount) {
        try {
            boolean success = true;
            MassSpecTableDataProcessor proc = (MassSpecTableDataProcessor)this.getParentEditor().getScansView().getTableDataProcessor();
            int i = 0;
            while (success && i < proc.getQuantFileProcessors().size()) {
                QuantFileProcessor processor = proc.getQuantFileProcessors().get(i);
                MassSpecEntityProperty newProp = (MassSpecEntityProperty)((Object)prop.clone());
                newProp.setPeakListNumber(i + 1);
                this.updateListeners("Creating External Quant tab " + (i + 1) + " (loading)", iProcessCount + i);
                int iSuccess = this.getParentEditor().addExternalQuantPage_Step1(newProp);
                if (iSuccess != GRITSProcessStatus.OK) {
                    return iSuccess;
                }
                this.updateListeners("CreatingExternal Quant tab" + (i + 1) + " (populating)", iProcessCount + 1);
                String sTitle = null;
                sTitle = processor instanceof ExtractDataProcessor ? "Extract Peak List" : "Full MS Peak List";
                iSuccess = this.getParentEditor().addExternalQuantPage_Step2(sTitle, newProp);
                this.updateListeners("CreatingExternal Quant tab" + (i + 1) + " (done)", iProcessCount + 2);
                if (iSuccess != GRITSProcessStatus.OK) {
                    return iSuccess;
                }
                ++i;
            }
            return GRITSProcessStatus.OK;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open MS External Quant views", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected int addScanHierarcyPage(MassSpecEntityProperty prop, int iProcessCount) {
        try {
            this.updateListeners("Creating MS Scan Hierarchy (loading)", iProcessCount);
            int iSuccess = this.getParentEditor().addScanHierarchyPage(prop);
            this.updateListeners("Creating MS Scan Hierarchy", iProcessCount + 1);
            return iSuccess;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open MS Scan hierarcy view", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }
}

