/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.tablehelpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMScan;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSTableDataObject;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.display.control.table.process.TableDataProcessorRunner;
import org.grits.toolbox.display.control.table.tablecore.GRITSTable;
import org.grits.toolbox.display.control.table.tablecore.IGritsTable;
import org.grits.toolbox.entry.ms.command.ViewColumnChooserCommandHandler;
import org.grits.toolbox.entry.ms.command.ViewMassSpecOverviewCommandExecutor;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.tablehelpers.MassSpecCellOverrideLabelAccumulator;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecTableBase;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;

public class MassSpecTable
extends GRITSTable {
    private static final Logger logger = Logger.getLogger(MassSpecTable.class);
    public static final String POLARITYLABEL = "PolarityValue";
    private String sMzXMLPathName = null;
    protected MassSpecTableBase parentView = null;

    public MassSpecTable(Composite parent, TableDataProcessor tableDataExtractor) {
        super(parent, tableDataExtractor);
    }

    public MassSpecTable(MassSpecTableBase parent, TableDataProcessor xmlExtractor) throws Exception {
        super(parent.getParent(), xmlExtractor);
        this.parentView = parent;
    }

    public void loadData() throws Exception {
        int iStatus = this.openReadWriteDialog(TableDataProcessor.READ);
        if (iStatus == GRITSProcessStatus.ERROR) {
            throw new Exception("Failed to read table data.");
        }
        if (iStatus == GRITSProcessStatus.CANCEL) {
            return;
        }
        this.setSimDataObject((GRITSTableDataObject)((MassSpecTableDataProcessor)this.getTableDataProcessor()).getSimianTableDataObject());
    }

    public void createMainTable() throws Exception {
        try {
            this.initCommonTableComponents();
            this.initColumnChooserLayer();
            this.registerDoubleStyles((IConfigRegistry)this.configRegistry);
            this.registerPolarityStyle(this.configRegistry);
            this.finishNatTable();
            this.performAutoResizeAfterPaint();
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing table.");
            throw new Exception(e.getMessage());
        }
    }

    protected void registerPolarityStyle(ConfigRegistry configRegistry) {
        DisplayConverter polarityConverter = new DisplayConverter(){

            public Object displayToCanonicalValue(Object displayValue) {
                if (displayValue == null) {
                    return null;
                }
                if (displayValue instanceof String) {
                    if (((String)displayValue).isEmpty()) {
                        return null;
                    }
                    if (((String)displayValue).equals("+")) {
                        return "Yes";
                    }
                    if (((String)displayValue).equals("-")) {
                        return "No";
                    }
                }
                return null;
            }

            public Object canonicalToDisplayValue(Object canonicalValue) {
                if (canonicalValue == null) {
                    return "";
                }
                if (canonicalValue instanceof String) {
                    if (canonicalValue.equals("Yes")) {
                        return "+";
                    }
                    return "-";
                }
                return null;
            }
        };
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)polarityConverter, "NORMAL", POLARITYLABEL);
    }

    private MassSpecTableDataObject getMyTableDataObject() {
        return (MassSpecTableDataObject)this.getGRITSTableDataObject();
    }

    protected boolean rowNeedsResize(int iRowNum) {
        return super.rowNeedsResize(iRowNum);
    }

    public void writeDataToXML(String _sNewXMLFile) {
        this.getTableDataProcessor().prepareThreadForWrite(_sNewXMLFile);
        this.openReadWriteDialog(TableDataProcessor.WRITE);
    }

    protected int openReadWriteDialog(Integer processType) {
        TableDataProcessorRunner processRunner = new TableDataProcessorRunner((TableDataProcessor)((MassSpecTableDataProcessor)this.getTableDataProcessor()));
        this.getTableDataProcessor().setProcessType(processType);
        try {
            this.getTableDataProcessor().setProcessType(processType);
            int iStatus = processRunner.startJob();
            return iStatus;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    public String getMzXMLPathName() {
        return this.sMzXMLPathName;
    }

    public void setMzXMLPathName(String sMzXMLPathName) {
        this.sMzXMLPathName = sMzXMLPathName;
    }

    public void initCellAccumulator() {
        int polarityColumn;
        MassSpecCellOverrideLabelAccumulator cellLabelAccumulator = null;
        List<Integer> intensityCols = this.getAllIntensityColumns(null);
        cellLabelAccumulator = new MassSpecCellOverrideLabelAccumulator(this.bodyDataProvider, 0, intensityCols);
        if (this.getTableDataProcessor() != null && this.getTableDataProcessor().getTempPreference() != null && (polarityColumn = this.getTableDataProcessor().getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_polarity.name())) != -1) {
            cellLabelAccumulator.setPolarityColumn(polarityColumn);
        }
        this.dataLayer.setConfigLabelAccumulator(cellLabelAccumulator);
    }

    protected List<Integer> getAllIntensityColumns(Integer shift) {
        int offset = shift == null ? 0 : shift;
        ArrayList<Integer> intensityCols = new ArrayList<Integer>();
        if (this.getMyTableDataObject().getPeakIntensityCols() != null && !this.getMyTableDataObject().getPeakIntensityCols().isEmpty()) {
            intensityCols.addAll(this.getMyTableDataObject().getPeakIntensityCols());
        }
        if (this.getMyTableDataObject().getPrecursorIntensityCols() != null && !this.getMyTableDataObject().getPrecursorIntensityCols().isEmpty()) {
            intensityCols.addAll(this.getMyTableDataObject().getPrecursorIntensityCols());
        }
        if (this.getTableDataProcessor() == null || this.getTableDataProcessor().getTempPreference() == null || this.getTableDataProcessor().getTempPreference().getPreferenceSettings() == null) {
            return intensityCols;
        }
        HashMap customExtraDataColumnMap = this.getTableDataProcessor().getTempPreference().getPreferenceSettings().getUnrecognizedHeaders();
        for (String key : customExtraDataColumnMap.keySet()) {
            if (!key.toLowerCase().contains("intensity") || key.toLowerCase().contains("score")) continue;
            intensityCols.add((Integer)customExtraDataColumnMap.get(key) + offset);
        }
        for (GRITSColumnHeader column : this.getTableDataProcessor().getTempPreference().getPreferenceSettings().getHeaders()) {
            int columnNo;
            if (!column.getKeyValue().toLowerCase().contains("intensity") || column.getKeyValue().toLowerCase().contains("score") || intensityCols.contains((columnNo = this.getTableDataProcessor().getTempPreference().getPreferenceSettings().getColumnPosition(column)) + offset)) continue;
            intensityCols.add(columnNo + offset);
        }
        return intensityCols;
    }

    protected void initConfigRegistry() {
        super.initConfigRegistry();
    }

    public MassSpecViewerPreference getPreference() {
        return (MassSpecViewerPreference)this.getGRITSTableDataObject().getTablePreferences();
    }

    public void setPreference(MassSpecViewerPreference preference) {
        this.getGRITSTableDataObject().setTablePreferences((TableViewerPreference)preference);
    }

    protected void initColumnChooserLayer() {
        ViewColumnChooserCommandHandler columnChooserCommandHandler = new ViewColumnChooserCommandHandler((IGritsTable)this);
        this.columnGroupHeaderLayer.registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
    }

    protected void finishNatTable() {
        super.finishNatTable();
    }

    protected boolean addHeaderListeners() {
        return super.addHeaderListeners();
    }

    public void moveToFirstColumn(String _sStartLabel) {
        ArrayList<Integer> alHidden = new ArrayList<Integer>();
        int iFromPos = 0;
        while (iFromPos < this.columnHeaderDataLayer.getColumnCount()) {
            String sThisHeaderKey = this.columnHeaderDataProvider.getDataValue(iFromPos, 0);
            if (sThisHeaderKey.startsWith(_sStartLabel) && this.columnHideShowLayer.isColumnIndexHidden(iFromPos)) {
                alHidden.add(iFromPos);
            }
            ++iFromPos;
        }
        if (!alHidden.isEmpty()) {
            this.columnHideShowLayer.showColumnIndexes(alHidden);
        }
        iFromPos = 0;
        while (iFromPos < this.columnHideShowLayer.getColumnCount()) {
            int iToPos;
            int iColPos = LayerUtil.convertColumnPosition((ILayer)this.columnHideShowLayer, (int)iFromPos, (IUniqueIndexLayer)this.columnHeaderDataLayer);
            String sThisHeaderKey = this.columnHeaderDataProvider.getDataValue(iColPos, 0);
            if (sThisHeaderKey.startsWith(_sStartLabel) && iFromPos != (iToPos = 0)) {
                ColumnReorderCommand command = new ColumnReorderCommand((ILayer)this.columnHideShowLayer, iFromPos, iToPos);
                this.columnHideShowLayer.doCommand((ILayerCommand)command);
            }
            ++iFromPos;
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        Object obj2;
        Object obj;
        if (this.getMyTableDataObject().getScanNoCols().isEmpty()) {
            return;
        }
        if (this.getMzXMLPathName() == null) {
            return;
        }
        GridLayer gl = (GridLayer)this.getLayer();
        int origRow = gl.getRowPositionByY(e.y);
        if (origRow < 2) {
            return;
        }
        int origCol = gl.getColumnPositionByX(e.x);
        if (origCol < 1) {
            return;
        }
        int iRowPostion = LayerUtil.convertRowPosition((ILayer)gl, (int)origRow, (IUniqueIndexLayer)this.getBottomDataLayer());
        int iColPostion = LayerUtil.convertColumnPosition((ILayer)gl, (int)origCol, (IUniqueIndexLayer)this.getBottomDataLayer());
        int iScanNum = -1;
        double dMz = 0.0;
        if (this.hasColumnGroupHeader()) {
            obj = this.getBottomDataLayer().getDataValueByPosition(iColPostion, iRowPostion);
            try {
                iScanNum = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                return;
            }
        }
        obj = this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getScanNoCols().get(0)).intValue(), iRowPostion);
        if (obj != null) {
            try {
                iScanNum = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                return;
            }
        }
        if (!this.getMyTableDataObject().getMzCols().isEmpty() && (obj2 = this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getMzCols().get(0)).intValue(), iRowPostion)) != null) {
            try {
                dMz = Double.parseDouble(obj2.toString());
            }
            catch (NumberFormatException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (iScanNum == -1) {
            return;
        }
        this.parentView.getEntry().getParent().getDisplayName();
        int iParentScanNum = -1;
        double dParentMz = 0.0;
        if (this.parentView.getEntry().getProperty() instanceof MassSpecEntityProperty) {
            iParentScanNum = ((MassSpecEntityProperty)this.parentView.getEntry().getProperty()).getScanNum();
            dParentMz = ((MassSpecEntityProperty)this.parentView.getEntry().getProperty()).getMz();
        }
        Entry newEntry = MassSpecEntityProperty.getTableCompatibleEntry(this.parentView.getEntry());
        MassSpecEntityProperty msEntityProp = (MassSpecEntityProperty)newEntry.getProperty();
        msEntityProp.setParentScanNum(iParentScanNum);
        msEntityProp.setScanNum(iScanNum);
        msEntityProp.setMz(dMz);
        msEntityProp.setParentMz(dParentMz);
        msEntityProp.setDataFile(((MassSpecEntityProperty)this.parentView.getEntityProperty()).getDataFile());
        int iCurMSLevel = ((MassSpecEntityProperty)this.parentView.getEntityProperty()).getMsLevel();
        msEntityProp.setMsLevel(iCurMSLevel + 1);
        StringBuilder sb = new StringBuilder(newEntry.getDisplayName());
        if (dMz == 0.0) {
            sb.append(": ");
        } else {
            sb.append("->");
        }
        sb.append("[Scan ");
        sb.append(iScanNum);
        sb.append(", MS");
        sb.append(iCurMSLevel);
        if (dMz > 0.0) {
            sb.append(", ");
            sb.append(dMz);
        }
        sb.append("]");
        newEntry.setDisplayName(sb.toString());
        this.showMSOverview(newEntry);
    }

    protected void showMSOverview(Entry newEntry) {
        ViewMassSpecOverviewCommandExecutor.showMSOverview(this.parentView.getParentEditor().getContext(), newEntry);
    }

    public void mouseDown(MouseEvent e) {
        super.mouseDown(e);
    }

    public void mouseUp(MouseEvent e) {
        super.mouseUp(e);
    }

    public TableViewerColumnSettings getPreferenceSettingsFromCurrentView() {
        return super.getPreferenceSettingsFromCurrentView();
    }

    public MassSpecTableBase getParentView() {
        return this.parentView;
    }
}

