/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference.viewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreferenceLoader;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.datamodel.GRITSTableDataObject;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.display.control.table.tablecore.GRITSTable;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.tablehelpers.MassSpecTable;

public class MassSpecViewerPreferencePage_NatBridge {
    private static final Logger logger = Logger.getLogger(MassSpecViewerPreferencePage_NatBridge.class);
    protected int iMSLevel;
    protected GRITSTable natTable = null;
    protected FillTypes fillType;

    public MassSpecViewerPreferencePage_NatBridge(Composite parent, int iMSLevel, FillTypes fillType) {
        this.natTable = this.getNewSimianTable(parent);
        this.iMSLevel = iMSLevel;
        this.fillType = fillType;
    }

    public void initializeComponents(boolean _bDefault) {
        try {
            this.initializePreferences();
            if (_bDefault || this.natTable.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings() == null) {
                this.setDefaultPreferences();
            }
            this.postProcessPreferences();
            this.initializeTableData(_bDefault);
            this.natTable.initCommonTableComponents();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to initialize MassSpecViewerPreferenceUI_NatBridge.", (Throwable)e);
        }
    }

    public MassSpecViewerPreference getPreference() {
        return (MassSpecViewerPreference)this.natTable.getGRITSTableDataObject().getTablePreferences();
    }

    protected GRITSTable getNewSimianTable(Composite parent) {
        return new MassSpecTable(parent, null);
    }

    protected ArrayList<ArrayList<GRITSColumnHeader>> getEmptyHeader() {
        ArrayList<ArrayList<GRITSColumnHeader>> alTable = new ArrayList<ArrayList<GRITSColumnHeader>>();
        ArrayList<GRITSColumnHeader> alRow = new ArrayList<GRITSColumnHeader>();
        if (this.natTable.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings() == null) {
            this.natTable.getGRITSTableDataObject().initializePreferences();
        }
        for (GRITSColumnHeader header : this.natTable.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().getHeaders()) {
            alRow.add(header);
        }
        if (alRow == null || alRow.isEmpty()) {
            return alTable;
        }
        Collections.sort(alRow);
        alTable.add(alRow);
        return alTable;
    }

    protected ArrayList<GRITSListDataRow> getEmptyData() {
        if (this.natTable.getGRITSTableDataObject() == null || this.natTable.getGRITSTableDataObject().getTablePreferences() == null || this.natTable.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings() == null) {
            return null;
        }
        ArrayList<GRITSListDataRow> alTable = new ArrayList<GRITSListDataRow>();
        ArrayList<String> alRow = new ArrayList<String>();
        TableViewerColumnSettings settings = this.natTable.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings();
        Iterator itr = settings.getHeaders().iterator();
        while (itr.hasNext()) {
            GRITSColumnHeader cfr_ignored_0 = (GRITSColumnHeader)itr.next();
            alRow.add("Blah");
        }
        GRITSListDataRow newRow = new GRITSListDataRow(0, alRow);
        if (alRow == null || alRow.isEmpty()) {
            return alTable;
        }
        alTable.add(newRow);
        return alTable;
    }

    protected MassSpecTableDataObject getNewTableDataObject() {
        return new MassSpecTableDataObject(this.iMSLevel, this.fillType);
    }

    protected TableViewerColumnSettings getNewTableViewerSettings() {
        return new TableViewerColumnSettings();
    }

    protected void postProcessPreferences() {
    }

    protected void initializePreferences() throws Exception {
        this.natTable.setSimDataObject((GRITSTableDataObject)this.getNewTableDataObject());
        ((MassSpecTableDataObject)this.natTable.getGRITSTableDataObject()).initializePreferences();
    }

    protected void setDefaultPreferences() {
        TableViewerColumnSettings tvcs = this.getDefaultSettings();
        MassSpecTableDataProcessor.setDefaultColumnViewSettings(this.fillType, tvcs);
        this.natTable.getGRITSTableDataObject().getTablePreferences().setPreferenceSettings(tvcs);
        this.natTable.getGRITSTableDataObject().getTablePreferences().setColumnSettings(this.natTable.getGRITSTableDataObject().getTablePreferences().toString());
    }

    protected void initializeTableData(boolean _bDefaults) throws Exception {
        ArrayList<ArrayList<GRITSColumnHeader>> prefData = this.getEmptyHeader();
        if (prefData == null || prefData.isEmpty()) {
            throw new Exception("Unable to initialize preferences.");
        }
        this.natTable.getGRITSTableDataObject().setHeaderData(prefData);
        ArrayList<GRITSListDataRow> emptyData = this.getEmptyData();
        this.natTable.getGRITSTableDataObject().setTableData(emptyData);
    }

    protected TableViewerPreference getNewTableViewerPreference() {
        return new TableViewerPreference();
    }

    protected TableViewerColumnSettings getDefaultSettings() {
        TableViewerColumnSettings newSettings = this.getNewTableViewerSettings();
        if (this.fillType == FillTypes.Scans) {
            MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsScan(newSettings, this.iMSLevel, false, true);
        } else if (this.fillType == FillTypes.PeakList) {
            MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsPeakList(newSettings);
        } else if (this.fillType == FillTypes.PeaksWithFeatures) {
            MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsPeakWithFeatures(newSettings, false);
        }
        return newSettings;
    }

    public void updatePreferences() {
        this.natTable.updatePreferenceSettingsFromCurrentView();
        this.natTable.getGRITSTableDataObject().getTablePreferences().writePreference();
    }

    protected MassSpecViewerPreference getCurrentTableViewerPreference(int _iMSLevel, FillTypes _fillType) {
        return MassSpecViewerPreferenceLoader.getTableViewerPreference((int)_iMSLevel, (FillTypes)_fillType);
    }

    public GRITSTable getNatTable() {
        return this.natTable;
    }
}

