/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridEditor;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.entry.ms.dialog.IDynamicTableProcessor;
import org.grits.toolbox.entry.ms.dialog.MassSpecViewerDialog;
import org.grits.toolbox.entry.ms.property.FileLockManager;
import org.grits.toolbox.entry.ms.property.FileLockingUtils;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantAlias;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MassSpecExternalQuantDialog
extends MassSpecViewerDialog
implements IDynamicTableProcessor {
    private static final Logger logger = Logger.getLogger(MassSpecExternalQuantDialog.class);
    private Grid extQuantFileGrid = null;
    protected GridLayout gridLayout = null;
    protected List<MSPropertyDataFile> storedExtQuantFiles = null;
    protected List<MSPropertyDataFile> appliedExtQuantFiles = null;
    protected FileLockManager fileLockManager = null;
    protected boolean bIsEditingTable = false;
    protected GridEditor editor = null;
    private static String[] columnHeaders = new String[]{"Applied", "External Quant File", "Type", "Alias"};
    private static int CELL_EDIT_COLUMN = 3;
    public static final String PROPERTY_WIN_CLOSED = "Window Closed";
    protected String lastUpdatedAlias = null;
    private String lockFilePath = null;

    public MassSpecExternalQuantDialog(Shell parentShell, MassSpecMultiPageViewer contextViewer) {
        super(parentShell, contextViewer);
        this.setShellStyle(67696);
        this.loadExternalQuantFiles();
        this.fileLockManager = this.loadLockFile();
    }

    protected void initGridLayout() {
        this.gridLayout = new GridLayout(1, false);
    }

    private FileLockManager loadLockFile() {
        Entry entry = this.getEntryForCurrentViewer();
        MassSpecEntityProperty msep = (MassSpecEntityProperty)entry.getProperty();
        MassSpecProperty pp = msep.getMassSpecParentProperty();
        try {
            this.lockFilePath = pp.getLockFilePath(entry);
            this.fileLockManager = FileLockingUtils.readLockFile(this.lockFilePath);
        }
        catch (IOException | JAXBException e) {
            logger.error((Object)"Cannot load the lock file", e);
            this.fileLockManager = null;
        }
        return this.fileLockManager;
    }

    protected List<MSPropertyDataFile> getQuantificationFiles() {
        MassSpecProperty msp = (MassSpecProperty)this.getEntryParentProperty();
        MassSpecMetaData entrySettings = msp.getMassSpecMetaData();
        return entrySettings.getQuantificationFiles();
    }

    protected MassSpecUISettings getEntrySettings() {
        MassSpecProperty msp = (MassSpecProperty)this.getEntryParentProperty();
        MassSpecMetaData entrySettings = msp.getMassSpecMetaData();
        return entrySettings;
    }

    protected void loadExternalQuantFiles() {
        this.storedExtQuantFiles = this.getQuantificationFiles();
    }

    protected void createQuantTableControl(Composite parent) {
        this.initGridLayout();
        parent.setLayout((Layout)this.gridLayout);
        GridData gd1 = new GridData(4, 4, true, false, 1, 1);
        Label purposeLabel = new Label(parent, 0);
        purposeLabel.setText("Available External Quantitiation Files: ");
        purposeLabel.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true, 1, 1);
        this.extQuantFileGrid = new Grid(parent, 2816);
        this.extQuantFileGrid.setLinesVisible(true);
        this.extQuantFileGrid.setHeaderVisible(true);
        this.extQuantFileGrid.setLayoutData((Object)gd2);
        int i = 0;
        while (i < columnHeaders.length) {
            GridColumn column = null;
            if (i == 0) {
                column = new GridColumn(this.extQuantFileGrid, 0x1000020);
                column.setCheckable(true);
            } else {
                column = new GridColumn(this.extQuantFileGrid, 0);
            }
            column.setText(columnHeaders[i]);
            ++i;
        }
        MassSpecUISettings entrySettings = this.getEntrySettings();
        this.editor = new GridEditor(this.extQuantFileGrid);
        int i2 = 0;
        while (i2 < this.storedExtQuantFiles.size()) {
            PropertyDataFile pdf = this.storedExtQuantFiles.get(i2);
            if (!(pdf instanceof MSPropertyDataFile)) {
                logger.error((Object)"Property data file not of correct type!");
            } else {
                MSPropertyDataFile mspdf = (MSPropertyDataFile)pdf;
                String sFilePath = mspdf.getName();
                String sFileName = MSPropertyDataFile.getFormattedName(mspdf);
                String sExtQuantType = MassSpecUISettings.getExternalQuantType(mspdf);
                ExternalQuantFileToAlias mAliases = entrySettings.getExternalQuantToAliasByQuantType(sExtQuantType);
                String sAlias = sFileName;
                if (mAliases != null && mAliases.getSourceDataFileNameToAlias().containsKey(sFilePath)) {
                    ExternalQuantAlias aliasInfo = mAliases.getSourceDataFileNameToAlias().get(sFilePath);
                    sAlias = aliasInfo.getAlias();
                }
                GridItem item = new GridItem(this.extQuantFileGrid, 0);
                boolean isInUse = mAliases != null && mAliases.getSourceDataFileNameToAlias().containsKey(sFilePath);
                item.setChecked(isInUse);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        logger.debug((Object)"Did you click the cell?");
                    }
                });
                item.setText(1, sFileName);
                item.setText(2, mspdf.getType());
                item.setText(3, sAlias);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < columnHeaders.length) {
            this.extQuantFileGrid.getColumn(i2).pack();
            ++i2;
        }
        this.extQuantFileGrid.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
                MassSpecExternalQuantDialog.this.disposeEditor();
                Point pt = new Point(e.x, e.y);
                GridColumn col = MassSpecExternalQuantDialog.this.extQuantFileGrid.getColumn(pt);
                GridItem item = MassSpecExternalQuantDialog.this.extQuantFileGrid.getItem(pt);
                if (item == null && col != null) {
                    MassSpecExternalQuantDialog.this.getColNumberForGridColumn(col);
                    if (col.getSort() == 128) {
                        // empty if block
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                MassSpecExternalQuantDialog.this.bIsEditingTable = true;
                Control oldEditor = MassSpecExternalQuantDialog.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                Point pt = new Point(e.x, e.y);
                final GridItem item = MassSpecExternalQuantDialog.this.extQuantFileGrid.getItem(pt);
                final Point cell = MassSpecExternalQuantDialog.this.extQuantFileGrid.getCell(pt);
                if (item == null || cell == null) {
                    return;
                }
                if (cell.x != CELL_EDIT_COLUMN) {
                    return;
                }
                MassSpecExternalQuantDialog.this.extQuantFileGrid.deselect(cell.y);
                final Text newEditor = new Text((Composite)MassSpecExternalQuantDialog.this.extQuantFileGrid, 2052);
                String curText = item.getText(cell.x);
                newEditor.setText(curText);
                MassSpecExternalQuantDialog.this.editor.setEditor((Control)newEditor, item, cell.x);
                MassSpecExternalQuantDialog.this.editor.grabHorizontal = true;
                MassSpecExternalQuantDialog.this.editor.grabVertical = true;
                newEditor.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                        item.setText(cell.x, newEditor.getText());
                    }

                    public void keyPressed(KeyEvent e) {
                    }
                });
                newEditor.forceFocus();
                newEditor.setSelection(newEditor.getText().length());
                newEditor.selectAll();
            }
        });
    }

    protected void disposeEditor() {
        if (this.editor == null) {
            return;
        }
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
            this.editor.setEditor(null);
            this.bIsEditingTable = false;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Select External Quantification Files");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        Monitor primary = this.getShell().getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.getShell().getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.getShell().setLocation(x, y);
        GridLayout gd = new GridLayout(4, false);
        container.setLayout((Layout)gd);
        container.setLayoutData((Object)new GridData(1808));
        this.createQuantTableControl(container);
        new Label(container, 0);
        new Label(container, 0);
        return area;
    }

    protected boolean externalQuantChanged() {
        boolean bChanged = false;
        try {
            MassSpecUISettings entrySettings = this.getEntrySettings();
            Property msp = this.getEntryParentProperty();
            Entry entry = this.findParentEntry(this.getEntryForCurrentViewer(), msp);
            int i = 0;
            while (i < this.extQuantFileGrid.getItems().length) {
                GridItem gi = this.extQuantFileGrid.getItem(i);
                String sGridFileName = gi.getText(1);
                boolean isInUse = gi.getChecked(0);
                String sGridAlias = gi.getText(3);
                int j = 0;
                while (j < this.storedExtQuantFiles.size()) {
                    PropertyDataFile pdf = this.storedExtQuantFiles.get(j);
                    if (!(pdf instanceof MSPropertyDataFile)) {
                        logger.error((Object)"Property data file not of correct type!");
                    } else {
                        MSPropertyDataFile mspdf = (MSPropertyDataFile)pdf;
                        String sFilePath = mspdf.getName();
                        String sFileName = MSPropertyDataFile.getFormattedName(mspdf);
                        if (sGridFileName.equals(sFileName)) {
                            boolean bChangedUse;
                            boolean bThisChanged;
                            String sExtQuantType = MassSpecUISettings.getExternalQuantType(mspdf);
                            boolean wasInUse = false;
                            ExternalQuantFileToAlias mAliases = entrySettings.getExternalQuantToAliasByQuantType(sExtQuantType);
                            String sAlias = sFileName;
                            if (mAliases != null && mAliases.getSourceDataFileNameToAlias().containsKey(sFilePath)) {
                                ExternalQuantAlias aliasInfo = mAliases.getSourceDataFileNameToAlias().get(sFilePath);
                                sAlias = aliasInfo.getAlias();
                                wasInUse = true;
                            }
                            boolean bl = bThisChanged = (bChangedUse = isInUse ^ wasInUse) || !sAlias.equals(sGridAlias);
                            if (bThisChanged) {
                                this.lastUpdatedAlias = null;
                                if (!isInUse) {
                                    mAliases.getSourceDataFileNameToAlias().remove(sFilePath);
                                    this.fileLockManager.removeLock(sFilePath, entry);
                                    FileLockingUtils.writeLockFile(this.fileLockManager, this.lockFilePath);
                                    if (entrySettings.getSourceDataFileList() != null && entrySettings.getSourceDataFileList().contains((Object)mspdf)) {
                                        entrySettings.getSourceDataFileList().remove((Object)mspdf);
                                    }
                                    entrySettings.updateQuantAliasKeyInfo(mspdf, mAliases, null);
                                } else {
                                    ExternalQuantAlias eqa = new ExternalQuantAlias();
                                    eqa.setAlias(sGridAlias);
                                    entrySettings.addExternalQuantFile(mspdf, eqa);
                                    mAliases = entrySettings.getExternalQuantToAliasByQuantType(sExtQuantType);
                                    entrySettings.updateQuantAliasKeyInfo(mspdf, mAliases, null);
                                    this.fileLockManager.lockFile(sFilePath, entry);
                                    FileLockingUtils.writeLockFile(this.fileLockManager, this.lockFilePath);
                                    if (entrySettings.getSourceDataFileList() == null || !entrySettings.getSourceDataFileList().contains((Object)mspdf)) {
                                        entrySettings.addSourceFile(mspdf);
                                    }
                                    this.lastUpdatedAlias = sGridAlias;
                                }
                                bChanged = true;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            bChanged = false;
        }
        return bChanged;
    }

    private Entry findParentEntry(Entry entry, Property msp) {
        Entry parent = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project");
        Entry entryFound = null;
        if (parent != null) {
            for (Entry e : parent.getChildren()) {
                entryFound = this.findEntryWithProperty(e, msp);
                if (entryFound != null) break;
            }
        }
        return entryFound;
    }

    private Entry findEntryWithProperty(Entry entry, Property msp) {
        if (entry.getProperty().equals(msp)) {
            return entry;
        }
        Entry entryFound = null;
        for (Entry e : entry.getChildren()) {
            entryFound = this.findEntryWithProperty(e, msp);
            if (entryFound != null) break;
        }
        return entryFound;
    }

    protected void updateSettings() {
        MassSpecProperty property = (MassSpecProperty)this.getEntryParentProperty();
        try {
            Entry projectEntry = this.getEntryForCurrentViewer();
            String settingsFile = String.valueOf(MassSpecProperty.getFullyQualifiedFolderName(projectEntry)) + File.separator + property.getMSSettingsFile().getName();
            property.marshallSettingsFile(settingsFile, property.getMassSpecMetaData());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void updateViewer() {
        try {
            MassSpecMultiPageViewer viewer = this.getCurrentViewer();
            List<String> sKeyVals = this.getColumnKeyLabels();
            viewer.reLoadScansTab(sKeyVals);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void okPressed() {
        if (this.externalQuantChanged()) {
            this.updateSettings();
            this.updateViewer();
        }
        super.okPressed();
    }

    protected int getColNumberForGridColumn(GridColumn col) {
        int i = 0;
        while (i < columnHeaders.length) {
            if (col.getText().equals(columnHeaders[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getRowNumberForItem(GridItem item) {
        int i = 0;
        while (i < this.extQuantFileGrid.getItems().length) {
            GridItem gi = this.extQuantFileGrid.getItem(i);
            if (gi.equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean close() {
        if (this.getListeners() != null) {
            for (IPropertyChangeListener listener : this.getListeners()) {
                listener.propertyChange(new PropertyChangeEvent((Object)this, PROPERTY_WIN_CLOSED, (Object)Boolean.FALSE, (Object)Boolean.TRUE));
            }
        }
        return super.close();
    }

    @Override
    public List<String> getColumnKeyLabels() {
        if (this.lastUpdatedAlias == null) {
            return null;
        }
        ArrayList<String> sKeys = new ArrayList<String>();
        sKeys.add(this.lastUpdatedAlias);
        return sKeys;
    }
}

