/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.mass;

import org.grits.toolbox.tools.gsl.structure.lipid.Ceramide;
import org.grits.toolbox.tools.gsl.util.mass.AtomicMass;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;
import org.grits.toolbox.tools.gsl.util.mass.LipidChemicalComposition;

public class CeramideChemicalComposition
extends ChemicalComposition {
    protected Ceramide m_oCeramide;

    public CeramideChemicalComposition(Ceramide a_oCeramide) {
        this.m_oCeramide = a_oCeramide;
        this.start();
    }

    @Override
    protected void start() {
        this.clear();
        LipidChemicalComposition t_oSphComp = new LipidChemicalComposition(this.m_oCeramide.getSphingosine());
        if (this.isDerivatized()) {
            t_oSphComp.derivatize();
        }
        this.addComposition(t_oSphComp);
        LipidChemicalComposition t_oFAComp = new LipidChemicalComposition(this.m_oCeramide.getFattyAcid());
        if (this.isDerivatized()) {
            t_oFAComp.derivatize();
        }
        this.addComposition(t_oFAComp);
        this.addNumberOfElements(AtomicMass.O, -1);
        this.addNumberOfElements(AtomicMass.H, -2);
    }

    @Override
    public ChemicalComposition copy() {
        CeramideChemicalComposition t_copy = new CeramideChemicalComposition(this.m_oCeramide);
        if (this.isDerivatized()) {
            t_copy.derivatize();
        }
        return t_copy;
    }
}

