/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.io.excel;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public abstract class ExporterXLSXAbstract {
    private FileOutputStream m_fos;
    protected Workbook m_book = new SXSSFWorkbook();
    protected Sheet m_sheetCurent;
    protected int m_nRowCurrent;
    private int m_nSheet;
    private CellStyle m_csWrapText = this.m_book.createCellStyle();

    public ExporterXLSXAbstract(String a_strOutputFile) throws IOException {
        this.m_csWrapText.setWrapText(true);
        this.m_fos = new FileOutputStream(a_strOutputFile);
    }

    public abstract boolean createBook();

    public void closeBook() {
        if (this.m_book == null) {
            return;
        }
        try {
            ((SXSSFWorkbook)this.m_book).dispose();
        }
        catch (Exception exception) {}
    }

    public void write() throws FileNotFoundException, IOException {
        this.m_book.write((OutputStream)this.m_fos);
        this.m_fos.close();
        this.closeBook();
    }

    protected void createRow(List<String> list) {
        throw new Error("Unresolved compilation problems: \n\tCELL_TYPE_NUMERIC cannot be resolved or is not a field\n\tCELL_TYPE_STRING cannot be resolved or is not a field\n");
    }

    protected boolean isNumeric(String a_strCell) {
        if (a_strCell == null || a_strCell.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(a_strCell);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected Sheet createSheet(String a_strSheetName) {
        Sheet t_sheet = this.m_book.createSheet();
        if (t_sheet instanceof SXSSFSheet) {
            ((SXSSFSheet)t_sheet).trackAllColumnsForAutoSizing();
        }
        this.m_book.setSheetName(this.m_nSheet++, a_strSheetName);
        this.m_nRowCurrent = 0;
        return t_sheet;
    }

    protected void autoSizeAllColumn(Sheet a_sheet) {
        ((SXSSFSheet)a_sheet).trackAllColumnsForAutoSizing();
        int t_iLastCol = 0;
        int t_iLastRow = a_sheet.getLastRowNum();
        int i = 0;
        while (i < t_iLastRow) {
            short t_iLastCell;
            Row t_row = a_sheet.getRow(i);
            if (t_row != null && t_iLastCol < (t_iLastCell = t_row.getLastCellNum())) {
                t_iLastCol = t_iLastCell;
            }
            ++i;
        }
        i = 0;
        while (i < t_iLastCol) {
            a_sheet.autoSizeColumn(i, true);
            ++i;
        }
    }
}

