/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dialog;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.tools.gsl.database.IonizationType;
import org.grits.toolbox.tools.gsl.structure.lipid.Ceramide;
import org.grits.toolbox.tools.gsl.structure.lipid.FattyAcid;
import org.grits.toolbox.tools.gsl.structure.lipid.ILipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Lipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Sphingosine;
import org.grits.toolbox.tools.gsl.util.LipidGeneratorUtils;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalCompositionProvider;

public class LipidCalculatorDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(LipidCalculatorDialog.class);
    private Text m_txtLipidName;
    private Label m_lblNumCSph;
    private Label m_lblNumCFA;
    private Label m_lblNumOHsSph;
    private Label m_lblNumOHsFA;
    private Label m_lblNumDBsSph;
    private Label m_lblNumDBsFA;
    private String m_strLipidName;
    private ILipid m_iLipid;
    private Text m_txtMassValue;
    private Text m_txtFormula;
    private Button m_btnM;
    private Button m_btnMmH2O;
    private Button m_btnMpH;
    private Button m_btnMmH;
    private Button m_btnMpNa;
    private Button m_btnMpHmH2O;
    private Button m_btnPerMe;
    private Table m_tblMassAbundance;

    public LipidCalculatorDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Lipid Mass Calculator");
        this.setMessage("Calculate lipid information and masses.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLipidName(container);
        this.createLipidInformation(container);
        this.createMassInformation(container);
        return area;
    }

    private void createLipidName(Composite container) {
        Label lbtFirstName = new Label(container, 0);
        lbtFirstName.setText("Lipid name");
        this.m_txtLipidName = new Text(container, 2048);
        this.m_txtLipidName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.parseLipidName();
        this.m_txtLipidName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LipidCalculatorDialog.this.m_iLipid = LipidCalculatorDialog.this.parseLipidName();
                if (LipidCalculatorDialog.this.m_iLipid == null) {
                    LipidCalculatorDialog.this.initLipidInformations();
                    LipidCalculatorDialog.this.initMassInformations();
                    return;
                }
                LipidCalculatorDialog.this.showStructureInformation(LipidCalculatorDialog.this.m_iLipid);
                LipidCalculatorDialog.this.showCalculatedMasses(LipidCalculatorDialog.this.m_iLipid);
            }
        });
    }

    private void createLipidInformation(Composite container) {
        Group grpInformation = new Group(container, 0);
        grpInformation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        grpInformation.setText("Lipid information");
        grpInformation.setLayout((Layout)new GridLayout(3, true));
        new Label((Composite)grpInformation, 0);
        Label lblSphingosine = new Label((Composite)grpInformation, 0);
        lblSphingosine.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        lblSphingosine.setText("Sphingosine");
        Label lblFattyAcid = new Label((Composite)grpInformation, 0);
        lblFattyAcid.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        lblFattyAcid.setText("Fatty Acid");
        Label lblNumC = new Label((Composite)grpInformation, 0);
        lblNumC.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblNumC.setText("Carbon chain length");
        this.m_lblNumCSph = new Label((Composite)grpInformation, 0);
        this.m_lblNumCSph.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.m_lblNumCFA = new Label((Composite)grpInformation, 0);
        this.m_lblNumCFA.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        Label lblNumOH = new Label((Composite)grpInformation, 0);
        lblNumOH.setText("# of hydroxyl groups");
        this.m_lblNumOHsSph = new Label((Composite)grpInformation, 0);
        this.m_lblNumOHsSph.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.m_lblNumOHsFA = new Label((Composite)grpInformation, 0);
        this.m_lblNumOHsFA.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        Label lblNumDB = new Label((Composite)grpInformation, 0);
        lblNumDB.setText("# of double bonds");
        this.m_lblNumDBsSph = new Label((Composite)grpInformation, 0);
        this.m_lblNumDBsSph.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.m_lblNumDBsFA = new Label((Composite)grpInformation, 0);
        this.m_lblNumDBsFA.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.initLipidInformations();
    }

    private void createMassInformation(Composite container) {
        Group grpMass = new Group(container, 0);
        grpMass.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        grpMass.setText("Mass information");
        grpMass.setLayout((Layout)new GridLayout(3, false));
        Label lblComposition = new Label((Composite)grpMass, 0);
        lblComposition.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblComposition.setText("Chemical Formula");
        this.m_txtFormula = new Text((Composite)grpMass, 2048);
        this.m_txtFormula.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_txtFormula.setEditable(false);
        Label lblMassValue = new Label((Composite)grpMass, 0);
        lblMassValue.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblMassValue.setText("Monoisotopic Mass Value");
        this.m_txtMassValue = new Text((Composite)grpMass, 2048);
        this.m_txtMassValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_txtMassValue.setEditable(false);
        new Label((Composite)grpMass, 0);
        this.m_btnPerMe = new Button((Composite)grpMass, 32);
        this.m_btnPerMe.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.m_btnPerMe.setText("Permethylation");
        this.setSelectionListerToButton(this.m_btnPerMe);
        Label lblIonization = new Label((Composite)grpMass, 0);
        lblIonization.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblIonization.setText("Ionization");
        this.m_btnM = this.createRadioButton(grpMass, "M");
        this.m_btnMmH2O = this.createRadioButton(grpMass, "M - H2O");
        new Label((Composite)grpMass, 0);
        this.m_btnMpH = this.createRadioButton(grpMass, "[M + H]+");
        this.m_btnMmH = this.createRadioButton(grpMass, "[M - H]-");
        new Label((Composite)grpMass, 0);
        this.m_btnMpNa = this.createRadioButton(grpMass, "[M + Na]+");
        this.m_btnMpHmH2O = this.createRadioButton(grpMass, "[M + H - H2O]+");
        this.m_btnM.setSelection(true);
        new Label((Composite)grpMass, 0);
        new Label((Composite)grpMass, 0);
    }

    private Button createRadioButton(Group a_grp, String a_strLabel) {
        Button t_btn = new Button((Composite)a_grp, 16);
        t_btn.setText(a_strLabel);
        this.setSelectionListerToButton(t_btn);
        return t_btn;
    }

    private void createMassAbundance(Composite container) {
        Group grpAbundanceTable = new Group(container, 0);
        grpAbundanceTable.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        grpAbundanceTable.setText("Mass Abundance");
        grpAbundanceTable.setLayout((Layout)new GridLayout(1, true));
        this.m_tblMassAbundance = new Table((Composite)grpAbundanceTable, 67586);
        GridData gData = new GridData(4, 4, true, true);
        gData.heightHint = 200;
        this.m_tblMassAbundance.setLayoutData((Object)gData);
        this.m_tblMassAbundance.setLinesVisible(true);
        this.m_tblMassAbundance.setHeaderVisible(true);
        String[] t_aHeaders = new String[]{"", "mass", "Intensity"};
        int[] t_aWidthes = new int[]{50, 200, 200};
        int i = 0;
        while (i < t_aHeaders.length) {
            TableColumn t_col = new TableColumn(this.m_tblMassAbundance, 0);
            t_col.setText(t_aHeaders[i]);
            t_col.setWidth(t_aWidthes[i]);
            this.m_tblMassAbundance.getColumn(i).pack();
            ++i;
        }
        int t_nRow = 50;
        int i2 = 0;
        while (i2 < t_nRow) {
            TableItem t_item = new TableItem(this.m_tblMassAbundance, 0);
            t_item.setText(0, "" + (i2 + 1));
            t_item.setText(1, "mass" + i2);
            t_item.setText(2, "intencity" + i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < t_aHeaders.length) {
            this.m_tblMassAbundance.getColumn(i2).pack();
            ++i2;
        }
        this.m_tblMassAbundance.setSize(this.m_tblMassAbundance.computeSize(-1, 200));
        grpAbundanceTable.pack();
    }

    private ILipid parseLipidName() {
        String t_strLipid = this.m_txtLipidName.getText().trim();
        if (t_strLipid.isEmpty()) {
            this.setErrorMessage("Please enter a lipid name.");
            return null;
        }
        ILipid t_iLip = LipidGeneratorUtils.parseLipidName(t_strLipid);
        if (t_iLip == null) {
            this.setErrorMessage("Lipid name is not valid.");
            return null;
        }
        this.setErrorMessage(null);
        return t_iLip;
    }

    private void initLipidInformations() {
        this.m_lblNumCSph.setText("-");
        this.m_lblNumCFA.setText("-");
        this.m_lblNumOHsSph.setText("-");
        this.m_lblNumOHsFA.setText("-");
        this.m_lblNumDBsSph.setText("-");
        this.m_lblNumDBsFA.setText("-");
        this.m_lblNumCSph.getParent().layout();
    }

    private void showStructureInformation(ILipid a_iLip) {
        this.initLipidInformations();
        if (a_iLip instanceof Ceramide) {
            Ceramide t_cer = (Ceramide)a_iLip;
            this.m_lblNumCSph.setText("" + t_cer.getSphingosine().getCarbonLength());
            this.m_lblNumCFA.setText("" + t_cer.getFattyAcid().getCarbonLength());
            this.m_lblNumOHsSph.setText("" + t_cer.getSphingosine().getNumberOfHydroxylGroups());
            this.m_lblNumOHsFA.setText("" + t_cer.getFattyAcid().getNumberOfHydroxylGroups());
            this.m_lblNumDBsSph.setText("" + t_cer.getSphingosine().getNumberOfUnsaturation());
            this.m_lblNumDBsFA.setText("" + t_cer.getFattyAcid().getNumberOfUnsaturation());
        }
        if (a_iLip instanceof Sphingosine) {
            Sphingosine t_sph = (Sphingosine)a_iLip;
            this.m_lblNumCSph.setText("" + t_sph.getCarbonLength());
            this.m_lblNumOHsSph.setText("" + t_sph.getNumberOfHydroxylGroups());
            this.m_lblNumDBsSph.setText("" + t_sph.getNumberOfUnsaturation());
        } else if (a_iLip instanceof FattyAcid) {
            FattyAcid t_fa = (FattyAcid)a_iLip;
            this.m_lblNumCFA.setText("" + t_fa.getCarbonLength());
            this.m_lblNumOHsFA.setText("" + t_fa.getNumberOfHydroxylGroups());
            this.m_lblNumDBsFA.setText("" + t_fa.getNumberOfUnsaturation());
        } else if (a_iLip instanceof Lipid) {
            this.setErrorMessage("Lipid name is not valid.");
            return;
        }
        this.m_lblNumCSph.getParent().layout();
    }

    private void initMassInformations() {
        this.m_txtFormula.setText("");
        this.m_txtMassValue.setText("");
    }

    private void showCalculatedMasses(ILipid a_iLip) {
        this.initMassInformations();
        ChemicalComposition t_calcMass = ChemicalCompositionProvider.getChemicalComposition(a_iLip);
        if (this.m_btnPerMe.getSelection()) {
            t_calcMass.derivatize();
            this.m_btnMmH2O.setText("M - MeOH");
            this.m_btnMpHmH2O.setText("[M + H - MeOH]+");
            this.m_btnMmH2O.getParent().layout();
        } else {
            this.m_btnMmH2O.setText("M - H2O");
            this.m_btnMpHmH2O.setText("[M + H - H2O]+");
            this.m_btnMmH2O.getParent().layout();
        }
        IonizationType t_ion = null;
        if (this.m_btnM.getSelection()) {
            t_ion = IonizationType.NOION;
        }
        if (this.m_btnMmH2O.getSelection()) {
            t_ion = IonizationType.NOIONMH2O;
        }
        if (this.m_btnMpH.getSelection()) {
            t_ion = IonizationType.PH;
        }
        if (this.m_btnMmH.getSelection()) {
            t_ion = IonizationType.MH;
        }
        if (this.m_btnMpNa.getSelection()) {
            t_ion = IonizationType.PNA;
        }
        if (this.m_btnMpHmH2O.getSelection()) {
            t_ion = IonizationType.PHMH2O;
        }
        this.m_txtMassValue.setText(t_calcMass.getMonoisotopicMass(t_ion));
        this.m_txtFormula.setText(t_calcMass.getFormula(t_ion));
    }

    private void setSelectionListerToButton(Button a_btn) {
        a_btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (LipidCalculatorDialog.this.m_iLipid == null) {
                    return;
                }
                LipidCalculatorDialog.this.showCalculatedMasses(LipidCalculatorDialog.this.m_iLipid);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (LipidCalculatorDialog.this.m_iLipid == null) {
                    return;
                }
                LipidCalculatorDialog.this.showCalculatedMasses(LipidCalculatorDialog.this.m_iLipid);
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.m_strLipidName = this.m_txtLipidName.getText();
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public String getLipidName() {
        return this.m_strLipidName;
    }
}

