/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.renderer.style;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResiduePlacement;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class ResiduePlacementDictionary {
    private Vector<ResiduePlacement> placements = new Vector();

    public void loadPlacements(String filename) {
        this.placements.clear();
        try {
            String line;
            URL file_url = ResiduePlacementDictionary.class.getResource(filename);
            if (file_url == null) {
                throw new FileNotFoundException(filename);
            }
            BufferedReader is = new BufferedReader(new InputStreamReader(file_url.openStream()));
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim((String)line)).length() <= 0 || line.startsWith("%")) continue;
                this.placements.add(new ResiduePlacement(line));
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            this.placements.clear();
        }
    }

    public ResiduePlacement getPlacement(Linkage link) {
        return this.getPlacement(link.getParentResidue(), link, link.getChildResidue());
    }

    public ResiduePlacement getPlacement(Linkage link, boolean sticky) {
        return this.getPlacement(link.getParentResidue(), link, link.getChildResidue(), sticky);
    }

    public ResiduePlacement getPlacement(Residue parent, Linkage link, Residue child) {
        for (ResiduePlacement p : this.placements) {
            if (!p.matches(parent, link, child)) continue;
            return p;
        }
        return new ResiduePlacement();
    }

    public ResiduePlacement getPlacement(Residue parent, Linkage link, Residue child, boolean sticky) {
        for (ResiduePlacement p : this.placements) {
            if (!p.matches(parent, link, child)) continue;
            return sticky ? p.getIfSticky() : p;
        }
        return new ResiduePlacement();
    }
}

