/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptorgroup;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.grits.toolbox.editor.samplemanager.ManagementEditor;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.descriptortype.descriptorgroup.AddDescriptorToGroupAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.descriptortype.descriptorgroup.DeleteDescriptorFromGroupAction;
import org.grits.toolbox.editor.samplemanager.input.DescriptorGroupWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.general.CheckboxTableUtility;
import org.grits.toolbox.editor.samplemanager.pages.general.SectionUtility;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.RightSideDescriptorTypeSection;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptorgroup.CheckMandatoryDescriptorInGroupListener;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptorgroup.DescriptorGroupMembersContenProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptorgroup.MandatoryCheckDescriptorProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptorgroup.tabledescriptorlist.DescriptorListLabelProvider;
import org.grits.toolbox.editor.samplemanager.util.GenericColumnsWithCheckboxSelectionListener;
import org.grits.toolbox.editor.samplemanager.util.GenericViewerComparatorCheckboxTable;

public class RightSideDescriptorGroupSection
extends RightSideDescriptorTypeSection {
    private Logger logger = Logger.getLogger(RightSideDescriptorGroupSection.class);
    private Section descriptorListSection = null;
    private CheckboxTableViewer tableViewer = null;
    private AddDescriptorToGroupAction addDescriptorToGroupAction = null;
    private DeleteDescriptorFromGroupAction deleteDescriptorFromGroupAction = null;

    public RightSideDescriptorGroupSection(AbstractManagementPage page) {
        super(page);
    }

    @Override
    protected void createMoreSpecificPart() {
        this.logger.debug((Object)"- START : Creating remaining part in Descriptor Group section.");
        try {
            List<String> existingLabels = ((ManagementEditor)this.page.getEditor()).getAllIndividualLabels("http://www.grits-toolbox.org/ontology/sample#descriptor_group");
            this.labelModifyListener.setExistingLabels(existingLabels);
            this.createTableForDescriptors();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Creating remaining part in Descriptor Group section.");
    }

    private void createTableForDescriptors() {
        this.descriptorListSection = SectionUtility.createSectionForCategory(this.toolkit, this.page.getRightComposite(), "Descriptors");
        Composite descriptorListSectionComposite = SectionUtility.getCompositeInsideSection(this.toolkit, this.descriptorListSection, 1, 150, 10, 2);
        this.tableViewer = CheckboxTableUtility.createCheckboxTableViewer(this.page, descriptorListSectionComposite, 32, "Descriptors");
        this.tableViewer.setContentProvider((IContentProvider)new DescriptorGroupMembersContenProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DescriptorListLabelProvider());
        this.tableViewer.setCheckStateProvider((ICheckStateProvider)new MandatoryCheckDescriptorProvider(this.tableViewer));
        this.tableViewer.addCheckStateListener((ICheckStateListener)new CheckMandatoryDescriptorInGroupListener(this.page, (TableViewer)this.tableViewer));
        GenericViewerComparatorCheckboxTable simpleTypeViewerComparator = new GenericViewerComparatorCheckboxTable();
        this.tableViewer.setComparator((ViewerComparator)simpleTypeViewerComparator);
        this.addColumnSelectionListenerForCheckbox(this.tableViewer);
        TableWrapData tData = new TableWrapData();
        tData.heightHint = 200;
        this.tableViewer.getTable().setLayoutData((Object)tData);
        ToolBarManager toolBarManager = new ToolBarManager(4096);
        this.addDescriptorToGroupAction = this.getAddDescriptorToGroupAction();
        toolBarManager.add((IAction)this.addDescriptorToGroupAction);
        this.deleteDescriptorFromGroupAction = this.getDeleteDescriptorFromGroupAction();
        toolBarManager.add((IAction)this.deleteDescriptorFromGroupAction);
        ToolBar toolbar = toolBarManager.createControl((Composite)this.descriptorListSection);
        this.descriptorListSection.setTextClient((Control)toolbar);
    }

    private void addColumnSelectionListenerForCheckbox(CheckboxTableViewer checkboxTableViewer) {
        int totalColumns = checkboxTableViewer.getTable().getColumns().length;
        int i = 0;
        while (i < totalColumns) {
            checkboxTableViewer.getTable().getColumn(i).addSelectionListener((SelectionListener)new GenericColumnsWithCheckboxSelectionListener(checkboxTableViewer));
            ++i;
        }
    }

    private DeleteDescriptorFromGroupAction getDeleteDescriptorFromGroupAction() {
        return new DeleteDescriptorFromGroupAction(this.page, this.tableViewer);
    }

    private AddDescriptorToGroupAction getAddDescriptorToGroupAction() {
        return new AddDescriptorToGroupAction(this.page, this.tableViewer);
    }

    @Override
    protected void resetMoreSpecificPart() {
        this.logger.debug((Object)"- START : Resetting remaining part in Descriptor Group section for the selection.");
        try {
            this.descriptorListSection.setExpanded(false);
            List<String> existingLabels = ((ManagementEditor)this.page.getEditor()).getAllIndividualLabels("http://www.grits-toolbox.org/ontology/sample#descriptor_group");
            this.labelModifyListener.setExistingLabels(existingLabels);
            DescriptorGroupWithFeatures descriptorGroupWithFeatures = (DescriptorGroupWithFeatures)this.selectedObject;
            this.tableViewer.setInput((Object)descriptorGroupWithFeatures.getDescriptorGroup());
            this.addDescriptorToGroupAction.setEnabled(this.editable);
            this.deleteDescriptorFromGroupAction.setEnabled(this.editable);
            this.tableViewer.getTable().setEnabled(this.editable);
            this.descriptorListSection.setExpanded(true);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Resetting remaining part in Descriptor Group section for the selection.");
    }
}

