/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.editor.samplemanager.actions.RefreshPageAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.CreateNewObjectInOntology;
import org.grits.toolbox.editor.samplemanager.actions.pages.DeleteObjectFromOntology;
import org.grits.toolbox.editor.samplemanager.actions.pages.sorting.SortClassesWithFeatures;
import org.grits.toolbox.editor.samplemanager.input.ClassesWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.leftside.SetupLeftSideSection;
import org.grits.toolbox.editor.samplemanager.pages.rightside.RightSideSelectionListener;

public abstract class AbstractManagementPage
extends FormPage {
    private Logger logger = Logger.getLogger(AbstractManagementPage.class);
    protected Section leftSectionOfPage = null;
    private Section rightSectionOfPage = null;
    private FormToolkit toolkit = null;
    protected TableViewer leftSideTableViewer = null;
    protected SortClassesWithFeatures sortAlphaNumericAction = null;
    protected int leftSideSelection = 0;
    private Composite rightComposite;

    public AbstractManagementPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public Section getLeftSectionOfPage() {
        return this.leftSectionOfPage;
    }

    public Composite getRightComposite() {
        return this.rightComposite;
    }

    public Section getRightSectionOfPage() {
        return this.rightSectionOfPage;
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    public TableViewer getLeftSideTableViewer() {
        return this.leftSideTableViewer;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.logger.debug((Object)"- START : Creating Abstract page.");
        try {
            super.createFormContent(managedForm);
            ScrolledForm form = managedForm.getForm();
            form.getForm().getHead().setBackground(Display.getCurrent().getSystemColor(35));
            managedForm.getForm().setText(this.getTitle());
            this.toolkit = managedForm.getToolkit();
            Composite fullComposite = form.getBody();
            fullComposite.setLayout((Layout)new GridLayout(2, false));
            Composite leftComposite = this.toolkit.createComposite(fullComposite);
            TableWrapLayout leftCompositeLayout = new TableWrapLayout();
            leftCompositeLayout.numColumns = 1;
            leftCompositeLayout.makeColumnsEqualWidth = true;
            leftComposite.setLayout((Layout)leftCompositeLayout);
            this.leftSectionOfPage = this.toolkit.createSection(leftComposite, 256);
            this.leftSectionOfPage.setLayout((Layout)new TableWrapLayout());
            TableWrapData section1LayoutData = new TableWrapData();
            section1LayoutData.colspan = 1;
            section1LayoutData.grabVertical = true;
            this.leftSectionOfPage.setLayoutData((Object)section1LayoutData);
            GridData leftCompositeData = new GridData();
            leftCompositeData.grabExcessVerticalSpace = true;
            leftCompositeData.horizontalSpan = 1;
            leftCompositeData.horizontalAlignment = 1;
            leftCompositeData.widthHint = 200;
            leftCompositeData.minimumHeight = 800;
            leftComposite.setLayoutData((Object)leftCompositeData);
            this.rightComposite = this.toolkit.createComposite(fullComposite);
            GridLayout rightCompositeLayout = new GridLayout();
            rightCompositeLayout.numColumns = 1;
            rightCompositeLayout.makeColumnsEqualWidth = true;
            this.rightComposite.setLayout((Layout)rightCompositeLayout);
            this.rightSectionOfPage = this.toolkit.createSection(this.rightComposite, 256);
            this.rightSectionOfPage.setText("No Selection    ");
            this.rightSectionOfPage.setLayout((Layout)new TableWrapLayout());
            GridData rightSectionLayoutData = new GridData();
            rightSectionLayoutData.horizontalSpan = 1;
            this.rightSectionOfPage.setLayoutData((Object)rightSectionLayoutData);
            GridData rightCompositeData = new GridData();
            rightCompositeData.grabExcessVerticalSpace = true;
            rightCompositeData.grabExcessHorizontalSpace = true;
            rightCompositeData.horizontalSpan = 1;
            rightCompositeData.horizontalAlignment = 1;
            rightCompositeData.minimumHeight = 807;
            this.rightComposite.setLayoutData((Object)rightCompositeData);
            this.leftSectionOfPage.setText(this.getTitle());
            SetupLeftSideSection leftSectionSetup = new SetupLeftSideSection(this, this.getInput());
            this.leftSideTableViewer = leftSectionSetup.tableViewer;
            this.leftSideTableViewer.addSelectionChangedListener((ISelectionChangedListener)this.getSelectionListener());
            this.createRestOftheContent();
            IToolBarManager manager = form.getToolBarManager();
            manager.add(this.getRefreshPageAction());
            form.updateToolBar();
            this.sortLeftSideInput();
            this.selectDefault();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Creating Abstract page.");
    }

    protected void sortLeftSideInput() {
        this.sortAlphaNumericAction.run();
    }

    protected void selectDefault() {
        if (this.leftSideTableViewer.getTable().getItemCount() > 0) {
            this.leftSideTableViewer.getTable().setSelection(0);
            this.leftSideTableViewer.setSelection(this.leftSideTableViewer.getSelection());
        }
    }

    private IAction getRefreshPageAction() {
        return new RefreshPageAction(this);
    }

    public abstract void createRestOftheContent();

    protected void createToolBar(TableViewer tableViewer, String classUri) {
        this.logger.debug((Object)"- START : Creating Toolbar for the page.");
        try {
            ToolBarManager toolBarManager = new ToolBarManager();
            toolBarManager.add((IAction)new CreateNewObjectInOntology(this, tableViewer, classUri));
            toolBarManager.add((IAction)new DeleteObjectFromOntology(this, tableViewer));
            this.sortAlphaNumericAction = new SortClassesWithFeatures(tableViewer);
            toolBarManager.add((IAction)this.sortAlphaNumericAction);
            ToolBar toolbar = toolBarManager.createControl((Composite)this.leftSectionOfPage);
            this.leftSectionOfPage.setTextClient((Control)toolbar);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Creating Toolbar for the page.");
    }

    protected abstract RightSideSelectionListener getSelectionListener();

    public abstract void refreshPage();

    protected abstract Object getInput();

    public void addInput(String label, String uri) {
        this.logger.debug((Object)"- START : Adding a new input to the page.");
        try {
            List inputList = (List)this.leftSideTableViewer.getInput();
            int selectionIndex = Math.max(this.leftSideTableViewer.getTable().getSelectionIndex(), 0);
            this.addInputToList(inputList, selectionIndex, label, uri);
            this.leftSideTableViewer.refresh();
            this.leftSideTableViewer.getTable().select(selectionIndex);
            this.leftSideTableViewer.setSelection(this.leftSideTableViewer.getSelection());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Adding a new input to the page.");
    }

    protected abstract void addInputToList(List<ClassesWithFeatures> var1, int var2, String var3, String var4);
}

